class SmartDOM expands SmartUT config( SmartUT );

/* Server Vars */
var ControlPoint ControlPoints[6];
var int TotControlPoints;

/* Server Vars Configurable */
var config int CapBonus, SealBonus;
var config bool bPlayCaptureSound;
var config bool bPlayLessCPSound;
var config float LessCPPercentage;
var config byte SealMsgType;

function PostBeginPlay()
{
	local ControlPoint cp;

	super.PostBeginPlay();
  
	// Get Control points
	TotControlPoints = 0;
	ForEach AllActors( class'ControlPoint', cp)
	{
		ControlPoints[TotControlPoints] = cp;
		TotControlPoints++;
	}
}

function bool PreventDeath( Pawn Victim, Pawn Killer, name DamageType, vector HitLocation )
{
	local PlayerReplicationInfo VictimPRI, KillerPRI;
	local bool bPrevent;
	local Pawn p;
	local SmartDOMPRI KillerStats, VictimStats;
	local int Index;
	local ControlPoint NearestControlPoint;

	bPrevent = super.PreventDeath( Victim, Killer, DamageType, HitLocation );
	if (bPrevent || Victim==None || Killer==None)
		return bPrevent; 

	VictimPRI = Victim.PlayerReplicationInfo;	
	if( VictimPRI==None || !Victim.bIsPlayer || ( VictimPRI.bIsSpectator && !VictimPRI.bWaitingPlayer ) )
		return bPrevent;

	VictimStats = SmartDOMPRI(SmartUTGame.GetStats(Victim));
	if (VictimStats!=None)
		VictimStats.SealSpree = 0;
		
	KillerPRI = Killer.PlayerReplicationInfo;
	if ( KillerPRI==None || !Killer.bIsPlayer || ( KillerPRI.bIsSpectator && !KillerPRI.bWaitingPlayer ) )
		return bPrevent;
		
	KillerStats = SmartDOMPRI(SmartUTGame.GetStats(Killer));
	if (KillerStats!=None)
	{
		// Get nearest ControlPoint
		for (Index=0; Index<ArrayCount(ControlPoints); Index++)
		{
			if (ControlPoints[Index]!=None && ControlPoints[Index].ControllingTeam!=None && (VSize(Victim.Location-ControlPoints[Index].Location)<512 || (VSize(Victim.Location-ControlPoints[Index].Location)<768 && Victim.lineOfSightTo(ControlPoints[Index]))))
			{
				if (NearestControlPoint==None || VSize(Victim.Location-ControlPoints[Index].Location)<VSize(Victim.Location-NearestControlPoint.Location))
					NearestControlPoint = ControlPoints[Index];
			}
		}
		
		// If the kill is near a ControlPoint, it might be a...
		if (NearestControlPoint!=None)
		{
			// ... ControlPoint kill if the victim is near his own cp
			if (NearestControlPoint.ControllingTeam.TeamIndex==VictimPRI.Team)
			{
				KillerStats.ControlPointKills++;
			}
			// ... Seal if the kill is near own cp
			else if (NearestControlPoint.ControllingTeam.TeamIndex==KillerPRI.Team)
			{
				// Killer killed near own cp... (seal)
				KillerStats.Seals++;
				KillerStats.SealSpree++;
				if( SealMsgType != 0 && KillerStats != None && KillerStats.SealSpree == 2 ) // Sealing base
				{
					if( SealMsgType == 1 && PlayerPawn( Killer ) != None ) Killer.ClientMessage( class'SmartUTMessage'.static.GetString( 1 + 64, KillerPRI, VictimPRI ) );
					else if( SealMsgType == 2 ) BroadcastMessage( class'SmartUTMessage'.static.GetString( 1, KillerPRI, VictimPRI ) );
					else if( SealMsgType == 3 ) BroadcastLocalizedMessage( class'SmartUTMessage', 1, KillerPRI, VictimPRI );
				}
				KillerStats.Score += SealBonus;						
					
				// Log seal
				if( Level.Game.LocalLog != None ) Level.Game.LocalLog.LogSpecialEvent( "controlpoint_seal", KillerPRI.PlayerID, VictimPRI.PlayerID, KillerPRI.Team ); // Log to ngLog;					
			}
		}

	}
	
	return bPrevent;
}

function bool MutatorBroadcastLocalizedMessage( Actor Sender, Pawn Receiver, out class<LocalMessage> Message, out optional int Switch, out optional PlayerReplicationInfo RelatedPRI_1, out optional PlayerReplicationInfo RelatedPRI_2, out optional Object OptionalObject )
{
	local ControlPoint cp;
	local SmartDOMPRI ReceiverStats;
 
	if (Message==class'ControlPointMessage')
	{
		if (Sender.IsA('Domination'))
			cp = ControlPoint(OptionalObject);
		else if (Sender.IsA('ControlPoint'))
			cp = ControlPoint(Sender);
		else
			return super.MutatorBroadcastLocalizedMessage( Sender, Receiver, Message, Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject );
		if (cp==None)
			return super.MutatorBroadcastLocalizedMessage( Sender, Receiver, Message, Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject );
			
		// Warmup
		if (DeathMatchPlus( Level.Game ).bTournament && !bTournamentGameStarted)
			return super.MutatorBroadcastLocalizedMessage( Sender, Receiver, Message, Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject );

		// Switch is the teamid
		
		if (cp.Controller==Receiver)
		{
			ReceiverStats = SmartDOMPRI(SmartUTGame.GetStats(Receiver));
			if (ReceiverStats!=None)
			{
				ReceiverStats.Captures++;
				ReceiverStats.Score += CapBonus;
				if (bPlayCaptureSound)
					PlayerPawn(Receiver).ReceiveLocalizedMessage(class'SmartUTAudioMsg', 0);
			}
		}
	}
	
	return super.MutatorBroadcastLocalizedMessage( Sender, Receiver, Message, Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject );
}

function SendSmartUTRules(PlayerPawn Sender)
{
      Sender.ClientMessage( "- Cap:" @ CapBonus @ "pts, Seal:" @ SealBonus @ "pts." );
}

function GetSmartUTInfo(out string SoundsString, out string MsgsString, out string CMsgsString)
{
	// Sounds
	if (bPlayCaptureSound) SoundsString = SoundsString @ "Capture";
	if (bPlayLessCPSound) SoundsString = SoundsString @ "LessCP";

	// Messages
	if( SealMsgType == 1 ) MsgsString = MsgsString @ "Seals<priv.con>";
	if( SealMsgType == 2 ) MsgsString = MsgsString @ "Seals<pub.con>";
	if( SealMsgType == 3 ) MsgsString = MsgsString @ "Seals";
	
	// ConsoleMessages	
}

function CalcSmartUTEndStats()
{
	local SmartDOMPRI TopScore, TopCaps, TopSeals, PawnStats;
	local string BestRecordDate;
	local int ID;
	local float PerHour;
	local PlayerReplicationInfo PRI;
	local byte i;
	local SmartDOMEndStats EndStats;
	
	Super.CalcSmartUTEndStats();

	EndStats = SmartDOMEndStats(SmartUTGame.EndStats);
	SmartUTGame.RefreshPRI();
	for( i = 0; i < 64; i++ )
	{
		PawnStats = SmartDOMPRI(SmartUTGame.GetStatNr(i));
		if( PawnStats==None) break;
		if( TopScore==None || PlayerReplicationInfo(PawnStats.Owner).Score>PlayerReplicationInfo(TopScore.Owner).Score)
			TopScore = PawnStats;
		if (TopCaps==None || PawnStats.Captures>TopCaps.Captures)
			TopCaps = PawnStats;
		if (TopSeals==None || PawnStats.Seals>TopSeals.Seals)
			TopSeals = PawnStats;
	}
			
	PRI = PlayerReplicationInfo( TopScore.Owner );
	PerHour = ( Level.TimeSeconds - PRI.StartTime ) / 3600;
	if( PRI.Score / PerHour > EndStats.MostPoints.Count && Level.TimeSeconds - PRI.StartTime > 300 )
	{
		EndStats.MostPoints.Count = PRI.Score / PerHour;
		EndStats.MostPoints.PlayerName = PRI.PlayerName;
		EndStats.MostPoints.MapName = Level.Title;
		TeamGamePlus(Level.Game).GetTimeStamp( BestRecordDate );
		EndStats.MostPoints.RecordDate = BestRecordDate;
	}

	PRI = PlayerReplicationInfo( TopCaps.Owner );
	PerHour = ( Level.TimeSeconds - PRI.StartTime ) / 3600;
	if( TopCaps.Captures / PerHour > EndStats.MostCaps.Count && Level.TimeSeconds - PRI.StartTime > 300 )
	{
		EndStats.MostCaps.Count = TopCaps.Captures;
		EndStats.MostCaps.PlayerName = PRI.PlayerName;
		EndStats.MostCaps.MapName = Level.Title;
		TeamGamePlus(Level.Game).GetTimeStamp( BestRecordDate );
		EndStats.MostCaps.RecordDate = BestRecordDate;
	}
	
	PRI = PlayerReplicationInfo( TopSeals.Owner );
	PerHour = ( Level.TimeSeconds - PRI.StartTime ) / 3600;
	if( TopSeals.Seals / PerHour > EndStats.MostSeals.Count && Level.TimeSeconds - PRI.StartTime > 300 )
	{
		EndStats.MostSeals.Count = TopSeals.Seals / PerHour;
		EndStats.MostSeals.PlayerName = PRI.PlayerName;
		EndStats.MostSeals.MapName = Level.Title;
		TeamGamePlus(Level.Game).GetTimeStamp( BestRecordDate );
		EndStats.MostSeals.RecordDate = BestRecordDate;
	}
	
	EndStats.SaveConfig();

}

simulated function Timer()
{
	local int Index;
	local int NumTakenControlPoints[4];
	local Pawn pn;
	
	super.Timer();
	
	// Server - 1 second timer. infinite.
	if( Level.NetMode == NM_DedicatedServer || Role == ROLE_Authority )
	{
		PlayLeadSound();
		
		if (bPlayLessCPSound)
		{
			for (Index=0; Index<ArrayCount(ControlPoints); Index++)
			{
				if (ControlPoints[Index]!=None && ControlPoints[Index].ControllingTeam!=None)
					NumTakenControlPoints[ControlPoints[Index].ControllingTeam.TeamIndex]++;
			}
			
			for (pn=Level.PawnList; pn!=None; pn=pn.NextPawn)
					if (PlayerPawn(pn)!=None && pn.bIsPlayer && ( (NumTakenControlPoints[pn.PlayerReplicationInfo.Team]/TotControlPoints)<LessCPPercentage))
						PlayerPawn(pn).ClientPlaySound(Sound'Botpack.CTF.flagtaken');
		}		
	}
		
		
		
}

simulated event PostRender( Canvas C )
{
  local int i, Y, X;
  local float DummyY, Size;
  local string TempStr;
  local int Eff;
  local SmartUTPRI PlayerStats;

  super.PostRender(C);
    
  // Draw Extra Info
  if (SmartUTGame.bShowExtraInfo)
  {
	PlayerStats = SmartUTGame.GetStatsByPRI(pPRI);
  	if (PlayerStats!=None)
	{
		C.Style = ERenderStyle.STY_Normal;
		C.Font = MyFonts.GetSmallestFont( C.ClipX );
	
		if (PlayerStats.Kills+pPRI.Deaths!=0)
		{
			Eff = int((PlayerStats.Kills/(pPRI.Deaths+PlayerStats.Kills)) * 100);
			if (Eff>=75)
				C.DrawColor = GreenTeamColor;
			else if (Eff<=25)
				C.DrawColor = RedTeamColor;
			else
				C.DrawColor = GoldTeamColor;
			TempStr = int((PlayerStats.Kills/(pPRI.Deaths+PlayerStats.Kills)) * 100)$"%";
		}
		else
		{
			C.DrawColor = White;
			TempStr = "N/A";
		}
				
		C.StrLen( TempStr, Size, DummyY );
		if( MyHUD.bHideAllWeapons ) Y = C.ClipY;
		else if( MyHUD.HudScale * MyHUD.WeaponScale * C.ClipX <= C.ClipX - 256 * MyHUD.Scale) Y = C.ClipY - 64 * MyHUD.Scale;
		else Y = C.ClipY - 128 * MyHUD.Scale;
		X = C.ClipX - Size - 6;
		Y = Y - 4 - 32 + ( 32 - DummyY ) / 2;
		C.SetPos( X, Y);
		C.DrawText( TempStr );

		TempStr = "D:"$int(pPRI.Deaths)@"E:";
		C.StrLen( TempStr, Size, DummyY );
		C.SetPos( X - Size, Y );
		C.DrawColor = White;
		C.DrawText( TempStr );
	}
  }
}

defaultproperties
{
    CapBonus=1
    SealBonus=3
    bPlayCaptureSound=True
    bPlayLessCPSound=True
    LessCPPercentage=0.50
    SealMsgType=3
    SmartUTEndStatsClass=Class'SmartDOMEndStats'
    SmartUTScoreBoardClass=Class'SmartDOMScoreBoard'
    SmartUTServerInfoClass=Class'SmartDOMServerInfo'
    GreenTeamColor=(R=0,G=255,B=0,A=0),
    GoldTeamColor=(R=255,G=255,B=0,A=0),
}
