class SmartCTFScoreBoard extends SmartUTScoreBoard;

var SmartCTFPRI OwnerStats;

var int MaxCaps, MaxAssists, MaxGrabs, MaxCovers, MaxSeals, MaxReturns, MaxFlagKills, MaxFrags, MaxDeaths;

function SpawnNormalScoreBoard()
{
	super.SpawnNormalScoreBoard();

	if (SmartUTGame!=None)
		OwnerStats = SmartCTFPRI(SmartUTGame.GetStats( PlayerOwner ));
}

function ShowScores( Canvas C )
{
  if( SmartUTGame == None || OwnerStats == None )
  {
    if( NormalScoreBoard != None )
		NormalScoreBoard.ShowScores( C );
    else
		PlayerOwner.bShowScores = False;
    return;
  }

  if( OwnerStats.bViewingStats )
  {
    SmartUTShowScores( C );
  }
  else
  {
    if( NormalScoreBoard == None )
		SmartUTShowScores( C );
    else
		NormalScoreBoard.ShowScores( C );
  }

  if( OwnerStats.IndicatorVisibility > 0 )
	ShowIndicator( C );
}

function SmartUTShowScores( Canvas C )
{
	local int i, j, Time, AvgPing, AvgPL, TotSB, TotAmp, Col;
	local int FPH, TTL, Eff;
	local int RedY, BlueY, X, Y;
	local float Nil, DummyX, DummyY, SizeX, SizeY, Buffer, Size;
	local byte LabelDrawn[2], Rendered[2];
	local Color TeamColor, TempColor;
	local string TempStr;
	local SmartCTFPRI PlayerStats, PlayerStats2;
	local int FlagShift; // CountryFlags

	if( Level.TimeSeconds - LastSortTime > 1 )
	{
		SortScores( 32 );
		RecountNumbers();
		InitStatBoardConstPos( C );
		CompressStatBoard( C );
		LastSortTime = Level.TimeSeconds;
	}

	Y = int( StartY );
	RedY = Y;
	BlueY = Y;
	C.Style = ERenderStyle.STY_Normal;

	for (i=0; i<32; i++)
	{
		if( Ordered[i] == None ) break;
		
		PlayerStats = SmartCTFPRI(SmartUTGame.GetStatsByPRI( Ordered[i] ));
		if (PlayerStats==None) continue;

		// set the pos depending on Team
		if( Ordered[i].Team == 0 )
		{
			X = RedStartX;
			Y = RedY;
			TeamColor = RedTeamColor;
		}
		else
		{
			X = BlueStartX;
			Y = BlueY;
			TeamColor = BlueTeamColor;
		}
		C.DrawColor = TeamColor;

	    if( LabelDrawn[Ordered[i].Team] == 0 )
	    {
			C.bNoSmooth = False;
			C.Font = PlayerNameFont;
			C.Style = ERenderStyle.STY_Translucent;
			if (Ordered[i].Team==0) C.DrawColor = RedHeaderColor;
			else C.DrawColor = BlueHeaderColor;
			C.StrLen( ScoreText, SizeX, SizeY );
			C.Style = ERenderStyle.STY_Modulated;
			C.SetPos( X - ShadingSpacingX, Y - HeaderShadingSpacingY );
			C.DrawRect( texture'shade', ColumnWidth + ( ShadingSpacingX * 2 ) , SizeY + ( HeaderShadingSpacingY * 2 ) );
			C.Style = ERenderStyle.STY_Translucent;
			C.SetPos( X - ShadingSpacingX, Y - HeaderShadingSpacingY );
			if (Ordered[i].Team==0) C.DrawPattern( texture'redskin2', ColumnWidth + ( ShadingSpacingX * 2 ) , SizeY + ( HeaderShadingSpacingY * 2 ) , 1 );
			else C.DrawPattern( texture'blueskin2', ColumnWidth + ( ShadingSpacingX * 2 ) , SizeY + ( HeaderShadingSpacingY * 2 ) , 1 );

			C.Style = ERenderStyle.STY_Modulated;
			C.SetPos( X - ShadingSpacingX, Y + SizeY + HeaderShadingSpacingY );
			C.DrawRect( texture'shade', ColumnWidth + ( ShadingSpacingX * 2 ) , ColumnHeight + ( ColumnShadingSpacingY * 2 ) );

			// Draw Team icon
			C.Style = ERenderStyle.STY_Translucent;
			C.DrawColor = TeamColor;
			C.SetPos( X, Y - ( ( 32 - SizeY ) / 2 ) ); // Y - 4
			if( Ordered[i].Team == 0 ) C.DrawIcon( texture'I_TeamR', 0.5 );
			else C.DrawIcon( texture'I_TeamB', 0.5 );

			// Draw Scores
			C.Font = CapFont;
			C.StrLen( int( pTGRI.Teams[Ordered[i].Team].Score ), DummyX, DummyY );
			C.Style = ERenderStyle.STY_Normal;
			C.SetPos( X + StatIndent, Y - ( ( DummyY - SizeY ) / 2 ) );
			C.DrawText( int( pTGRI.Teams[Ordered[i].Team].Score ) );
			C.Font = PlayerNameFont;
			C.StrLen( ScoreText, SizeX, Nil );
			C.SetPos( X + ColumnWidth - SizeX, Y );
			C.DrawText( ScoreText  );
			C.Font = FragsFont;
			C.StrLen( PointsText $ SepText, Buffer, Nil );
			C.SetPos( X + ColumnWidth - SizeX - Buffer, Y );
			C.DrawText( PointsText $ SepText );

			// Draw Team info
			C.DrawColor = HeaderTinyInfoColor;
			C.Font = TinyInfoFont;
			C.StrLen( "TEST", Nil, DummyY );
			C.SetPos( X + StatIndent + DummyX + 2 * StatsHorSpacing, Y + ( SizeY - DummyY * 2 ) / 2 );
			Time = Max( 1, Level.TimeSeconds / 60 );
			AvgPing = 0;
			AvgPL = 0;
			TotSB = 0;
			TotAmp = 0;
			for( j = 0; j < 32; j++ )
			{
				if( Ordered[j] == None ) break;
				if( Ordered[j].Team == Ordered[i].Team )
				{
					PlayerStats2 = SmartCTFPRI(SmartUTGame.GetStatsByPRI( Ordered[j] ));
					if( PlayerStats2 == None ) continue;
					AvgPing += Ordered[j].Ping;
					AvgPL += Ordered[j].PacketLoss;
					TotSB += PlayerStats2.ShieldBelts;
					TotAmp += PlayerStats2.Amplifiers;
				}
			}
			if( TotShieldBelts == 0 ) TotSB = 0;
			else TotSB = Clamp( float( TotSB ) / float( TotShieldBelts ) * 100, 0, 100 );
			if( TotAmps == 0 ) TotAmp = 0;
			else TotAmp = Clamp( float( TotAmp ) / float( TotAmps ) * 100, 0, 100 );
	  
			TempStr = "";
			if( TotSB != 0 ) TempStr = TempStr @"SB:" $ TotSB $ "%";	  
			if( TotAmp != 0 ) TempStr = TempStr @ "AM:" $ TotAmp $ "%";
			C.DrawText( TempStr );
			C.SetPos( X + StatIndent + DummyX + 2 * StatsHorSpacing, Y + ( SizeY - DummyY * 2 ) / 2 + DummyY );
			if( pTGRI.Teams[Ordered[i].Team].Size != 0 )
			{
				AvgPing = AvgPing / pTGRI.Teams[Ordered[i].Team].Size;
				AvgPL = AvgPL / pTGRI.Teams[Ordered[i].Team].Size;
			}
			TempStr = " TM:"$Time$" PI:"$AvgPing$" PL:" $ AvgPL $ "%";
			C.DrawText( TempStr );
			C.bNoSmooth = True;

			Y += SizeY + HeaderShadingSpacingY + ColumnShadingSpacingY;
			LabelDrawn[Ordered[i].Team] = 1;
		}

		C.Font = FooterFont;
		C.StrLen( "Test", Nil, DummyY );
		if( LabelDrawn[Ordered[i].Team] != 2 && ( Y + NameHeight + StatBlockHeight + StatBlockSpacing > C.ClipY - DummyY * 5 ) )
		{
			C.DrawColor = TeamColor;
			C.StrLen( MoreText , Size, DummyY );
			if( Ordered[i].Team == 1 ) C.SetPos( X + ColumnWidth - Size, C.ClipY - DummyY * 5 );
			else C.SetPos( X, C.ClipY - DummyY * 5 );
			C.DrawText( "[" @ pTGRI.Teams[Ordered[i].Team].Size - Rendered[Ordered[i].Team] @ MoreText @ "]" );
			LabelDrawn[Ordered[i].Team] = 2; // "More" label also drawn
		}
		else if( LabelDrawn[Ordered[i].Team] != 2 )
		{

			// Draw face
			//if(Ordered[i].HasFlag==None) // Flag icon on face
			//{
				C.bNoSmooth = False;
				C.DrawColor = White;
				C.Style = ERenderStyle.STY_Translucent;
				C.SetPos( X, Y );
				if( SmartUTGame.bStatsDrawFaces && Ordered[i].TalkTexture != None ) C.DrawIcon( Ordered[i].TalkTexture, 0.5 );
				else C.DrawIcon( texture'faceless', 0.5 );
				C.SetPos( X, Y );
				C.DrawColor = DarkGray;
				C.DrawIcon( texture'IconSelection', 1 );
				C.Style = ERenderStyle.STY_Normal;
				C.bNoSmooth = True;
			//}

			// Draw player name
			C.SetPos( X + StatIndent, Y );
			C.Font = PlayerNameFont;
			if (Ordered[i].bAdmin) C.DrawColor = White;
			else if (Ordered[i].PlayerID==pPRI.PlayerID) C.DrawColor = Yellow;
			else C.DrawColor = TeamColor;
			TempColor = C.DrawColor;
			C.DrawText( Ordered[i].PlayerName );
			C.StrLen( Ordered[i].PlayerName, Size, Buffer );

		  	// Draw info
			C.DrawColor = TinyInfoColor;
			C.Font = TinyInfoFont;
			C.StrLen( "TEST", Buffer, DummyY );
			C.SetPos( X + StatIndent + Size + StatsHorSpacing, Y + ( NameHeight - DummyY * 2 ) / 2 );
			TempStr = "";
			if (PlayerStats.HeadShots>0) TempStr = TempStr @"HS:"$ PlayerStats.HeadShots;
			if (PlayerStats.ShieldBelts>0) TempStr = TempStr @"SB:"$ PlayerStats.ShieldBelts;
			if (PlayerStats.Amplifiers>0) TempStr = TempStr @"AM:"$ PlayerStats.Amplifiers;
			if (Left(TempStr, 1)==" ") TempStr = Mid(TempStr, 1);
			C.DrawText( TempStr );
			TempStr = "TM:"$ Max(1, (Level.TimeSeconds+ pPRI.StartTime-Ordered[i].StartTime)/60);
			if ((PlayerStats.Kills+Ordered[i].Deaths)!=0)  TempStr = TempStr @"EFF:"$ Clamp(int((PlayerStats.Kills/(PlayerStats.Kills+Ordered[i].Deaths))*100), 0, 100)$"%";
			if (Left(TempStr, 1)==" ") TempStr = Mid(TempStr, 1);
			C.SetPos(X + StatIndent + Size + StatsHorSpacing, Y + ( NameHeight - DummyY * 2 ) / 2 + DummyY);
			C.DrawText(TempStr);
		
			// Draw Country flag
			if(PlayerStats.CountryPrefix != "")
			{
				C.SetPos( X+8, Y + StatIndent);
				C.bNoSmooth = False;
				C.DrawColor = White;
				C.DrawIcon(FD[GetFlagIndex(PlayerStats.CountryPrefix)].Tex, 1.0);
				FlagShift=12;
				C.bNoSmooth = True;
			}
			else
				FlagShift=0;	  

			// Draw Connection
			C.SetPos( X, Y + StatIndent + FlagShift);
			if( Ordered[i].bIsABot )
			{
				C.DrawText( "BOT" );
				if( Ordered[i].Team == pPRI.Team )
				{
					C.SetPos( X, Y + StatIndent + DummyY);
					C.DrawText( Left( string( BotReplicationInfo( Ordered[i] ).RealOrders ) , 3 ) );
				}
			}
			else
			{
		        C.DrawColor = HeaderTinyInfoColor;
		        TempStr = "PI:" $ Ordered[i].Ping;
		        if( Len( TempStr ) > 5 ) TempStr = "P:" $ Ordered[i].Ping;
		        if( Len( TempStr ) > 5 ) TempStr = string( Ordered[i].Ping );
		        C.DrawText( TempStr );
		        C.SetPos( X, Y + StatIndent + DummyY + FlagShift);
		        TempStr = "PL:" $ Ordered[i].PacketLoss $ "%";
		        if( Len( TempStr ) > 5 ) TempStr = "L:" $ Ordered[i].PacketLoss $ "%";
		        if( Len( TempStr ) > 5 ) TempStr = "L:" $ Ordered[i].PacketLoss;
		        if( Len( TempStr ) > 5 ) TempStr = Ordered[i].PacketLoss $ "%";
		        C.DrawText( TempStr );
			}
		
			// Draw Flag
			if( Ordered[i].HasFlag != None )
			{
				C.DrawColor = White;
				C.SetPos( X, Y );
				if( Ordered[i].HasFlag.IsA( 'GreenFlag' ) ) C.DrawIcon( texture'GreenFlag', 1 );
				else if( Ordered[i].HasFlag.IsA( 'YellowFlag' ) ) C.DrawIcon( texture'YellowFlag', 1 );
				else if( Ordered[i].Team == 0 ) C.DrawIcon( texture'BlueFlag', 1 );
				else C.DrawIcon( texture'RedFlag', 1 );
			}
		
			// Draw Score
			C.Font = PlayerNameFont;
			C.DrawColor = TempColor;
			C.StrLen( int(Ordered[i].Score), Size, DummyY );
			C.SetPos( X + ColumnWidth - Size, Y );
			C.DrawText( int(Ordered[i].Score) );
			C.DrawColor = TempColor;
			C.Font = FragsFont;
			C.StrLen( PlayerStats.Score $ SepText, Buffer, SizeY );
			C.SetPos( X + ColumnWidth - Size - Buffer, Y );
			C.DrawText(PlayerStats.Kills $ SepText );
	 
			// Draw Game stats
			Y += NameHeight;
			C.Font = StatFont; //TinyInfoFont
			if( RowColState == 1 )
			{
				DrawStatType( C, X, Y, 1, 1, "Caps: ", PlayerStats.Captures, MaxCaps );
				DrawStatType( C, X, Y, 1, 2, "Assists: ", PlayerStats.Assists, MaxAssists );
				DrawStatType( C, X, Y, 1, 3, "Grabs: ", PlayerStats.Grabs, MaxGrabs );
				DrawStatType( C, X, Y, 2, 1, "Covers: ", PlayerStats.Covers, MaxCovers );
				if( MaxSeals > 0 ) DrawStatType( C, X, Y, 2, 2, "Seals: ", PlayerStats.Seals, MaxSeals );
				else DrawStatType( C, X, Y, 2, 2, "Returns: ", PlayerStats.Returns, MaxReturns ); //DrawStatType( C, X, Y, 2, 2, "Deaths: ", Ordered[i].Deaths, MaxDeaths );
				DrawStatType( C, X, Y, 2, 3, "FlagKls: ", PlayerStats.FlagKills, MaxFlagKills );
			}
			else
			{
				DrawStatType( C, X, Y, 1, 1, "Caps: ", PlayerStats.Captures, MaxCaps );
				DrawStatType( C, X, Y, 1, 2, "Covers: ", PlayerStats.Covers, MaxCovers );
				DrawStatType( C, X, Y, 2, 1, "Grabs: ", PlayerStats.Grabs, MaxGrabs );
				if( MaxSeals > 0 ) DrawStatType( C, X, Y, 2, 2, "Seals: ", PlayerStats.Seals, MaxSeals );
				else DrawStatType( C, X, Y, 2, 2, "Returns: ", PlayerStats.Returns, MaxReturns ); //DrawStatType( C, X, Y, 2, 2, "Deaths: ", Ordered[i].Deaths, MaxDeaths );
				DrawStatType( C, X, Y, 3, 1, "Assists: ", PlayerStats.Assists, MaxAssists );
				DrawStatType( C, X, Y, 3, 2, "FlagKls: ", PlayerStats.FlagKills, MaxFlagKills );
			}
	  
			Y += StatBlockHeight + StatBlockSpacing;
		}

	    // Alter the RedY or BlueY and do next player
		if (Ordered[i].Team==0) RedY = Y;
		else BlueY = Y;
	    Rendered[Ordered[i].Team]++;

	} //End of PRI for loop

	DrawHeader( C );
	DrawFooters( C );
}

function RecountNumbers()
{
  local byte i;
  local SmartCTFPRI PlayerStats;

  MaxCaps = 0;
  MaxAssists = 0;
  MaxGrabs = 0;
  MaxCovers = 0;
  MaxSeals = 0;
  MaxReturns = 0;
  MaxFlagKills = 0;
  MaxFrags = 0;
  MaxDeaths = 0;
  TotShieldBelts = 0;
  TotAmps = 0;

  for( i = 0; i < 32; i++ )
  {
    if( Ordered[i] == None ) break;
    if( Ordered[i].bIsSpectator && !Ordered[i].bWaitingPlayer ) continue;

    PlayerStats = SmartCTFPRI(SmartUTGame.GetStatsByPRI( Ordered[i] ));
    if( PlayerStats != None )
    {
      if( PlayerStats.Captures > MaxCaps ) MaxCaps = PlayerStats.Captures;
      if( PlayerStats.Assists > MaxAssists ) MaxAssists = PlayerStats.Assists;
      if( PlayerStats.Grabs > MaxGrabs ) MaxGrabs = PlayerStats.Grabs;
      if( PlayerStats.Covers > MaxCovers ) MaxCovers = PlayerStats.Covers;
      if( PlayerStats.Seals > MaxSeals ) MaxSeals = PlayerStats.Seals;
	  if( PlayerStats.Returns > MaxReturns ) MaxReturns = PlayerStats.Returns;
      if( PlayerStats.FlagKills > MaxFlagKills ) MaxFlagKills = PlayerStats.FlagKills;
      if( PlayerStats.Kills > MaxFrags ) MaxFrags = PlayerStats.Kills;
      TotShieldBelts += PlayerStats.ShieldBelts;
      TotAmps += PlayerStats.Amplifiers;
    }
    if( Ordered[i].Deaths > MaxDeaths ) MaxDeaths = Ordered[i].Deaths;
  }
}

defaultproperties
{
    NormalScoreBoardClass=Class'Botpack.UnrealCTFScoreboard'
    HeaderText="SmartUT:CTF"
}
