class SmartCTF expands SmartUT config( SmartUT );

// This is an adopted version of SmartCTF 4C by {DnF2}SiNiSTeR; SmartCTF made by {PiN}Kev

/* Server Vars */
var byte RedAstIndex, BlueAstIndex;
var Pawn FCs[2], RedAssisters[32], BlueAssisters[32];
var Pawn RedFlagCarrier[32], BlueFlagCarrier[32];
var float RedFlagCarrierTime[32], BlueFlagCarrierTime[32];
var byte RedFCIndex, BlueFCIndex;
var float RedAssistTimes[32], BlueAssistTimes[32], PickupTime[2];
var FlagBase FlagStands[2];
var bool bTooCloseForSaves;

/* Client Vars */
var Color RedTeamColor, BlueTeamColor, White, Gray;

/* Server Vars Configurable */
var() config int CapBonus, AssistBonus, FlagKillBonus, CoverBonus, SealBonus, GrabBonus;
var() config float BaseReturnBonus, MidReturnBonus, EnemyBaseReturnBonus, CloseSaveReturnBonus;
var() config int MinimalCapBonus;
var() config bool bFixFlagBug;
var() config bool bNewCapAssistScoring;
var() config byte CoverMsgType;
var() config byte CoverSpreeMsgType;
var() config byte SealMsgType;
var() config byte SavedMsgType;
var() config bool bShowAssistConsoleMsg;
var() config bool bShowSealRewardConsoleMsg;
var() config bool bShowCoverRewardConsoleMsg;
var() config bool bPlayCaptureSound;
var() config bool bPlayAssistSound;
var() config bool bPlaySavedSound;

function PostBeginPlay()
{
  local FlagBase fb;

  super.PostBeginPlay();
  
  SmartCTFGameReplicationInfo(SmartUTGame).bShowFCLocation = bShowExtraInfo;

  // Get the Flag bases
  ForEach AllActors( class'FlagBase', fb ) FlagStands[ fb.Team ] = fb;
  if( VSize( FlagStands[0].Location - FlagStands[1].Location ) < 1.5 * 900  ) bTooCloseForSaves = True;
}

/*
 * For the flag bug each player gets a FlagChecker inventory on spawn.
 */
function ModifyPlayer( Pawn Other )
{
  local Inventory Inv;
  
  if( bFixFlagBug && Other.bIsPlayer && !( Other.PlayerReplicationInfo.bIsSpectator && !Other.PlayerReplicationInfo.bWaitingPlayer ) )
  {
    Inv = Spawn( class'SmartCTFFlagCheckerInventory' , Other );
    if( Inv != None ) Inv.GiveTo( Other );
  }
  super.ModifyPlayer( Other );
}

/*
 * Check for covers and seals, and adjust scores.
 */
function bool PreventDeath( Pawn Victim, Pawn Killer, name DamageType, vector HitLocation )
{
  local PlayerReplicationInfo VictimPRI, KillerPRI;
  local bool bPrevent, bVictimTeamHasFlag, bWarmupSkip;
  local Pawn pn;
  local float TimeAwake;
  local SmartCTFPRI KillerStats, VictimStats;

  bPrevent = super.PreventDeath( Victim, Killer, DamageType, HitLocation );
  if( bPrevent ) return bPrevent; // Player didn't die, so return.

  // If there is no victim, return.
  if( Victim == None ) return bPrevent;
  VictimPRI = Victim.PlayerReplicationInfo;
  if( VictimPRI == None || !Victim.bIsPlayer || ( VictimPRI.bIsSpectator && !VictimPRI.bWaitingPlayer ) ) return bPrevent;
  VictimStats = SmartCTFPRI(SmartUTGame.GetStats( Victim ));

  // If there is no killer / suicide, return.
  if( Killer == None || Killer == Victim )
    return bPrevent;

	
  KillerPRI = Killer.PlayerReplicationInfo;
  if( KillerPRI == None || !Killer.bIsPlayer || ( KillerPRI.bIsSpectator && !KillerPRI.bWaitingPlayer ) ) return bPrevent;
  KillerStats = SmartCTFPRI(SmartUTGame.GetStats( Killer ));

  // Same Team! We don't count those stats like that in SmartCTF.
  if( VictimPRI.Team == KillerPRI.Team ) return bPrevent;

  bWarmupSkip = DeathMatchPlus( Level.Game ).bTournament && !bTournamentGameStarted;

  if( !bWarmupSkip )
  {
    // For Flag Kill, inc player's FlagKills and total
    if( VictimPRI.HasFlag != None )
    {
      if( KillerStats != None ) KillerStats.FlagKills++;
      KillerPRI.Score += FlagKillBonus;
      // Already logged by UTStats serveractor. Dont want to do it twice.
      //if( Level.Game.LocalLog != None ) Level.Game.LocalLog.LogSpecialEvent( "flag_kill", KillerPRI.PlayerID, VictimPRI.PlayerID, VictimPRI.Team );
    } // If Killer has Flag, no cover or seal for him
    else if( KillerPRI.HasFlag == None && FCs[KillerPRI.Team] != None && FCs[KillerPRI.Team].PlayerReplicationInfo.HasFlag != None )
    {
      // COVER FRAG  / SEAL BASE
      // If Killer's Team has had an FC

      // If the FC has Flag Right now
      // Defend kill
      // org: If victim can see the FC or is within 600 unreal units (approx 40 feet) and has a line of sight to fc.
      //if( Victim.canSee( FCs[KillerPRI.Team] ) || ( Victim.lineOfSightTo( FCs[KillerPRI.Team] ) && Distance( Victim.Location, FCs[KillerPRI.Team].Location ) < 600 ) )
      // new: victim within 512 uu of FC
      //      or killer within 512 uu of FC
      //      or victim can see FC and was Victim within 1536 uu of FC
      //      or killer can see FC and Victim victim within 1024 uu of FC
      //      or victim has direct line to FC and was Victim within 768 uu
      if( ( VSize( Victim.Location - FCs[KillerPRI.Team].Location ) < 512 )
       || ( VSize( Killer.Location - FCs[KillerPRI.Team].Location ) < 512 )
       || ( VSize( Victim.Location - FCs[KillerPRI.Team].Location ) < 1536 && Victim.canSee( FCs[KillerPRI.Team] ) )
       || ( VSize( Victim.Location - FCs[KillerPRI.Team].Location ) < 1024 && Killer.canSee( FCs[KillerPRI.Team] ) )
       || ( VSize( Victim.Location - FCs[KillerPRI.Team].Location ) < 768  && Victim.lineOfSightTo( FCs[KillerPRI.Team] ) ) )
      {
        // Killer DEFENDED THE Flag CARRIER
        if( KillerStats != None )
        {
          KillerStats.Covers++;
          KillerStats.CoverSpree++;    // Increment Cover spree
        }
        KillerPRI.Score += CoverBonus;       // Reward points

        // Log cover
        if( Level.Game.LocalLog != None ) Level.Game.LocalLog.LogSpecialEvent( "flag_cover", KillerPRI.PlayerID, VictimPRI.PlayerID, KillerPRI.Team );

        // Cover sprees
        if( KillerStats != None )
        {
          if( KillerStats.CoverSpree == 3 )  // Cover x 3
          {
            if( CoverSpreeMsgType == 1 && PlayerPawn( Killer ) != None ) Killer.ClientMessage( class'SmartUTMessage'.static.GetString( 4 + 64, KillerPRI, VictimPRI ) );
            else if( CoverSpreeMsgType == 2 ) BroadcastMessage( class'SmartUTMessage'.static.GetString( 4, KillerPRI, VictimPRI ) );
            else if( CoverSpreeMsgType == 3 ) BroadcastLocalizedMessage( class'SmartUTMessage', 4, KillerPRI, VictimPRI );
          }
          else if( KillerStats.CoverSpree == 4 ) // Cover x 4
          {
            if( CoverSpreeMsgType == 1 && PlayerPawn( Killer ) != None ) Killer.ClientMessage( class'SmartUTMessage'.static.GetString( 5 + 64, KillerPRI, VictimPRI ) );
            else if( CoverSpreeMsgType == 2 ) BroadcastMessage( class'SmartUTMessage'.static.GetString( 5, KillerPRI, VictimPRI ) );
            else if( CoverSpreeMsgType == 3 ) BroadcastLocalizedMessage( class'SmartUTMessage', 5, KillerPRI, VictimPRI );
          }
          else //  // Covered FC
          {
            if( CoverMsgType == 1 && PlayerPawn( Killer ) != None ) Killer.ClientMessage( class'SmartUTMessage'.static.GetString( 0 + 64, KillerPRI, VictimPRI ) );
            else if( CoverMsgType == 2 ) BroadcastMessage( class'SmartUTMessage'.static.GetString( 0, KillerPRI, VictimPRI ) );
            else if( CoverMsgType == 3 ) BroadcastLocalizedMessage( class'SmartUTMessage', 0, KillerPRI, VictimPRI );
          }
        }
      }

      // Seal kill
      // If the map has player zones
      if( VictimPRI.PlayerZone != None )
      {
        bVictimTeamHasFlag = True;
        if( FCs[VictimPRI.Team] == None ) bVictimTeamHasFlag = False;
        if( FCs[VictimPRI.Team] != None && FCs[VictimPRI.Team].PlayerReplicationInfo.HasFlag == None ) bVictimTeamHasFlag = False;
        // If Victim's FC has not been set / If Victim's FC doesn't have our Flag
        if( !bVictimTeamHasFlag )
        {
          // If Killer is Red & he and his FC's Location has Red
          if( IsInZone( VictimPRI, KillerPRI.Team ) && IsInZone( FCs[KillerPRI.Team].PlayerReplicationInfo, KillerPRI.Team ) )
          {
            // Killer SEALED THE BASE
            if( KillerStats != None )
            {
              KillerStats.Seals++;
              KillerStats.SealSpree++;
            }
            KillerPRI.Score += SealBonus;
            if( SealMsgType != 0 && KillerStats != None && KillerStats.SealSpree == 2 ) // Sealing base
            {
              if( SealMsgType == 1 && PlayerPawn( Killer ) != None ) Killer.ClientMessage( class'SmartUTMessage'.static.GetString( 1 + 64, KillerPRI, VictimPRI ) );
              else if( SealMsgType == 2 ) BroadcastMessage( class'SmartUTMessage'.static.GetString( 1, KillerPRI, VictimPRI ) );
              else if( SealMsgType == 3 ) BroadcastLocalizedMessage( class'SmartUTMessage', 1, KillerPRI, VictimPRI );
            }

            // Log seal
            if( Level.Game.LocalLog != None ) Level.Game.LocalLog.LogSpecialEvent( "flag_seal", KillerPRI.PlayerID, VictimPRI.PlayerID, KillerPRI.Team ); // Log to ngLog;
          }
        }
      }
    }
  }

  return bPrevent;
}

/*
 * Proper check if a player is in a location with 'red' or 'blue' in the name.
 */
function bool IsInZone( PlayerReplicationInfo PRI, byte Team )
{
  local string Loc;

  if( PRI.PlayerLocation != None ) Loc = PRI.PlayerLocation.LocationName;
  else if( PRI.PlayerZone != None ) Loc = PRI.PlayerZone.ZoneName;
  else return False;

  if( Team == 0 ) return ( Instr( Caps( Loc ), "RED" ) != -1 );
  else return ( Instr( Caps( Loc ), "BLUE" ) != -1 );
}

/*
 * Add a player to the Red FC/assister list.
 */
function AddRedFlagCarrier( Pawn Aster, float Fct )
{
  local byte i;

  if( Aster == None || !Aster.bIsPlayer || ( Aster.PlayerReplicationInfo.bIsSpectator && !Aster.PlayerReplicationInfo.bWaitingPlayer ) ) return;
  if( RedFCIndex >= 32 ) RedFCIndex = 0;

  // Check if already in list
  for( i = 0; i < 32; i++ )
  {
    if( Aster == RedFlagCarrier[i] )
    {
      RedFlagCarrierTime[i] += Fct;
      return;
    }
  }

  RedFlagCarrier[RedFCIndex] = Aster;
  RedFlagCarrierTime[RedFCIndex] = Fct;
  RedFCIndex++;
}

function AddBlueFlagCarrier( Pawn Aster, float Fct )
{
  local byte i;

  if( Aster == None || !Aster.bIsPlayer || ( Aster.PlayerReplicationInfo.bIsSpectator && !Aster.PlayerReplicationInfo.bWaitingPlayer ) ) return;
  if( BlueFCIndex >= 32 ) BlueFCIndex = 0;

  for( i = 0; i < 32; i++ )
  {
    if( Aster == BlueFlagCarrier[i] )
    {
      BlueFlagCarrierTime[i] += Fct;
      return;
    }
  }

  BlueFlagCarrier[BlueFCIndex] = Aster;
  BlueFlagCarrierTime[BlueFCIndex] = Fct;
  BlueFCIndex++;
}


/*
 * Walk through Red assisters/FC and reward them with points because of a cap.
 */
function RewardRedFlagCarriers( bool bNotPlayedLead )
{
  local byte j;
  local SmartCTFPRI AssisterStats;
  local int Bonus;
  local float TotalTime, f;

  Bonus = AssistBonus;

  // Calculate the total flag carrying time
  for( j = 0; j < 32; j++ ) TotalTime += RedFlagCarrierTime[j];

  for( j = 0; j < 32; j++ )
  {
    // If flagcarrier was not the capper
    if( RedFlagCarrier[j] != None && RedFlagCarrier[j] != FCs[0] )
    {
      AssisterStats = SmartCTFPRI(SmartUTGame.GetStats( RedFlagCarrier[j] ));
      if( AssisterStats != None ) AssisterStats.Assists++;

      if( bNewCapAssistScoring )
      {
        if( TotalTime == 0 ) f = 0;
        else f = ( RedFlagCarrierTime[j] / TotalTime ) * ( 7 + CapBonus ); // proportionally score
        Bonus = Max( f, 1 );
      }
      RedFlagCarrier[j].PlayerReplicationInfo.Score += Bonus;

      if( PlayerPawn( RedFlagCarrier[j] ) != None )
      {
        if( bShowAssistConsoleMsg ) PlayerPawn( RedFlagCarrier[j] ).ClientMessage( "You get " $ Bonus $ " bonus pts for the Assist!" @ CarriedString( RedFlagCarrierTime[j], TotalTime ) );
        if( bPlayAssistSound && bNotPlayedLead ) PlayerPawn( RedFlagCarrier[j] ).ReceiveLocalizedMessage( class'SmartUTAudioMsg', 1 );
      }
      if( Level.Game.LocalLog != None ) Level.Game.LocalLog.LogSpecialEvent( "Flag_assist", RedFlagCarrier[j].PlayerReplicationInfo.PlayerID, 0 );
    }
    // Award capper propertionally too. Behave like assist
    else if( RedFlagCarrier[j] == FCs[0] )
    {
      if( bNewCapAssistScoring )
      {
        if( TotalTime == 0 ) f = 0;
        else f = ( RedFlagCarrierTime[j] / TotalTime ) * ( 7 + CapBonus );
        Bonus = Max( f, MinimalCapBonus );
        FCs[0].PlayerReplicationInfo.Score += Bonus - 7; // 7 already awarded by UT
        if( bShowAssistConsoleMsg && PlayerPawn( FCs[0] ) != None ) PlayerPawn( FCs[0] ).ClientMessage( "You get " $ Bonus $ " pts for the Capture!" @ CarriedString( RedFlagCarrierTime[j], TotalTime ) );
      }
      else FCs[0].PlayerReplicationInfo.Score += CapBonus;
    }
  }
  ResetFlagCarriers( 0 );
}

function RewardBlueFlagCarriers( bool bNotPlayedLead )
{
  local byte j;
  local SmartCTFPRI AssisterStats;
  local int Bonus;
  local float TotalTime, f;

  Bonus = AssistBonus;

  for( j = 0; j < 32; j++ ) TotalTime += BlueFlagCarrierTime[j];

  for( j = 0; j < 32; j++ )
  {
    if( BlueFlagCarrier[j] != None && BlueFlagCarrier[j] != FCs[1] )
    {
      AssisterStats = SmartCTFPRI(SmartUTGame.GetStats( BlueFlagCarrier[j] ));
      if( AssisterStats != None ) AssisterStats.Assists++;

      if( bNewCapAssistScoring )
      {
        if( TotalTime == 0 ) f = 0;
        else f = ( BlueFlagCarrierTime[j] / TotalTime ) * ( 7 + CapBonus );
        Bonus = Max( f, 1 );
      }
      BlueFlagCarrier[j].PlayerReplicationInfo.Score += Bonus;

      if( PlayerPawn( BlueFlagCarrier[j] ) != None )
      {
        if( bShowAssistConsoleMsg ) PlayerPawn( BlueFlagCarrier[j] ).ClientMessage( "You get " $ Bonus $ " bonus pts for the Assist!" @ CarriedString( BlueFlagCarrierTime[j], TotalTime ) );
        if( bPlayAssistSound && bNotPlayedLead ) PlayerPawn( BlueFlagCarrier[j] ).ReceiveLocalizedMessage( class'SmartUTAudioMsg', 1 );
      }
      if( Level.Game.LocalLog != None ) Level.Game.LocalLog.LogSpecialEvent( "Flag_assist", BlueFlagCarrier[j].PlayerReplicationInfo.PlayerID, 0 );
    }
    else if( BlueFlagCarrier[j] == FCs[1] )
    {
      if( bNewCapAssistScoring )
      {
        if( TotalTime == 0 ) f = 0;
        else f = ( BlueFlagCarrierTime[j] / TotalTime ) * ( 7 + CapBonus );
        Bonus = Max( f, MinimalCapBonus );
        FCs[1].PlayerReplicationInfo.Score += Bonus - 7;
        if( bShowAssistConsoleMsg && PlayerPawn( FCs[1] ) != None ) PlayerPawn( FCs[1] ).ClientMessage( "You get " $ Bonus $ " pts for the Capture!" @ CarriedString( BlueFlagCarrierTime[j], TotalTime ) );
      }
      else FCs[1].PlayerReplicationInfo.Score += CapBonus;
    }
  }
  ResetFlagCarriers( 1 );
}

/*
 * Clear assisters list of Team, because of flag return. Team = 2: clear both teams.
 */
function ResetFlagCarriers( byte Team )
{
  local byte i;

  if( Team != 1 )
  {
    RedFCIndex = 0;
    for( i = 0; i < 32; i++ )
    {
      RedFlagCarrier[i] = None;
      RedFlagCarrierTime[i] = 0;
    }
  }
  if( Team != 0 )
  {
    BlueFCIndex = 0;
    for( i = 0; i < 32; i++ )
    {
      BlueFlagCarrier[i] = None;
      BlueFlagCarrierTime[i] = 0;
    }
  }
}

function string CarriedString( float Time, float TotalTime )
{
  local int Perc;
  local float f;

  //if( !bNewCapAssistScoring ) return "";

  if( TotalTime == 0 ) f = 0;
  else f = ( Time / TotalTime ) * 100;
  Perc = Clamp( f, 0, 100 );
  if( Perc == 100 ) return "(Solocap," @ int( Time ) @ "sec.)";
  else return "(Carried" @ Perc $ "% of the time:" @ int( Time ) @ "sec.)";
}

/*
 * Intercept CTF messages to set FC states and adjust scores.
 */
function bool MutatorBroadcastLocalizedMessage( Actor Sender, Pawn Receiver, out class<LocalMessage> Message, out optional int Switch, out optional PlayerReplicationInfo RelatedPRI_1, out optional PlayerReplicationInfo RelatedPRI_2, out optional Object OptionalObject )
{
  local CTFFlag Flag;
  local byte i, LeadSound;
  local Pawn pn, FirstPawn;
  local SmartCTFPRI ReceiverStats;

  // This function gets called each time someone receives a message. Thus for a broadcast, we need to make sure code only
  // gets executed once. We can do that by comparing Receiver with f.e. the FC if applicable, or with the first Pawn
  // in the PawnList (FirstPawn, see below).

  if( Message == class'CTFMessage' )
  {
    if( Sender.IsA( 'CTFGame' ) ) Flag = CTFFlag( OptionalObject );
    else if( Sender.IsA( 'CTFFlag' ) ) Flag = CTFFlag( Sender );
    else return super.MutatorBroadcastLocalizedMessage( Sender, Receiver, Message, Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject );
    if( Flag == None ) return super.MutatorBroadcastLocalizedMessage( Sender, Receiver, Message, Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject );

    // Warmup
    if( DeathMatchPlus( Level.Game ).bTournament && !bTournamentGameStarted ) return super.MutatorBroadcastLocalizedMessage( Sender, Receiver, Message, Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject );

    switch( Switch )
    {
      // CAPTURE
      // Sender: CTFGame, PRI: Scorer.PlayerReplicationInfo, OptObj: TheFlag
      case 0:
        if( Receiver == Pawn( RelatedPRI_1.Owner ) )
        {
          //Flag = CTFFlag( OptionalObject );
          i = 1 - Flag.Team;
          if( i == 1 ) AddBlueFlagCarrier( FCs[i], Level.TimeSeconds - PickupTime[i] );
          else AddRedFlagCarrier( FCs[i], Level.TimeSeconds - PickupTime[i] );

          // Increment Caps for the player and the total
          ReceiverStats = SmartCTFPRI(SmartUTGame.GetStats( FCs[i] ));
          if( ReceiverStats != None ) ReceiverStats.Captures++;

		  PlayLeadSound();

          // Don't play Capture sound if "Got The Lead" sound has played
          if( bPlayCaptureSound && PlayerPawn( FCs[i] ) != None )
          {
            if( !( bPlayLeadSound && ( LeadSound == 1 ) ) ) PlayerPawn( FCs[i] ).ReceiveLocalizedMessage( class'SmartUTAudioMsg', 0 );
          }

          // Reward points To FC and Assisters and increment Assists count and total
          if( Flag.Team == 0 ) RewardBlueFlagCarriers( !( bPlayLeadSound && ( LeadSound == 1 ) ) );
          else RewardRedFlagCarriers( !( bPlayLeadSound && ( LeadSound == 1 ) ) );
          ResetFlagCarriers( 2 );
          GiveCoverSealBonus( Flag.Team ); // Reward pts to Covers And Sealers

          // Reset FCs And Assister num n index And reset sprees
          FCs[0] = None;
          FCs[1] = None;
          ResetSprees( 2 ); // Means reset all since no Team is equal to 2.
        }
        break;

      // DROP
      // Sender: CTFFlag, PRI: Holder.PlayerReplicationInfo, OptObj: CTFGame(Level.Game).Teams[Team]
      case 2:
        if( Receiver == Pawn( RelatedPRI_1.Owner ) )
        {
          i = 1 - Flag.Team;
          if( i == 1 ) AddBlueFlagCarrier( FCs[i], Level.TimeSeconds - PickupTime[i] );
          else AddRedFlagCarrier( FCs[i], Level.TimeSeconds - PickupTime[i] );
        }
        break;

      // PICKUP (after the FC dropped it)
      // Sender: CTFFlag, PRI: Holder.PlayerReplicationInfo, OptObj: CTFGame(Level.Game).Teams[Team]
      case 4:
        if( Receiver == Flag.Holder )
        {
          i = 1 - Flag.Team;
          PickupTime[i] = Level.TimeSeconds;
          FCs[i] = Flag.Holder;
        }
        break;

      // GRAB
      // Sender: CTFFlag, PRI: Holder.PlayerReplicationInfo, OptObj: CTFGame(Level.Game).Teams[Team]
      case 6:
        if( Receiver == Flag.Holder )
        {
          i = 1 - Flag.Team;
          PickupTime[i] = Level.TimeSeconds;
          FCs[i] = Flag.Holder; // Set the FC
          RelatedPRI_1.Score += GrabBonus;
          // Increment FC's Grabs and total Grabs
          ReceiverStats = SmartCTFPRI(SmartUTGame.GetStats( FCs[i] ));
          if( ReceiverStats != None ) ReceiverStats.Grabs++;
        }
        break;


      // RETURN
      case 1:
      case 3:
      case 5:
        // Get a pawn that receives messages, thus triggers this function ( as Receiver )
        for( FirstPawn = Level.PawnList; FirstPawn != None; FirstPawn = FirstPawn.NextPawn )
        {
          if( FirstPawn.bIsPlayer || FirstPawn.IsA( 'MessagingSpectator' ) ) break;
        }

        if( Receiver == FirstPawn ) // Just get the first one.
        {
          // Switch == 1: it's returned by player, sent by CTFGame.
          //   Sender: CTFGame, PRI: Scorer.PlayerReplicationInfo, ObtObj: TheFlag
          if( Switch == 1 )
          {			
            // 8 pts for a close save (with msg), Half a pt for base returns, 2 pts for Mid, 4 pts for enemy base
            if( !bTooCloseForSaves && VSize( Flag.Location - FlagStands[1 - Flag.Team].Location ) < 900 )
            { // CLOSE SAVE
              RelatedPRI_1.Score += CloseSaveReturnBonus;
              if( Level.Game.LocalLog != None ) Level.Game.LocalLog.LogSpecialEvent( "flag_return_closesave", RelatedPRI_1.PlayerID, Flag.Team );

              // Only a msg if not a Flag standoff - other flag is home
              if( CTFReplicationInfo( Level.Game.GameReplicationInfo ).FlagList[1 - Flag.Team].bHome )
              {
                if( SavedMsgType == 1 && PlayerPawn( RelatedPRI_1.Owner ) != None ) PlayerPawn( RelatedPRI_1.Owner ).ClientMessage( class'SmartUTMessage'.static.GetString( 7 + 64, RelatedPRI_1 ) );
                else if( SavedMsgType == 2 ) BroadcastMessage( class'SmartUTMessage'.static.GetString( 7, RelatedPRI_1 ) );
                else if( SavedMsgType == 3 ) BroadcastLocalizedMessage( class'SmartUTMessage', 7, RelatedPRI_1 );
                if( bPlaySavedSound && PlayerPawn( RelatedPRI_1.Owner ) != None ) PlayerPawn( RelatedPRI_1.Owner ).ReceiveLocalizedMessage( class'SmartUTAudioMsg', 2 );
              }
            }
            else if( IsInZone( RelatedPRI_1, 1 - Flag.Team ) )
            {
              RelatedPRI_1.Score += EnemyBaseReturnBonus; // If in enemy base
              if( Level.Game.LocalLog != None ) Level.Game.LocalLog.LogSpecialEvent( "flag_return_enemybase", RelatedPRI_1.PlayerID, Flag.Team );
            }
            else if( !IsInZone( RelatedPRI_1, Flag.Team ) ) // Not in enemy base and not on own side = mid
            {
              RelatedPRI_1.Score += MidReturnBonus; // If in Mid
              if( Level.Game.LocalLog != None ) Level.Game.LocalLog.LogSpecialEvent( "flag_return_mid", RelatedPRI_1.PlayerID, Flag.Team );
            }
            else
            {
              RelatedPRI_1.Score += BaseReturnBonus;
              if( Level.Game.LocalLog != None ) Level.Game.LocalLog.LogSpecialEvent( "flag_return_base", RelatedPRI_1.PlayerID, Flag.Team );
            }

          } // end if switch == 1

		  // Register return
			ReceiverStats = SmartCTFPRI(SmartUTGame.GetStats( RelatedPRI_1.Owner ));
			if (ReceiverStats!=None) ReceiverStats.Returns++;
		  
			ResetSprees( Flag.Team ); // Reset cover sprees and seal sprees of Other Team
			ResetFlagCarriers( 1 - Flag.Team ); // Reset assist list
        }

        break;
    } // end switch
  } // end if msg is CTF msg.

  return super.MutatorBroadcastLocalizedMessage( Sender, Receiver, Message, Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject );
}

/*
 * Gives all players of Team that covered their FC extra bonus points after the cap.
 */
function GiveCoverSealBonus( int Team )
{
  local PlayerReplicationInfo pnPRI;
  local byte i;
  local SmartCTFPRI PawnStats;
  local Pawn pn;

  SmartUTGame.RefreshPRI();
  for( i = 0; i < 64; i++ )
  {
    PawnStats = SmartCTFPRI(SmartUTGame.GetStatNr( i ));
    if( PawnStats == None ) break;
    pnPRI = PlayerReplicationInfo( PawnStats.Owner );
    pn = Pawn( pnPRI.Owner );

    if( pnPRI.Team != Team )
    {
      if( PawnStats != None && PawnStats.SealSpree > 0 )
      {
        pnPRI.Score += PawnStats.SealSpree * SealBonus;
        if( bShowSealRewardConsoleMsg && PlayerPawn( pn ) != None ) PlayerPawn( pn ).ClientMessage("You killed " $ PawnStats.SealSpree $ " people sealing off the base. You get " $ PawnStats.SealSpree * SealBonus $ " bonus pts!" );
        if( Level.Game.LocalLog != None ) Level.Game.LocalLog.LogSpecialEvent( "seal_bonus", pnPRI.PlayerID, PawnStats.SealSpree, PawnStats.SealSpree * SealBonus );
      }
      if( PawnStats != None && PawnStats.CoverSpree > 0 )
      {
        pnPRI.Score += PawnStats.CoverSpree * CoverBonus;
        if( bShowCoverRewardConsoleMsg && PlayerPawn( pn ) != None ) PlayerPawn( pn ).ClientMessage("You killed " $ PawnStats.CoverSpree $ " people covering your FC. You get " $ PawnStats.CoverSpree * CoverBonus $ " bonus pts!" );
        if( Level.Game.LocalLog != None ) Level.Game.LocalLog.LogSpecialEvent( "cover_bonus", pnPRI.PlayerID, PawnStats.CoverSpree, PawnStats.CoverSpree * CoverBonus );
      }
    }
  }
}

/*
 * Reset cover and seal sprees of Team cause of flag return.
 */
function ResetSprees( int Team )
{
  local byte i;
  local SmartCTFPRI PawnStats;

  SmartUTGame.RefreshPRI();
  for( i = 0; i < 64; i++ )
  {
    PawnStats = SmartCTFPRI(SmartUTGame.GetStatNr( i ));
    if( PawnStats == None ) break;
    if( PlayerReplicationInfo( PawnStats.Owner ).Team != Team )
    {
      PawnStats.CoverSpree = 0;
      PawnStats.SealSpree = 0;
    }
  }
}

function ClearStats()
{
	Super.ClearStats();
	ResetFlagCarriers( 2 );
	FCs[0] = None;
	FCs[1] = None;
}

function SendSmartUTRules(PlayerPawn Sender)
{
	if( bNewCapAssistScoring ) Sender.ClientMessage( "SmartUT:CTF Score Settings: - Cap/Assist:" @ 7 + CapBonus @ "pts divided over all FC's by time" );
	else Sender.ClientMessage( "SmartUT:CTF Score Settings: - Cap:" @ 7 + CapBonus @ "pts, Assist:" @ AssistBonus @ "pts." );
	Sender.ClientMessage( "- Cover (Kills while defending FC) Bonus :" @ CoverBonus @ "pts each. And" @ CoverBonus @ "more pts each if FC caps." );
	Sender.ClientMessage( "- Seal Bonus:" @ SealBonus @ "pts each, and" @ SealBonus @ "more pts each if FC caps." );
	Sender.ClientMessage( "- Seals (Kills while sealing off base) are defined by: 1) Your FC is on your team's side of map. 2) Your flag is not taken. 3) You kill someone on your side of the map." );
	Sender.ClientMessage( "- Flagkills:" @ 5 + FlagKillBonus @ "pts. Flag Returns in base are worth" @ DitchZeros( BaseReturnBonus ) @ "pts, in mid" @ DitchZeros( MidReturnBonus ) @ "pts, enemy base" @ DitchZeros( EnemyBaseReturnBonus ) @ "pts, VERY close to capping" @ DitchZeros( CloseSaveReturnBonus ) @ "pts." );
}

function SendSmartUTInfo(PlayerPawn Sender)
{
    Sender.ClientMessage( "- bFixFlagBug:" @ bFixFlagBug );
}

function GetSmartUTInfo(out string SoundsString, out string MsgsString, out string CMsgsString)
{
	if( bPlayCaptureSound ) SoundsString = SoundsString @ "Capture";
    if( bPlayAssistSound ) SoundsString = SoundsString @ "Assist";
    if( bPlaySavedSound ) SoundsString = SoundsString @ "Saved";
    if( bPlayLeadSound ) SoundsString = SoundsString @ "Lead";
    if( bPlay30SecSound ) SoundsString = SoundsString @ "30SecLeft";

    if( CoverMsgType == 1 ) MsgsString = MsgsString @ "Covers<priv.con>";
    if( CoverMsgType == 2 ) MsgsString = MsgsString @ "Covers<pub.con>";
    if( CoverMsgType == 3 ) MsgsString = MsgsString @ "Covers";
    if( CoverSpreeMsgType == 1 ) MsgsString = MsgsString @ "Coversprees<priv.con>";
    if( CoverSpreeMsgType == 2 ) MsgsString = MsgsString @ "Coversprees<pub.con>";
    if( CoverSpreeMsgType == 3 ) MsgsString = MsgsString @ "Coversprees";
    if( SealMsgType == 1 ) MsgsString = MsgsString @ "Seals<priv.con>";
    if( SealMsgType == 2 ) MsgsString = MsgsString @ "Seals<pub.con>";
    if( SealMsgType == 3 ) MsgsString = MsgsString @ "Seals";
    if( SavedMsgType == 1 ) MsgsString = MsgsString @ "Saved<priv.con>";
    if( SavedMsgType == 2 ) MsgsString = MsgsString @ "Saved<pub.con>";
    if( SavedMsgType == 3 ) MsgsString = MsgsString @ "Saved";

    if( bShowAssistConsoleMsg ) CMsgsString = CMsgsString @ "AssistBonus";
    if( bShowSealRewardConsoleMsg ) CMsgsString = CMsgsString @ "SealReward";
    if( bShowCoverRewardConsoleMsg ) CMsgsString = CMsgsString @ "CoverReward";
}

function CalcSmartUTEndStats()
{
  local SmartCTFPRI TopScore, TopFrags, TopCaps, TopCovers, TopFlagkills, TopHeadshots, PawnStats;
  local string BestRecordDate;
  local int ID;
  local float PerHour;
  local PlayerReplicationInfo PRI;
  local byte i;
  local SmartCTFEndStats EndStats;

  Super.CalcSmartUTEndStats();
  
  EndStats = SmartCTFEndStats(SmartUTGame.EndStats);

  SmartUTGame.RefreshPRI();
  for( i = 0; i < 64; i++ )
  {
    PawnStats = SmartCTFPRI(SmartUTGame.GetStatNr( i ));
    if( PawnStats == None ) break;

    if( TopScore == None || PlayerReplicationInfo( PawnStats.Owner ).Score > PlayerReplicationInfo( TopScore.Owner ).Score ) TopScore = PawnStats;
    if( TopFrags == None || PawnStats.Kills > TopFrags.Kills ) TopFrags = PawnStats;
    if( TopCaps == None || PawnStats.Captures > TopCaps.Captures ) TopCaps = PawnStats;
    if( TopCovers == None || PawnStats.Covers > TopCovers.Covers ) TopCovers = PawnStats;
    if( TopFlagkills == None || PawnStats.FlagKills > TopFlagkills.FlagKills ) TopFlagkills = PawnStats;
    if( TopHeadshots == None || PawnStats.HeadShots > TopHeadshots.HeadShots ) TopHeadshots = PawnStats;
  }

  PRI = PlayerReplicationInfo( TopScore.Owner );
  PerHour = ( Level.TimeSeconds - PRI.StartTime ) / 3600;
  if( PRI.Score / PerHour > EndStats.MostPoints.Count && Level.TimeSeconds - PRI.StartTime > 300 )
  {
    EndStats.MostPoints.Count = PRI.Score / PerHour;
    EndStats.MostPoints.PlayerName = PRI.PlayerName;
    EndStats.MostPoints.MapName = Level.Title;
    CTFGame( Level.Game ).GetTimeStamp( BestRecordDate );
    EndStats.MostPoints.RecordDate = BestRecordDate;
  }

  PRI = PlayerReplicationInfo( TopFrags.Owner );
  PerHour = ( Level.TimeSeconds - PRI.StartTime ) / 3600;
  if( TopFrags.Kills / PerHour > EndStats.MostFrags.Count && Level.TimeSeconds - PRI.StartTime > 300 )
  {
    EndStats.MostFrags.Count = TopFrags.Kills / PerHour;
    EndStats.MostFrags.PlayerName = PRI.PlayerName;
    EndStats.MostFrags.MapName = Level.Title;
    CTFGame( Level.Game ).GetTimeStamp( BestRecordDate );
    EndStats.MostFrags.RecordDate = BestRecordDate;
  }

  PRI = PlayerReplicationInfo( TopCaps.Owner );
  PerHour = ( Level.TimeSeconds - PRI.StartTime ) / 3600;
  if( TopCaps.Captures / PerHour > EndStats.MostCaps.Count && Level.TimeSeconds - PRI.StartTime > 300 )
  {
    EndStats.MostCaps.Count = TopCaps.Captures / PerHour;
    EndStats.MostCaps.PlayerName = PRI.PlayerName;
    EndStats.MostCaps.MapName = Level.Title;
    CTFGame( Level.Game ).GetTimeStamp( BestRecordDate );
    EndStats.MostCaps.RecordDate = BestRecordDate;
  }

  PRI = PlayerReplicationInfo( TopCovers.Owner );
  PerHour = ( Level.TimeSeconds - PRI.StartTime ) / 3600;
  if( TopCovers.Covers / PerHour > EndStats.MostCovers.Count && Level.TimeSeconds - PRI.StartTime > 300 )
  {
    EndStats.MostCovers.Count = TopCovers.Covers / PerHour;
    EndStats.MostCovers.PlayerName = PRI.PlayerName;
    EndStats.MostCovers.MapName = Level.Title;
    CTFGame( Level.Game ).GetTimeStamp( BestRecordDate );
    EndStats.MostCovers.RecordDate = BestRecordDate;
  }

  PRI = PlayerReplicationInfo( TopFlagkills.Owner );
  PerHour = ( Level.TimeSeconds - PRI.StartTime ) / 3600;
  if( TopFlagkills.FlagKills / PerHour > EndStats.MostFlagKills.Count && Level.TimeSeconds - PRI.StartTime > 300 )
  {
    EndStats.MostFlagKills.Count = TopFlagkills.FlagKills / PerHour;
    EndStats.MostFlagKills.PlayerName = PRI.PlayerName;
    EndStats.MostFlagKills.MapName = Level.Title;
    CTFGame( Level.Game ).GetTimeStamp( BestRecordDate );
    EndStats.MostFlagKills.RecordDate = BestRecordDate;
  }

  PRI = PlayerReplicationInfo( TopHeadshots.Owner );
  PerHour = ( Level.TimeSeconds - PRI.StartTime ) / 3600;
  if( TopHeadshots.HeadShots / PerHour > EndStats.MostHeadShots.Count && Level.TimeSeconds - PRI.StartTime > 300 )
  {
    EndStats.MostHeadShots.Count = TopHeadshots.HeadShots / PerHour;
    EndStats.MostHeadShots.PlayerName = PRI.PlayerName;
    EndStats.MostHeadShots.MapName = Level.Title;
    CTFGame( Level.Game ).GetTimeStamp( BestRecordDate );
    EndStats.MostHeadShots.RecordDate = BestRecordDate;
  }

  EndStats.SaveConfig();
}

//----------------------------------------------------------------------------------------------------------------
//------------------------------------------------ CLIENT FUNCTIONS ----------------------------------------------
//----------------------------------------------------------------------------------------------------------------

/*
 * Render the HUD that is startup logo and FC location.
 * ONLY gets executed on clients.
 */
simulated event PostRender( Canvas C )
{
  local int i, Y;
  local float DummyY, Size;
  local string TempStr;

  super.PostRender(C);
    
  // Draw the FC Location
  if(SmartCTFGameReplicationInfo(SmartUTGame).bShowFCLocation )
  {
    for( i = 0; i < 32; i++ )
    {
      if( pTGRI.PRIArray[i] == None ) break;
      if( pTGRI.PRIArray[i].bIsSpectator && !pTGRI.PRIArray[i].bWaitingPlayer ) continue;
      if( pTGRI.PRIArray[i].HasFlag != None && pTGRI.PRIArray[i].Team == pPRI.Team && pTGRI.PRIArray[i].PlayerID != pPRI.PlayerID && !pTGRI.PRIArray[i].HasFlag.IsA( 'GreenFlag' ) )
      {
	  	  
        if( pTGRI.PRIArray[i].PlayerLocation != None ) TempStr = pTGRI.PRIArray[i].PlayerLocation.LocationName;
        else if( pTGRI.PRIArray[i].PlayerZone != None ) TempStr = pTGRI.PRIArray[i].PlayerZone.ZoneName;
        if( TempStr == "" )
        {
          TempStr = "Nameless Area";
          C.Style = ERenderStyle.STY_Translucent;
        }
        else
        {
          C.Style = ERenderStyle.STY_Normal;
        }

        if( pPRI.Team == 0 ) C.DrawColor = RedTeamColor;
        else C.DrawColor = BlueTeamColor;

        C.Font = MyFonts.GetSmallestFont( C.ClipX );
        C.StrLen( TempStr, Size, DummyY );
        if( MyHUD.bHideAllWeapons ) Y = C.ClipY;
        else if( MyHUD.HudScale * MyHUD.WeaponScale * C.ClipX <= C.ClipX - 256 * MyHUD.Scale) Y = C.ClipY - 64 * MyHUD.Scale;
        else Y = C.ClipY - 128 * MyHUD.Scale;

        C.SetPos( C.ClipX - Size - 6, Y - 4 - 32 + ( 32 - DummyY ) / 2 );
        C.DrawText( TempStr );
        if( C.Style == ERenderStyle.STY_Translucent ) C.DrawColor = Gray;
        else C.DrawColor = White;
        C.SetPos( C.ClipX - Size - 6 - 32 - 4, Y - 4 - 32 );
        if( pPRI.Team == 0 ) C.DrawIcon( texture'blueflag', 1.0 );
        else C.DrawIcon( texture'redflag', 1.0 );

        break;
      }
    }
  }

}

defaultproperties
{
    RedTeamColor=(R=255,G=0,B=0,A=0),
    BlueTeamColor=(R=0,G=128,B=255,A=0),
    White=(R=255,G=255,B=255,A=0),
    Gray=(R=128,G=128,B=128,A=0),
    CapBonus=8
    AssistBonus=7
    CoverBonus=2
    SealBonus=2
    BaseReturnBonus=0.50
    MidReturnBonus=2.00
    EnemyBaseReturnBonus=4.00
    CloseSaveReturnBonus=8.00
    MinimalCapBonus=5
    bFixFlagBug=True
    bNewCapAssistScoring=True
    CoverSpreeMsgType=1
    SealMsgType=1
    SavedMsgType=3
    bShowAssistConsoleMsg=True
    bShowSealRewardConsoleMsg=True
    bShowCoverRewardConsoleMsg=True
    bPlayAssistSound=True
    bPlaySavedSound=True
    SmartUTEndStatsClass=Class'SmartCTFEndStats'
    SmartUTGameReplicationInfoClass=Class'SmartCTFGameReplicationInfo'
    SmartUTScoreBoardClass=Class'SmartCTFScoreBoard'
    SmartUTServerInfoClass=Class'SmartCTFServerInfo'
}
