// FraggedMessage - Displaymessage for fraggers and fragged ones
// author: Jolle

class FraggedMessage extends LocalMessagePlus;

var color RedColor;

static function float GetOffset(int Switch, float YL, float ClipY )
{
	// Set position just over the "Head Shot" msg
	return (Default.YPos / 768.0) * ClipY - YL * 3;
}

// Switch: 0, Fragged someone - Cyan Color
//         1, Fragged by someone - Red Color
//         2, Fragged her/himself - Red Color
//
static function color GetColor(
	optional int Switch,
	optional PlayerReplicationInfo RelatedPRI_1, 
	optional PlayerReplicationInfo RelatedPRI_2
	)
{
	switch (Switch)
	{
		case 0:
			return Default.CyanColor;
			break;
		case 1:
		case 2:
			return Default.RedColor;
			break;
	}

	return Default.DrawColor;
}

// Switch: 0, Fragged someone - You fragged %killed%
//         1, Fragged by someone - You were fragged by %fragger%
//         2, Fragged her/himself - You fragged yourself!
// RelatedPRI_1: depends on Switch. is %killed%/%fragger% above
//
static function string GetString(
	optional int Switch,
	optional PlayerReplicationInfo RelatedPRI_1, 
	optional PlayerReplicationInfo RelatedPRI_2,
	optional Object OptionalObject 
	)
{
	if (Switch == 0)
	{
		if (RelatedPRI_1 == None)
			return "";
		return "You fragged " $ RelatedPRI_1.PlayerName;
	}
	if (Switch == 1)
	{
		if (RelatedPRI_1 == None)
			return "";
		return "You were fragged by " $ RelatedPRI_1.PlayerName;
	}
	if (Switch == 2)
		return "You fragged yourself!";

	return "";
}

defaultproperties
{
     RedColor=(R=255)
     FontSize=1
     bIsSpecial=True
     bIsUnique=True
     bFadeMessage=True
     YPos=196.000000
     bCenter=True
}
