// FragMessage - Player1 fragged Player2, Player1 fragged her/himself -  up in the radio
// author: Jolle

class FragMessage extends LocalMessagePlus;

// switch bit 1: 0 = Player1 fragged Player2
//               1 = player1 fragged her/himself
// switch bit 2<: percentage of damage inflicted
// RelatedPRI_1: The fragger
// RelatedPRI_2: The fragged one
//
static function string GetString(
	optional int Switch,
	optional PlayerReplicationInfo RelatedPRI_1, 
	optional PlayerReplicationInfo RelatedPRI_2,
	optional Object OptionalObject 
	)
{
	local int bit1;
	local int percent;
	local string startMsg;
	local string middleMsg;
	local string endMsg;
	
	if (RelatedPRI_1 == None)
		return "";

	bit1 = Switch % 2;
	percent = (Switch - bit1) / 2;

	startMsg = RelatedPRI_1.PlayerName $ " fragged ";
	endMsg = " with " $ string(percent) $ "%";

	if (bit1 == 0)
	{
		if (RelatedPRI_2 == None)
			return "";
		else
			middleMsg = RelatedPRI_2.PlayerName;
	}
	else if (bit1 == 1)
	{
		if (RelatedPRI_1.bIsFemale == True)
			middleMsg = "herself";
		else
			middleMsg = "himself";
	}
	else
		return "";

	return startMsg $ middleMsg $ endMsg;
}

defaultproperties
{
     DrawColor=(G=64,B=64)
}
