// FairFrags - You don't get a frag by killing somebody, you get it by causing
//             most damage to him.
// author: Jolle

class FairFrags extends Mutator;

var Pawn players[32];
var int damageInflicted[1600];
var bool initialized;

function PostBeginPlay()
{
  if (initialized)
    return;
  initialized = True;

  // Register our MutatorTakeDamage
  Level.Game.RegisterDamageMutator( Self );
}

function int GetIndexOfPlayer(Pawn player)
{
  local int i;
  local int j;
	
  // Do until we find a the player...
  i = 0;
  while (i < 32)
  {
    if (players[i] == player)
      return i;
    i++;
  }

  // ... or a free spot
  i = 0;
  while ((players[i] != None) && (i < 32))
    i++;

  // Check if we have too many players
  if (players[i] != None)
  {
    log("Mutator FairFrags: WARNING! Too many players! Only 32 is supported.");
    return 0;
  }

  // If it is a new player, add it and reset it
  players[i] = player;
  for (j = 0; j < 32; j++)
  {
    damageInflicted[j + (i << 5)] = 0;
    damageInflicted[i + (j << 5)] = 0;
  }

  return i;
}

function MutatorTakeDamage( out int ActualDamage, Pawn Victim, Pawn InstigatedBy, out Vector HitLocation, out Vector Momentum, name DamageType)
{
  local int victimIndex;

  if (Victim != None && InstigatedBy != None)
  {
    victimIndex = GetIndexOfPlayer(Victim);

    if (InstigatedBy.IsA('Bot') || InstigatedBy.IsA('PlayerPawn'))
      damageInflicted[GetIndexOfPlayer(InstigatedBy) + (victimIndex << 5)] += ActualDamage;
    else
      damageInflicted[victimIndex + (victimIndex << 5)] += ActualDamage;
  }

  if (NextDamageMutator != None)
    NextDamageMutator.MutatorTakeDamage( ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType);
}

function ModifyPlayer(Pawn Other)
{
  local int baseIndex;
  local int i;
	
  // Reset damage inflicted on player
  baseIndex = GetIndexOfPlayer(Other) << 5;
  for (i = 0; i < 32; i++)
    damageInflicted[i + baseIndex] = 0;
  
  if ( NextMutator != None )
    NextMutator.ModifyPlayer(Other);
}

function ScoreKill(Pawn Killer, Pawn Other)
{
  local int baseIndex;
  local int i;
  local int most;
  local int mostIndex;
  local int all;
  local int percent;
  local int healthDiff;

  if (Other != None)
  {
    baseIndex = GetIndexOfPlayer(Other) << 5;

    // Fix thingy if telefragged or trapped, and add 7 for killbonus
    if (Killer != None)
    {
      if (Other.Health < -299)
        damageInflicted[GetIndexOfPlayer(Killer) + baseIndex] += 1000;
      else
        damageInflicted[GetIndexOfPlayer(Killer) + baseIndex] += 7;
    }

    // the killer should not get a point, so lets remove the one that he gets later
    if ((Killer != None) && (Killer != Other))
      Killer.PlayerReplicationInfo.Score -= 1;

    // if it was suicide, then add the frag wich they remove later
    if ((Killer == None) || (Killer == Other))
      Other.PlayerReplicationInfo.Score += 1;

    // Lets find the one who have inflicted most damage
    for (i = 0; i < 32; i++)
    {
      if (damageInflicted[i + baseIndex] > most)
      {
        most = damageInflicted[i + baseIndex];
        mostIndex = i;
      }
      all += damageInflicted[i + baseIndex];
    }
    percent = most * 100 / all;

    baseIndex = baseIndex >> 5;

    // Suicide
    if (mostIndex == baseIndex)
    {
      // Let the suicider know
      Other.ReceiveLocalizedMessage(class'FraggedMessage', 2);

      // Let everybody know
      BroadcastLocalizedMessage(class'FragMessage', 1 + percent * 2, Other.PlayerReplicationInfo);

      // Steal frag :)
      Other.PlayerReplicationInfo.Score -= 1;
    }
    // And we have a winner? play safe, and make sure the fragger is still in game
    else if (players[mostIndex] != None)
    {
      // Let the fragger and the fragged one know what happend
      players[mostIndex].ReceiveLocalizedMessage( class'FraggedMessage', 0, Other.PlayerReplicationInfo);
      Other.ReceiveLocalizedMessage( class'FraggedMessage', 1, players[mostIndex].PlayerReplicationInfo);

      // Let everybody know what happend
      BroadcastLocalizedMessage(class'FragMessage', percent * 2, players[mostIndex].PlayerReplicationInfo, Other.PlayerReplicationInfo);

      // AND HE SCORES!
      players[mostIndex].PlayerReplicationInfo.Score += 1;
    }
  }

  Super.ScoreKill(Killer, Other);
}

defaultproperties
{
}
