class BN  expands Mutator config(BN4);

var bool		initialized;
var scriptedpawn	sp;
var int			monstertype;
var vector		loc;
var int			spreetype;
var string		mn;
var float		attackRadius;
var config float	SpreeMult;
var config float	HealthMult;
var config bool		bDoSpawn;

// 
// this function is never called, is just here to precache stuff and kill "spawn lag" (works fine !) 
//
function NobodyEverCallsMe()
{
sp = spawn(class'unreali.Queen',,, loc);     
sp = spawn(class'unreali.Warlord',,, loc);     
sp = spawn(class'unreali.SkaarjBerserker',,, loc);     
sp = spawn(class'unreali.SkaarjScout',,, loc);
sp = spawn(class'unreali.SkaarjWarrior',,, loc);
sp = spawn(class'unreali.SkaarjAssassin',,, loc);
sp = spawn(class'unreali.SkaarjLord',,, loc);
sp = spawn(class'unreali.SkaarjBerserker',,, loc);
sp = spawn(class'unreali.GiantManta',,, loc);
sp = spawn(class'unreali.KrallElite',,, loc);     
sp = spawn(class'unreali.MercenaryElite',,, loc);
sp = spawn(class'unreali.Krall',,, loc);
sp = spawn(class'unreali.Mercenary',,, loc);
sp = spawn(class'unreali.Slith',,, loc);
sp = spawn(class'unreali.Titan',,, loc);
sp = spawn(class'unreali.StoneTitan',,, loc);     
sp = spawn(class'unreali.Fly',,, loc);
sp = spawn(class'unreali.Manta',,, loc);     
sp = spawn(class'unreali.Brute',,, loc);
sp = spawn(class'unreali.Cow',,, loc);
sp = spawn(class'unreali.Nali',,, loc);
sp = spawn(class'unreali.Pupae',,, loc);
}

function PostBeginPlay()
{
     log("*** Initializing BadNews!");
     Level.Game.RegisterDamageMutator( Self );
     attackRadius = 600;
     Super.PostBeginPlay();
}

function ScoreKill(Pawn Killer, Pawn Other)
{
     local string deathmsg;


//  if ((Killer != None) && (Other != None) && bDoSPawn)
  if ((Killer != None) && (Other != None))
  {
     if (Other.isA('ScriptedPawn') && (Killer.isA('PlayerPawn') || Killer.isA('Bot')))
     {
	  Killer.spree++;
	  deathmsg=dmsg();
          if (Other.isA('Queen') || Other.isA('Titan') || Other.isA('StoneTitan'))
          {
               Killer.playerreplicationinfo.score += 4;
               BroadcastMessage( Killer.PlayerReplicationInfo.PlayerName@deathmsg@Other.GetHumanName()@"!!! 5 BONUS frags!" );
          }
          else
	     {
		if (Other.isA('Warlord') )
	        {
			Killer.playerreplicationinfo.score += 2;
               		BroadcastMessage( Killer.PlayerReplicationInfo.PlayerName@deathmsg@"a Warlord !! 3 BONUS frags!" );
	        }
		else
	        {
			BroadcastMessage( Killer.PlayerReplicationInfo.PlayerName@deathmsg@Other.GetHumanName() );
	        }
	    }
     }
  }
  Super.ScoreKill(Killer, Other);
}

function bool PreventDeath(Pawn Killed, Pawn Killer, name damageType, vector HitLocation)
{
  if ((Killer != None) && (Killed != None) && bDoSPawn)
  {
     if (Killed.isA('Cow') || Killed.isA('Nali') || Killed.isA('LeglessKrall'))
     {
        HurtRadius(1000.0, 250.0, 'RedeemerDeath', 10000, Killed.Location );
        spawn(class'ShockWave',Killer,,Killed.Location);
     }

  }
  return Super.PreventDeath(Killed, Killer, damageType, HitLocation);
}

function bool PlayerOn()
{
	local pawn P;

	for ( P=Level.PawnList; P!=None; P=P.nextPawn )
		if (PlayerPawn(P) != None) return true;
	return false;
}

function MutatorTakeDamage( out int ActualDamage, Pawn Victim, Pawn InstigatedBy, out Vector HitLocation,
     out Vector Momentum, name DamageType)
{
	local pawn aVictim;
	local int racnt;

//    if ((Instigatedby != None) && (Victim != InstigatedBy))
    if ((Instigatedby != None) && (Victim != InstigatedBy) && PlayerOn())
    {
	if (ActualDamage > Victim.Health)
	{
		if ((Victim.spree > 4) && bDoSPawn && (Victim.isA('PlayerPawn') || Victim.isA('Bot')))
		{
	          
			SpreeType = Victim.spree;
			Loc = Victim.Location;
			setTimer(1,false);
		}
		else
		if (bDoSPawn && ((DamageType == 'Decapitated') || (DamageType == 'Impact')))
		{
			SpreeType = InstigatedBy.spree;
			if (DamageType == 'Impact')
				SpreeType = -1;
			Loc = Victim.Location;
			setTimer(1,false);
		}
		if (InstigatedBy.IsA('ScriptedPawn'))
		{
			if (Victim.bIsPlayer) Victim.PlayerReplicationInfo.Deaths += 1;
			foreach RadiusActors(class'Pawn', aVictim, attackRadius, InstigatedBy.Location)
			{
				if ((!aVictim.IsA('PlayerPawn')) && (aVictim != Victim) && (aVictim.Health > 0)
				    && (InstigatedBy.Enemy != aVictim) && (InstigatedBy != aVictim) && (!InstigatedBy.IsA('Trigger')))
				{
					racnt++;
					InstigatedBy.Enemy = aVictim;
					if (aVictim.bIsPlayer) aVictim.Enemy = InstigatedBy;
					     else if (ScriptedPawn(aVictim) != None)
						  {
							ScriptedPawn(aVictim).OldEnemy = aVictim.Enemy;
							aVictim.Enemy = InstigatedBy;
							ScriptedPawn(aVictim).Hated = InstigatedBy;
							if (ScriptedPawn(aVictim).SetEnemy(InstigatedBy)) { ScriptedPawn(aVictim).GotoState('Attacking'); }
						  }
					if ((ScriptedPawn(InstigatedBy).SetEnemy(aVictim)) || (aVictim.bIsPlayer))
					{
						if (InstigatedBy.Enemy != None) InstigatedBy.gotostate('Attacking'); else InstigatedBy.gotostate('Wandering');
						break;
					}
				}
			}
			if (racnt == 0) attackRadius += attackRadius * 0.25; else attackRadius -= attackRadius * 0.25;
			FClamp(attackRadius, 20.0, 12000.0);
//			log("MTD --> attackRadius: "$attackRadius@" racnt: "$racnt);
		}

	} else
		if ((Victim.IsA('ScriptedPawn')) && (Victim.Enemy != InstigatedBy))
		{
			ScriptedPawn(Victim).OldEnemy = Victim.Enemy;
			Victim.Enemy = InstigatedBy;
			ScriptedPawn(Victim).Hated = InstigatedBy;
			ScriptedPawn(Victim).SetEnemy(InstigatedBy);
			if (Victim.Enemy != None) Victim.gotostate('Attacking'); else Victim.gotostate('Wandering');
		}
    }
	Super.MutatorTakeDamage( ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType );
}

function string dmsg()
{
     local int msgtype;
     local string msgtext;

               msgtype=rand(23);
               switch(msgtype)
               {
               case 0:
                    msgtext = "took out";
                    break;
               case 1:
                    msgtext = "make short work of";
                    break;
               case 2:
                    msgtext = "just slaughtered";
                    break;
               case 3:
                    msgtext = "terminated";
                    break;
               case 4:
                    msgtext = "massacrated";
                    break;
               case 5:
                    msgtext = "violated";
                    break;
               case 6:
                    msgtext = "destroyed";
                    break;
               case 7:
                    msgtext = "obliterated";
                    break;
               case 8:
                    msgtext = "beat up";
                    break;
               case 9:
                    msgtext = "smashed";
                    break;
               case 10:
                    msgtext = "owned";
                    break;
               case 11:
                    msgtext = "gave a major ass-whooping to";
                    break;
               case 12:
                    msgtext = "provided a fatal dose of pain to";
                    break;
               case 13:
                    msgtext = "blowed up";
                    break;
               case 14:
                    msgtext = "fatally fucked up";
                    break;
               case 15:
                    msgtext = "mangled";
                    break;
               case 16:
                    msgtext = "recreationally abused";
                    break;
               case 17:
                    msgtext = "dismantled";
                    break;
               case 18:
                    msgtext = "assaulted";
                    break;
               case 19:
                    msgtext = "soiled himself and wept after murdering";
                    break;
               case 20:
                    msgtext = "executed";
                    break;
               case 21:
                    msgtext = "eliminated";
                    break;
               case 22:
                    msgtext = "murdered";
               }
	return msgtext;
}

function Timer()
{
	spreetype = spreetype / SpreeMult;
	SpawnBadGuy();
	spreetype = 0;
	if (sp != None)
	{
		mn = sp.GetHumanName();
//		log("*** Timer Spawned " $ mn$" - "@sp);
		BroadcastMessage("Monster alert:"  $ mn $ " detected !");
	}
}

// Spawn a monster, if monster can't be spawn try to fall back on a smaller one
function SpawnBadGuy()
{
//     log("*** Attempting to spawn a monster");
     if (spreetype > 19)          //unstoppable & godlike (24)
     {
          monstertype=rand(3);
          switch(monstertype)
          {
          case 0:
               sp = spawn(class'unreali.Queen',,, loc);
               break;
          case 1:
               sp = spawn(class'unreali.Titan',,, loc);
               break;
          case 2:
               sp = spawn(class'unreali.StoneTitan',,, loc);
          }
          if (sp != none)
          {
               setupMonster(sp);
               return;
          }
     }
     if (spreetype > 14)          //dominating
     {
          monstertype=rand(2);
          switch(monstertype)
          {
          case 0:
               sp = spawn(class'unreali.WarLord',,, loc);
               break;
          case 1:
               sp = spawn(class'unreali.Queen',,, loc);
          }
          if (sp != none)
          {
               setupMonster(sp);
               return;
          }
     }
     if (spreetype > 9)          //rampage
     {
          monstertype=rand(5);
          switch(monstertype)
          {
          case 0:
               sp = spawn(class'unreali.SkaarjScout',,, loc);
               break;
          case 1:
               sp = spawn(class'unreali.SkaarjWarrior',,, loc);
               break;
          case 2:
               sp = spawn(class'unreali.SkaarjAssassin',,, loc);
               break;
          case 3:
               sp = spawn(class'unreali.SkaarjLord',,, loc);
               break;
          case 4:
               sp = spawn(class'unreali.SkaarjBerserker',,, loc);
          }     
          if (sp != none)
          {
               setupMonster(sp);
               return;
          }
     }
     if (spreetype > 4)           //killing spree 
     {
          monstertype=rand(4);
          switch(monstertype)
          {
          case 0:
               sp = spawn(class'unreali.Slith',,, loc);
               break;
          case 1:
               sp = spawn(class'unreali.KrallElite',,, loc);
               break;
          case 2:
               sp = spawn(class'unreali.MercenaryElite',,, loc);
               break;
          case 3:
               sp = spawn(class'unreali.Brute',,, loc);
          }     
          if (sp != none)
          {
               setupMonster(sp);
               return;
          }
     }
     if (spreetype > 0)           //any  
     {
          monstertype=rand(6);
          switch(monstertype)
          {
          case 0:
               sp = spawn(class'unreali.Brute',,, loc);
               break;
          case 1:
               sp = spawn(class'unreali.Fly',,, loc);
               break;
          case 2:
               sp = spawn(class'unreali.Manta',,, loc);
               break;
           case 3:
               sp = spawn(class'unreali.Krall',,, loc);
               break;
           case 4:
               sp = spawn(class'unreali.Mercenary',,, loc);
               break;
           case 5:
               sp = spawn(class'unreali.Pupae',,, loc);
          }     
          if (sp != none)
          {
               setupMonster(sp);
               return;
          }
     }
     if (spreetype == -1)           // Hammer Damage  
     {
          monstertype=rand(5);
          switch(monstertype)
          {
          case 0:
               sp = spawn(class'unreali.Cow',,, loc);
               break;
          case 1:
               sp = spawn(class'unreali.Nali',,, loc);
               break;
          case 2:
               sp = spawn(class'unreali.Manta',,, loc);
               break;
          case 3:
               sp = spawn(class'unreali.Fly',,, loc);
               break;
          case 4:
               sp = spawn(class'unreali.Pupae',,, loc);
          }     
          if (sp != none)
          {
               setupMonster(sp);
               return;
          }
     }

     if (sp == None)                               // last attempt to spawn something
     {              
          sp = spawn(class'unreali.Fly',,, loc);
          if (sp == None)                          // still no monster, too bad
          {
//            log("*** Could not spawn a monster");
          }
	  else { setupMonster(sp); }
     }
}

function bool CheckCollision(Actor A, float DSM, vector newLoc)  // Credit to Feralidragon for help with this function
{
local bool isColliding;
local float CRadius, CHeight;

   CRadius = A.CollisionRadius;
   CHeight = A.CollisionHeight;
   A.SetCollisionSize(A.CollisionRadius * DSM, A.CollisionHeight * DSM);
   isColliding = !A.SetLocation(newLoc);
   A.SetCollisionSize(CRadius, CHeight);
   return isColliding;
}

function setupMonster(out scriptedpawn monster)
{
     local pawn aVictim;
     local float F;
     local Vector V;
     local int racnt;

/*     if ((monster.bHidden) || (!monster.bCollideActors))     // This was needed for prior versions.  Haven't seen it happen yet in testing BN4
     {
//         log("Inviso monster destroyed.....BORK BORK BORK!!!!!");
         monster.Destroy(); return;
     }
*/

     racnt = 0; 
     monster.skill = 3;
     monster.bHunting=true;
     F = FMax(0.5000, (FRand()*2.0000));
     V = monster.Location;
     if ((F > 1.0) && (CheckCollision(monster, F, V))) { F = FMax(0.5000, FRand()); }
     monster.DrawScale = monster.DrawScale * F;
     monster.Mass = monster.Mass * F;
     monster.GroundSpeed = monster.GroundSpeed * F;
     monster.WaterSpeed = monster.WaterSpeed * F;
     monster.AirSpeed = monster.AirSpeed * F;
     monster.AccelRate = monster.AccelRate * F;
     monster.JumpZ = monster.JumpZ * F;
     monster.MaxStepHeight = monster.MaxStepHeight * F;
     monster.MeleeRange = monster.MeleeRange * F;
     monster.BaseEyeHeight = monster.BaseEyeHeight * F;
     monster.EyeHeight = monster.EyeHeight * F;
     if (monster.Shadow != None)
	{ monster.Shadow.DrawScale = monster.Shadow.DrawScale * F; }
     monster.Health = monster.Health * F * HealthMult;
     monster.SetCollisionSize((monster.CollisionRadius * F), (monster.CollisionHeight * F));
     monster.Buoyancy = monster.Buoyancy * F;
     monster.bHateWhenTriggered=true;
     foreach RadiusActors(class'Pawn', aVictim, attackRadius, V)
     {
	if ((!aVictim.IsA('PlayerPawn')) && (aVictim != monster) && (aVictim.Health > 0))
	{
		racnt++;
		monster.Hated = aVictim;
		monster.Enemy = aVictim;
		if (aVictim.bIsPlayer) aVictim.Enemy = monster;
		     else if (ScriptedPawn(aVictim) != None)
			{
				ScriptedPawn(aVictim).OldEnemy = aVictim.Enemy;
				aVictim.Enemy = monster;
				ScriptedPawn(aVictim).Hated = monster;
				if (ScriptedPawn(aVictim).SetEnemy(monster))
					ScriptedPawn(aVictim).GotoState('Attacking');
			}
		if ((monster.SetEnemy(aVictim)) || (aVictim.bIsPlayer))
		{
			if (monster.enemy != None) monster.gotostate('Attacking'); else monster.gotostate('Wandering');
			break;
		}
	}
     }
     monster.SetPhysics(PHYS_Falling);
     if (racnt == 0) attackRadius += attackRadius * 0.25; else attackRadius -= attackRadius * 0.25;
     FClamp(attackRadius, 20.0, 12000.0);
//     log("SetupMonster -> attackRadius: "$attackRadius@" racnt: "$racnt);
}

defaultproperties
{
    SpreeMult=1.0
    HealthMult=2.0
    bDoSpawn=True
}
