//=============================================================================
// TDM_SPGame.  12/17/11 - by Mr.Loathsome
//=============================================================================
class TDM_SPGame extends TeamGamePlus config;

var() config bool bScoreSPKills;
var() config bool bNegScoring;
var() config bool bScoreTeamKills;
var() config bool bMonsterTeam;
var() config bool bScoreSPvsSP;
var() config int MonsterTeamNum;
var() config int ForceTeamNum;
var() config bool bRandTeams;
var() config bool bSpawnInTeamArea;
var Bot Dummy;

function PostBeginPlay()
{
	local pawn P;
	local NavigationPoint N;

	if (bRandTeams) MaxTeams == Rand(3) + 2;
	if (bMonsterTeam)
	{
		FragLimit = GoalTeamScore;
		bNoTeamChanges = True;
		bScoreTeamKills = True;
		if (bRandTeams)
			MonsterTeamNum = Rand(4);
		else
			if ((MonsterTeamNum > 3) || (MonsterTeamNum < 0))
				MonsterTeamNum = 3;

		for (N = Level.NavigationPointList; N != NONE; N = N.NextNavigationPoint)
		{
			Dummy = Spawn(class'BotPack.TMale1Bot',,,N.Location);
			if (Dummy != None) break;
		}
		if (Dummy != None)
		{
			Dummy.PlayerReplicationInfo.PlayerID = Level.Game.CurrentID++;
			Level.Game.ChangeName(Dummy, "The Monster Team", false);
			Dummy.PlayerReplicationInfo.Team = MonsterTeamNum;
			Dummy.SetTimer(0, false);
			Dummy.Health = 0;
			Dummy.GotoState('GameEnded');
			Dummy.bHidden = True;
			Dummy.bCollideWorld = False;
		}
	}
	Super.PostBeginPlay();

	if (bMonsterTeam)
	{
		Teams[MonsterTeamNum] = Spawn(class'TeamInfo');
		Teams[MonsterTeamNum].Size = 1;
		Teams[MonsterTeamNum].Score = 0;
		Teams[MonsterTeamNum].TeamName = "The Monster Team";
		Teams[MonsterTeamNum].TeamIndex = MonsterTeamNum;
		TournamentGameReplicationInfo(GameReplicationInfo).Teams[MonsterTeamNum] = Teams[MonsterTeamNum];
	}
}

function playerpawn Login
(
	string Portal,
	string Options,
	out string Error,
	class<playerpawn> SpawnClass
)
{
	local PlayerPawn NewPlayer;
	local NavigationPoint StartSpot;

	NewPlayer = Super.Login(Portal, Options, Error, SpawnClass);
	if (NewPlayer == None)
		return None;
	if (ForceTeamNum != 255)
	{
		if (bRandTeams)
			ForceTeamNum = Rand(4);
		else
			if ((ForceTeamNum > 3) || (ForceTeamNum < 0))
				ForceTeamNum = 3;
		AddToTeam(ForceTeamNum, NewPlayer);
	}
	if ( bSpawnInTeamArea )
	{
		StartSpot = FindPlayerStart(NewPlayer,NewPlayer.PlayerReplicationInfo.Team);
		if ( StartSpot != None )
		{
			NewPlayer.SetLocation(StartSpot.Location);
			NewPlayer.SetRotation(StartSpot.Rotation);
			NewPlayer.ViewRotation = StartSpot.Rotation;
			NewPlayer.ClientSetRotation(NewPlayer.Rotation);
			StartSpot.PlayTeleportEffect(NewPlayer, true);
		}
	}
	PlayerTeamNum = NewPlayer.PlayerReplicationInfo.Team;
	return NewPlayer;
}

function bool IsOnTeam(Pawn Other, int TeamNum)
{
	if (((Other.bIsPlayer) && (Other.PlayerReplicationInfo.Team == TeamNum)) || ((!Other.bIsPlayer) && (MonsterTeamNum == TeamNum)))
		return true;

	return false;
}

function byte AssessBotAttitude(Bot aBot, Pawn Other)
{
	if (!Other.bIsPlayer) return 1;
	else 
		return Super.AssessBotAttitude(aBot, Other);
}

function ScoreKill(pawn Killer, pawn Other)
{
	if (((killer == None) && (Other.bIsPlayer)) || ((killer != None) && (killer == Other) && (Other.bIsPlayer)))
		Other.PlayerReplicationInfo.Score -= 1;
	else if (killer != None)
	{
		if ( Killer.bIsPlayer && Other.bIsPlayer && (Killer.PlayerReplicationInfo.Team != Other.PlayerReplicationInfo.Team) )
			Killer.PlayerReplicationInfo.Score += 1;
		else
		if (!Other.bIsPlayer && Killer.bIsPlayer)
		{
			if (bScoreSPKills)
				Killer.PlayerReplicationInfo.Score += 1;
			else
				if (bNegScoring)
					Killer.PlayerReplicationInfo.Score -= 1;
		}
	}
   if ( bScoreTeamKills )
   {
	if ((!Other.bIsPlayer) && (Killer != None) && (Killer.bIsPlayer) && (Killer.PlayerReplicationInfo.Team != 255))
	{
		Teams[Killer.PlayerReplicationInfo.Team].Score += 1;
	}
	if ((Other.bIsPlayer) && (Killer != None) && (Killer.bIsPlayer))
	{
		if ((Killer.PlayerReplicationInfo.Team != Other.PlayerReplicationInfo.Team) && (Killer.PlayerReplicationInfo.Team != 255))
			Teams[Killer.PlayerReplicationInfo.Team].Score += 1;
		else if ((FriendlyFireScale > 0) &&  (Other.PlayerReplicationInfo.Team != 255))
		{
			Teams[Other.PlayerReplicationInfo.Team].Score -= 1;
			Killer.PlayerReplicationInfo.Score -= 1;
		}
	}
   }
	BaseMutator.ScoreKill(Killer, Other);
}

function Killed(pawn killer, pawn Other, name damageType)
{
	local int NextTaunt, i, wt, ts;
	local bool bAutoTaunt, bTie;

	if ((Killer != None) && (Killer != Other) && (other.PlayerReplicationInfo != None) && (killer.PlayerReplicationInfo != None))
	{
		if (damageType == 'Decapitated')
		{
			if ((Level.Game.LocalLog != None) && (Other.PlayerReplicationInfo != None))
				Level.Game.LocalLog.LogSpecialEvent("headshot", Killer.PlayerReplicationInfo.PlayerID, Other.PlayerReplicationInfo.PlayerID);
			if ((Level.Game.WorldLog != None) && (Other.PlayerReplicationInfo != None))
				Level.Game.WorldLog.LogSpecialEvent("headshot", Killer.PlayerReplicationInfo.PlayerID, Other.PlayerReplicationInfo.PlayerID);
		}
	}
	if ((Killer != None) && (killer.PlayerReplicationInfo != None) && (damageType == 'Decapitated') && (!Other.bIsPlayer))
		Killer.ReceiveLocalizedMessage( class'DecapitationMessage' );
	if (!bMonsterTeam || ((Killer != None) && (killer.PlayerReplicationInfo != None) && (Other.PlayerReplicationInfo != None)))
	{
		Super.Killed(killer, Other, damageType);
	}
	else
	{
		if ((Killer != None) && (killer.PlayerReplicationInfo == None) && (Killer != Other))
		{
			if (bMonsterTeam)
			{
				Dummy.PlayerReplicationInfo.PlayerName = Killer.GetHumanName();
				if ((Other.bIsPlayer) && (!Killer.IsA('StationaryPawn'))) ScoreKill(Dummy, Other);
			}
			Super(GameInfo).Killed(killer, Other, damageType);
			if ((!bFirstBlood) && (Other.PlayerReplicationInfo != None) && (!Killer.bIsPlayer) && (!Self.IsA('TrainingDM')))
			{
				bFirstBlood = True;  PlayerPawn(Other).ServerReStartPlayer();
				if (bMonsterTeam) BroadcastLocalizedMessage( class'FirstBloodMessage', 0, Dummy.PlayerReplicationInfo );
			}
			if (bMonsterTeam && bScoreSPvsSP && !Other.bIsPlayer && !Killer.IsA('StationaryPawn'))
			{
				Dummy.PlayerReplicationInfo.Score += 1; Teams[Dummy.PlayerReplicationInfo.Team].Score += 1;
			}
			if (bMonsterTeam)
			{
				Dummy.PlayerReplicationInfo.PlayerName = "The Monster Team";
			}
		}
		else
		{
			Super(GameInfo).Killed(killer, Other, damageType);
		}
	}

		if ( bOverTime )
		{
			bTie = false;
			//check for clear winner now
			// find team winner
			for ( i=0; i<4; i++ )
				if (Teams[i].Score > ts)
					{ wt = i; ts = Teams[i].Score; }

			// check for tie
			for ( i=0; i<4; i++ )
				if ((i != wt) && (Teams[i].Score == ts))
					bTie = true;
			if ( !bTie )
			{
				if (GoalTeamScore > 0)
				{
					if ((killer != None) && (!killer.bIsPlayer) && (bMonsterTeam))
						Dummy.PlayerReplicationInfo.PlayerName = "The Monster Team";
					MaxTeams = 4;
					EndGame("teamscorelimit");
				}
			}
		}
		else if ((FragLimit > 0) && (killer != None) && (killer.PlayerReplicationInfo != None)
				 && (Killer.PlayerReplicationInfo.Team != 255) && (Teams[Killer.PlayerReplicationInfo.Team].Score >= FragLimit))
			{ MaxTeams = 4; EndGame("fraglimit"); }
			else if ((FragLimit > 0) && (killer != None) && (!killer.bIsPlayer) && (bMonsterTeam)
					&& (Teams[Dummy.PlayerReplicationInfo.Team].Score >= FragLimit))
				{ MaxTeams = 4; Dummy.PlayerReplicationInfo.PlayerName = "The Monster Team"; EndGame("fraglimit"); }

		if (bMonsterTeam && (Other.PlayerReplicationInfo == None))
		{
			if ( Dummy.Spree > 4 )
				EndSpree(Killer, Dummy); 
			Dummy.Spree = 0;
		}
		else
		{
			if ( Other.Spree > 4 )
				EndSpree(Killer, Other); 
			Other.Spree = 0;
		}

		if ((killer == None) || (Other == None) || ((Killer != None) && (Killer.IsA('StationaryPawn'))))
			return;

		if ( !bFirstBlood )
			if ((Killer.bIsPlayer && (Killer != Other)) || (!Killer.bIsPlayer && bMonsterTeam && (Killer != Other)))
				if (!Self.IsA('TrainingDM'))
				{
					bFirstBlood = True;
					if (!Killer.bIsPlayer && bMonsterTeam)
						BroadcastLocalizedMessage( class'FirstBloodMessage', 0, Dummy.PlayerReplicationInfo );
					else
						BroadcastLocalizedMessage( class'FirstBloodMessage', 0, Killer.PlayerReplicationInfo );
				}

		if ( BotConfig.bAdjustSkill && (killer.IsA('PlayerPawn') || Other.IsA('PlayerPawn')) )
		{
			if ( killer.IsA('Bot') )
				BotConfig.AdjustSkill(Bot(killer),true);
			if ( Other.IsA('Bot') )
				BotConfig.AdjustSkill(Bot(Other),false);
		}
		if (bMonsterTeam && (Killer.PlayerReplicationInfo == None) && (Killer != Other))
		{
			Dummy.Spree++;
			if ( Dummy.Spree > 4 )
				NotifySpree(Dummy, Dummy.Spree);
		}
		else
		if ( Other.bIsPlayer && (Killer != None) && Killer.bIsPlayer && (Killer != Other) 
			&& (!bTeamGame || (Other.PlayerReplicationInfo.Team != Killer.PlayerReplicationInfo.Team)) )
			{
				Killer.Spree++;
				if ( Killer.Spree > 4 )
				NotifySpree(Killer, Killer.Spree);
			} 

		bAutoTaunt = ((TournamentPlayer(Killer) != None) && TournamentPlayer(Killer).bAutoTaunt);
		if ( ((Bot(Killer) != None) || bAutoTaunt)
			&& (Killer != Other) && (DamageType != 'gibbed') && (Killer.Health > 0)
			&& (Level.TimeSeconds - LastTauntTime > 3) )
		{
			LastTauntTime = Level.TimeSeconds;
			NextTaunt = Rand(class<ChallengeVoicePack>(Killer.PlayerReplicationInfo.VoiceType).Default.NumTaunts);
			for ( i=0; i<4; i++ )
			{
				if ( NextTaunt == LastTaunt[i] )
					NextTaunt = Rand(class<ChallengeVoicePack>(Killer.PlayerReplicationInfo.VoiceType).Default.NumTaunts);
				if ( i > 0 )
					LastTaunt[i-1] = LastTaunt[i];
			}	
			LastTaunt[3] = NextTaunt;
	 		killer.SendGlobalMessage(None, 'AUTOTAUNT', NextTaunt, 5);
		}
		if ( bRatedGame )
			RateVs(Other, Killer);
}

defaultproperties
{
     GameName="Team DeathMatch - SP Fix"
     bScoreSPKills=True
     bScoreSPvsSP=True
     bNegScoring=False
     bScoreTeamKills=True
     bMonsterTeam=True
     MonsterTeamNum=3
     ForceTeamNum=255
     bSpawnInTeamArea=True
     bRandTeams=False
}
