//=============================================================================
// DM_SPGame.  06/18/12 - by Mr.Loathsome
//=============================================================================
class DM_SPGame extends DeathMatchPlus config;

var() config bool bScoreSPKills;
var() config bool bNegScoring;
var() config bool bScoreDeathsBySP;
var() config bool bMonsterTeam;
var() config bool bScoreSPvsSP;
var Bot Dummy;

function PostBeginPlay()
{
	local pawn P;
	local NavigationPoint N;

	if (bMonsterTeam)
	{
		for (N = Level.NavigationPointList; N != NONE; N = N.NextNavigationPoint)
		{
			Dummy = Spawn(class'BotPack.TMale1Bot',,,N.Location);
			if (Dummy != None) break;
		}
		if (Dummy != None)
		{
			Dummy.PlayerReplicationInfo.PlayerID = Level.Game.CurrentID++;
			Level.Game.ChangeName(Dummy, "The Monster Team", false);
			Dummy.SetTimer(0, false);
			Dummy.Health = 0;
			Dummy.GotoState('GameEnded');
			Dummy.bHidden = True;
			Dummy.bCollideWorld = False;
		}
	}
	Super.PostBeginPlay();
}

function ScoreKill(pawn Killer, pawn Other)
{
	if (((killer == None) || (killer == Other)) && (Other.bIsPlayer))
		Other.PlayerReplicationInfo.Score -= 1;
	else if (killer != None)
	{
		if (Killer.bIsPlayer && Other.bIsPlayer)
			Killer.PlayerReplicationInfo.Score += 1;
		else
		if ((!Other.bIsPlayer) && (Killer.bIsPlayer))
		{
			if (bScoreSPKills)
				Killer.PlayerReplicationInfo.Score += 1;
			else
				if (bNegScoring)
					Killer.PlayerReplicationInfo.Score -= 1;
			if (bMonsterTeam) Dummy.PlayerReplicationInfo.Deaths += 1;
		}
	}
	if (bAltScoring && (Killer != None) && (killer != Other) && (Other.bIsPlayer))
		Other.PlayerReplicationInfo.Score -= 1;
	BaseMutator.ScoreKill(Killer, Other);
}

function Killed(pawn killer, pawn Other, name damageType)
{
	local int NextTaunt, i;
	local bool bAutoTaunt, bEndOverTime;
	local Pawn P, Best;

log(killer@Other@damageType);

	if ((Killer != None) && (Killer != Other) && (other.PlayerReplicationInfo != None) && (killer.PlayerReplicationInfo != None))
	{
		if (damageType == 'Decapitated')
		{
			if ((Level.Game.LocalLog != None) && (Other.PlayerReplicationInfo != None))
				Level.Game.LocalLog.LogSpecialEvent("headshot", Killer.PlayerReplicationInfo.PlayerID, Other.PlayerReplicationInfo.PlayerID);
			if ((Level.Game.WorldLog != None) && (Other.PlayerReplicationInfo != None))
				Level.Game.WorldLog.LogSpecialEvent("headshot", Killer.PlayerReplicationInfo.PlayerID, Other.PlayerReplicationInfo.PlayerID);
		}
	}
	if ((Killer != None) && (killer.PlayerReplicationInfo != None) && (damageType == 'Decapitated') && (!Other.bIsPlayer))
		Killer.ReceiveLocalizedMessage(class'DecapitationMessage');
	if (!bMonsterTeam || ((Killer != None) && (killer.PlayerReplicationInfo != None) && (Other.PlayerReplicationInfo != None)))
	{
		Super.Killed(killer, Other, damageType);
	}
	else
	{
		if ((Killer != None) && (killer.PlayerReplicationInfo == None) && (Killer != Other))
		{
			if (bMonsterTeam)
			{
				Dummy.PlayerReplicationInfo.PlayerName = Killer.GetHumanName();
				if ((Other.bIsPlayer) && (!Killer.IsA('StationaryPawn'))) ScoreKill(Dummy, Other);
			}
			Super(GameInfo).Killed(killer, Other, damageType);
			if ((!bFirstBlood) && (Other.PlayerReplicationInfo != None) && (!Self.IsA('TrainingDM')))
			{
				bFirstBlood = True; PlayerPawn(Other).ServerReStartPlayer();
				if (bMonsterTeam) BroadcastLocalizedMessage( class'FirstBloodMessage', 0, Dummy.PlayerReplicationInfo );
			}
			if (bMonsterTeam && bScoreSPvsSP && !Other.bIsPlayer && !Killer.IsA('StationaryPawn'))
			{
				Dummy.PlayerReplicationInfo.Score += 1; Dummy.PlayerReplicationInfo.Deaths += 1;
			}
			if (bMonsterTeam)
			{
				Dummy.PlayerReplicationInfo.PlayerName = "The Monster Team";
			}
		}
		else
		{
			Super(GameInfo).Killed(killer, Other, damageType);
		}

		if ( !bTeamGame )
		{
			if ( bOverTime )
			{
				bEndOverTime = true;
				//check for clear winner now
				// find individual winner
				for ( P=Level.PawnList; P!=None; P=P.nextPawn )
					if ( P.bIsPlayer && ((Best == None) || (P.PlayerReplicationInfo.Score > Best.PlayerReplicationInfo.Score)) )
						Best = P;

				// check for tie
				for ( P=Level.PawnList; P!=None; P=P.nextPawn )
					if ( P.bIsPlayer && (Best != P) && (P.PlayerReplicationInfo.Score == Best.PlayerReplicationInfo.Score) )
						bEndOverTime = false;

				if ( bEndOverTime )
				{
					if (bMonsterTeam) Dummy.PlayerReplicationInfo.PlayerName = "The Monster Team";
					if ( (FragLimit > 0) && (Best.PlayerReplicationInfo.Score >= FragLimit) )
						EndGame("fraglimit");
					else
						EndGame("timelimit");
				}
			}
			else if ( (FragLimit > 0) && (killer != None) && (killer.PlayerReplicationInfo != None)
				&& (killer.PlayerReplicationInfo.Score >= FragLimit) )
					{ EndGame("fraglimit"); }
			else if ((FragLimit > 0) && (killer != None) && (!killer.bIsPlayer) && (bMonsterTeam)
				&& (Dummy.PlayerReplicationInfo.Score >= FragLimit))
					{ Dummy.PlayerReplicationInfo.PlayerName = "The Monster Team"; EndGame("fraglimit"); }
		}

	}

	if ((bScoreDeathsBySP) && (Other.bIsPlayer) && (Killer != None) && (killer.PlayerReplicationInfo == None)) Other.PlayerReplicationInfo.Deaths += 1;
		if (bMonsterTeam && (Other.PlayerReplicationInfo == None))
		{
			if ( Dummy.Spree > 4 )
				EndSpree(Killer, Dummy); 
			Dummy.Spree = 0;
		}
		else
		{
			if ( Other.Spree > 4 )
				EndSpree(Killer, Other); 
			Other.Spree = 0;
		}

		if ((killer == None) || (Other == None) || ((Killer != None) && (Killer.IsA('StationaryPawn'))))
			return;

		if ( !bFirstBlood )
			if ((Killer.bIsPlayer && (Killer != Other)) || (!Killer.bIsPlayer && bMonsterTeam && (Killer != Other)))
				if (!Self.IsA('TrainingDM'))
				{
					bFirstBlood = True;
					if (!Killer.bIsPlayer && bMonsterTeam)
						BroadcastLocalizedMessage( class'FirstBloodMessage', 0, Dummy.PlayerReplicationInfo );
					else
						BroadcastLocalizedMessage( class'FirstBloodMessage', 0, Killer.PlayerReplicationInfo );
				}

		if ( BotConfig.bAdjustSkill && (killer.IsA('PlayerPawn') || Other.IsA('PlayerPawn')) )
		{
			if ( killer.IsA('Bot') )
				BotConfig.AdjustSkill(Bot(killer),true);
			if ( Other.IsA('Bot') )
				BotConfig.AdjustSkill(Bot(Other),false);
		}
		
		if (bMonsterTeam && (Killer.PlayerReplicationInfo == None) && (Killer != Other))
		{
			Dummy.Spree++;
			if ( Dummy.Spree > 4 )
				NotifySpree(Dummy, Dummy.Spree);
		}
		else
		if ( Other.bIsPlayer && (Killer != None) && Killer.bIsPlayer && (Killer != Other) 
			&& (!bTeamGame || (Other.PlayerReplicationInfo.Team != Killer.PlayerReplicationInfo.Team)) )
			{
				Killer.Spree++;
				if ( Killer.Spree > 4 )
				NotifySpree(Killer, Killer.Spree);
			} 

		bAutoTaunt = ((TournamentPlayer(Killer) != None) && TournamentPlayer(Killer).bAutoTaunt);
		if ( ((Bot(Killer) != None) || bAutoTaunt)
			&& (Killer != Other) && (DamageType != 'gibbed') && (Killer.Health > 0)
			&& (Level.TimeSeconds - LastTauntTime > 3) )
		{
			LastTauntTime = Level.TimeSeconds;
			NextTaunt = Rand(class<ChallengeVoicePack>(Killer.PlayerReplicationInfo.VoiceType).Default.NumTaunts);
			for ( i=0; i<4; i++ )
			{
				if ( NextTaunt == LastTaunt[i] )
					NextTaunt = Rand(class<ChallengeVoicePack>(Killer.PlayerReplicationInfo.VoiceType).Default.NumTaunts);
				if ( i > 0 )
					LastTaunt[i-1] = LastTaunt[i];
			}	
			LastTaunt[3] = NextTaunt;
	 		killer.SendGlobalMessage(None, 'AUTOTAUNT', NextTaunt, 5);
		}
		if ( bRatedGame )
			RateVs(Other, Killer);

}

defaultproperties
{
     GameName="DeathMatch - SP Fix"
     bScoreSPKills=True
     bNegScoring=False
     bScoreDeathsBySP=True
     bMonsterTeam=True
     bScoreSPvsSP=True
}
