//=============================================================================
// CTF_SPGame.  06/18/12 - by Mr.Loathsome
//=============================================================================
class CTF_SPGame extends CTFGame config;

var() config bool bScoreSPKills;
var() config bool bNegScoring;

function bool IsOnTeam(Pawn Other, int TeamNum)
{
	if ((Other.bIsPlayer) && (Other.PlayerReplicationInfo.Team == TeamNum))
		return true;

	return false;
}

function float GameThreatAdd(Bot aBot, Pawn Other)
{
	local CTFFlag aFlag;

	if ((Other.bIsPlayer) && (Other.PlayerReplicationInfo.HasFlag != None))
		return 10;
	else
		return 0;
}

function byte AssessBotAttitude(Bot aBot, Pawn Other)
{
	if (!Other.bIsPlayer) return 1;
	if ( aBot.PlayerReplicationInfo.Team == Other.PlayerReplicationInfo.Team )
		return 3; //teammate
	else if ( (Other.bIsPlayer && (Other.PlayerReplicationInfo.HasFlag != None)) 
			|| (aBot.PlayerReplicationInfo.HasFlag != None) )
		return 1;
	else 
		return Super.AssessBotAttitude(aBot, Other);
}

function int ReduceDamage(int Damage, name DamageType, pawn injured, pawn instigatedBy)
{
	if ((instigatedBy == None) || (injured == None) || (!injured.bIsPlayer) || (!instigatedBy.bIsPlayer)) return Damage;

	if ((injured.PlayerReplicationInfo.Team != instigatedBy.PlayerReplicationInfo.Team)
		&& injured.IsA('Bot') 
		&& ((injured.health < 35) || (injured.PlayerReplicationInfo.HasFlag != None)) )
			Bot(injured).SendTeamMessage(None, 'OTHER', 4, 15);
	return Super.ReduceDamage(Damage, DamageType, injured, instigatedBy);
}

function ScoreKill(pawn Killer, pawn Other)
{
	if (((killer == None) && (Other.bIsPlayer)) || ((killer == Other) && (Other.bIsPlayer)))
		{ Other.PlayerReplicationInfo.Score -= 1; Other.DieCount++; }
	else if (killer != None)
	{
		if ( Killer.bIsPlayer && Other.bIsPlayer && (Killer.PlayerReplicationInfo.Team != Other.PlayerReplicationInfo.Team) )
			{ Killer.PlayerReplicationInfo.Score += 1; killer.killCount++; }
		else
		if (((ScriptedPawn(Other) != None) && Killer.bIsPlayer))
		{
			if (bScoreSPKills)
				{ Killer.PlayerReplicationInfo.Score += 1; killer.killCount++; }
			else
				if (bNegScoring)
					{ Killer.PlayerReplicationInfo.Score -= 1; killer.killCount++; }
		}
	}
	if ( bAltScoring && (killer != None) && (Killer != Other) && Other.bIsPlayer )
		{ Other.PlayerReplicationInfo.Score -= 1; Other.DieCount++; }
	BaseMutator.ScoreKill(Killer, Other);
}	

function Killed(pawn killer, pawn Other, name damageType)
{
	local int NextTaunt, i;
	local bool bAutoTaunt;

	if ( Other.bIsPlayer && (Other.PlayerReplicationInfo.HasFlag != None) )
	{
		if ( (Killer != None) && Killer.bIsPlayer && Other.bIsPlayer && (Killer.PlayerReplicationInfo.Team != Other.PlayerReplicationInfo.Team) )
		{
			killer.PlayerReplicationInfo.Score += 4;
			bAutoTaunt = ((TournamentPlayer(Killer) != None) && TournamentPlayer(Killer).bAutoTaunt);
			if ( (Bot(Killer) != None) || bAutoTaunt )
			{
				NextTaunt = Rand(class<ChallengeVoicePack>(Killer.PlayerReplicationInfo.VoiceType).Default.NumTaunts);
				for ( i=0; i<4; i++ )
				{
					if ( NextTaunt == LastTaunt[i] )
						NextTaunt = Rand(class<ChallengeVoicePack>(Killer.PlayerReplicationInfo.VoiceType).Default.NumTaunts);
					if ( i > 0 )
						LastTaunt[i-1] = LastTaunt[i];
				}	
				LastTaunt[3] = NextTaunt;
				killer.SendGlobalMessage(None, 'AUTOTAUNT', NextTaunt, 5);
			}
		}
		CTFFlag(Other.PlayerReplicationInfo.HasFlag).Drop(0.5 * Other.Velocity);
	}

	if ((Killer != None) && (Killer != Other) && (other.PlayerReplicationInfo != None) && (killer.PlayerReplicationInfo != None))
	{
		if (damageType == 'Decapitated')
		{
			if ((Level.Game.LocalLog != None) && (Other.PlayerReplicationInfo != None))
				Level.Game.LocalLog.LogSpecialEvent("headshot", Killer.PlayerReplicationInfo.PlayerID, Other.PlayerReplicationInfo.PlayerID);
			if ((Level.Game.WorldLog != None) && (Other.PlayerReplicationInfo != None))
				Level.Game.WorldLog.LogSpecialEvent("headshot", Killer.PlayerReplicationInfo.PlayerID, Other.PlayerReplicationInfo.PlayerID);
		}
	}
	if ((Killer != None) && (killer.PlayerReplicationInfo != None) && (damageType == 'Decapitated') && (!Other.bIsPlayer)) Killer.ReceiveLocalizedMessage( class'DecapitationMessage' );
	if ((Killer != None) && (killer.PlayerReplicationInfo != None) && (Other.PlayerReplicationInfo != None))
		Super.Killed(killer, Other, damageType);
	else
	{
		if ((Killer != None) && (killer.PlayerReplicationInfo == None) && (Killer != Other))
		{
			ScoreKill(Killer, Other);
			Super(GameInfo).Killed(killer, Other, damageType);
		}
		else
		{
			Super(GameInfo).Killed(killer, Other, damageType);
		}
		if ((!bFirstBlood) && (Other.PlayerReplicationInfo != None) && (!Self.IsA('TrainingDM')))
		{
			bFirstBlood = True; PlayerPawn(Other).ServerReStartPlayer();
		}
	}

		if ( Other.Spree > 4 )
			EndSpree(Killer, Other); 
		Other.Spree = 0;

		if ( (killer == None) || (Other == None) )
			return;

		if ( !bFirstBlood )
			if ( Killer.bIsPlayer && (Killer != Other) )
				if (!Self.IsA('TrainingDM'))
				{
					bFirstBlood = True;
					BroadcastLocalizedMessage( class'FirstBloodMessage', 0, Killer.PlayerReplicationInfo );
				}

		if ( BotConfig.bAdjustSkill && (killer.IsA('PlayerPawn') || Other.IsA('PlayerPawn')) )
		{
			if ( killer.IsA('Bot') )
				BotConfig.AdjustSkill(Bot(killer),true);
			if ( Other.IsA('Bot') )
				BotConfig.AdjustSkill(Bot(Other),false);
		}

		if ( Other.bIsPlayer && (Killer != None) && Killer.bIsPlayer && (Killer != Other) 
			&& (!bTeamGame || (Other.PlayerReplicationInfo.Team != Killer.PlayerReplicationInfo.Team)) )
		{
			Killer.Spree++;
			if ( Killer.Spree > 4 )
				NotifySpree(Killer, Killer.Spree);
		}

		if ( bRatedGame )
			RateVs(Other, Killer);
}

defaultproperties
{
     GameName="CTF - SP Fix"
     bScoreSPKills=True
     bNegScoring=False
}
