//=============================================================================
// AS_SPGame.  06/18/12 - by Mr.Loathsome
//=============================================================================
class AS_SPGame extends Assault config;

var() config bool bScoreSPKills;
var() config bool bNegScoring;
var() config bool bScoreTeamKills;

function byte AssessBotAttitude(Bot aBot, Pawn Other)
{
	if (!Other.bIsPlayer) return 1;
	else 
		return Super.AssessBotAttitude(aBot, Other);
}

function ScoreKill(pawn Killer, pawn Other)
{

	if (((killer == None) && (Other.bIsPlayer)) || ((killer != None) && (killer == Other) && (Other.bIsPlayer)))
		Other.PlayerReplicationInfo.Score -= 1;
	else if (killer != None)
	{
		if ( Killer.bIsPlayer && Other.bIsPlayer && (Killer.PlayerReplicationInfo.Team != Other.PlayerReplicationInfo.Team) )
			Killer.PlayerReplicationInfo.Score += 1;
		else
		if (((ScriptedPawn(Other) != None) && Killer.bIsPlayer))
		{
			if (bScoreSPKills)
				Killer.PlayerReplicationInfo.Score += 1;
			else
				if (bNegScoring)
					Killer.PlayerReplicationInfo.Score -= 1;
		}
	}
	if (bScoreTeamKills)
	{
		if ((Killer == None) || (Killer == Other))
		{
			if (Other.bIsPlayer) Teams[Other.PlayerReplicationInfo.Team].Score -= 1;
		}
		else
			{
				if (Killer.bIsPlayer)
					Teams[Killer.PlayerReplicationInfo.Team].Score += 1;
				else if ((FriendlyFireScale > 0) && (Killer.bIsPlayer && Other.bIsPlayer && (Killer.PlayerReplicationInfo.Team != Other.PlayerReplicationInfo.Team)))
				{
					Teams[Other.PlayerReplicationInfo.Team].Score -= 1;
					Killer.PlayerReplicationInfo.Score -= 1;
				}
			}
	}
	BaseMutator.ScoreKill(Killer, Other);
}

function Killed(pawn killer, pawn Other, name damageType)
{
	if ((Killer != None) && (Killer != Other) && (other.PlayerReplicationInfo != None) && (killer.PlayerReplicationInfo != None))
	{
		if (damageType == 'Decapitated')
		{
			if ((Level.Game.LocalLog != None) && (Other.PlayerReplicationInfo != None))
				Level.Game.LocalLog.LogSpecialEvent("headshot", Killer.PlayerReplicationInfo.PlayerID, Other.PlayerReplicationInfo.PlayerID);
			if ((Level.Game.WorldLog != None) && (Other.PlayerReplicationInfo != None))
				Level.Game.WorldLog.LogSpecialEvent("headshot", Killer.PlayerReplicationInfo.PlayerID, Other.PlayerReplicationInfo.PlayerID);
		}
	}
	if ((Killer != None) && (killer.PlayerReplicationInfo != None) && (damageType == 'Decapitated') && (!Other.bIsPlayer))
		Killer.ReceiveLocalizedMessage(class'DecapitationMessage');
	if ((Other.bIsPlayer) && (Other == Leader[Other.PlayerReplicationInfo.Team]) && Other.IsA('Bot'))
		ElectNewLeaderFor(Bot(Other));

	if ((Killer != None) && (killer.PlayerReplicationInfo != None) && (Other.PlayerReplicationInfo != None))
		Super.Killed(killer, Other, damageType);
	else
	{
		if ((Killer != None) && (killer.PlayerReplicationInfo == None) && (Killer != Other))
		{
			ScoreKill(Killer, Other);
			Super(GameInfo).Killed(killer, Other, damageType);
		}
		else
		{
			Super(GameInfo).Killed(killer, Other, damageType);
		}
	}

		if ((!bFirstBlood) && (Other.PlayerReplicationInfo != None) && (!Self.IsA('TrainingDM')))
		{
			bFirstBlood = True; PlayerPawn(Other).ServerReStartPlayer();
		}

		if ( Other.Spree > 4 )
			EndSpree(Killer, Other); 
		Other.Spree = 0;

		if ( (killer == None) || (Other == None) )
			return;

		if ( !bFirstBlood )
			if ( Killer.bIsPlayer && (Killer != Other) )
				if (!Self.IsA('TrainingDM'))
				{
					bFirstBlood = True;
					BroadcastLocalizedMessage( class'FirstBloodMessage', 0, Killer.PlayerReplicationInfo );
				}

		if ( BotConfig.bAdjustSkill && (killer.IsA('PlayerPawn') || Other.IsA('PlayerPawn')) )
		{
			if ( killer.IsA('Bot') )
				BotConfig.AdjustSkill(Bot(killer),true);
			if ( Other.IsA('Bot') )
				BotConfig.AdjustSkill(Bot(Other),false);
		}
		if ( Other.bIsPlayer && (Killer != None) && Killer.bIsPlayer && (Killer != Other) 
			&& (!bTeamGame || (Other.PlayerReplicationInfo.Team != Killer.PlayerReplicationInfo.Team)) )
		{
			Killer.Spree++;
			if ( Killer.Spree > 4 )
				NotifySpree(Killer, Killer.Spree);
		}
		if ( bRatedGame )
			RateVs(Other, Killer);
}

defaultproperties
{
     GameName="Assault - SP Fix"
     bScoreSPKills=True
     bNegScoring=False
     bScoreTeamKills=True
}
