//*  SwarmSpawn Mutator v2.0 Final - (c) 2016 MrLoathsome   *//
//*  Spawns Swarms of Actors into any map. + More  *//

class SS expands Mutator config(SwarmSpawn);

var() config float CheckRate;
var() config bool bDebugMode, bRandMode;

struct SSetType
{
	var String SName;
	var String SVal;
};

struct SwarmInfoType
{
	var String SwarmClass;
	var int Qty;
	var float SDS;
	var bool bSpawnOnce;
	var bool bHorde;
	var bool bIsMut;
	var bool bReplace;
	var SSetType SSet0;
	var SSetType SSet1;
	var SSetType SSet2;
	var SSetType SSet3;
	var SSetType SSet4;
	var SSetType SSet5;
	var SSetType SSet6;
	var SSetType SSet7;
	var SSetType SSet8;
	var SSetType SSet9;
	var SSetType SSet10;
	var SSetType SSet11;
	var SSetType SSet12;
	var SSetType SSet13;
	var SSetType SSet14;
	var SSetType SSet15;
};

var() config SwarmInfoType SwarmInfo[64];

var Vector SpawnLocs[4096];
var int SpawnLocCount, NumSwarms, CurSwarm, ActiveSwarms, INeededPawns, SPawnCount, FScnt, RepCnt, SetCntTot[64], RetryCnt[64], ReplaceIdx[64];
var class<Actor> SwarmClasses[64];
var(Events) name tmpTag, tmpEvent;
var string SetName[1024];
var bool bFirstSpawn;

function PostBeginPlay()
{
   local NavigationPoint N;
   local int i, j, x;
   local class<Actor> aC;

	Super.PostBeginPlay();

	foreach AllActors (class'NavigationPoint',N)
		if ((N.IsA('PathNode') || N.IsA('SpawnPoint') || N.IsA('PlayerStart') || N.IsA('InventorySpot'))
		   && (N.Region.Zone != None && N.Region.ZoneNumber != 0 && !N.Region.Zone.bWaterZone && !N.Region.Zone.bPainZone))
	{
		if (SpawnLocCount <= 4095)
		{
				SpawnLocs[SpawnLocCount] = N.Location;
				SpawnLocCount++;
				N.bPlayerOnly = False;
		}
	}
	PreCacheLists();
	log(Self.Class$": Begin Init - Spawnpoint count: "$SpawnLocCount@" Number Swarms: "$NumSwarms);
	if (SpawnLocCount >= 1)
	{
		if (NumSwarms > 0)
		{
			for (i = 0; i < NumSwarms; i++)
			{
				aC = class<Actor>(DynamicLoadObject(SwarmInfo[i].SwarmClass, class'Class'));
				if (aC != None)
				{
					if ((SwarmInfo[i].bSpawnOnce) && (!SwarmInfo[i].bReplace))
					{
						if (bDebugMode) { log(Self.Class$": Swarm #"$i@aC); }
						INeededPawns = SwarmInfo[i].Qty;
						if (SwarmInfo[i].bSpawnOnce) j++;
						if (SwarmInfo[i].Qty == 0)
							SpawnSwarm(aC, i);
						else	{ for (x = 0; x < INeededPawns; x++) { SpawnSwarm(aC, i); if (SwarmInfo[i].bHorde) break; } }
					}
				} else { SwarmInfo[i].bSpawnOnce = True; SwarmInfo[i].Qty = 0; }
			}
			ActiveSwarms = NumSwarms - j;
			bFirstSpawn = True;
			if (ActiveSwarms == NumSwarms)
				SetTimer(CheckRate, true);
			else
				SetTimer(0.50, true);
		}
	}
	log(Self.Class$": End Init - Number Active Swarms: "$ActiveSwarms$" - Number Replacement lines: "$RepCnt);
}

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	local class<Actor> aClass;
	local int k;

	if (RepCnt == 0) return true;

	for (k = 0; k<RepCnt; k++)
	{
		aClass = class<Actor>(DynamicLoadObject(SwarmInfo[ReplaceIdx[k]].SSet0.SName, class'Class'));
		if (Other.Class == aClass)
		{
			aClass = class<Actor>(DynamicLoadObject(SwarmInfo[ReplaceIdx[k]].SwarmClass, class'Class'));
			if (aClass!=None)
			{
				tmpTag = Other.Tag;  tmpEvent = Other.Event;
				if (SpawnPawn(aClass, Other.Location, ReplaceIdx[k]))
				{
					Other.Destroy();
					return false;
				}
			}
		}
	}

	bSuperRelevant = 0;
	return true;
}

function PreCacheLists()
{
	local int i, j, k;
	local class<Actor> aC;

	if (bDebugMode) log(Self.Class$": Begin PreCacheLists");
	for (i=0; i<256; i++)
	{
		if (SwarmInfo[i].SwarmClass == "") break;
		aC = None;
		aC = class<Actor>(DynamicLoadObject(SwarmInfo[i].SwarmClass, class'Class'));
		if (aC == None)
			{ log(Self.Class$": Swarm# "$i@"SwarmSpawn Init - Bad Class: "$SwarmInfo[i].SwarmClass); }
		else
		{
			if (bDebugMode) log(Self.Class$": Swarm# "$i@aC);
			if (SwarmInfo[i].SDS == 0.0) SwarmInfo[i].SDS = 1.0;
			SwarmClasses[i] = aC;
			for (j = 0; j<16; j++)
			{
				k = (i * 16) + j;
				switch(j) {
					case 15: if (SwarmInfo[i].SSet15.SName != "")
					{
						SetCntTot[i]++;
						SetName[k] = "Set"@aC@SwarmInfo[i].SSet15.SName@SwarmInfo[i].SSet15.SVal;
					} break;
					case 14: if (SwarmInfo[i].SSet14.SName != "")
					{
						SetCntTot[i]++;
						SetName[k] = "Set"@aC@SwarmInfo[i].SSet14.SName@SwarmInfo[i].SSet14.SVal;
					} break;
					case 13: if (SwarmInfo[i].SSet13.SName != "")
					{
						SetCntTot[i]++;
						SetName[k] = "Set"@aC@SwarmInfo[i].SSet13.SName@SwarmInfo[i].SSet13.SVal;
					} break;
					case 12: if (SwarmInfo[i].SSet12.SName != "")
					{
						SetCntTot[i]++;
						SetName[k] = "Set"@aC@SwarmInfo[i].SSet12.SName@SwarmInfo[i].SSet12.SVal;
					} break;
					case 11: if (SwarmInfo[i].SSet11.SName != "")
					{
						SetCntTot[i]++;
						SetName[k] = "Set"@aC@SwarmInfo[i].SSet11.SName@SwarmInfo[i].SSet11.SVal;
					} break;
					case 10: if (SwarmInfo[i].SSet10.SName != "")
					{
						SetCntTot[i]++;
						SetName[k] = "Set"@aC@SwarmInfo[i].SSet10.SName@SwarmInfo[i].SSet10.SVal;
					} break;
					case 9: if (SwarmInfo[i].SSet9.SName != "")
					{
						SetCntTot[i]++;
						SetName[k] = "Set"@aC@SwarmInfo[i].SSet9.SName@SwarmInfo[i].SSet9.SVal;
					} break;
					case 8: if (SwarmInfo[i].SSet8.SName != "")
					{
						SetCntTot[i]++;
						SetName[k] = "Set"@aC@SwarmInfo[i].SSet8.SName@SwarmInfo[i].SSet8.SVal;
					} break;
					case 7: if (SwarmInfo[i].SSet7.SName != "")
					{
						SetCntTot[i]++;
						SetName[k] = "Set"@aC@SwarmInfo[i].SSet7.SName@SwarmInfo[i].SSet7.SVal;
					} break;
					case 6: if (SwarmInfo[i].SSet6.SName != "")
					{
						SetCntTot[i]++;
						SetName[k] = "Set"@aC@SwarmInfo[i].SSet6.SName@SwarmInfo[i].SSet6.SVal;
					} break;
					case 5: if (SwarmInfo[i].SSet5.SName != "")
					{
						SetCntTot[i]++;
						SetName[k] = "Set"@aC@SwarmInfo[i].SSet5.SName@SwarmInfo[i].SSet5.SVal;
					} break;
					case 4: if (SwarmInfo[i].SSet4.SName != "")
					{
						SetCntTot[i]++;
						SetName[k] = "Set"@aC@SwarmInfo[i].SSet4.SName@SwarmInfo[i].SSet4.SVal;
					} break;
					case 3: if (SwarmInfo[i].SSet3.SName != "")
					{
						SetCntTot[i]++;
						SetName[k] = "Set"@aC@SwarmInfo[i].SSet3.SName@SwarmInfo[i].SSet3.SVal;
					} break;
					case 2: if (SwarmInfo[i].SSet2.SName != "")
					{
						SetCntTot[i]++;
						SetName[k] = "Set"@aC@SwarmInfo[i].SSet2.SName@SwarmInfo[i].SSet2.SVal;
					} break;
					case 1: if (SwarmInfo[i].SSet1.SName != "")
					{
						SetCntTot[i]++;
						SetName[k] = "Set"@aC@SwarmInfo[i].SSet1.SName@SwarmInfo[i].SSet1.SVal;
					} break;
					case 0: if (SwarmInfo[i].SSet0.SName != "")
					{
						SetCntTot[i]++;
						SetName[k] = "Set"@aC@SwarmInfo[i].SSet0.SName@SwarmInfo[i].SSet0.SVal;
						if (SwarmInfo[i].bReplace) { ReplaceIdx[RepCnt] = i;  RepCnt++; }
					}
				}
				if ((bDebugMode) && (SetName[k] != ""))
				{
					if (bDebugMode) { log(Self.Class$":         SSet"$j@"-"@SetName[k]); }
				}
			}
		}
		NumSwarms++;
	}
	if (bDebugMode) log(Self.Class$": End PreCacheLists");
}

function bool SpawnPawn(class<Actor> aC, Vector Location, int SwarmNum)
{
   local Pawn NewPawn;
   local SActor tP;
   local int i, j;
   local float F;

   tP = Spawn(class'SwarmSpawn.SActor',,,Location);

   if (tP != None)
	{
		if (tP.Region.ZoneNumber == 0) { tP.Destroy(); return false; }
		tP.AActor = Spawn(aC,,,Location);
		if (tP.AActor == None)
		{
			if (bDebugMode) log(Self.Class$": Spawn failed, retrying...");
			tP.Destroy(); return false;
		}
		else if (SwarmInfo[SwarmNum].bReplace)
			{
				tP.AActor.Event = tmpEvent; tP.AActor.Tag = tmpTag;
			}
	}
   else	{ return false; }

   if (SwarmInfo[SwarmNum].bIsMut)
   {
		if (Mutator(tP.AActor) != None)
		{ 
			if (bDebugMode) log(Self.Class$": Adding Mutator: "$tP.AActor);
			Super.AddMutator(Mutator(tP.AActor));
		}

   }

   if ((SwarmInfo[SwarmNum].SDS != 1.0) && (SwarmInfo[SwarmNum].SDS != 0.0))
   {
	F = SwarmInfo[SwarmNum].SDS;
	tP.AActor.DrawScale = tP.AActor.DrawScale * F;
	tP.AActor.Mass = tP.AActor.Mass * F;
	if (Inventory(tp.AActor) != None) Inventory(tP.AActor).PickupViewScale = Inventory(tP.AActor).PickupViewScale * F;
	NewPawn = Pawn(tP.AActor);
	if (NewPawn != None)
	{
		NewPawn.GroundSpeed = NewPawn.GroundSpeed * F;
		NewPawn.WaterSpeed = NewPawn.WaterSpeed * F;
		NewPawn.AirSpeed = NewPawn.AirSpeed * F;
		NewPawn.AccelRate = NewPawn.AccelRate * F;
		NewPawn.JumpZ = NewPawn.JumpZ * F;
		NewPawn.MaxStepHeight = NewPawn.MaxStepHeight * F;
		NewPawn.MeleeRange = NewPawn.MeleeRange * F;
		NewPawn.BaseEyeHeight = NewPawn.BaseEyeHeight * F;
		NewPawn.EyeHeight = NewPawn.EyeHeight * F;
		if (ScriptedPawn(NewPawn) != None)
		   if (ScriptedPawn(NewPawn).Shadow != None)
			{ ScriptedPawn(NewPawn).Shadow.DrawScale = ScriptedPawn(NewPawn).Shadow.DrawScale * F; }
		NewPawn.Health = NewPawn.Health * F;
	}
	tP.AActor.SetCollisionSize((tP.AActor.CollisionRadius * F), (tP.AActor.CollisionHeight * F));
	tP.AActor.Buoyancy = tP.AActor.Buoyancy * F;
   }
   if (bDebugMode) if (!SwarmInfo[SwarmNum].bReplace) log(Self.Class$":"@tP.AActor@"spawned"); else log(Self.Class$":"@tP.AActor@"replacing"@SwarmInfo[SwarmNum].SSet0.SName);
   for (i = 0; i<SetCntTot[SwarmNum]; i++)
   {
	switch(i) {
		case 15: if (SwarmInfo[SwarmNum].SSet15.SName != "") { tP.AActor.SetPropertyText(SwarmInfo[SwarmNum].SSet15.SName, SwarmInfo[SwarmNum].SSet15.SVal); } break;
		case 14: if (SwarmInfo[SwarmNum].SSet14.SName != "") { tP.AActor.SetPropertyText(SwarmInfo[SwarmNum].SSet14.SName, SwarmInfo[SwarmNum].SSet14.SVal); } break;
		case 13: if (SwarmInfo[SwarmNum].SSet13.SName != "") { tP.AActor.SetPropertyText(SwarmInfo[SwarmNum].SSet13.SName, SwarmInfo[SwarmNum].SSet13.SVal); } break;
		case 12: if (SwarmInfo[SwarmNum].SSet12.SName != "") { tP.AActor.SetPropertyText(SwarmInfo[SwarmNum].SSet12.SName, SwarmInfo[SwarmNum].SSet12.SVal); } break;
		case 11: if (SwarmInfo[SwarmNum].SSet11.SName != "") { tP.AActor.SetPropertyText(SwarmInfo[SwarmNum].SSet11.SName, SwarmInfo[SwarmNum].SSet11.SVal); } break;
		case 10: if (SwarmInfo[SwarmNum].SSet10.SName != "") { tP.AActor.SetPropertyText(SwarmInfo[SwarmNum].SSet10.SName, SwarmInfo[SwarmNum].SSet10.SVal); } break;
		case 9: if (SwarmInfo[SwarmNum].SSet9.SName != "") { tP.AActor.SetPropertyText(SwarmInfo[SwarmNum].SSet9.SName, SwarmInfo[SwarmNum].SSet9.SVal); } break;
		case 8: if (SwarmInfo[SwarmNum].SSet8.SName != "") { tP.AActor.SetPropertyText(SwarmInfo[SwarmNum].SSet8.SName, SwarmInfo[SwarmNum].SSet8.SVal); } break;
		case 7: if (SwarmInfo[SwarmNum].SSet7.SName != "") { tP.AActor.SetPropertyText(SwarmInfo[SwarmNum].SSet7.SName, SwarmInfo[SwarmNum].SSet7.SVal); } break;
		case 6: if (SwarmInfo[SwarmNum].SSet6.SName != "") { tP.AActor.SetPropertyText(SwarmInfo[SwarmNum].SSet6.SName, SwarmInfo[SwarmNum].SSet6.SVal); } break;
		case 5: if (SwarmInfo[SwarmNum].SSet5.SName != "") { tP.AActor.SetPropertyText(SwarmInfo[SwarmNum].SSet5.SName, SwarmInfo[SwarmNum].SSet5.SVal); } break;
		case 4: if (SwarmInfo[SwarmNum].SSet4.SName != "") { tP.AActor.SetPropertyText(SwarmInfo[SwarmNum].SSet4.SName, SwarmInfo[SwarmNum].SSet4.SVal); } break;
		case 3: if (SwarmInfo[SwarmNum].SSet3.SName != "") { tP.AActor.SetPropertyText(SwarmInfo[SwarmNum].SSet3.SName, SwarmInfo[SwarmNum].SSet3.SVal); } break;
		case 2: if (SwarmInfo[SwarmNum].SSet2.SName != "") { tP.AActor.SetPropertyText(SwarmInfo[SwarmNum].SSet2.SName, SwarmInfo[SwarmNum].SSet2.SVal); } break;
		case 1: if (SwarmInfo[SwarmNum].SSet1.SName != "") { tP.AActor.SetPropertyText(SwarmInfo[SwarmNum].SSet1.SName, SwarmInfo[SwarmNum].SSet1.SVal); } break;
		case 0: if (SwarmInfo[SwarmNum].SSet0.SName != "") { tP.AActor.SetPropertyText(SwarmInfo[SwarmNum].SSet0.SName, SwarmInfo[SwarmNum].SSet0.SVal); }
	}
   }
   if (bDebugMode)
   {
      for (i = 0; i<16; i++)
	{
	    switch(i) {
   		case 15: if (SwarmInfo[SwarmNum].SSet15.SName != "")
			 {
				log(Self.Class$": Attempted settings: "$tP.AActor@SwarmInfo[SwarmNum].SSet15.SName@SwarmInfo[SwarmNum].SSet15.SVal);
				log(Self.Class$": Actual values: "$tP.AActor@SwarmInfo[SwarmNum].SSet15.SName@tP.AActor.getPropertyText(SwarmInfo[SwarmNum].SSet15.SName));
			 } break;
   		case 14: if (SwarmInfo[SwarmNum].SSet14.SName != "")
			 {
				log(Self.Class$": Attempted settings: "$tP.AActor@SwarmInfo[SwarmNum].SSet14.SName@SwarmInfo[SwarmNum].SSet14.SVal);
				log(Self.Class$": Actual values: "$tP.AActor@SwarmInfo[SwarmNum].SSet14.SName@tP.AActor.getPropertyText(SwarmInfo[SwarmNum].SSet14.SName));
			 } break;
   		case 13: if (SwarmInfo[SwarmNum].SSet13.SName != "")
			 {
				log(Self.Class$": Attempted settings: "$tP.AActor@SwarmInfo[SwarmNum].SSet13.SName@SwarmInfo[SwarmNum].SSet13.SVal);
				log(Self.Class$": Actual values: "$tP.AActor@SwarmInfo[SwarmNum].SSet13.SName@tP.AActor.getPropertyText(SwarmInfo[SwarmNum].SSet13.SName));
			 } break;
   		case 12: if (SwarmInfo[SwarmNum].SSet12.SName != "")
			 {
				log(Self.Class$": Attempted settings: "$tP.AActor@SwarmInfo[SwarmNum].SSet12.SName@SwarmInfo[SwarmNum].SSet12.SVal);
				log(Self.Class$": Actual values: "$tP.AActor@SwarmInfo[SwarmNum].SSet12.SName@tP.AActor.getPropertyText(SwarmInfo[SwarmNum].SSet12.SName));
			 } break;
   		case 11: if (SwarmInfo[SwarmNum].SSet11.SName != "")
			 {
				log(Self.Class$": Attempted settings: "$tP.AActor@SwarmInfo[SwarmNum].SSet11.SName@SwarmInfo[SwarmNum].SSet11.SVal);
				log(Self.Class$": Actual values: "$tP.AActor@SwarmInfo[SwarmNum].SSet11.SName@tP.AActor.getPropertyText(SwarmInfo[SwarmNum].SSet11.SName));
			 } break;
   		case 10: if (SwarmInfo[SwarmNum].SSet10.SName != "")
			 {
				log(Self.Class$": Attempted settings: "$tP.AActor@SwarmInfo[SwarmNum].SSet10.SName@SwarmInfo[SwarmNum].SSet10.SVal);
				log(Self.Class$": Actual values: "$tP.AActor@SwarmInfo[SwarmNum].SSet10.SName@tP.AActor.getPropertyText(SwarmInfo[SwarmNum].SSet10.SName));
			 } break;
   		case 9: if (SwarmInfo[SwarmNum].SSet9.SName != "")
			 {
				log(Self.Class$": Attempted settings: "$tP.AActor@SwarmInfo[SwarmNum].SSet9.SName@SwarmInfo[SwarmNum].SSet9.SVal);
				log(Self.Class$": Actual values: "$tP.AActor@SwarmInfo[SwarmNum].SSet9.SName@tP.AActor.getPropertyText(SwarmInfo[SwarmNum].SSet9.SName));
			 } break;
   		case 8: if (SwarmInfo[SwarmNum].SSet8.SName != "")
			 {
				log(Self.Class$": Attempted settings: "$tP.AActor@SwarmInfo[SwarmNum].SSet8.SName@SwarmInfo[SwarmNum].SSet8.SVal);
				log(Self.Class$": Actual values: "$tP.AActor@SwarmInfo[SwarmNum].SSet8.SName@tP.AActor.getPropertyText(SwarmInfo[SwarmNum].SSet8.SName));
			 } break;
   		case 7: if (SwarmInfo[SwarmNum].SSet7.SName != "")
			 {
				log(Self.Class$": Attempted settings: "$tP.AActor@SwarmInfo[SwarmNum].SSet7.SName@SwarmInfo[SwarmNum].SSet7.SVal);
				log(Self.Class$": Actual values: "$tP.AActor@SwarmInfo[SwarmNum].SSet7.SName@tP.AActor.getPropertyText(SwarmInfo[SwarmNum].SSet7.SName));
			 } break;
   		case 6: if (SwarmInfo[SwarmNum].SSet6.SName != "")
			 {
				log(Self.Class$": Attempted settings: "$tP.AActor@SwarmInfo[SwarmNum].SSet6.SName@SwarmInfo[SwarmNum].SSet6.SVal);
				log(Self.Class$": Actual values: "$tP.AActor@SwarmInfo[SwarmNum].SSet6.SName@tP.AActor.getPropertyText(SwarmInfo[SwarmNum].SSet6.SName));
			 } break;
   		case 5: if (SwarmInfo[SwarmNum].SSet5.SName != "")
			 {
				log(Self.Class$": Attempted settings: "$tP.AActor@SwarmInfo[SwarmNum].SSet5.SName@SwarmInfo[SwarmNum].SSet5.SVal);
				log(Self.Class$": Actual values: "$tP.AActor@SwarmInfo[SwarmNum].SSet5.SName@tP.AActor.getPropertyText(SwarmInfo[SwarmNum].SSet5.SName));
			 } break;
   		case 4: if (SwarmInfo[SwarmNum].SSet4.SName != "")
			 {
				log(Self.Class$": Attempted settings: "$tP.AActor@SwarmInfo[SwarmNum].SSet4.SName@SwarmInfo[SwarmNum].SSet4.SVal);
				log(Self.Class$": Actual values: "$tP.AActor@SwarmInfo[SwarmNum].SSet4.SName@tP.AActor.getPropertyText(SwarmInfo[SwarmNum].SSet4.SName));
			 } break;
   		case 3: if (SwarmInfo[SwarmNum].SSet3.SName != "")
			 {
				log(Self.Class$": Attempted settings: "$tP.AActor@SwarmInfo[SwarmNum].SSet3.SName@SwarmInfo[SwarmNum].SSet3.SVal);
				log(Self.Class$": Actual values: "$tP.AActor@SwarmInfo[SwarmNum].SSet3.SName@tP.AActor.getPropertyText(SwarmInfo[SwarmNum].SSet3.SName));
			 } break;
   		case 2: if (SwarmInfo[SwarmNum].SSet2.SName != "")
			 {
				log(Self.Class$": Attempted settings: "$tP.AActor@SwarmInfo[SwarmNum].SSet2.SName@SwarmInfo[SwarmNum].SSet2.SVal);
				log(Self.Class$": Actual values: "$tP.AActor@SwarmInfo[SwarmNum].SSet2.SName@tP.AActor.getPropertyText(SwarmInfo[SwarmNum].SSet2.SName));
			 } break;
   		case 1: if (SwarmInfo[SwarmNum].SSet1.SName != "")
			 {
				log(Self.Class$": Attempted settings: "$tP.AActor@SwarmInfo[SwarmNum].SSet1.SName@SwarmInfo[SwarmNum].SSet1.SVal);
				log(Self.Class$": Actual values: "$tP.AActor@SwarmInfo[SwarmNum].SSet1.SName@tP.AActor.getPropertyText(SwarmInfo[SwarmNum].SSet1.SName));
			 } break;
   		case 0: if ((SwarmInfo[SwarmNum].SSet0.SName != "") && (!SwarmInfo[SwarmNum].bReplace))
			 {
				log(Self.Class$": Attempted settings: "$tP.AActor@SwarmInfo[SwarmNum].SSet0.SName@SwarmInfo[SwarmNum].SSet0.SVal);
				log(Self.Class$": Actual values: "$tP.AActor@SwarmInfo[SwarmNum].SSet0.SName@tP.AActor.getPropertyText(SwarmInfo[SwarmNum].SSet0.SName));
			 }
	    }
	}
   }
   tP.ASNum = SwarmNum + 1;
   tP.LifeSpan = tP.AActor.LifeSpan;
   if ((SwarmInfo[SwarmNum].Qty != 0) && (!SwarmInfo[SwarmNum].bIsMut)) tP.AActor.SetPhysics(PHYS_Falling);
   return true;
}

function SpawnSwarm(class<Actor> aC,  int SwarmNum)
{
   local int ThisHordeSize, INZ;
   local int PawnPerRow;
   local int retries,maxRetries;
   local int row, col, i, x;
   local Vector location1,location2;
   local float CPCR;

   if ((SwarmInfo[SwarmNum].Qty == 0) || (SwarmInfo[SwarmNum].bSpawnOnce))
     for (i = 0; i<SetCntTot[SwarmNum]; i++)
     {
	x = (SwarmNum * 16) + i;
	if (SetName[x] != "") { if (bDebugMode) { log(Self.Class$": - Class default adjustment:"@SetName[x]); } ConsoleCommand(SetName[x]); }
     }
   if (SwarmInfo[SwarmNum].Qty == 0) return;
   CPCR = ((aC.default.CollisionRadius * SwarmInfo[SwarmNum].SDS) + (aC.default.CollisionHeight * SwarmInfo[SwarmNum].SDS) + 10.0);
   maxRetries = 40;
   retries = 0;

   if (SwarmInfo[SwarmNum].bHorde)
   {
      if (INeededPawns > SpawnLocCount)
	INZ = SpawnLocCount;
      else
	INZ = INeededPawns;
   } else INZ = 1;

      if(INZ > SwarmInfo[SwarmNum].Qty)
         ThisHordeSize = SwarmInfo[SwarmNum].Qty;
      else ThisHordeSize = INZ;
      PawnPerRow =  abs(sqrt(ThisHordeSize)+1);
      if ( Square(PawnPerRow-1) == ThisHordeSize)
         PawnPerRow--;

ReTry:
      while(INZ > 0)
      {
	 Location1 = SpawnLocs[Rand(SpawnLocCount)];
	 maxRetries = SwarmInfo[SwarmNum].Qty + 10;
	 retries = 0;
	 Location1.x = Location1.x - (1.25 * CPCR * (PawnPerRow-1));
	 Location1.y = Location1.y - (1.25 * CPCR * (PawnPerRow-1));

	 for (row = 1; row <= PawnPerRow; row++)
            for (col = 1;( col <= PawnPerRow && INZ > 0 && ThisHordeSize > 0 ); col++)
	    {
		Location2 = Location1;
		Location2.x += (row * CPCR * 1.25);
		Location2.y += (col * CPCR * 1.25);
		Location2.x += (CPCR * SwarmInfo[SwarmNum].SDS);
		Location2.y += (CPCR * SwarmInfo[SwarmNum].SDS);
		if (SpawnPawn(aC, Location2, SwarmNum))
		{
		  INZ--;
		  ThisHordeSize--;
		} else { retries++; if (retries > maxRetries) return; else goto ReTry; }
	    }
            break;
      }
      if (bDebugMode) { log("."); }
}

event Timer()
{
	local int i, j, FSDone, QtyHold;
	local SActor TP;

	SPawnCount = 0;
	if (bFirstSpawn)
	{
		FSDone = 0;
		for (i=0; i< NumSwarms; i++)
		{
			if ((SwarmInfo[i].bSpawnOnce) && (SwarmInfo[i].Qty > 0))
			{
				foreach AllActors(class'SwarmSpawn.SActor', TP)
				{
					if ((TP.AActor != None) && (TP.AActor.Class == SwarmClasses[i]) && (TP.ASNum == i + 1) && (TP.AActor.Region.ZoneNumber != 0))
					{
						if ((Inventory(TP.AActor) != None) && (Inventory(TP.AActor).bRotatingPickup) && (TP.AActor.Physics != PHYS_Falling))
							TP.AActor.SetPhysics(PHYS_Rotating);
						if ((SwarmClasses[i] == TP.AActor.Class)  && (TP.AActor.Owner == None) && (!SwarmInfo[i].bReplace)) { SPawnCount++; }
					} else if ((TP.AActor == None) || (tP.AActor.Region.Zone.bWaterZone) || (tP.AActor.Region.Zone.bPainZone) || (TP.AActor.Region.ZoneNumber == 0))
							{ if ((TP.AActor != None) && (!TP.AActor.bDeleteMe)) TP.AActor.Destroy(); else TP.Destroy(); }
				}
				INeededPawns = SwarmInfo[i].Qty - SPawnCount;
				if (INeededPawns != 0)
				{
					if (bDebugMode)
					{
						BroadcastMessage(Self.Class$": Post Init - Swarm #"$i@SwarmClasses[i]@"Needs:"@INeededPawns);
						log(Self.Class$": Post Init - Swarm #"$i@SwarmClasses[i]@"Needs:"@INeededPawns);
						log(Self.Class$": Attempting respawn of class"@SwarmClasses[i]@"that almost 'fell out of the world'...");
					}
					RetryCnt[i]++;
					if (RetryCnt[i] > 10)
					{ 
						log("SwarmSpawn Post Init Aborting!!!  One of your bSpawnOnce classes will not spawn.");
						bFirstSpawn = False; break;
					}
					QtyHold = SwarmInfo[i].Qty;
					SwarmInfo[i].Qty = INeededPawns;
					SpawnSwarm(SwarmClasses[i], i); FSDone++;
					SwarmInfo[i].Qty = QtyHold;
				}
				SPawnCount = 0;
			}
		}
		if (FSDone == 0) { bFirstSpawn = False; SetTimer(CheckRate, true); if (ActiveSwarms == 0) SetTimer(0.0, False); }
		return;
	}

    if (Level.Game.NumPlayers > 0)
    {
	i = CurSwarm;
	if ((SwarmInfo[i].bSpawnOnce) || (SwarmClasses[i] == None))
	{
		CurSwarm++;
		if (CurSwarm >= NumSwarms) { CurSwarm = 0; }
		SetTimer(0.01250, True);
		return;
	} else SetTimer(CheckRate, true);

	if (SwarmInfo[i].Qty > 0)
	{
		foreach AllActors(class'SwarmSpawn.SActor', TP)
		{
			if ((TP.AActor != None) && (Pawn(TP.AActor) != None) && (Pawn(TP.AActor).Health <= 0)) { TP.AActor.LifeSpan = 1.0; TP.LifeSpan = 1.0; }
			if (TP.AActor != None)
			{
				if ((SwarmClasses[i] == TP.AActor.Class) && (TP.ASNum == i + 1) && (Pawn(TP.AActor) != None) && (Pawn(TP.AActor).Health > 0)) { SPawnCount++; }
				else if ((SwarmClasses[i] == TP.AActor.Class) && (TP.ASNum == i + 1) && (TP.AActor.Owner == None)) { SPawnCount++; }
			} else TP.Destroy();
		}
		INeededPawns = SwarmInfo[i].Qty - SPawnCount;
	} else INeededPawns = 1;
	if (bDebugMode) { BroadcastMessage("SwarmSpawning Time!  Swarm #"$i@SwarmClasses[i]@"Needs:"@INeededPawns); log(Self.Class$": Swarm #"$i@SwarmClasses[i]@"Needs:"@INeededPawns); }
	if (INeededPawns > 0)
	{
		SpawnSwarm(SwarmClasses[i], i);
		FScnt = 0; SetTimer(CheckRate, true);
	}
	else
	{
		FScnt++;
	}
	if (FScnt >= ActiveSwarms * 2)
	{
		SetTimer(CheckRate * 4, true);  FScnt = NumSwarms;
	}
	if (bRandMode)
		CurSwarm = Rand(NumSwarms);
	else
	{
		CurSwarm++;
		if (CurSwarm >= NumSwarms) { CurSwarm = 0; }
	}
    }
}

defaultproperties
{
     CheckRate=1.0
     bDebugMode=False
     bRandMode=False
     SwarmInfo(0)=(SwarmClass="UnrealShare.Cow",Qty=12,SDS=1.0,bSpawnOnce="False",bHorde="False",bIsMut="False",bReplace="False")
}
