//=============================================================================
// Tentacle.
// I haven't imagine a bigger bullshit
//=============================================================================
class NsTentacle extends NsScriptedPawn;

#exec MESH NOTIFY MESH=Tentacle1 SEQ=Dead1 TIME=0.96 FUNCTION=Drop
#exec MESH NOTIFY MESH=Tentacle1 SEQ=Smack TIME=0.6 FUNCTION=SmackTarget

//-----------------------------------------------------------------------------
// Tentacle variables.
// Attack damage.
var() int WhipDamage; // Damage done by whipping.

var(Sounds) sound mebax;
var(Sounds)  sound whip;
var(Sounds) sound Smack;

//-----------------------------------------------------------------------------
// Tentacle functions.

function PostBeginPlay()
{
	Super.PostBeginPlay();
	bLeadTarget = bLeadTarget && (FRand() > 0.5);
}

function WhatToDoNext(name LikelyState, name LikelyLabel)
{
	bQuiet = false;
	GotoState('Waiting');
}
/*
function eAttitude AttitudeToCreature(Pawn Other)
{
	if ( Other.IsA('Tentacle') )
		return ATTITUDE_Friendly;
	else if ( Other.IsA('ScriptedPawn') )
		return ATTITUDE_Hate;
	else
		return ATTITUDE_Ignore;
}
*/
simulated function AddVelocity( vector NewVelocity )
{
	if (Physics == PHYS_Rotating)
		Velocity = vect(0,0,0);
	else
		Velocity += NewVelocity; // ????
}

function PreSetMovement()
{
	bCanJump = false;
	bCanWalk = false;
	bCanSwim = true;
	bCanFly = false;
	MinHitWall = -0.6;
	bCanOpenDoors = false;
	bCanDoSpecial = false;
}

function bool CanFireAtEnemy()
{
	local vector HitLocation, HitNormal, EnemyDir, projStart, EnemyUp;
	local actor HitActor;
	local float EnemyDist;
	local bool bPrecheck;

	if ( Target == None && ( Enemy != None && CanSee(Enemy)) )
		Target = Enemy;
	if ( Target == None )
		return False;
	if ( Target != None )
	{
		HitActor = Trace(HitLocation, HitNormal, Target.Location, Location, false);
		if ( HitActor == None )
			bPreCheck=True;
		if ( bPrecheck )
		{
			EnemyDir = Target.Location - Location;
			EnemyDist = VSize(EnemyDir);
			EnemyUp = Target.CollisionHeight * vect(0,0,0.9);
			if ( EnemyDist > 300 )
			{
				EnemyDir = 300 * EnemyDir/EnemyDist;
				EnemyUp = 300 * EnemyUp/EnemyDist;
			}
			projStart = Location + CollisionHeight * vect(0,0,-1.2);

			HitActor = Trace(HitLocation, HitNormal, projStart + EnemyDir + EnemyUp, projStart, true);

			if ( (HitActor == None) || (HitActor == Target) 
				|| ((Pawn(HitActor) != None) && (AttitudeTo(Pawn(HitActor)) <= ATTITUDE_Ignore)) )
				return true;

			HitActor = Trace(HitLocation, HitNormal, projStart + EnemyDir, projStart, true);

			return ( (HitActor == None) || (HitActor == Target) 
				|| ((Pawn(HitActor) != None) && (AttitudeTo(Pawn(HitActor)) <= ATTITUDE_Ignore)) );
		}
	}
	return False; //Done
}

function SetMovementPhysics()
{
	if (Region.Zone.bWaterZone)
		SetPhysics(PHYS_Swimming);
	else
		SetPhysics(PHYS_Rotating); 
}

function bool SetMyEnemy( Pawn NewEnemy )
{
	local bool result;

	bCanWalk = true; //even though can't move, still acquire enemies
	result = Super.SetMyEnemy(NewEnemy);
	bCanWalk = false;
	return result;
}

function Drop()
{
	//implemented in TentacleCarcass
	//Won't mock me, don't worry
}

singular function Falling()
{
	SetMovementPhysics();
}

function PlayWaiting()
{
	TweenAnim('Hide', 5.0);
}

function PlayPatrolStop()
{
	TweenAnim('Hide', 5.0);
}

function PlayWaitingAmbush()
{
	TweenAnim('Hide', 5.0);
}

function PlayChallenge()
{
	if ( GetAnimGroup(AnimSequence) == 'Hiding')
	{
		PlaySound(Mebax, SLOT_Interact);
		PlayAnim('Uncurl', 0.6, 0.2);
	}
	else
		PlayAnim('Waver', 1.0, 0.1);
}

function TweenToFighter(float tweentime)
{
	if ( GetAnimGroup(AnimSequence) == 'Hiding')
	{
		PlaySound(Mebax, SLOT_Interact);
		PlayAnim('Uncurl', 0.6, 0.2);
	}
	else
		TweenAnim('Waver', tweentime);
}

function TweenToRunning(float tweentime)
{
	if ( GetAnimGroup(AnimSequence) == 'Hiding')
	{
		PlaySound(Mebax, SLOT_Interact);
		PlayAnim('Uncurl', 0.6, 0.2);
	}
	else if ( (AnimSequence != 'Move2') || !bAnimLoop )
		TweenAnim('Move2', tweentime);
}

function TweenToWalking(float tweentime)
{
	if ( GetAnimGroup(AnimSequence) == 'Hiding')
	{
		PlaySound(Mebax, SLOT_Interact);
		PlayAnim('Uncurl', 0.6, 0.2);
	}
	else if ( (AnimSequence != 'Move1') || !bAnimLoop )
		TweenAnim('Move1', tweentime);
}

function TweenToWaiting(float tweentime)
{
	if ( GetAnimGroup(AnimSequence) != 'Hiding')
	{
		PlaySound(Mebax, SLOT_Interact);
		PlayAnim('Curl', 0.6, 0.2);
	}
}

function TweenToPatrolStop(float tweentime)
{
	if ( GetAnimGroup(AnimSequence) == 'Hiding')
	{
		PlaySound(Mebax, SLOT_Interact);
		PlayAnim('Uncurl', 0.6, 0.2);
	}
	else TweenAnim('Waver', tweentime);
}

function PlayRunning()
{
	LoopAnim('Move2', 1.0,, 0.4);
}

function PlayWalking()
{
	LoopAnim('Move1', 1.0,, 0.4);
}

function PlayThreatening()
{
	if ( FRand() < 0.8 )
		PlayAnim('Waver', 0.4);
	else
		PlayAnim('Smack', 0.4);
}

function PlayTurning()
{
	if ( GetAnimGroup(AnimSequence) == 'Hiding')
	{
		PlaySound(Mebax, SLOT_Interact);
		PlayAnim('Uncurl', 0.6, 0.2);
	}
	else
		LoopAnim('Waver');
}

function PlayDying(name DamageType, vector HitLocation)
{
	PlaySound(Die, SLOT_Talk, 3 * TransientSoundVolume);
	if ( Velocity.Z > 200 )
		PlayAnim('Dead2', 0.7, 0.1);
	else
	{
		PlayAnim('Dead1', 0.7, 0.1);
		SetPhysics(PHYS_None);
	}
}

function PlayTakeHit(float tweentime, vector HitLoc, int Damage)
{
	TweenAnim('TakeHit', tweentime);
}

function TweenToFalling()
{
	TweenAnim('Waver', 0.2);
}

function PlayInAir()
{
	LoopAnim('Waver');
}

function PlayLanded(float impactVel)
{
	PlayAnim('Waver');
}

function PlayVictoryDance()
{
	PlaySound(whip, SLOT_Interact);
	PlayAnim('Smack', 0.6, 0.1);
}

function PlayMeleeAttack()
{
	if ( Target != None )
	PlaySound(whip, SLOT_Interact);
	PlayAnim('Smack');
}

function SmackTarget()
{
	if ( Target != None )
		if ( MeleeDamageTarget(WhipDamage, (WhipDamage * 1000 * Normal(Target.Location - Location))) )
			PlaySound(Smack, SLOT_Interact);
}

function PlayRangedAttack()
{
	local vector projStart;

	if ( Target != None ) //Stop craps
	{
		MakeNoise(1.0); 
		projStart = Location + CollisionHeight * vect(0,0,-1.2);
		spawn(RangedProjectile ,self,'',projStart,AdjustAim(ProjectileSpeed, projStart, 900, bLeadTarget, bWarnTarget));
		PlayAnim('Shoot');
	}
}

state Attacking
{
ignores SeePlayer, HearNoise, Bump, HitWall;

	function ChooseAttackMode()
	{
		if (Physics == PHYS_Swimming)
		{
			Super.ChooseAttackMode();
			return;
		}
			
		if ((Enemy == None) || (Enemy.Health <= 0) || Enemy.bHidden || Enemy == Self || Enemy.bDeleteMe )
		{
			if ((OldEnemy != None) && (OldEnemy.Health > 0)) 
			{
				Enemy = OldEnemy;
				OldEnemy = None;
			}
			else
			{
				 GotoState('Waiting');
				 return;
			}
		}
			
		if (!LineOfSightTo(Enemy))
			GotoState('StakeOut');
		else
			GotoState('RangedAttack');
	}
}

state StakeOut
{
ignores EnemyNotVisible; 

	function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
							Vector momentum, name damageType)
	{
		Global.TakeDamage(Damage, instigatedBy, hitlocation, momentum, damageType);
		if ( health <= 0 )
			return;
		if (NextState == 'TakeHit')
		{
			NextState = 'Attacking';
			NextLabel = 'Begin';
			GotoState('TakeHit'); 
		}
	}

Begin:
	PlayChallenge();
	TurnTo(LastSeenPos);
HangOut:
	if ( Enemy != None )
		if ( bHasRangedAttack && bClearShot && (FRand() < 0.5) && (VSize(Enemy.Location - LastSeenPos) < 100) && CanStakeOut() )
			PlayRangedAttack();
	FinishAnim();
	PlayChallenge();
	Sleep(1 + FRand());
	if ( FRand() < 0.1 )
		GotoState('Waiting');
	else
		LoopAnim('Waver');
	Goto('HangOut');
}

state Acquisition
{
 
PlayOut:
	FinishAnim();

Begin:
	PlayTurning();
	FinishAnim();
	GotoState('Attacking');
}

defaultproperties
{
     mebax=Sound'UnrealShare.Tentacle.curltn'
     Whip=Sound'UnrealShare.Tentacle.strike2tn'
     Smack=Sound'UnrealShare.Tentacle.splat2tn'
     CarcassType=Class'NsMonster.ExCreatureCarcass'
     Aggressiveness=1.000000
     RefireRate=0.700000
     bHasRangedAttack=True
     bMovingRangedAttack=True
     bLeadTarget=False
     RangedProjectile=Class'NsMonster.ExTentacleProjectile'
     Acquire=Sound'UnrealShare.Tentacle.yell1tn'
     Fear=Sound'UnrealShare.Tentacle.injured2tn'
     Roam=Sound'UnrealShare.Tentacle.waver1tn'
     Threaten=Sound'UnrealShare.Tentacle.yell2tn'
     MeleeRange=70.000000
     WaterSpeed=100.000000
     AccelRate=100.000000
     JumpZ=10.000000
     SightRadius=1000.000000
     PeripheralVision=-0.800000
     HearingThreshold=0.500000
     Health=50
     UnderWaterTime=-1.000000
     Intelligence=BRAINS_REPTILE
     HitSound1=Sound'UnrealShare.Tentacle.injured1tn'
     HitSound2=Sound'UnrealShare.Tentacle.injured2tn'
     Land=Sound'UnrealShare.Tentacle.splat2tn'
     Die=Sound'UnrealShare.Tentacle.death2tn'
     DrawType=DT_Mesh
     Mesh=LodMesh'UnrealShare.Tentacle1'
     CollisionRadius=28.000000
     CollisionHeight=36.000000
     Mass=200.000000
     Buoyancy=400.000000
     RotationRate=(Pitch=0,Yaw=30000,Roll=0)
     MenuName="Tentacle"
}
