//=============================================================================
// ExTentacleProjectile.
//=============================================================================
class ExTentacleProjectile extends Projectile;

auto state Flying
{
	simulated function ProcessTouch (Actor Other, Vector HitLocation)
	{
		local vector momentum;
	
		if ((NsTentacle(Other) == None) && (ExTentacleProjectile(Other) == None))
		{
			if ( Role == ROLE_Authority )
			{
				momentum = 10000.0 * Normal(Velocity);
				Other.TakeDamage(Damage, instigator, HitLocation, momentum, 'stung');
			}
			Destroy();
		}
	}
	
	simulated function Explode(vector HitLocation, vector HitNormal)
	{
		local SmallSpark2 s;
		PlaySound(ImpactSound);
		MakeNoise(1.0);
		s = spawn(class'SmallSpark2',,,HitLocation+HitNormal*5,rotator(HitNormal*2+VRand()));
		s.RemoteRole = ROLE_None;
		destroy();
	}

	function BeginState()
	{
		Velocity = Vector(Rotation) * speed;
		PlaySound(SpawnSound);
	}

Begin:
	Sleep(7.0); //self destruct after 7.0 seconds
	Explode(Location, vect(0,0,0));
	
}

defaultproperties
{
     ExplosionDecal=Class'pock'
     speed=800.000000
     MaxSpeed=800.000000
     Damage=12.000000
     SpawnSound=Sound'UnrealShare.Tentacle.TentSpawn'
     ImpactSound=Sound'UnrealShare.Tentacle.TentImpact'
     RemoteRole=ROLE_SimulatedProxy
     LifeSpan=15.000000
     AnimRate=1.000000
     Mesh=LodMesh'UnrealShare.TentProjectile'
     AmbientGlow=255
     bUnlit=True
     Mass=2.000000
}
