//*  SwarmSpawn Mutator  2012 MrLoathsome *//
//*  Spawns Swarms of Pawns into any map.  *//
// Version with a few add-ons by Nelsona

class SS expands Mutator config(SwarmSpawn);

var config float CheckRate;
var config bool bDebugMode;
var config bool bSpawnAtStart;

struct SSetType
{
	var String SName;
	var String SVal;
	var bool bPS;
};

struct SwarmInfoType
{
	var String SwarmClass;
	var int Qty;
	var float SDS;
	var config SSetType SSet0;
	var config SSetType SSet1;
	var config SSetType SSet2;
	var config SSetType SSet3;
	var config SSetType SSet4;
	var config SSetType SSet5;
	var config SSetType SSet6;
	var config SSetType SSet7;
	var config SSetType SSet8;
	var config SSetType SSet9;
	var config SSetType SSet10;
	var config SSetType SSet11;
	var config SSetType SSet12;
	var config SSetType SSet13;
	var config SSetType SSet14;
	var config SSetType SSet15;
};

var config SwarmInfoType SwarmInfo[64];

var Vector SpawnLocs[3001];// array of spawnpoints
var int SpawnLocCount;  // amount of navigation nodes in this map
var int NumSwarms, CurSwarm, CurSPNum, INeededPawns, SPawnCount, FScnt, SetCnt[64], SetCntTot[64];
var Actor pcla, SWtmp;
var class<Pawn> SwarmClasses[64];
var string SetName[1024], DefName[1024];
var bool bFirstPawn;

function PostBeginPlay()
{
   local NavigationPoint N;
   local Inventory Inv;
   local Weapon W;
   local int i;
   local class<Pawn> aC;
   local vector L;

	Super.PostBeginPlay();

	for (N = Level.NavigationPointList; N != NONE; N = N.NextNavigationPoint)
	{
		if ((N.IsA('PathNode') || N.IsA('SpawnPoint') /*|| N.IsA('PlayerStart')*/) && !N.Region.Zone.bWaterZone)
		{
			if (SpawnLocCount <= 3000)
			{
				SWtmp = spawn(class'UnrealI.SkaarjWarrior',,,N.Location);
				if (SWtmp != None)
				{
					SWtmp.SetCollision(false,false,false);
					SpawnLocs[SpawnLocCount] = N.Location;
					SpawnLocCount++;
					SWtmp.Destroy();
					N.bPlayerOnly = False;
				}
			}
		}
	}
/*
	forEach AllActors(class'Inventory', Inv)
	{
		if ((!Inv.Region.Zone.bWaterZone) && (!Inv.Region.Zone.bPainZone))
		{
			if (SpawnLocCount <= 3000)
			{
				L = Inv.Location;   L.z = L.z + 90;
				SWtmp = spawn(class'UnrealI.SkaarjWarrior',,,L);
				if (SWtmp != None)
				{
					SWtmp.SetCollision(false,false,false); //Ehe ...
					SpawnLocs[SpawnLocCount] = Inv.Location;
					SpawnLocs[SpawnLocCount].Z = SpawnLocs[SpawnLocCount].Z + 90;
					SpawnLocCount++;
					SWtmp.Destroy();
				}

			}
		}
	}
*/
	PreCacheLists();
	SWtmp = spawn(class'UnrealShare.SeaWeed',,,SpawnLocs[0]);
	log("SwarmSpawn Init - Spawnpoint count: "$SpawnLocCount@" Number Swarms: "$NumSwarms);
	if (SpawnLocCount >= 1)
	{
		if (NumSwarms > 0)
		{
		    if (bSpawnAtStart)
			for (i = 0; i < NumSwarms; i++)
			{
				aC = class<Pawn>(DynamicLoadObject(SwarmInfo[i].SwarmClass, class'Class'));
				INeededPawns = SwarmInfo[i].Qty;
				SpawnSwarm(aC, i);
			}
		    SetTimer(CheckRate, true);
		} else { NumSwarms = 1; INeededPawns = 12; SwarmInfo[0].SDS = 2.0; SpawnSwarm(Class'UnrealShare.Cow', 0); }
	}
//***********************
	foreach AllActors (class 'Weapon', W) //Ruin skaarj left over trashes - Previous attempt not worked - probably too fast, weapons weren't assigned to pawns yet
	{
		if ( W != None && W.ReSpawnTime == 0 && W.Owner == None )
			W.Destroy();
	}
//***********************
}

function PreCacheLists()
{
	local int i, j, k, x;
	local class<Pawn> aC;

	for (i=0; i<64; i++)
	{
		if (SwarmInfo[i].SwarmClass == "") break;
		aC = class<Pawn>(DynamicLoadObject(SwarmInfo[i].SwarmClass, class'Class'));
		if (aC == None) { log("SwarmSpawn Init - Bad Class: "$SwarmInfo[i].SwarmClass); break; }
		pcla = spawn(aC,,,SpawnLocs[0]);
		if (pcla != None)
		{
//			pcla.SetCollision(false,false,false);
			NumSwarms++;
			SwarmClasses[i] = aC;
			for (j = 0; j<16; j++)
			{
				switch(j) {
					case 15: if (SwarmInfo[i].SSet15.SName != "")
					{
						SetCntTot[i]++;
						if (SwarmInfo[i].SSet15.bPS)
						{
							SetName[k] = "Set"@aC@SwarmInfo[i].SSet15.SName@SwarmInfo[i].SSet15.SVal;
							if (SwarmInfo[i].Qty > 0) DefName[k] = "Set"@aC@SwarmInfo[i].SSet15.SName@pcla.GetPropertyText(SwarmInfo[i].SSet15.SName);
								else ConsoleCommand(SetName[k]);
							SetCnt[i]++;
						}
					} break;
					case 14: if (SwarmInfo[i].SSet14.SName != "")
					{
						SetCntTot[i]++;
						if (SwarmInfo[i].SSet14.bPS)
						{
							SetName[k] = "Set"@aC@SwarmInfo[i].SSet14.SName@SwarmInfo[i].SSet14.SVal;
							if (SwarmInfo[i].Qty > 0) DefName[k] = "Set"@aC@SwarmInfo[i].SSet14.SName@pcla.GetPropertyText(SwarmInfo[i].SSet14.SName);
								else ConsoleCommand(SetName[k]);
							SetCnt[i]++;
						}
					} break;
					case 13: if (SwarmInfo[i].SSet13.SName != "")
					{
						SetCntTot[i]++;
						if (SwarmInfo[i].SSet13.bPS)
						{
							SetName[k] = "Set"@aC@SwarmInfo[i].SSet13.SName@SwarmInfo[i].SSet13.SVal;
							if (SwarmInfo[i].Qty > 0) DefName[k] = "Set"@aC@SwarmInfo[i].SSet13.SName@pcla.GetPropertyText(SwarmInfo[i].SSet13.SName);
								else ConsoleCommand(SetName[k]);
							SetCnt[i]++;
						}
					} break;
					case 12: if (SwarmInfo[i].SSet12.SName != "")
					{
						SetCntTot[i]++;
						if (SwarmInfo[i].SSet12.bPS)
						{
							SetName[k] = "Set"@aC@SwarmInfo[i].SSet12.SName@SwarmInfo[i].SSet12.SVal;
							if (SwarmInfo[i].Qty > 0) DefName[k] = "Set"@aC@SwarmInfo[i].SSet12.SName@pcla.GetPropertyText(SwarmInfo[i].SSet12.SName);
								else ConsoleCommand(SetName[k]);
							SetCnt[i]++;
						}
					} break;
					case 11: if (SwarmInfo[i].SSet11.SName != "")
					{
						SetCntTot[i]++;
						if (SwarmInfo[i].SSet11.bPS)
						{
							SetName[k] = "Set"@aC@SwarmInfo[i].SSet11.SName@SwarmInfo[i].SSet11.SVal;
							if (SwarmInfo[i].Qty > 0) DefName[k] = "Set"@aC@SwarmInfo[i].SSet11.SName@pcla.GetPropertyText(SwarmInfo[i].SSet11.SName);
								else ConsoleCommand(SetName[k]);
							SetCnt[i]++;
						}
					} break;
					case 10: if (SwarmInfo[i].SSet10.SName != "")
					{
						SetCntTot[i]++;
						if (SwarmInfo[i].SSet10.bPS)
						{
							SetName[k] = "Set"@aC@SwarmInfo[i].SSet10.SName@SwarmInfo[i].SSet10.SVal;
							if (SwarmInfo[i].Qty > 0) DefName[k] = "Set"@aC@SwarmInfo[i].SSet10.SName@pcla.GetPropertyText(SwarmInfo[i].SSet10.SName);
								else ConsoleCommand(SetName[k]);
							SetCnt[i]++;
						}
					} break;
					case 9: if (SwarmInfo[i].SSet9.SName != "")
					{
						SetCntTot[i]++;
						if (SwarmInfo[i].SSet9.bPS)
						{
							SetName[k] = "Set"@aC@SwarmInfo[i].SSet9.SName@SwarmInfo[i].SSet9.SVal;
							if (SwarmInfo[i].Qty > 0) DefName[k] = "Set"@aC@SwarmInfo[i].SSet9.SName@pcla.GetPropertyText(SwarmInfo[i].SSet9.SName);
								else ConsoleCommand(SetName[k]);
							SetCnt[i]++;
						}
					} break;
					case 8: if (SwarmInfo[i].SSet8.SName != "")
					{
						SetCntTot[i]++;
						if (SwarmInfo[i].SSet8.bPS)
						{
							SetName[k] = "Set"@aC@SwarmInfo[i].SSet8.SName@SwarmInfo[i].SSet8.SVal;
							if (SwarmInfo[i].Qty > 0) DefName[k] = "Set"@aC@SwarmInfo[i].SSet8.SName@pcla.GetPropertyText(SwarmInfo[i].SSet8.SName);
								else ConsoleCommand(SetName[k]);
							SetCnt[i]++;
						}
					} break;
					case 7: if (SwarmInfo[i].SSet7.SName != "")
					{
						SetCntTot[i]++;
						if (SwarmInfo[i].SSet7.bPS)
						{
							SetName[k] = "Set"@aC@SwarmInfo[i].SSet7.SName@SwarmInfo[i].SSet7.SVal;
							if (SwarmInfo[i].Qty > 0) DefName[k] = "Set"@aC@SwarmInfo[i].SSet7.SName@pcla.GetPropertyText(SwarmInfo[i].SSet7.SName);
								else ConsoleCommand(SetName[k]);
							SetCnt[i]++;
						}
					} break;
					case 6: if (SwarmInfo[i].SSet6.SName != "")
					{
						SetCntTot[i]++;
						if (SwarmInfo[i].SSet6.bPS)
						{
							SetName[k] = "Set"@aC@SwarmInfo[i].SSet6.SName@SwarmInfo[i].SSet6.SVal;
							if (SwarmInfo[i].Qty > 0) DefName[k] = "Set"@aC@SwarmInfo[i].SSet6.SName@pcla.GetPropertyText(SwarmInfo[i].SSet6.SName);
								else ConsoleCommand(SetName[k]);
							SetCnt[i]++;
						}
					} break;
					case 5: if (SwarmInfo[i].SSet5.SName != "")
					{
						SetCntTot[i]++;
						if (SwarmInfo[i].SSet5.bPS)
						{
							SetName[k] = "Set"@aC@SwarmInfo[i].SSet5.SName@SwarmInfo[i].SSet5.SVal;
							if (SwarmInfo[i].Qty > 0) DefName[k] = "Set"@aC@SwarmInfo[i].SSet5.SName@pcla.GetPropertyText(SwarmInfo[i].SSet5.SName);
								else ConsoleCommand(SetName[k]);
							SetCnt[i]++;
						}
					} break;
					case 4: if (SwarmInfo[i].SSet4.SName != "")
					{
						SetCntTot[i]++;
						if (SwarmInfo[i].SSet4.bPS)
						{
							SetName[k] = "Set"@aC@SwarmInfo[i].SSet4.SName@SwarmInfo[i].SSet4.SVal;
							if (SwarmInfo[i].Qty > 0) DefName[k] = "Set"@aC@SwarmInfo[i].SSet4.SName@pcla.GetPropertyText(SwarmInfo[i].SSet4.SName);
								else ConsoleCommand(SetName[k]);
							SetCnt[i]++;
						}
					} break;
					case 3: if (SwarmInfo[i].SSet3.SName != "")
					{
						SetCntTot[i]++;
						if (SwarmInfo[i].SSet3.bPS)
						{
							SetName[k] = "Set"@aC@SwarmInfo[i].SSet3.SName@SwarmInfo[i].SSet3.SVal;
							if (SwarmInfo[i].Qty > 0) DefName[k] = "Set"@aC@SwarmInfo[i].SSet3.SName@pcla.GetPropertyText(SwarmInfo[i].SSet3.SName);
								else ConsoleCommand(SetName[k]);
							SetCnt[i]++;
						}
					} break;
					case 2: if (SwarmInfo[i].SSet2.SName != "")
					{
						SetCntTot[i]++;
						if (SwarmInfo[i].SSet2.bPS)
						{
							SetName[k] = "Set"@aC@SwarmInfo[i].SSet2.SName@SwarmInfo[i].SSet2.SVal;
							if (SwarmInfo[i].Qty > 0) DefName[k] = "Set"@aC@SwarmInfo[i].SSet2.SName@pcla.GetPropertyText(SwarmInfo[i].SSet2.SName);
								else ConsoleCommand(SetName[k]);
							SetCnt[i]++;
						}
					} break;
					case 1: if (SwarmInfo[i].SSet1.SName != "")
					{
						SetCntTot[i]++;
						if (SwarmInfo[i].SSet1.bPS)
						{
							SetName[k] = "Set"@aC@SwarmInfo[i].SSet1.SName@SwarmInfo[i].SSet1.SVal;
							if (SwarmInfo[i].Qty > 0) DefName[k] = "Set"@aC@SwarmInfo[i].SSet1.SName@pcla.GetPropertyText(SwarmInfo[i].SSet1.SName);
								else ConsoleCommand(SetName[k]);
							SetCnt[i]++;
						}
					} break;
					case 0: if (SwarmInfo[i].SSet0.SName != "")
					{
						SetCntTot[i]++;
						if (SwarmInfo[i].SSet0.bPS)
						{
							SetName[k] = "Set"@aC@SwarmInfo[i].SSet0.SName@SwarmInfo[i].SSet0.SVal;
							if (SwarmInfo[i].Qty > 0) DefName[k] = "Set"@aC@SwarmInfo[i].SSet0.SName@pcla.GetPropertyText(SwarmInfo[i].SSet0.SName);
								else ConsoleCommand(SetName[k]);
							SetCnt[i]++;
						}
					}
				}
				k++;
			}
			if (Pawn(pcla).Weapon != None)
				Pawn(pcla).Weapon.Destroy();
			pcla.destroy();
		}
		else { log("SwarmSpawn: Precache failed for: "$aC); }
	}
}

function bool CheckCollision(Actor A, float DSM, vector newLoc)  // Credit to Feralidragon for help with this function
{
	local bool isColliding;
	local float CRadius, CHeight;

	CRadius = A.CollisionRadius;
	CHeight = A.CollisionHeight;
	A.SetCollisionSize(A.CollisionRadius * DSM, A.CollisionHeight * DSM);
	isColliding = !A.SetLocation(newLoc);
	A.SetCollisionSize(CRadius, CHeight);
	return isColliding;
}

function bool SpawnPawn(class<Pawn> aC, Vector Location, int SwarmNum)
{
	local Pawn NewPawn, tP;
	local int i, j;
	local float F;

	NewPawn = Spawn(aC,,,Location);
	if ( NewPawn == None )
		return false;

	if (NewPawn != None)
	{
		if ((SwarmInfo[SwarmNum].SDS != 1.0) && (SwarmInfo[SwarmNum].SDS != 0.0))
		{
			if ((SwarmInfo[SwarmNum].SDS > 1.0) && (CheckCollision(NewPawn, SwarmInfo[SwarmNum].SDS, NewPawn.Location)))
			{ NewPawn.Destroy(); return false; } else { F = SwarmInfo[SwarmNum].SDS; }
			NewPawn.DrawScale = NewPawn.DrawScale * F;
			NewPawn.Mass = NewPawn.Mass * F;
			NewPawn.GroundSpeed = NewPawn.GroundSpeed * F;
			NewPawn.WaterSpeed = NewPawn.WaterSpeed * F;
			NewPawn.AirSpeed = NewPawn.AirSpeed * F;
			NewPawn.AccelRate = NewPawn.AccelRate * F;
			NewPawn.JumpZ = NewPawn.JumpZ * F;
			NewPawn.MaxStepHeight = NewPawn.MaxStepHeight * F;
			NewPawn.MeleeRange = NewPawn.MeleeRange * F;
			NewPawn.BaseEyeHeight = NewPawn.BaseEyeHeight * F;
			NewPawn.EyeHeight = NewPawn.EyeHeight * F;
			if ( ScriptedPawn(NewPawn) != None )
			{
				if (ScriptedPawn(NewPawn).Shadow != None)
					ScriptedPawn(NewPawn).Shadow.DrawScale = ScriptedPawn(NewPawn).Shadow.DrawScale * F;
			}
			NewPawn.Health = NewPawn.Health * F;
			NewPawn.SetCollisionSize((NewPawn.CollisionRadius * F), (NewPawn.CollisionHeight * F));
			NewPawn.Buoyancy = NewPawn.Buoyancy * F;
		}
		for (i = 0; i<SetCntTot[SwarmNum]; i++)
		{
		switch(i)
			{
			case 15: if (SwarmInfo[SwarmNum].SSet15.SName != "") { NewPawn.SetPropertyText(SwarmInfo[SwarmNum].SSet15.SName, SwarmInfo[SwarmNum].SSet15.SVal); } break;
			case 14: if (SwarmInfo[SwarmNum].SSet14.SName != "") { NewPawn.SetPropertyText(SwarmInfo[SwarmNum].SSet14.SName, SwarmInfo[SwarmNum].SSet14.SVal); } break;
			case 13: if (SwarmInfo[SwarmNum].SSet13.SName != "") { NewPawn.SetPropertyText(SwarmInfo[SwarmNum].SSet13.SName, SwarmInfo[SwarmNum].SSet13.SVal); } break;
			case 12: if (SwarmInfo[SwarmNum].SSet12.SName != "") { NewPawn.SetPropertyText(SwarmInfo[SwarmNum].SSet12.SName, SwarmInfo[SwarmNum].SSet12.SVal); } break;
			case 11: if (SwarmInfo[SwarmNum].SSet11.SName != "") { NewPawn.SetPropertyText(SwarmInfo[SwarmNum].SSet11.SName, SwarmInfo[SwarmNum].SSet11.SVal); } break;
			case 10: if (SwarmInfo[SwarmNum].SSet10.SName != "") { NewPawn.SetPropertyText(SwarmInfo[SwarmNum].SSet10.SName, SwarmInfo[SwarmNum].SSet10.SVal); } break;
			case 9: if (SwarmInfo[SwarmNum].SSet9.SName != "") { NewPawn.SetPropertyText(SwarmInfo[SwarmNum].SSet9.SName, SwarmInfo[SwarmNum].SSet9.SVal); } break;
			case 8: if (SwarmInfo[SwarmNum].SSet8.SName != "") { NewPawn.SetPropertyText(SwarmInfo[SwarmNum].SSet8.SName, SwarmInfo[SwarmNum].SSet8.SVal); } break;
			case 7: if (SwarmInfo[SwarmNum].SSet7.SName != "") { NewPawn.SetPropertyText(SwarmInfo[SwarmNum].SSet7.SName, SwarmInfo[SwarmNum].SSet7.SVal); } break;
			case 6: if (SwarmInfo[SwarmNum].SSet6.SName != "") { NewPawn.SetPropertyText(SwarmInfo[SwarmNum].SSet6.SName, SwarmInfo[SwarmNum].SSet6.SVal); } break;
			case 5: if (SwarmInfo[SwarmNum].SSet5.SName != "") { NewPawn.SetPropertyText(SwarmInfo[SwarmNum].SSet5.SName, SwarmInfo[SwarmNum].SSet5.SVal); } break;
			case 4: if (SwarmInfo[SwarmNum].SSet4.SName != "") { NewPawn.SetPropertyText(SwarmInfo[SwarmNum].SSet4.SName, SwarmInfo[SwarmNum].SSet4.SVal); } break;
			case 3: if (SwarmInfo[SwarmNum].SSet3.SName != "") { NewPawn.SetPropertyText(SwarmInfo[SwarmNum].SSet3.SName, SwarmInfo[SwarmNum].SSet3.SVal); } break;
			case 2: if (SwarmInfo[SwarmNum].SSet2.SName != "") { NewPawn.SetPropertyText(SwarmInfo[SwarmNum].SSet2.SName, SwarmInfo[SwarmNum].SSet2.SVal); } break;
			case 1: if (SwarmInfo[SwarmNum].SSet1.SName != "") { NewPawn.SetPropertyText(SwarmInfo[SwarmNum].SSet1.SName, SwarmInfo[SwarmNum].SSet1.SVal); } break;
			case 0: if (SwarmInfo[SwarmNum].SSet0.SName != "") { NewPawn.SetPropertyText(SwarmInfo[SwarmNum].SSet0.SName, SwarmInfo[SwarmNum].SSet0.SVal); }
			}
		}
		if ((bDebugMode) && (bFirstPawn))
		{
			for (i = 0; i<16; i++)
			{
				switch(i)
				{
					case 15: if (SwarmInfo[SwarmNum].SSet15.SName != "") { log(NewPawn@SwarmInfo[SwarmNum].SSet15.SName@NewPawn.getPropertyText(SwarmInfo[SwarmNum].SSet15.SName)); } break;
					case 14: if (SwarmInfo[SwarmNum].SSet14.SName != "") { log(NewPawn@SwarmInfo[SwarmNum].SSet14.SName@NewPawn.getPropertyText(SwarmInfo[SwarmNum].SSet14.SName)); } break;
					case 13: if (SwarmInfo[SwarmNum].SSet13.SName != "") { log(NewPawn@SwarmInfo[SwarmNum].SSet13.SName@NewPawn.getPropertyText(SwarmInfo[SwarmNum].SSet13.SName)); } break;
					case 12: if (SwarmInfo[SwarmNum].SSet12.SName != "") { log(NewPawn@SwarmInfo[SwarmNum].SSet12.SName@NewPawn.getPropertyText(SwarmInfo[SwarmNum].SSet12.SName)); } break;
					case 11: if (SwarmInfo[SwarmNum].SSet11.SName != "") { log(NewPawn@SwarmInfo[SwarmNum].SSet11.SName@NewPawn.getPropertyText(SwarmInfo[SwarmNum].SSet11.SName)); } break;
					case 10: if (SwarmInfo[SwarmNum].SSet10.SName != "") { log(NewPawn@SwarmInfo[SwarmNum].SSet10.SName@NewPawn.getPropertyText(SwarmInfo[SwarmNum].SSet10.SName)); } break;
					case 9: if (SwarmInfo[SwarmNum].SSet9.SName != "") { log(NewPawn@SwarmInfo[SwarmNum].SSet9.SName@NewPawn.getPropertyText(SwarmInfo[SwarmNum].SSet9.SName)); } break;
					case 8: if (SwarmInfo[SwarmNum].SSet8.SName != "") { log(NewPawn@SwarmInfo[SwarmNum].SSet8.SName@NewPawn.getPropertyText(SwarmInfo[SwarmNum].SSet8.SName)); } break;
					case 7: if (SwarmInfo[SwarmNum].SSet7.SName != "") { log(NewPawn@SwarmInfo[SwarmNum].SSet7.SName@NewPawn.getPropertyText(SwarmInfo[SwarmNum].SSet7.SName)); } break;
					case 6: if (SwarmInfo[SwarmNum].SSet6.SName != "") { log(NewPawn@SwarmInfo[SwarmNum].SSet6.SName@NewPawn.getPropertyText(SwarmInfo[SwarmNum].SSet6.SName)); } break;
					case 5: if (SwarmInfo[SwarmNum].SSet5.SName != "") { log(NewPawn@SwarmInfo[SwarmNum].SSet5.SName@NewPawn.getPropertyText(SwarmInfo[SwarmNum].SSet5.SName)); } break;
					case 4: if (SwarmInfo[SwarmNum].SSet4.SName != "") { log(NewPawn@SwarmInfo[SwarmNum].SSet4.SName@NewPawn.getPropertyText(SwarmInfo[SwarmNum].SSet4.SName)); } break;
					case 3: if (SwarmInfo[SwarmNum].SSet3.SName != "") { log(NewPawn@SwarmInfo[SwarmNum].SSet3.SName@NewPawn.getPropertyText(SwarmInfo[SwarmNum].SSet3.SName)); } break;
					case 2: if (SwarmInfo[SwarmNum].SSet2.SName != "") { log(NewPawn@SwarmInfo[SwarmNum].SSet2.SName@NewPawn.getPropertyText(SwarmInfo[SwarmNum].SSet2.SName)); } break;
					case 1: if (SwarmInfo[SwarmNum].SSet1.SName != "") { log(NewPawn@SwarmInfo[SwarmNum].SSet1.SName@NewPawn.getPropertyText(SwarmInfo[SwarmNum].SSet1.SName)); } break;
					case 0: if (SwarmInfo[SwarmNum].SSet0.SName != "") { log(NewPawn@SwarmInfo[SwarmNum].SSet0.SName@NewPawn.getPropertyText(SwarmInfo[SwarmNum].SSet0.SName)); }
				}
			}
		}
	// NewPawn.SecretCount = SwarmNum + 1;  // Never do this...... Unless you are Loathsome
	NewPawn.SetPhysics(PHYS_Falling);
	if (ScriptedPawn(NewPawn) != None)
	{
		if (Level.Game.IsA('TeamGamePlus'))
			ScriptedPawn(NewPawn).Team = Rand(TeamGamePlus(Level.Game).MaxTeams);
				ScriptedPawn(NewPawn).AttitudeToPlayer = ATTITUDE_Frenzy;
	}
	}
	return true;
}

function bool GetSpawnPoint(out Vector Location, int HordeRadius, float HHRad)
{
	local Vector L;
	local PlayerPawn radiusActor;
	local bool NearPlayer;
	local Actor CollidingActor;
	local vector traceStart,traceEnd,Extent;
	local vector HitLocation, HitNormal;

	L = SpawnLocs[Rand(SpawnLocCount)];
	SWtmp.bHidden = False;
	SWtmp.SetLocation(L);
	if (SWtmp.PlayerCanSeeMe() == false)
	{
		nearplayer = false;
		foreach RadiusActors(class'PlayerPawn', radiusActor, 500, L) //500 = 30meters around
		{
			if (radiusActor != none)
			{
				NearPlayer=true;
				break;
			}
		}
		if (nearplayer == false)
		{
			traceStart = L;
			traceEnd = L;
			traceStart.z += 10;
			traceEnd.z += 10 + HHRad * 2;
			Extent.X = HordeRadius;
			Extent.Y = HordeRadius;
			Extent.Z = HHRad;
			CollidingActor=Trace(HitLocation, HitNormal,traceStart,traceEnd,True,Extent);
			if (CollidingActor != none)
			{
				if ( !CollidingActor.bIsPawn && CollidingActor != Level)
				{
					SWtmp.bHidden = True;
					Location = L;
					return true;
				}
			}
		}
	}
	SWtmp.bHidden = True;
	Location = L;
	return false;
}

function SpawnSwarm(class<Pawn> aC,  int SwarmNum)
{
	local int ThisHordeSize, HordeRadius, INZ;
	local int PawnPerRow; //spawn a block of N x N pawns
	local int retries,maxRetries;
	local int row, col, i, x, scnt;
	local Vector location,location2;
	local float CPCH, CPCR;

	if (bDebugMode) { log("SwarmSpawn: Swarm #"@SwarmNum); }
	for (i = 0; i<SetCnt[SwarmNum]; i++)
	{
		x = (SwarmNum * 16) + i;
		if (SetName[x] != "") { if (bDebugMode) { log("SwarmSpawn -  Pre-Spawn class default adjustment:"@SetName[x]); } ConsoleCommand(SetName[x]); }
	}
	scnt = 0; bFirstPawn = True;
	if (aC != None) //Only if exists this aC, else will assign unexistent ... - Accesed Null Context
	{
		CPCH = aC.default.CollisionHeight * SwarmInfo[SwarmNum].SDS;
		CPCR = aC.default.CollisionRadius * SwarmInfo[SwarmNum].SDS + (aC.default.CollisionRadius * 2);
	}
	else {CPCH = 46; CPCR = 32;} //Nelsona: Assign some values if aC is mising
	maxRetries = 10;
	retries = 0;
	if (INeededPawns > SpawnLocCount)
		INZ = SpawnLocCount;
	else
		INZ = INeededPawns;
	while(INZ > 0 && retries < maxRetries)
	{
		if(INZ > SwarmInfo[SwarmNum].Qty)
			ThisHordeSize = SwarmInfo[SwarmNum].Qty;
		else ThisHordeSize = INZ;
		PawnPerRow =  abs(sqrt(ThisHordeSize)+1);
		if ( Square(PawnPerRow-1) == ThisHordeSize)
		PawnPerRow--; // exact  n x n  box
		HordeRadius= ( (1.4142135 * 2.5) * CPCR * (PawnPerRow * 0.5));
		while(INZ > 0 && retries < maxRetries)
		{
			if (!GetSpawnPoint(Location, HordeRadius, CPCH))
			{
				if(retries != maxRetries-1)
				{
					retries++;
					continue;
				}
			}
		location.x = location.x - (1.25 * CPCR * (PawnPerRow-1));
		location.y = location.y - (1.25 * CPCR * (PawnPerRow-1));

		for (row = 1; row <= PawnPerRow; row++)
		for (col = 1;( col <= PawnPerRow && INZ > 0 && ThisHordeSize > 0 ); col++)
		{
			location2 = location;
			location2.x += (row * CPCR * 1.25);
			location2.y += (col * CPCR * 1.25);
			location2.x += CPCR * SwarmInfo[SwarmNum].SDS;
			location2.y += CPCR * SwarmInfo[SwarmNum].SDS;
			if (SpawnPawn(aC, location2, SwarmNum))
			{
				INZ--;
				ThisHordeSize--;
				bFirstPawn = False;
			}
			else retries++;
	    }//end for (horde)
            break; // success spawning horde, quit retrying and go spawn next horde (exit inner while loop)
		}// end inner while
	}// end outer while

	for (i = 0; i<SetCnt[SwarmNum]; i++)
	{
		x = (SwarmNum * 16) + i;
		if (DefName[x] != "") { if (bDebugMode) { log("SwarmSpawn - Restoring class default:"@DefName[x]); } ConsoleCommand(DefName[x]); }
	}
	if (bDebugMode) { log(" "); }
}

function bool PlayerOn()
{
	local pawn P;
//	local PlayerPawn PP; - Nelsona: I'm not interested only in PlayerPawn(s) - Bots should be hunted even if player leaves and game runs
	local bool bResult;

	bResult = False;
	for ( P=Level.PawnList; P!=None; P=P.nextPawn )
	{
		if ( P != None && P.bIsPlayer && P.PlayerReplicationInfo != None ) //Let me know
		{
			bResult=True;
			goto FoundPlayer;
		}
/*
		if (PP != None)
		{
			bResult = True;
			goto FoundPlayer;
		}
*/
	}
FoundPlayer:
return bResult;
}

singular event Timer()
{
	local int i;
	local Actor TP;
	local Pawn P;
	local ScriptedPawn S;

	i = CurSwarm;
	SPawnCount = 0;
	if ( Level.Game.IsA('DeathMatchPlus') && DeathMatchPlus(Level.Game).bRequireReady
	&& Level.NetMode != NM_StandAlone && DeathMatchPlus(Level.Game).CountDown > 0) return; //Doh
	foreach AllActors(class'ScriptedPawn',S)
	{
		if ( S != None && S.Enemy == None && S.Health > 0 )
		{
			foreach S.RadiusActors (class 'Pawn', P, 2500)
			{
				if ( P != None && P.bIsPlayer && P.PlayerReplicationInfo != None && P.Health > 0 && !P.bHidden 
				&& P.PlayerReplicationInfo.Team != S.Team && (Level.Game).bTeamGame )
				{
					S.Hated = P;
					S.Enemy = P;
					S.LastSeenPos = P.Location;
					S.GotoState('Attacking');
					break;
				}
			}
		}
	}

	if ( (Level.Game).bGameEnded )
	{
		foreach Level.AllActors (class'Pawn',P)
		{
			if ( P!= None && !P.IsInState('GameEnded'))
				P.GoToState('GameEnded');
		}
		return;
	}
    if (PlayerOn())
    {
	if (SwarmInfo[i].Qty > 0)
	{
		foreach AllActors(SwarmClasses[i], TP)
		{
			if ( Pawn(TP) != None )
				if (/*(Pawn(TP).SecretCount == i + 1) && */( Pawn(TP).Health > 0) )
				{
					SPawnCount++;
				}
		}
		INeededPawns = SwarmInfo[i].Qty - SPawnCount;	
		if (bDebugMode) { BroadcastMessage("SwarmSpawning Time!  Swarm #"$i@SwarmClasses[i]@"Needs:"@INeededPawns); log("SwarmSpawning Time!  Swarm #"$i@SwarmClasses[i]@"Needs:"@INeededPawns); }
		if (INeededPawns > 0)
		{
			SpawnSwarm(SwarmClasses[i], i);
			if (FScnt >= NumSwarms)
			{
				SetTimer(CheckRate,true);
			}
			FScnt = 0; 
		}
		else
		{
			FScnt++; if (FScnt >= NumSwarms) { SetTimer(CheckRate * 4, true); }
		}
	}
	CurSwarm++;
	if (CurSwarm >= NumSwarms) CurSwarm = 0;
    }
}

defaultproperties
{
     CheckRate=7.5
     bDebugMode=False
     bSpawnAtStart=False
     SwarmInfo(0)=(SwarmClass="UnrealShare.Cow",Qty=12,SDS=1.0)
}
