//=============================================================================
// ExFly.
// In fact is a smaller one. If you don't destroy a dead creature will
// spawn some small flies hunting you as well
//=============================================================================
class ExFly extends NsScriptedPawn;
//-----------------------------------------------------------------------------
// ExFly variables.
//-----------------------------------------------------------------------------
// ExFly functions.

function PreSetMovement()
{
	bCanJump = true;
	bCanWalk = true;
	bCanSwim = false;
	bCanFly = true;
	MinHitWall = -0.6;
	bCanOpenDoors = false;
	bCanDoSpecial = false;
}

function ZoneChange(ZoneInfo newZone)
{
	local vector jumpDir;

	if ( newZone.bWaterZone )
	{
		MoveTimer = -1.0;
		if ( (Enemy != None) && (Enemy.Location.Z < Location.Z) )
			GotoState('TacticalMove', 'BackOff');
		else
			Acceleration = Accelrate * vect(0,0,1);
	}

}

function SetMovementPhysics()
{
	if (Enemy != None)
		SetPhysics(PHYS_Flying); 
	else if (Physics != PHYS_Falling)
		SetPhysics(PHYS_Walking);
}

singular function Falling()
{
	SetPhysics(PHYS_Flying);
	if (bIsPlayer)
	{
		PlayInAir();
		return;
	}
		
	if (health > 0)
		SetFall();
}

function PlayWaiting()
{
	if ( Physics == PHYS_Walking )
		TweenAnim('Waiting', 10.0);
	else
		LoopAnim('Flying', 0.75);
}

function PlayPatrolStop()
{
	PlayWaiting();
}

function PlayWaitingAmbush()
{
	PlayWaiting();
}

function PlayChallenge()
{
	PlayAnim('Shoot1', 1.0, 0.1);
}

function TweenToFighter(float tweentime)
{
	TweenAnim('Flying', tweentime);
}

function TweenToRunning(float tweentime)
{
	if ( (AnimSequence != 'Flying') || !bAnimLoop )
		TweenAnim('Flying', tweentime);
}

function TweenToWalking(float tweentime)
{
	if (Physics == PHYS_Walking)
		TweenAnim('Walking', tweentime);
	else if ( (AnimSequence != 'Flying') || !bAnimLoop )
		TweenAnim('Flying', tweentime);
}

function TweenToWaiting(float tweentime)
{
	PlayAnim('Land', 0.2 + 0.5 * FRand());
	SetPhysics(PHYS_Falling);
}

function TweenToPatrolStop(float tweentime)
{
	TweenAnim('Flying', tweentime);
}

function PlayRunning()
{
	LoopAnim('Flying');
}

function PlayWalking()
{
	if (Physics == PHYS_Walking)
		LoopAnim('Walking', -1.0/GroundSpeed,, 0.4);
	else
		LoopAnim('Flying');
}

function PlayThreatening()
{
	if ( FRand() < 0.8 )
		LoopAnim('Flying');
	else
		LoopAnim('Shoot1', 0.4);
}

function PlayTurning()
{
	if (Physics == PHYS_Walking)
		LoopAnim('Walking');
	else
		LoopAnim('Flying');
}

function PlayDying(name DamageType, vector HitLocation)
{
	PlaySound(Die, SLOT_Talk, 3.5 * TransientSoundVolume);
	PlayAnim('Dead', 0.7, 0.1);
}

function PlayTakeHit(float tweentime, vector HitLoc, int damage)
{
	TweenAnim('TakeHit', tweentime);
}

function TweenToFalling()
{
	TweenAnim('Flying', 0.2);
}

function PlayInAir()
{
	LoopAnim('Flying');
}

function PlayLanded(float impactVel)
{
	PlayAnim('Land');
}

function PlayVictoryDance()
{
	if ( FRand() < 0.4 )
		TweenToWaiting(0.25);
	else
		PlayAnim('Flying',1.0, 0.05);
}
	
function PlayMeleeAttack()
{
	if ( Target != None )
	{
		PlayAnim('Shoot1');
		if ( MeleeDamageTarget(15, (15 * 1000.0 * Normal(Target.Location - Location))) )
			PlaySound(Threaten, SLOT_Talk); //FIXME - stingdamage instead of projectile
		GotoState('TacticalMove', 'BackOff');
	}
}

function PlayRangedAttack()
{
	local vector projStart;
	local vector adjust;

	if ( Target != None )
		PlayAnim('Shoot1');
	/*
	adjust = vect(0,0,0);
	adjust.Z = Target.CollisionHeight + 20;
	Acceleration = AccelRate * Normal(Target.Location - Location + adjust);
	projStart = Location - 0.5 * CollisionHeight * vect(0,0,1);
	spawn(RangedProjectile ,self,'',projStart,AdjustAim(ProjectileSpeed, projStart, 400, false, false));
	*/
}

function PlayMovingAttack()
{
	PlayRangedAttack();
}

/*state TacticalMove
{
ignores SeePlayer, HearNoise;

	function PickDestination(bool bNoCharge)
	{
		local vector pick, pickdir, enemydir,Y, minDest;
		local actor HitActor;
		local vector HitLocation, HitNormal, collSpec;
		local float Aggression, enemydist, minDist, strafeSize, MaxMove;
		if ( FRand() < 0.7 )
			MaxMove = 300;
		else
			MaxMove = 600;
		enemyDist = VSize(Location - Enemy.Location);
		Aggression = 2 * FRand() - 1.0;
		if (enemyDist < CollisionRadius + Enemy.CollisionRadius + 2 * MeleeRange)
			Aggression = FMin(0.0, Aggression);	
		else if (enemyDist > FMax(VSize(OldLocation - Enemy.OldLocation), 240))
			Aggression = FMax(0.0, Aggression);
		enemydir = (Enemy.Location - Location)/enemyDist;
		minDist = FMin(160.0, 5*CollisionRadius);
		Y = (enemydir Cross vect(0,0,1));
		strafeSize = FMin(0.8, (2 * Abs(Aggression) * FRand() - 0.2));
		if (Aggression <= 0)
			strafeSize *= -1;
		enemydir = enemydir * strafeSize;
		if (FRand() < 0.8)
			enemydir.Z = 1.5;
		else
			enemydir.Z = FMax(0,enemydir.Z);
		strafeSize = FMax(0.0, 1 - Abs(strafeSize));
		pickdir = strafeSize * Y;
		pick = Location + (pickdir + enemydir) * (minDist + MaxMove * FRand());
		pick.Z = Location.Z + 60 + 0.65 * MaxMove * FRand();
		minDest = Location + minDist * Normal(pick - location); 
		collSpec.X = CollisionRadius;
		collSpec.Y = CollisionRadius;
		collSpec.Z = CollisionHeight;
		HitActor = Trace(HitLocation, HitNormal, minDest, Location, false, collSpec);
		if ( HitActor == None )
		{
			Destination = pick;
			return;	
		}
		pick = Location + (enemydir - pickdir) * (minDist + MaxMove * FRand());
		pick.Z = Location.Z + 60 + 0.5 * MaxMove * FRand();
		minDest = Location + minDist * Normal(pick - location); 
		HitActor = Trace(HitLocation, HitNormal, minDest, Location, false, collSpec);
		if ( HitActor == None )
		{
			Destination = pick;
			return;	
		}
		pick = Location - enemydir * (minDist + MaxMove * FRand());
		pick.Z = Location.Z + 0.5 * MaxMove * FRand();
		minDest = Location + Normal(pick - Location) * minDist;
		HitActor = Trace(HitLocation, HitNormal, minDest, Location, false, collSpec);
		if ( HitActor == None )
		{
			Destination = pick;
			return;	
		}
		if ( !bNoCharge && (enemyDist > 120) )
			GotoState('Charging');	
		pick = MaxMove * FRand() * VRand();	
		pick.Z = FMin(Location.Z, pick.Z);
		Destination = pick;	 
	}

	function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
	{
		Global.TakeDamage(Damage, instigatedBy, hitlocation, momentum, damageType);
		if ( health <= 0 )
			return;
		if ( Enemy != None )
			LastSeenPos = Enemy.Location;
		if ( NextState == 'TakeHit' )
		{
			NextState = 'TacticalMove'; 
			NextLabel = 'TakeHit';
			GotoState('TakeHit'); 
		}
	}

	function Timer()
	{
		Enable('Bump');
		if ( Enemy != None || Enemy.Health > 0 )
		{
			bReadyToAttack = True;
			Target = Enemy;
			if (VSize(Enemy.Location - Location) 
				<= (MeleeRange + Enemy.CollisionRadius + CollisionRadius))
			GotoState('MeleeAttack');
		else if ( bHasRangedAttack && ((!bMovingRangedAttack && (FRand() < 0.8)) || (FRand() > 0.5 + 0.17 * skill)) ) 
			GotoState('RangedAttack');
		}
		else
		{
			Target = None;
			GotoState('Wandering');
		}
	}

Begin:
	TweenToRunning(0.15);
	Enable('AnimEnd');
	if ( Physics != PHYS_None || Physics == PHYS_Flying )
	{
		DesiredRotation = Rotator(Enemy.Location - Location);
		Focus = Enemy.Location;
		Destination = Enemy.Location;
		WaitForLanding();
	}
	if ( Enemy != None && Enemy.Health > 0)
		PickDestination(false);
	else GotoState('Wandering');

BackOff:
	Acceleration = AccelRate * Normal(Location - Enemy.Location);
	Acceleration.Z *= 0.5;
	Destination = Location;
	Sleep(0.5);
	SetTimer(TimeBetweenAttacks, false);
	Goto('TacticalTick');
}
*/

state TacticalMove
{
ignores SeePlayer, HearNoise;

	function PickDestination (bool bNoCharge)
	{
			local vector pickdir, enemydir, enemyPart, Y, minDest;
			local actor HitActor;
			local vector HitLocation, HitNormal, collSpec;
			local float Aggression, enemydist, minDist, strafeSize, optDist;
			local bool success, bNoReach;

		if ( !bReadyToAttack && (TimerRate == 0.00) )
			SetTimer(0.75,False);
		bChangeDir = False;
		if ( Region.Zone.bWaterZone &&  !bCanSwim && bCanFly )
		{
			Destination = Location + 75 * (VRand() + vect(0,0,1));
			Destination.Z += 100;
			return;
		}
		if ( Enemy == None || Enemy.Health <= 0 )
		{
			WhatToDoNext('Waiting','TurnFromWall');
			return;
		}
		if ( Enemy.Region.Zone.bWaterZone )
			bNoCharge = bNoCharge || !bCanSwim;
		else
			bNoCharge = bNoCharge || !bCanFly && !bCanWalk;
		success = False;
		enemyDist = VSize(Location - Enemy.Location);
		Aggression = 2.0 * (CombatStyle + FRand()) - 1.12;
		if ( Intelligence == BRAINS_Human )
		{
			if ( Enemy.bIsPlayer && ( AttitudeToPlayer == ATTITUDE_Fear ) && (CombatStyle > 0) )
				Aggression = Aggression - 2 - 2 * CombatStyle;
			if ( Weapon != None )
				Aggression += 2 * Weapon.SuggestAttackStyle();
			if ( Enemy.Weapon != None )
				Aggression += 2 * Enemy.Weapon.SuggestDefenseStyle();
		}
		if ( enemyDist > 1000 )
			Aggression += 1;
		if ( bIsPlayer && !bNoCharge )
			bNoCharge = ( Aggression < FRand() );
		if ( (Physics == PHYS_Walking) || (Physics == PHYS_Falling) )
		{
			if (Location.Z > Enemy.Location.Z + 140) //tactical height advantage
				Aggression = FMax(0.0, Aggression - 1.0 + CombatStyle);
			else if (Location.Z < Enemy.Location.Z - CollisionHeight) // below enemy
			{
				if ( !bNoCharge && (Intelligence > BRAINS_Reptile) 
					&& (Aggression > 0) && (FRand() < 0.6) )
				{
					GotoState('Charging');
					return;
				}
				else if ( (enemyDist < 1.1 * (Enemy.Location.Z - Location.Z)) 
						&& !actorReachable(Enemy) ) 
				{
					bNoReach = (Intelligence > BRAINS_None);
					aggression = -1.5 * FRand();
				}
			}
		}
		if (!bNoCharge && (Aggression > 2 * FRand()))
		{
			if ( bNoReach && (Physics != PHYS_Falling) )
			{
				TweenToRunning(0.15);
				GotoState('Charging', 'NoReach');
			}
			else
				GotoState('Charging');
			return;
		}
		if (enemyDist > FMax(VSize(OldLocation - Enemy.OldLocation), 240))
			Aggression += 0.4 * FRand();
		enemydir = (Enemy.Location - Location)/enemyDist;
		minDist = FMin(160.0, 3*CollisionRadius);
		if ( bIsPlayer )
			optDist = 80 + FMin(EnemyDist, 250 * (FRand() + FRand()));  
		else 
			optDist = 50 + FMin(EnemyDist, 500 * FRand());
		Y = (enemydir Cross vect(0,0,1));
		if ( Physics == PHYS_Walking )
		{
			Y.Z = 0;
			enemydir.Z = 0;
		}
		else 
			enemydir.Z = FMax(0,enemydir.Z);
		strafeSize = FMax(-0.7, FMin(0.85, (2 * Aggression * FRand() - 0.3)));
		enemyPart = enemydir * strafeSize;
		strafeSize = FMax(0.0, 1 - Abs(strafeSize));
		pickdir = strafeSize * Y;
		if ( bStrafeDir )
			pickdir *= -1;
		bStrafeDir = !bStrafeDir;
		collSpec.X = CollisionRadius;
		collSpec.Y = CollisionRadius;
		collSpec.Z = FMax(6, CollisionHeight - 18);
		minDest = Location + minDist * (pickdir + enemyPart);
		HitActor = Trace(HitLocation, HitNormal, minDest, Location, false, collSpec);
		if (HitActor == None)
		{
			success = (Physics != PHYS_Walking);
			if ( !success )
			{
				collSpec.X = FMin(14, 0.5 * CollisionRadius);
				collSpec.Y = collSpec.X;
				HitActor = Trace(HitLocation, HitNormal, minDest - (18 + MaxStepHeight) * vect(0,0,1), minDest, false, collSpec);
				success = (HitActor != None);
			}
			if (success)
				Destination = minDest + (pickdir + enemyPart) * optDist;
		}
		if ( !success )
		{
			collSpec.X = CollisionRadius;
			collSpec.Y = CollisionRadius;
			minDest = Location + minDist * (enemyPart - pickdir); 
			HitActor = Trace(HitLocation, HitNormal, minDest, Location, false, collSpec);
			if (HitActor == None)
			{
				success = (Physics != PHYS_Walking);
				if ( !success )
				{
					collSpec.X = FMin(14, 0.5 * CollisionRadius);
					collSpec.Y = collSpec.X;
					HitActor = Trace(HitLocation, HitNormal, minDest - (18 + MaxStepHeight) * vect(0,0,1), minDest, false, collSpec);
					success = (HitActor != None);
				}
				if (success)
					Destination = minDest + (enemyPart - pickdir) * optDist;
			}
			else 
			{
				if ( (CombatStyle <= 0) || (Enemy.bIsPlayer && (AttitudeToPlayer == ATTITUDE_Fear)) )
					enemypart = vect(0,0,0);
				else if ( (enemydir Dot enemyPart) < 0 )
					enemyPart = -1 * enemyPart;
				pickDir = Normal(enemyPart - pickdir + HitNormal);
				minDest = Location + minDist * pickDir;
				collSpec.X = CollisionRadius;
				collSpec.Y = CollisionRadius;
				HitActor = Trace(HitLocation, HitNormal, minDest, Location, false, collSpec);
				if (HitActor == None)
				{
					success = (Physics != PHYS_Walking);
					if ( !success )
					{
						collSpec.X = FMin(14, 0.5 * CollisionRadius);
						collSpec.Y = collSpec.X;
						HitActor = Trace(HitLocation, HitNormal, minDest - (18 + MaxStepHeight) * vect(0,0,1), minDest, false, collSpec);
						success = (HitActor != None);
					}
					if (success)
						Destination = minDest + pickDir * optDist;
				}
			}
		}
		if ( !success )
			GiveUpTactical(bNoCharge);
		else
		{
			pickDir = (Destination - Location);
			enemyDist = VSize(pickDir);
			if ( enemyDist > minDist + 2 * CollisionRadius )
			{
				pickDir = pickDir/enemyDist;
				HitActor = Trace(HitLocation, HitNormal, Destination + 2 * CollisionRadius * pickdir, Location, false);
				if ( (HitActor != None) && ((HitNormal Dot pickDir) < -0.6) )
					Destination = HitLocation - 2 * CollisionRadius * pickdir;
			}
		}
	}
	
	function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
	{
		Global.TakeDamage(Damage, instigatedBy, hitlocation, momentum, damageType);
		if ( health <= 0 )
			return;
		if ( Enemy != None )
			LastSeenPos = Enemy.Location;
		if ( NextState == 'TakeHit' )
		{
			NextState = 'TacticalMove'; 
			NextLabel = 'TakeHit';
			GotoState('TakeHit'); 
		}
	}

	function Timer()
	{
		Enable('Bump');
		if ( Enemy != None && Enemy.Health > 0 )
		{
			bReadyToAttack = True;
			Target = Enemy;
			if (VSize(Enemy.Location - Location) 
				<= (MeleeRange + Enemy.CollisionRadius + CollisionRadius))
			GotoState('MeleeAttack');
		else if ( Enemy != None && bHasRangedAttack && ((!bMovingRangedAttack && (FRand() < 0.8)) || (FRand() > 0.5 + 0.17 * skill)) ) 
			GotoState('RangedAttack');
		}
		else
		{
			if (Target != None)
				Target = None;
			WhatToDoNext('','');
//			GotoState('Wandering');
		}
	}

BackOff:
	if ( Enemy == None )
		Acceleration = AccelRate * Normal(Focus);
	else
		Acceleration = AccelRate * Normal(Location - Enemy.Location);
	Acceleration.Z *= 0.5;
	Destination = Location;
	Sleep(0.5);
	SetTimer(TimeBetweenAttacks,False);
	goto ('TacticalTick');
}

state Roaming
{
	function PickDestination()
	{
		GotoState('Wandering');
	}

Begin:
	GotoState('Wandering');
}

defaultproperties
{
     CarcassType=Class'NsMonster.ExFlyCarcass'
     Aggressiveness=0.700000
     RefireRate=0.700000
     WalkingSpeed=5.000000
     bCanStrafe=True
     MeleeRange=30.000000
     GroundSpeed=100.000000
     AirSpeed=150.000000
     AccelRate=300.000000
     JumpZ=100.000000
     Visibility=100
     SightRadius=2000.000000
     PeripheralVision=-1.500000
     Health=10
     HitSound1=Sound'UnrealShare.Razorfly.injur1rf'
     HitSound2=Sound'UnrealShare.Razorfly.injur2rf'
     Land=None
     Die=Sound'UnrealShare.Razorfly.death1rf'
     CombatStyle=0.400000
     MenuName="CorpseFly"
     AmbientSound=Sound'UnrealShare.flies.flybuzz'
     DrawType=DT_Mesh
     Mesh=LodMesh'NsMonster.ExFlyM'
     DrawScale=0.300000
     SoundRadius=40
     SoundVolume=245
     TransientSoundVolume=6.000000
     CollisionRadius=12.000000
     CollisionHeight=9.000000
     Buoyancy=110.000000
     RotationRate=(Pitch=6000,Yaw=65000,Roll=8192)
     LifeSpan=50.000000
}
