class Tweaker extends Actor;

var bool bInitialized;

function PostBeginPlay()
{
	if (bInitialized) return;
	bInitialized = True;
	DevelopJumps();
	SetTimer(1.20,True);
	log ("A tweaker has been spawned.");
	Super.PostBeginPlay();
}

function DevelopJumps()
{
	local NavigationPoint N;
	local DummyTarget DT;
	if ((Level.Game).IsA('DeathMatchPlus') && DeathMatchPlus(Level.Game).bUseTranslocator)
	{
		for ( N=Level.NavigationPointList; N!=None; N=N.nextNavigationPoint )
		{
			if ( N != None && N.IsA('InventorySpot'))
			{
				DT = Spawn( class'DummyTarget',,,N.Location+Vect(0,0,5) );
			}
		}
	}
}

singular event timer()
{
	local ScriptedPawn S;
	local Pawn P, En;
	local Bot B;
	local name gstate;
	local NavigationPoint NP;
	local DummyTarget DT;
	local int i;

	for (P=Level.PawnList; P!=None; P=P.NextPawn)
	{
		S = ScriptedPawn(P);
		B = Bot(P);
		if ( B != None && B.Health > 0 && B.MoveTimer > 0)
		{
			if ( B.MyTranslocator != None && B.bCanTranslocate )
			{
				Foreach B.RadiusActors (class 'DummyTarget', DT, 910)
				{
					if ( DT != None && FastTrace(B.Location,DT.Location) && B.bCanTranslocate
					&& !DT.Region.Zone.bWaterZone && VSize(DT.Location-B.Location) > 300
					&& !B.HeadRegion.Zone.bWaterZone) //forced recheck
					{
						B.DesiredRotation=Rotator(DT.Location-B.Location);
						B.Target = DT;
						B.TranslocateToTarget(DT);
						B.bCanTranslocate = False;
						//break;
					}
				}	
			}
		}
		if ( S != None && S.Health > 0 && ( S.PlayerReplicationInfo == None || ((Level.Game).bTeamGame && S.PlayerReplicationInfo != None && S.PlayerReplicationInfo.Team != En.PlayerReplicationInfo.Team)))
		{
			if ( S.IsA('Nali') || S.IsA('Cow') )
	            continue;
			foreach S.RadiusActors ( class 'Pawn', En, S.SightRadius*3 )
			{
				if ( En != None && !En.IsA('ScriptedPawn') && En != S && En.Health > 0 && !En.bHidden )
				{
				gstate = S.GetStateName();
				if ( S.Enemy == None  || ( S.Enemy != None && VSize(S.Enemy.Location-S.Location) > Vsize( En.Location-S.Location )))
				{
					if ( !S.IsInState('Attacking') && (gstate != 'Dying') )
					{
						S.Hated = En;
						S.Enemy = En;
						S.LastSeenPos = En.Location;
						S.GotoState('Attacking');
					}
					if (En.IsA('Bot'))
					{
						if (Bot(En).Enemy == None || (VSize(S.Location - Bot(En).Location) < VSize(Bot(En).Enemy.Location-Bot(En).Location) ))
						Bot(En).Enemy = S;
					}
					break;
				}
				}
			}
			if ((Level.Game).bTeamGame)
			{
				if (S.Enemy != None && S.Enemy.IsA('ScriptedPawn'))
				{
					S.Hated = None;
					S.Enemy = None;
					S.bHunting = False;
					S.Target = None;
					if ( S.OldEnemy != None && S.OldEnemy.IsA('ScriptedPawn') )
						S.OldEnemy = None;
					S.GotoState('Waiting');
				}
				S.TeamTag = 'Arn';
			}
		}
	}
	if ((Level.Game).bGameEnded) Destroy();
}

defaultproperties
{
     RemoteRole=ROLE_None
     bGameRelevant=True
     bHidden=True
}