// ============================================================
//EverythingNotify
// ============================================================

class PawnNotify expands SpawnNotify;

function prebeginplay(); //don't check for relevance

simulated function PostBeginPlay()
{
	local actor other;
	local ScriptedPawn S;

	//Don't add to notifylist if server, but keep available, so it's existence is replicated to clients
	if (level.netmode == NM_DedicatedServer) //mutator works on server.
		return;
	Super.PostBeginPlay(); //add.
	log ("Pawn Notify Initialized");
	ForEach Allactors(class'actor',other)
	{	//mask.
		if (other.style==STY_NORMAL&&(other.IsA('decoration')&&((other.isa('tree')||left(getitemname(string(other.class)),5)~="plant"))||(other.role==role_authority&&other.isa('pawn')&&(other.isa('skaarjwarrior')||other.isa('krall')||other.isa('warlord')||other.isa('bird1')||other.isa('Slith')||other.isa('manta')))))
			Other.Style=Sty_masked;
		if (other.IsA('scriptedpawn')&&!other.isa('tentacle')&&pawn(other).shadow==none)	//no decal for them.
		{
			scriptedpawn(other).Shadow = Spawn(class'Monster2Shadow',other,,other.location);
		}
	}
}

function PreCacheReferences()
{	//never called - here to force precaching of meshes like in any normal UT game...
	//continuing mission in attempt to reduce lag as much as possible - Client
	Spawn(Class'UnrealShare.BruteCarcass');
	Spawn(Class'UnrealShare.LesserBruteCarcass');
	Spawn(Class'UnrealShare.CowCarcass');
	Spawn(Class'UnrealShare.DevilfishCarcass');
	Spawn(Class'UnrealShare.FlyCarcass');
	Spawn(Class'UnrealI.GassiusCarcass');
	Spawn(Class'UnrealI.KrallCarcass');
	Spawn(Class'UnrealShare.MantaCarcass');
	Spawn(Class'UnrealI.MercCarcass');
	Spawn(Class'UnrealShare.NaliCarcass');
	Spawn(Class'UnrealI.PupaeCarcass');
	Spawn(Class'UnrealShare.CreatureCarcass');
	Spawn(Class'UnrealShare.SkaarjCarcass');
	Spawn(Class'UnrealI.TrooperCarcass');
	Spawn(Class'UnrealShare.SlithCarcass');
	Spawn(Class'UnrealShare.TentacleCarcass');
	Spawn(Class'UnrealI.WarlordCarcass');
	Spawn(Class'Unrealshare.CreatureChunks');
	//Reinforce Defaults
	spawn(class'TMale1');
	spawn(class'TMale2');
	spawn(class'TFemale1');
	spawn(class'TFemale2');
	spawn(class'TBoss');
	spawn(class'ImpactHammer');
	spawn(class'Translocator');
	spawn(class'Enforcer');
	spawn(class'UT_Biorifle');
	spawn(class'ShockRifle');
	spawn(class'PulseGun');
	spawn(class'Ripper');
	spawn(class'Minigun2');
	spawn(class'UT_FlakCannon');
	spawn(class'UT_Eightball');
	spawn(class'SniperRifle');
	spawn(class'WarheadLauncher'); //This one too
	//Now Let's see the options for old weaponry
	//These are in fact meshes used - originals
	Spawn(class'UnrealShare.ASMD');
	Spawn(class'UnrealShare.AutoMag');
	Spawn(class'UnrealShare.DispersionPistol');
	Spawn(class'UnrealShare.Eightball');
	Spawn(class'UnrealI.FlakCannon');
	Spawn(class'UnrealI.GESBioRifle');
	Spawn(class'UnrealI.Minigun');
	Spawn(class'UnrealI.QuadShot');
	Spawn(class'UnrealI.Razorjack');
	Spawn(class'UnrealI.Rifle');
	Spawn(class'UnrealShare.Stinger');
}

simulated event Actor SpawnNotification(Actor other)
{

	if (other.style==STY_NORMAL&&(other.IsA('decoration')&&((other.isa('tree')||left(getitemname(string(other.class)),5)~="plant"))||(other.role==role_authority&&other.isa('pawn')&&(other.isa('skaarjwarrior')||other.isa('krall')||other.isa('warlord')||other.isa('bird1')||other.isa('Slith')||other.isa('manta')))))
			Other.Style=Sty_masked;
	if (other.IsA('scriptedpawn')&&!other.isa('tentacle')&&pawn(other).shadow==none)	//no decal for them.
	{
		scriptedpawn(other).Shadow = Spawn(class'Monster2Shadow',other,,other.location);
	}
	return other;
}

defaultproperties
{
}
