//=============================================================================
// DMMutator converted to Other Mutator
//=============================================================================

class NsDeathMatchMutator expands Mutator;

var DeathMatchPlus MyGame;
var float md;

function PostBeginPlay()
{
	local Tweaker tw;

	MyGame = DeathMatchPlus(Level.Game);
	Level.Game.RegisterDamageMutator(Self);
	Level.Game.RegisterMessageMutator(Self);
	Super.PostBeginPlay(); //Do different stuff first and let me finish if still exist troubles
	SetUpCurrent();
	FixMovers();
	TuneSpeed();
	NavigSlow();
}

function TuneSpeed()
{
	if ( Level.NetMode != NM_Standalone )
		spawn(class'AlignS');
}

function bool AlwaysKeep(Actor Other)
{
	local bool bTemp;

	if ( Other.IsA('ScriptedPawn'))
	{
		ScriptedPawn(Other).NetUpdateFrequency = 20.000000;
		ScriptedPawn(Other).NetPriority = 3.000000;
		ScriptedPawn(Other).bCanBePissed = False;
		ScriptedPawn(Other).bIgnoreFriends = True;
		ScriptedPawn(Other).bGameRelevant = True;
		ScriptedPawn(Other).bHateWhenTriggered = True;
		ScriptedPawn(Other).bCanOpenDoors = True;
		ScriptedPawn(Other).bCanDoSpecial = True;
		if ((Level.Game).Difficulty < 4)
			ScriptedPawn(Other).Skill = (Level.Game).Difficulty;
	}
	if (Other.bIsPawn && Pawn(Other).bIsPlayer && !Other.IsA('ScriptedPawn'))
		Other.bAlwaysRelevant = True;

	if ( NextMutator != None )
		return ( NextMutator.AlwaysKeep(Other) );
	return false;
}

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	local Inventory Inv;
	local Weapon W;

	// replace Unreal I inventory actors by their Unreal Tournament equivalents
	// set bSuperRelevant to false if want the gameinfo's super.IsRelevant() function called
	// to check on relevancy of this actor.
////////////////////////////////////
	// Nelsona notes: I won't replace anything except crappy weps developed by your specific ignorance
	// I expect Monsters in troubles at replacements but I don't think is so bad this time

	if (Other.IsA('Weapon'))
	{
		if (Other.IsA('Quadshot'))
		{
			ReplaceWith(Other, "UnrealI.FlakCannon"); //Is using the same ammo in case of questions
			return False;
		}
		if (Other.IsA('SuperShockRifle'))
		{
			ReplaceWith(Other, "BotPack.ShockRifle");
			return False;
		}
		if (Other.IsA ('Translocator') && !Other.IsA('CTFTranslocator'))
		{
			ReplaceWith(Other, "NsDM.CTFTranslocator");
			return False;
		}
		bSuperRelevant = 0;
	}
	if ( Other.IsA('Inventory') )
	{
		if (Other.IsA('Pickup'))
			Pickup(Other).bAutoActivate = true;
		Inventory(Other).RespawnTime = FClamp( Inventory(Other).RespawnTime-5,5,15 );
		Inventory(Other).PickupMessageClass = Class'Botpack.PickupMessagePlus';
		if (Other.Class == Class 'Amplifier')
		{
			if ( Amplifier(Other).Charge == Amplifier(Other).Default.Charge )
				Amplifier(Other).Charge *= 5;
		}
		if (Other.IsA('Invisibility') || Other.IsA('UT_invisibility'))
		{
			ReplaceWith( Other, "UnrealShare.WeaponPowerUp" );
			return False;
		}
		if ( Other.IsA('JumpBoots') )
		{
			if ( MyGame.bJumpMatch )
			return false;
		}
		return True;
	}
	if (Other.Isa('WayBeacon'))
	{
		Other.NetUpdateFrequency = 5.000000;
		Other.RemoteRole = ROLE_DumbProxy;
		Other.AmbientGlow = 200;
		Other.LightEffect = LE_NonIncidence;
		Other.LightBrightness = 200;
		Other.LightRadius = 10;
	}
	bSuperRelevant = 1;
	if ( MyGame.bMegaSpeed && Other.bIsPawn )
	{
		Pawn(Other).GroundSpeed *= 1.4;
		Pawn(Other).WaterSpeed *= 1.4;
		Pawn(Other).AirSpeed *= 1.4;
		Pawn(Other).AccelRate *= 1.4;
	}

	if ( Other.IsA('ScriptedPawn') )
		return true;
	if ( Other.IsA('ThingFactory') )
		return true;

	Inv = Inventory(Other);
 	if ( Inv == None )
	{
		bSuperRelevant = 0;
		if ( Other.IsA('TorchFlame') )
			Other.NetUpdateFrequency = 0.5;
		return true;
	}
	bSuperRelevant = 0;
	return true;
}
//////////
// Next lines are added at my requests
//////////
function bool ReplaceWith(actor Other, string aClassName)
{
	local Actor A;
	local class<Actor> aClass;
	local Pawn P;
	local Weapon W;

	if ( Other.IsA('Inventory') && (Other.Location == vect(0,0,0)) )
		return false;
	aClass = class<Actor>(DynamicLoadObject(aClassName, class'Class'));
	if ( aClass != None )
		A = Spawn(aClass,Other.Owner,Other.tag,Other.Location, Other.Rotation);
	if ( Other.IsA('Inventory') )
	{
		if ( Inventory(Other).MyMarker != None )
		{
			Inventory(Other).MyMarker.markedItem = Inventory(A);
			if ( Inventory(A) != None )
			{
				Inventory(A).MyMarker = Inventory(Other).MyMarker;
				A.SetLocation(A.Location 
					+ (A.CollisionHeight - Other.CollisionHeight) * vect(0,0,1));
			}
			Inventory(Other).MyMarker = None;
		}
		else if ( A.IsA('Inventory') )
		{
// To work here
			Inventory(A).Respawntime = 0.0;
			Inventory(A).bHeldItem = True;
			if (Inventory(A).IsA('Weapon'))
			{
				W = Weapon(Inventory(A));
				W.PickupMessageClass = Class'Botpack.PickupMessagePlus';
				if (Other.Instigator != None && Other.Instigator.Health > 0 )
				{
					P = Other.Instigator;
					W.Instigator = P; //Let me see this
					if ( P.FindInventoryType(aClass) == None )
					{
						log ("Found Instigator Pawn "$P$" for "$Inventory(A)$" as replacement for "$Other$".");
						if (!P.bIsPlayer)
							P.bIsPlayer=True;
						W.Touch(P);
					}
				}
/*				
				Foreach W.RadiusActors(class 'ScriptedPawn', P, W.CollisionRadius-3)
				{
					if (P != None && P.FindInventoryType(aClass) == None && P.Health > 0)
					{
						log ("Found closer Pawn "$P$" for "$Inventory(A)$" as replacement for "$Other);
						if (!P.bIsPlayer)
							P.bIsPlayer=True;
						W.Touch(P);
					}
				}
*/
			}
// Will check if still bug me. No, it looks fine.
		}
	}
	if ( A != None )
	{
		A.event = Other.event;
		A.tag = Other.tag;
		A.RotationRate = Other.RotationRate; //Agree
		return true;
	}
	return false;
}

function SetUpCurrent()
{
	spawn(class'PawnNotify');
	spawn(class'Tweaker');
}

function NavigSlow()
{
	local NavigationPoint NP;
	local class<Actor> aClass;
	
	foreach AllActors(class 'NavigationPoint', NP)
	{
		if (NP != None)
		{
			NP.NetUpdateFrequency = 5.000000; //Why more ?
			if (NP.IsA('LiftCenter'))
				NP.RemoteRole = ROLE_DumbProxy; //Why was None ?
		}	
	}
}

function FixMovers()
{
	local mover M;
	local Trigger T;

	foreach AllActors(class 'Mover', M)
	{
	if (M != None)
		{
		M.NetUpdateFrequency = 10.000000;
//		log ("Mover "@M@" updated to frequency "@M.NetUpdateFrequency);
			if (M.MoverEncroachType == ME_CrushWhenEncroach && !M.bTriggerOnceOnly)
			{
				M.BumpType = BT_PawnBump;	//If I was killed why Bot need to not be killed, even is blocked, fag ?
				if (M.EncroachDamage <= 0)
					M.EncroachDamage = 5000000;
			}
		foreach AllActors (class 'Trigger', T)
			{
			if (T != None && T.Event == M.Tag && !M.bTriggerOnceOnly && T.InitialState == 'NormalTrigger' && !T.bTriggerOnceOnly )
				if ( T.TriggerType == TT_PlayerProximity )
				{
					T.TriggerType = TT_PawnProximity;
					T.ClassProximityType = class 'Pawn';
				}
			}

		if ( M.bTriggerOnceOnly )
		{
			if (M.MoverEncroachType == ME_ReturnWhenEncroach)
			{
				M.MoverEncroachType = ME_IgnoreWhenEncroach;
				log ("Detected & Resolved a Mover Triggered Once With ReturnWhenEncroach >> "@M.name);
			}
			if ( M.InitialState == 'TriggerControl' )
			{
				log ("Ass ? A mover with TriggerControl shouldn't be set bTriggerOnceOnly >> "@M.Name);
				log ("Attempt to fix mover state >> "@M.Name@" to TriggerOpenTimed.");
				M.InitialState = 'TriggerOpenTimed';
				if ( M.InitialState == 'TriggerOpenTimed' )
					log ("Succesfully fixed.");
				else
					log ("Fixing failed !!!");
			}
		}
		if (!M.bTriggerOnceOnly && M.InitialState == 'TriggerControl')
		{
			if (M.MoverEncroachType == ME_StopWhenEncroach)
				M.MoverEncroachType = ME_IgnoreWhenEncroach;
		}
		if (M.bUseTriggered == True)
		{
			M.bUseTriggered = False;
			log ("Detected & Resolved a Mover to not be cheated by GRAB command >> " @M.name);
		}
		if (M.bDamageTriggered)
			log(M@" >> is damage triggered");
		if (!M.bTriggerOnceOnly && M.MoverEncroachType == ME_ReturnWhenEncroach)
		{
			M.MoverEncroachType = ME_CrushWhenEncroach; //Camping under lifts bad ideea for lamers :P
			M.EncroachDamage = 5000000;
			log ("Detected & Resolved a Mover to not be turned back without to suffer a big damage >> "@M.name);
		}
		if (!M.bTriggerOnceOnly && M.DelayTime < md)
		{
			M.DelayTime = md; //Expect some ping reaction for NetworkPlay
		}
		if (!M.bTriggerOnceOnly && M.BumpType == BT_PlayerBump && ( M.InitialState == 'StandOpenTimed' || M.InitialState == 'BumpOpenTimed' || M.InitialState == 'BumpButon'))
		{
			M.BumpType = BT_PawnBump; //Enhanced mover, LOL, monsters will use it to hunt you back :P
		}
		}
	}
}

function ModifyPlayer(Pawn Other)
{
	local Triggerator T;
	
	if(Other.IsA('ScriptedPawn'))
		return;

	if ( Other.IsA('TournamentPlayer') )
	{
		T = Spawn(class'Triggerator',Other,,Other.Location);
		T.SetOwner(Other);
	}
	if (NextMutator != None)
		NextMutator.ModifyPlayer(Other);
}

function bool PreventDeath (Pawn Killed, Pawn Killer, name DamageType, Vector HitLocation)
{
	local bool PD;
	local Actor T;
	local int i;
	local inventory Inv;
	local weapon weap;
	local float speed;

	PD = Super.PreventDeath(Killed,Killer,DamageType,HitLocation);
	if ( Killed != none )
	{
		if (Killed.IsA('ScriptedPawn') || !Killed.bIsPlayer)
		{
			DiscardInventory(Killed);
			foreach Killed.RadiusActors (class'Actor', T, 700)
			{
				if (T != None)
				{
					for (i=0;i<4;i++)
					{
						if (T.Touching[i] == Killed && !T.IsA('Mover') && Killed.Event != T.Tag)
							T.UnTouch( Killed );
					
						if (T.IsA('Mover') && Mover(T).Instigator != None && Mover(T).Instigator == Killed && !Mover(T).bTriggerOnceOnly && Killed.Event != Mover(T).Tag )
							Mover(T).UnTrigger(Killed,Instigator);
					}
				}
			}
			CheckTouchers();
			Killed.GoToState('Dying');
		}
	}
	return PD;
	return false;
}

function DiscardInventory (Pawn Other)
{
	local Actor dropped;
	local Inventory Inv;
	local class<Weapon> Initial1;
	local class<Weapon> Initial2;

	if (Other != none)
	{
	Inv=Other.Inventory;
	Loop1:
		if ( Inv != None )
		{
			if ( Inv.IsA('Weapon') )
			{
				if ( (Inv.Class != Level.Game.BaseMutator.MutatedDefaultWeapon()) && ((Weapon(Inv).AmmoType == None) || (Weapon(Inv).AmmoType.AmmoAmount > 0)) && Weapon(Inv).bCanThrow)
				{
					if ( Inv.class != class'Enforcer' && Inv.Class != class'DoubleEnforcer' ) //Doh...
						DropWeapon(Other,Inv);
				}
			}
			Inv.Destroy();
			Inv=Inv.Inventory;
			goto Loop1;
    	}
   	}
}

function DropWeapon (Pawn Other, Inventory Inv)
{
	local Inventory DropInv;
	local int DropPitch;
	local int DropYaw;
	local Rotator DropRot;

	DropInv=Spawn(Inv.Class,,,Other.Location);
	if ( DropInv == None )
		return;
	if ( DropInv.Region.Zone == None )
	{
		DropInv.Destroy();
		return;
	}
	DropRot=Other.ViewRotation;
	DropPitch=Rand(32768);
	DropYaw=Rand(65536);
	DropRot.Pitch=DropPitch;
	DropRot.Yaw=DropYaw;
	Weapon(DropInv).bWeaponStay = false;
	DropInv.Velocity=vector(DropRot) * (Rand(250) + 250);
	DropInv.RespawnTime=0.00;
	DropInv.BecomePickup();
	DropInv.NetPriority = 1.400000;
	DropInv.NetUpdateFrequency = 10.000000;
	DropInv.RemoteRole = ROLE_DumbProxy;
	DropInv.SetPhysics(PHYS_Falling);
	DropInv.bCollideWorld=True;
	DropInv.GotoState('Pickup','dropped');
}

function checktouchers()
{
	local Actor A, Other;
	local int i;

	foreach AllActors (class 'Actor', Other)
	{
		if (Other.bDeleteMe /*|| ( Other.bIsPawn && Pawn(Other).Health < 0)*/ )
		{
			log ("Actor "$Other$ " found... checking status...");
			foreach Other.RadiusActors (Class 'Actor', A, 500)
			{
				if (A != None)
				{
					for (i=0;i<4;i++)
					if ( A.Touching[i] == Other )
					{
						log ("Found Invalid Toucher for "@A@" at "$A.Touching[i]$" being "$Other);
						A.Untouch(Other);
						A.Untrigger(Other,Instigator);
					}
				}
			}
		}
	}
}

defaultproperties
{
     md=0.300000
}
