//=============================================================================
// DMMutator.
//=============================================================================

class NsDmMutator expands Mutator;

var DeathMatchPlus MyGame;
var(Object) name InitialState;

event PostBeginPlay()
{
	MyGame = DeathMatchPlus(Level.Game);
	Level.Game.RegisterDamageMutator(Self);
	Level.Game.RegisterMessageMutator(Self);
	Super.PostBeginPlay();
	SetUpCurrent();
	EnhanceMovers();
	TuneSpeed();
	NavigSlow();
}

function SetUpCurrent()
{
	spawn(class'PawnNotify');
	spawn(class'Tweaker');
}

function TuneSpeed()
{
	if ( Level.NetMode != NM_Standalone )
		spawn(class'AlignS');
}

function EnhanceMovers()
{
	local Mover M;
	local Trigger T;

	foreach AllActors (class 'Mover',M)
	{
		if (M != None)
		{
		foreach AllActors (class 'Trigger', T)
			{
			if (T != None && T.Event == M.Tag && !M.bTriggerOnceOnly && !T.bTriggerOnceOnly)
				if (T.TriggerType == TT_PlayerProximity)
					T.TriggerType = TT_PawnProximity;
			}
		if (!M.bTriggerOnceOnly)
			if (M.BumpType == BT_PlayerBump)
				M.BumpType = BT_PawnBump;
		M.NetUpdateFrequency = 10.000000; //Done... Mover is crap anyway
		}
	}
}

function NavigSlow()
{
	local NavigationPoint NP;
	foreach AllActors(class 'NavigationPoint', NP)
	{
		if (NP != None)
		{
			NP.NetUpdateFrequency = 5.000000; //Why more ?
			if (NP.IsA('LiftCenter'))
				NP.RemoteRole = ROLE_DumbProxy; //Why was None ?
		}	
	}
}

function bool AlwaysKeep(Actor Other)
{
	local bool bTemp;

	if ( Other.IsA('StationaryPawn') )
	{
		StationaryPawn(Other).NetUpdateFrequency = 20.000000;
		StationaryPawn(Other).bGameRelevant = True;
	}

	if ( Other.IsA('ScriptedPawn') )
	{
		ScriptedPawn(Other).NetUpdateFrequency = 20.000000;
		ScriptedPawn(Other).NetPriority = 3.000000;
		ScriptedPawn(Other).bCanBePissed = True;
		ScriptedPawn(Other).bHateWhenTriggered = False;
		ScriptedPawn(Other).bGameRelevant = True;
		ScriptedPawn(Other).bCanOpenDoors = True;
		ScriptedPawn(Other).bCanDoSpecial = True;
			if ((Level.Game).Difficulty < 4)
		ScriptedPawn(Other).Skill = (Level.Game).Difficulty;
	}

	if (Other.bIsPawn && Pawn(Other).bIsPlayer && !Other.IsA('ScriptedPawn'))
		Other.bAlwaysRelevant = True;
	
	if ( NextMutator != None )
		return ( NextMutator.AlwaysKeep(Other) );
	return false;
}

function bool ReplaceWith(actor Other, string aClassName)
{
	local Actor A;
	local class<Actor> aClass;
	local Pawn P;
	local Weapon W;

	if ( Other.IsA('Inventory') && (Other.Location == vect(0,0,0)) )
		return false;
	aClass = class<Actor>(DynamicLoadObject(aClassName, class'Class'));
	if ( aClass != None )
		A = Spawn(aClass,Other.Owner,Other.tag,Other.Location, Other.Rotation);
	if ( Other.IsA('Inventory') )
	{
		if ( Inventory(Other).MyMarker != None )
		{
			Inventory(Other).MyMarker.markedItem = Inventory(A);
			if ( Inventory(A) != None )
			{
				Inventory(A).MyMarker = Inventory(Other).MyMarker;
				A.SetLocation(A.Location 
					+ (A.CollisionHeight - Other.CollisionHeight) * vect(0,0,1));
			}
			Inventory(Other).MyMarker = None;
		}
		else if ( A.IsA('Inventory') )
		{
// To work here
			Inventory(A).Respawntime = 0.0;
			Inventory(A).bHeldItem = True;
			if (Inventory(A).IsA('Weapon'))
			{
				W = Weapon(Inventory(A));
				W.PickupMessageClass = Class'Botpack.PickupMessagePlus';
				if (Other.Instigator != None && Other.Instigator.Health > 0 )
				{
					P = Other.Instigator;
					W.Instigator = P; //Let me see this
					if ( P.FindInventoryType(aClass) == None )
					{
						log ("Found Instigator Pawn "$P$" for "$Inventory(A)$" as replacement for "$Other$".");
						if (!P.bIsPlayer)
							P.bIsPlayer=True;
						W.Touch(P);
					}
				}
/*				
				Foreach W.RadiusActors(class 'ScriptedPawn', P, W.CollisionRadius-3)
				{
					if (P != None && P.FindInventoryType(aClass) == None && P.Health > 0)
					{
						log ("Found closer Pawn "$P$" for "$Inventory(A)$" as replacement for "$Other);
						if (!P.bIsPlayer)
							P.bIsPlayer=True;
						W.Touch(P);
					}
				}
*/
			}
// Will check if still bug me. No, it looks fine.
		}
	}
	if ( A != None )
	{
		A.event = Other.event;
		A.tag = Other.tag;
		A.RotationRate = Other.RotationRate; //Agree
		return true;
	}
	return false;
}

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	local Inventory Inv;

	// set bSuperRelevant to false if want the gameinfo's super.IsRelevant() function called
	// to check on relevancy of this actor.

	if (Other.IsA('Weapon'))
	{
		if (Other.IsA('Quadshot'))
		{
			ReplaceWith(Other, "UnrealI.FlakCannon"); //Is using the same ammo in case of questions
			return False;
		}
		if (Other.IsA('SuperShockRifle'))
		{
			ReplaceWith(Other, "BotPack.ShockRifle");
			return False;
		}
		if (Other.IsA ('Translocator') && !Other.IsA('CTFTranslocator'))
		{
			ReplaceWith(Other, "NsCTF.CTFTranslocator");
			return False;
		}
		bSuperRelevant = 0;
	}
	if ( Other.IsA('Inventory') )
	{
//		Pickup(Other).bAutoActivate = True;
		Inventory(Other).PickupMessageClass = Class'Botpack.PickupMessagePlus';
		if (Other.class == class 'Amplifier')
		{
			if ( Amplifier(Other).Charge == Amplifier(Other).Default.Charge )
				Amplifier(Other).Charge *= 5;
		}
		if ( Other.IsA('Invisibility') )
		{
			ReplaceWith( Other, "Botpack.UT_ShieldBelt" );
			return false;
		}
		if ( Other.IsA('UT_Invisibility') )
		{
			ReplaceWith( Other, "Botpack.UT_ShieldBelt" );
			return false;
		}
		return true;
	}

	if (Other.Isa('WayBeacon'))
	{
		Other.NetUpdateFrequency = 5.000000;
		Other.RemoteRole = ROLE_DumbProxy;
		Other.AmbientGlow = 200;
		Other.LightEffect = LE_NonIncidence;
		Other.LightBrightness = 200;
		Other.LightRadius = 10;
	}
	
	bSuperRelevant = 1;
	if ( MyGame.bMegaSpeed && Other.bIsPawn && Pawn(Other).bIsPlayer )
	{
		Pawn(Other).GroundSpeed *= 1.4;
		Pawn(Other).WaterSpeed *= 1.4;
		Pawn(Other).AirSpeed *= 1.4;
		Pawn(Other).AccelRate *= 1.4;
	}

	if ( Other.IsA('StationaryPawn') )
		return true;

	if ( Other.IsA('ScriptedPawn') )
		return true;

	Inv = Inventory(Other);
 	if ( Inv == None )
	{
		bSuperRelevant = 0;
		if ( Other.IsA('TorchFlame') )
			Other.NetUpdateFrequency = 0.5;
		return true;
	}
	if ( MyGame.bNoviceMode && MyGame.bRatedGame && (Level.NetMode == NM_Standalone) )
		Inv.RespawnTime *= (0.1 + 0.1 * MyGame.Difficulty);

	if ( Other.IsA('JumpBoots') || Other.IsA('UT_JumpBoots'))
	{
		if ( MyGame.bJumpMatch )
			return false;
	}
	bSuperRelevant = 0;
	return true;
}

function ModifyPlayer(Pawn Other)
{
	local Triggerator T;

	if ( !Other.bIsPlayer || Other.PlayerReplicationInfo == None ) //Not sure if this one will be ever used
		return;

	if ( Other.IsA('TournamentPlayer') )
	{
		T = Spawn(class'Triggerator',Other,,Other.Location);
		T.SetOwner(Other);
	}
	if (NextMutator != None)
		NextMutator.ModifyPlayer(Other);
}

function bool PreventDeath (Pawn Killed, Pawn Killer, name DamageType, Vector HitLocation)
{
	local bool PD;
	local Actor T;
	local int i;

	PD = Super.PreventDeath(Killed,Killer,DamageType,HitLocation);
	if ( Killed != none )
	{
		if (Killed.IsA('ScriptedPawn') || !Killed.bIsPlayer)
		{
			DiscardInventory(Killed);
			foreach Killed.RadiusActors (class'Actor', T, 1500)
			{
				if (T != None)
				{
					for (i=0;i<4;i++)
					{
					if (T.Touching[i] == Killed && !T.IsA('Mover'))
						T.UnTouch( Killed );
					}
					if (T.IsA('Mover') && Mover(T).Instigator != None && Mover(T).Instigator == Killed && !Mover(T).bTriggerOnceOnly)
					{
						Mover(T).UnTrigger(Killed,Instigator);
//						log ("Attempt to restore Mover "@T);
					}
				}
			}
			CheckTouchers();
			Killed.GoToState('Dying');
		}
	}
	return PD;
	return false;
}

function checktouchers()
{
	local Actor A, Other;
	local int i;

	foreach AllActors (class 'Actor', Other)
	{
		if (Other.bDeleteMe /*|| ( Other.bIsPawn && Pawn(Other).Health < 0)*/ )
		{
			log ("Actor "$Other$ " found... checking status...");
			foreach Other.RadiusActors (Class 'Actor', A, 1500)
			{
				if (A != None)
				{
					for (i=0;i<4;i++)
					if ( A.Touching[i] == Other )
					{
						log ("Found Invalid Toucher for "@A@" at "$A.Touching[i]$" being "$Other);
						A.Untouch(Other);
					}
				}
			}
		}
	}
}

function DiscardInventory (Pawn Other)
{
	local Actor dropped;
	local Inventory Inv;
	local class<Weapon> Initial1;
	local class<Weapon> Initial2;

	if (Other != none)
	{
	Inv=Other.Inventory;
	Loop1:
		if ( Inv != None )
		{
			if ( Inv.IsA('Weapon') )
			{
				if ( (Inv.Class != Level.Game.BaseMutator.MutatedDefaultWeapon()) && ((Weapon(Inv).AmmoType == None) || (Weapon(Inv).AmmoType.AmmoAmount > 0)) && Weapon(Inv).bCanThrow)
				{
					if ( Inv.class != class'Enforcer' && Inv.Class != class'DoubleEnforcer' ) //Doh...
						DropWeapon(Other,Inv);
				}
			}
			Inv.Destroy();
			Inv=Inv.Inventory;
			goto Loop1;
    	}
   	}
}

function DropWeapon (Pawn Other, Inventory Inv)
{
	local Inventory DropInv;
	local int DropPitch;
	local int DropYaw;
	local Rotator DropRot;

	DropInv=Spawn(Inv.Class,,,Other.Location);
	if ( DropInv == None )
		return;
	if ( DropInv.Region.Zone == None )
	{
		DropInv.Destroy();
		return;
	}
	DropRot=Other.ViewRotation;
	DropPitch=Rand(32768);
	DropYaw=Rand(65536);
	DropRot.Pitch=DropPitch;
	DropRot.Yaw=DropYaw;
	Weapon(DropInv).bWeaponStay = false;
	DropInv.Velocity=vector(DropRot) * (Rand(250) + 250);
	DropInv.RespawnTime=0.00;
	DropInv.BecomePickup();
	DropInv.NetPriority = 1.400000;
	DropInv.NetUpdateFrequency = 10.000000;
	DropInv.RemoteRole = ROLE_DumbProxy;
	DropInv.SetPhysics(PHYS_Falling);
	DropInv.bCollideWorld=True;
	DropInv.GotoState('Pickup','dropped');
}
/*
function Mutate(string MutateString, PlayerPawn Sender)
{
	local CTFFlag FriendlyFlag, EnemyFlag;
	
	if ( MutateString ~= "OtherFlag" )
	{
		if (Level.Game.IsA('CTFGame'))
		{
			if ( Sender.PlayerReplicationInfo.Team == 0 )
			{
				Sender.ClientMessage("Requested path for Enemy FLAG if available!", 'CriticalEvent', True);
				EnemyFlag = CTFReplicationInfo(GameReplicationInfo).FlagList[1];
				if (EnemyFlag.bHome)
				{
					Sender.Destination = EnemyFlag.Location;
					Sender.ClientMesasage("Your Destination is placed at :" $Enemy.Flag.Location);
				}
				else
					Sender.ClientMesasage("EnemyFlag is not at Home Place...");
			}
			if ( Sender.PlayerReplicationInfo.Team == 1 )
			{
				Sender.ClientMessage("Requested path for Enemy FLAG if available!", 'CriticalEvent', True);
				EnemyFlag = CTFReplicationInfo(GameReplicationInfo).FlagList[0];
				if (EnemyFlag.bHome)
				{
					Sender.Destination = EnemyFlag.Location;
					Sender.ClientMesasage("Your Destination is placed at :" $Enemy.Flag.Location);
				}
				else
					Sender.ClientMesasage("EnemyFlag is not at Home Place...");
			}
		}
	}
	if ( MutateString ~= "MyFlag" )
	{
		if (Level.Game.IsA('CTFGame'))
		{
			if ( Sender.PlayerReplicationInfo.Team == 0 )
			{
				Sender.ClientMessage("Requested path for Team FLAG if available!", 'CriticalEvent', True);
				FriendlyFlag = CTFReplicationInfo(GameReplicationInfo).FlagList[0];
				if (FriendlyFlag.bHome)
				{
					Sender.Destination = FriendlyFlag.Location;
					Sender.ClientMesasage("Your Destination is placed at :" $FriendlyFlag.Location);
				}
				else
					Sender.ClientMesasage("FriendlyFlag is not at Home Place... Go to recover it !");
			}
			if ( Sender.PlayerReplicationInfo.Team == 1 )
			{
				Sender.ClientMessage("Requested path for Team FLAG if available!", 'CriticalEvent', True);
				FriendlyFlag = CTFReplicationInfo(GameReplicationInfo).FlagList[1];
				if (FriendlyFlag.bHome)
				{
					Sender.Destination = FriendlyFlag.Location;
					Sender.ClientMesasage("Your Destination is placed at :" $FriendlyFlag.Location);
				}
				else
					Sender.ClientMesasage("FriendlyFlag is not at Home Place... Go to recover it !");
			}
		}
	}
	if ( NextMutator != None )
		NextMutator.Mutate(MutateString, Sender);	
}
*/
defaultproperties
{
}
