//=============================================================================
// CTFGame - Browser problem to show game in TAB normally
// Modifications for monsters presence (ScriptedPawn)
// Including death messages announced, multikill for combined kill
// Enhanced Attraction between A.I. sides
// External Net support for Original old weapons - read again if did not understand - Player ...
// Minimum Support for Skaarj - other craps might develop problems
//=============================================================================
class CTFGame extends Botpack.CTFGame;

function PreCacheReferences()
{	//never called - here to force precaching of meshes like in any normal UT game...
	//continuing mission in attempt to reduce lag as much as possible
	Spawn(Class'UnrealShare.BruteCarcass');
	Spawn(Class'UnrealShare.LesserBruteCarcass');
	Spawn(Class'UnrealShare.CowCarcass');
	Spawn(Class'UnrealShare.DevilfishCarcass');
	Spawn(Class'UnrealShare.FlyCarcass');
	Spawn(Class'UnrealI.GassiusCarcass');
	Spawn(Class'UnrealI.KrallCarcass');
	Spawn(Class'UnrealShare.MantaCarcass');
	Spawn(Class'UnrealI.MercCarcass');
	Spawn(Class'UnrealShare.NaliCarcass');
	Spawn(Class'UnrealI.PupaeCarcass');
	Spawn(Class'UnrealShare.CreatureCarcass');
	Spawn(Class'UnrealShare.SkaarjCarcass');
	Spawn(Class'UnrealI.TrooperCarcass');
	Spawn(Class'UnrealShare.SlithCarcass');
	Spawn(Class'UnrealShare.TentacleCarcass');
	Spawn(Class'UnrealI.WarlordCarcass');
	Spawn(Class'Unrealshare.CreatureChunks');
	//Reinforce Defaults
	spawn(class'TMale1');
	spawn(class'TMale2');
	spawn(class'TFemale1');
	spawn(class'TFemale2');
	spawn(class'TBoss');
	spawn(class'ImpactHammer');
	spawn(class'Translocator');
	spawn(class'Enforcer');
	spawn(class'UT_Biorifle');
	spawn(class'ShockRifle');
	spawn(class'PulseGun');
	spawn(class'Ripper');
	spawn(class'Minigun2');
	spawn(class'UT_FlakCannon');
	spawn(class'UT_Eightball');
	spawn(class'SniperRifle');
	spawn(class'WarheadLauncher'); //This one too
	//Now Let's see the options for old weaponry
	//These are in fact meshes used - originals
	Spawn(class'UnrealShare.ASMD');
	Spawn(class'UnrealShare.AutoMag');
	Spawn(class'UnrealShare.DispersionPistol');
	Spawn(class'UnrealShare.Eightball');
	Spawn(class'UnrealI.FlakCannon');
	Spawn(class'UnrealI.GESBioRifle');
	Spawn(class'UnrealI.Minigun');
	Spawn(class'UnrealI.QuadShot');
	Spawn(class'UnrealI.Razorjack');
	Spawn(class'UnrealI.Rifle');
	Spawn(class'UnrealShare.Stinger');
}

function Logout(pawn Exiting)
{
	local Projectile Pr;

	foreach Exiting.VisibleCollidingActors (class 'Projectile',Pr,Exiting.Default.SightRadius*2)
	{
		if ( Pr != None && Pr.Instigator == Exiting )
		{
			Pr.bReplicateInstigator = False;
			Pr.Instigator = None;
			Pr.Destroy();
		}
	}

	if ( !Exiting.bIsPlayer || Exiting.PlayerReplicationInfo == None )
		return;
	if ( Exiting.PlayerReplicationInfo.HasFlag != None && !Exiting.IsA('ScriptedPawn') && Exiting.PlayerReplicationInfo != None)
		CTFFlag(Exiting.PlayerReplicationInfo.HasFlag).SendHome();

	Super(DeathMatchPlus).Logout(Exiting);
	if ( Exiting.IsA('Spectator') || Exiting.IsA('Commander') )
		return;
    Teams[Exiting.PlayerReplicationInfo.Team].Size--;
	ClearOrders(Exiting);
	if ( (!bGameEnded && bBalanceTeams && !bRatedGame) )
		ReBalance();
}

event InitGame( string Options, out string Error )
{
	local string InOpt;

	Super(TeamGamePlus).InitGame(Options, Error);
	if ( bRatedGame )
		GoalTeamScore = 5;
	FragLimit = 0;
	bNoMonsters = False;
	NetWait = 0.100000;
	RestartWait = 3.000000;
//	bRequireReady = False;
//	bNetReady = False;
}

function bool RestartPlayer(Pawn aPlayer)
{
	local NavigationPoint N;
	local int num;
	local float totalWeight, selection, partialWeight;
	local bool bResult, bPowerPlay;
	local bot B;
	local Pawn P;
	
	bResult = Super(DeathMatchPlus).RestartPlayer(aPlayer);

	B = Bot(aPlayer);
	if ( B == None )
		return bResult;

	B.AlternatePath = None;
	
	if ( B.bPowerPlay || (BotReplicationInfo(B.PlayerReplicationInfo).RealOrders == 'Defend') )
	{
		// if bot only team and already one defender, 50% chance of powerplay for this guy if defender
		if ( FRand() < 0.5 )
		{
			B.bPowerPlay = false;
			B.SetOrders('Defend', None, true);
		}
		else
		{
			// check for bot only team and already a valid defender
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			{
				if ( !P.bIsPlayer || P.PlayerReplicationInfo == None )
					continue;
				if ( P.bIsPlayer && (P.PlayerReplicationInfo.Team == B.PlayerReplicationInfo.Team) )
				{
					if ( P.IsA('PlayerPawn') )
					{
						bPowerPlay = false;
						break;
					}
					else if ( (P != B) && P.IsA('Bot') && (Bot(P).Orders == 'Defend') )
						bPowerPlay = true;
				}
			}
			if ( bPowerPlay )
			{
				B.bPowerPlay = true;
				B.SetOrders('Attack', None, true);
			}
		}
	}

	if ( BotReplicationInfo(B.PlayerReplicationInfo).RealOrders != 'Attack' )
		return bResult;

	if ( FRand() < 0.8 )
	{
		for ( N=Level.NavigationPointList; N!=None; N=N.nextNavigationPoint )
			if ( N.IsA('AlternatePath') && (AlternatePath(N).team != B.PlayerReplicationInfo.team)
				&& !AlternatePath(N).bReturnOnly )
				TotalWeight += AlternatePath(N).SelectionWeight;
		selection = FRand() * TotalWeight;
		for ( N=Level.NavigationPointList; N!=None; N=N.nextNavigationPoint )
			if ( N.IsA('AlternatePath') && (AlternatePath(N).team != B.PlayerReplicationInfo.team) )
			{
				B.AlternatePath = AlternatePath(N);
				PartialWeight += AlternatePath(N).SelectionWeight;
				if ( PartialWeight > selection )
					break;
			}
	}
	return bResult;
}

function NavigationPoint FindPlayerStart( Pawn Player, optional byte InTeam, optional string incomingName )
{
	local PlayerStart Dest, Candidate[16], Best;
	local float Score[16], BestScore, NextDist;
	local pawn OtherPlayer;
	local int i, num;
	local Teleporter Tel;
	local NavigationPoint N;
	local byte Team;

	if ( bStartMatch && (Player != None) && Player.IsA('TournamentPlayer') 
		&& (Level.NetMode == NM_Standalone)
		&& (TournamentPlayer(Player).StartSpot != None) )
		return TournamentPlayer(Player).StartSpot;

	if ( (Player != None) && (Player.PlayerReplicationInfo != None) && !Player.IsA('ScriptedPawn'))
		Team = Player.PlayerReplicationInfo.Team;
	else
		Team = InTeam;

	if( incomingName!="" )
		foreach AllActors( class 'Teleporter', Tel )
			if( string(Tel.Tag)~=incomingName )
				return Tel;

	if ( Team == 255 )
		Team = 0;
				
	//choose candidates	
	for ( N=Level.NavigationPointList; N!=None; N=N.nextNavigationPoint )
	{
		Dest = PlayerStart(N);
		if ( (Dest != None) && Dest.bEnabled
			&& (!bSpawnInTeamArea || (Team == Dest.TeamNumber)) )
		{
			if (num<16)
				Candidate[num] = Dest;
			else if (Rand(num) < 16)
				Candidate[Rand(16)] = Dest;
			num++;
		}
	}

	if (num == 0 )
	{
		log("Didn't find any player starts in list for team"@Team@"!!!"); 
		foreach AllActors( class'PlayerStart', Dest )
		{
			if (num<16)
				Candidate[num] = Dest;
			else if (Rand(num) < 16)
				Candidate[Rand(16)] = Dest;
			num++;
		}
		if ( num == 0 )
			return None;
	}

	if (num>16) 
		num = 16;
	
	//assess candidates
	for (i=0;i<num;i++)
	{
		if ( Candidate[i] == LastStartSpot )
			Score[i] = -6000.0;
		else
			Score[i] = 4000 * FRand(); //randomize
	}		
	
	for ( OtherPlayer=Level.PawnList; OtherPlayer!=None; OtherPlayer=OtherPlayer.NextPawn)
		{
		if (OtherPlayer.IsA('ScriptedPawn'))
			continue;
		if ( OtherPlayer.bIsPlayer && (OtherPlayer.Health > 0) && !OtherPlayer.IsA('Spectator') )
			for (i=0; i<num; i++)
				if ( OtherPlayer.Region.Zone == Candidate[i].Region.Zone ) 
				{
					Score[i] -= 1500;
					NextDist = VSize(OtherPlayer.Location - Candidate[i].Location);
					if (NextDist < 2 * (CollisionRadius + CollisionHeight))
						Score[i] -= 1000000.0;
					else if ( (NextDist < 2000) && (OtherPlayer.PlayerReplicationInfo.Team != Team)
							&& FastTrace(Candidate[i].Location, OtherPlayer.Location) )
						Score[i] -= (10000.0 - NextDist);
				}
		}
	BestScore = Score[0];
	Best = Candidate[0];
	for (i=1; i<num; i++)
		if (Score[i] > BestScore)
		{
			BestScore = Score[i];
			Best = Candidate[i];
		}
	LastStartSpot = Best;
				
	return Best;
}

function SetBotOrders(Bot NewBot)
{
	local Pawn P, L, M;
	local int num;
	local bool bAvailable;

	if ( CurrentOrders[NewBot.PlayerReplicationInfo.Team] == 'Freelance' )
		CurrentOrders[NewBot.PlayerReplicationInfo.Team] = 'Attack';
	else if ( CurrentOrders[NewBot.PlayerReplicationInfo.Team] == 'Defend' )
		CurrentOrders[NewBot.PlayerReplicationInfo.Team] = 'Freelance';
	else 
	{
		CurrentOrders[NewBot.PlayerReplicationInfo.Team] = 'Defend';		
		if ( bNoviceMode )
			for ( P=Level.PawnList; P!=None; P= P.NextPawn )
			{
				if (P.IsA('ScriptedPawn'))
					continue;
				if ( P.bIsPlayer && (P != NewBot) && (P.PlayerReplicationInfo.Team == NewBot.PlayerReplicationInfo.Team)
					&& P.IsA('Bot') && (BotReplicationInfo(P.PlayerReplicationInfo).RealOrders == 'Defend') && (FRand() < 0.5) )
					{	
						CurrentOrders[NewBot.PlayerReplicationInfo.Team] = 'Attack';
						break;
					}
			}
	}		

	if ( ((CurrentOrders[NewBot.PlayerReplicationInfo.Team] == 'Attack') || (CurrentOrders[NewBot.PlayerReplicationInfo.Team] == 'Freelance'))	
		&& (NumSupportingPlayer == 0) )
	{
		For ( P=Level.PawnList; P!=None; P=P.NextPawn )
		{
			if (P.IsA('ScriptedPawn'))
				continue;
			if ( P.IsA('PlayerPawn') && (P.PlayerReplicationInfo.Team == NewBot.PlayerReplicationInfo.Team)
					&& !P.IsA('Spectator') )
			{
				num++;
				if ( (L == None) || (FRand() < 1.0/float(num)) )
					L = P;
			}
		}

		if ( L != None )
		{
			NumSupportingPlayer++;
			NewBot.SetOrders('Attack',None, true);
			return;
		}
		else if ( FRand() < 0.8 )
		{
			// no players on this team - possibly support other bot
			num = 0;
			For ( P=Level.PawnList; P!=None; P=P.NextPawn )
			{
				if (P.IsA('ScriptedPawn'))
					continue;
				if ( P.IsA('Bot') && (P.PlayerReplicationInfo.Team == NewBot.PlayerReplicationInfo.Team) 
					&& (Bot(P).Orders == 'Attack') )
			{
				num++;
				if ( (L == None) || (FRand() < 1.0/float(num)) )
				{
					// make sure P doesn't already have a follower
					bAvailable = true;
					for ( M=Level.PawnList; M!=None; M=M.NextPawn )
					{
						if (M.IsA('ScriptedPawn'))
							continue;
						if ( M.IsA('Bot') && (M.PlayerReplicationInfo.Team == NewBot.PlayerReplicationInfo.Team) 
							&& (Bot(M).Orders == 'Follow') && (Bot(M).OrderObject == P) )
							bAvailable = false;
					}
					if ( bAvailable )
						L = P;
				}
			}
			}

			if ( L != None )
			{
				NewBot.SetOrders('Attack',None, true);
				return;
			}
		}
	}
	
	if ( CurrentOrders[NewBot.PlayerReplicationInfo.Team] == 'Freelance' )
		NewBot.SetOrders('Attack', None, true);
	else	
		NewBot.SetOrders(CurrentOrders[NewBot.PlayerReplicationInfo.Team], None, true);
}

function ChangeName(Pawn Other, string S, bool bNameChange)
{
	local pawn APlayer;
	S = left(S,24);
	if (Other.PlayerReplicationInfo.PlayerName~=S)
		return;
	Super(GameInfo).ChangeName(Other, S, bNameChange);
}

/*
function float GameThreatAdd(Bot aBot, Pawn Other)
{
	local CTFFlag aFlag;

	if ((Other.bIsPlayer) && (Other.PlayerReplicationInfo.HasFlag != None))
		return 10;
	else
		return 0;
}
*/
function float GameThreatAdd(Bot aBot, Pawn Other)
{
	local CTFFlag FriendlyFlag;
	local float Threaten;
	local bool bFoundMainThreat;

	Threaten = 0;
	FriendlyFlag = CTFReplicationInfo(GameReplicationInfo).FlagList[aBot.PlayerReplicationInfo.Team];
	if ( FriendlyFlag.Holder != None && FriendlyFlag.Holder == Other && Other.PlayerReplicationInfo.HasFlag != None && Other.PlayerReplicationInfo != None)
	{
		Threaten = 10;
		bFoundMainThreat=True;
//		log (Other.GetHumanName()$ " is Main Threat for "$aBot.GetHumanName());
	}
	if (!bFoundMainThreat)
	if ( Other.PlayerReplicationInfo == None || (Other.PlayerReplicationInfo.Team != aBot.PlayerReplicationInfo.Team) )
		Threaten = FClamp(aBot.Sightradius*2/VSize(Other.Location-aBot.Location),1,5);
//	log ("Game threat for "$aBot.GetHumanName()$" is "$Threaten$ " at "$Other.GetHumanName());
	return Threaten;
}

function bool IsOnTeam(Pawn Other, int TeamNum)
{
	if ( Other.PlayerReplicationInfo != None
		&& Other.bIsPlayer && Other.PlayerReplicationInfo.Team == TeamNum
		&& Other.PlayerReplicationInfo.PlayerName != "" )
		return true;

	return false;
}

function AddToTeam( int num, Pawn Other )
{
	local teaminfo aTeam;
	local Pawn P;
	local bool bSuccess;
	local string SkinName, FaceName;
	if ( Other == None || !Other.bIsPlayer || Other.PlayerReplicationInfo == None || Other.PlayerReplicationInfo.PlayerName ~= "" )
	{
		log("Added none to team!!!");
		if ( Other != None )
			log("Pawn was "$Other);
		return;
	}
	aTeam = Teams[num];
	aTeam.Size++;
	Other.PlayerReplicationInfo.Team = num;
	Other.PlayerReplicationInfo.TeamName = aTeam.TeamName;
	if (LocalLog != None)
		LocalLog.LogTeamChange(Other);
	if (WorldLog != None)
		WorldLog.LogTeamChange(Other);
	bSuccess = false;
	if ( Other.IsA('PlayerPawn') )
	{
		Other.PlayerReplicationInfo.TeamID = 0;
		PlayerPawn(Other).ClientChangeTeam(Other.PlayerReplicationInfo.Team);
	}
	else if ( Other.bIsPlayer && Other.PlayerReplicationInfo != None )
		Other.PlayerReplicationInfo.TeamID = 1;

	while ( !bSuccess )
	{
		bSuccess = true;
		for ( P=Level.PawnList; P!=None; P=P.nextPawn )
		{
		if (!P.bIsPlayer || P.PlayerReplicationInfo == None)
			continue;
            if ( P.bIsPlayer && (P != Other)
				&& (P.PlayerReplicationInfo.Team == Other.PlayerReplicationInfo.Team) 
				&& (P.PlayerReplicationInfo.TeamId == Other.PlayerReplicationInfo.TeamId) )
				bSuccess = false;
		}
		if ( !bSuccess )
			Other.PlayerReplicationInfo.TeamID++;
	}
	BroadcastLocalizedMessage( DMMessageClass, 3, Other.PlayerReplicationInfo, None, aTeam );
	Other.static.GetMultiSkin(Other, SkinName, FaceName);
	Other.static.SetMultiSkin(Other, SkinName, FaceName, num);
	if ( bBalanceTeams && !bRatedGame )
		ReBalance();
}

function ReBalance()
{
	local int big, small, i, bigsize, smallsize;
	local Pawn P, A;
	local Bot B;

	if ( bBalancing || NumBots == 0 )
		return;

	big = 0;
	small = 0;
	bigsize = Teams[0].Size;
	smallsize = Teams[0].Size;
	for ( i=1; i<MaxTeams; i++ )
	{
		if ( Teams[i].Size > bigsize )
		{
			big = i;
			bigsize = Teams[i].Size;
		}
		else if ( Teams[i].Size < smallsize )
		{
			small = i;
			smallsize = Teams[i].Size;
		}
	}
	bBalancing = true;
	while ( bigsize - smallsize > 1 )
	{
		for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			if ( P.bIsPlayer && (P.PlayerReplicationInfo.Team == big)
				&& P.IsA('Bot') && P.PlayerReplicationInfo != None )
			{
				B = Bot(P);
				break;
			}
		if ( B != None )
		{
			B.Health = 0;
			B.Died( None, 'Suicided', B.Location );
			bigsize--;
			smallsize++;
			ChangeTeam(B, small);
		}
		else
			Break;
	}
	bBalancing = false;

	// re-assign orders to follower bots with no leaders
	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
	{
		if (!P.bIsPlayer || P.PlayerReplicationInfo == None ) continue;
		if ( P.bIsPlayer && P.IsA('Bot') && (BotReplicationInfo(P.PlayerReplicationInfo).RealOrders == 'Follow') )
		{
			A = Pawn(Bot(P).OrderObject);
			if ( (A == None) || A.bDeleteMe || !A.bIsPlayer || (A.PlayerReplicationInfo.Team != P.PlayerReplicationInfo.Team) )
			{
				Bot(P).OrderObject = None;
				SetBotOrders(Bot(P));
			}
		}
	}
}

function bool ChangeTeam(Pawn Other, int NewTeam)
{
	local int i, Smallest, DesiredTeam;
	local pawn APlayer, P;
	local teaminfo SmallestTeam;
	
	if ( !Other.bIsPlayer || Other.PlayerReplicationInfo == None )
		return false;
	if ( bRatedGame && (Other.PlayerReplicationInfo.Team != 255) )
		return false;
	if ( Other.IsA('Spectator') )
	{
		Other.PlayerReplicationInfo.Team = 255;
		if (LocalLog != None)
			LocalLog.LogTeamChange(Other);
		if (WorldLog != None)
			WorldLog.LogTeamChange(Other);
		return true;
	}

	// find smallest team
	Smallest = 0;
	for( i=1; i<MaxTeams; i++ )
		if ( Teams[Smallest].Size > Teams[i].Size )
			Smallest = i;

	if ( (NewTeam == 255) || (NewTeam >= MaxTeams) )
		NewTeam = Smallest;

	if ( bPlayersBalanceTeams && (Level.NetMode != NM_Standalone) )
	{
		if ( Teams[NewTeam].Size > Teams[Smallest].Size )
			NewTeam = Smallest;
		if ( Teams[Smallest].Size < 1 && NumPlayers > 1 )
			NewTeam = Smallest;

		if ( NumBots == 1 )
		{
			// join bot's team if sizes are equal, because he will leave
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			{
				if (!P.bIsPlayer || P.PlayerReplicationInfo == None ) continue;
				if ( P.IsA('Bot') )
					break;
			}
			if ( (P != None) && (P.PlayerReplicationInfo != None) && (P.PlayerReplicationInfo.Team != 255)
				&& (Teams[P.PlayerReplicationInfo.Team].Size == Teams[Smallest].Size) )
				NewTeam = P.PlayerReplicationInfo.Team;
		}
	}

	if ( (Other.PlayerReplicationInfo.Team == NewTeam) && bNoTeamChanges )
		return false;

	if ( Other.IsA('TournamentPlayer') )
		TournamentPlayer(Other).StartSpot = None;

	if ( Other.PlayerReplicationInfo.Team != 255 )
	{
		ClearOrders(Other);
		Teams[Other.PlayerReplicationInfo.Team].Size--;
	}

	if ( Teams[NewTeam].Size < MaxTeamSize )
	{
		AddToTeam(NewTeam, Other);
		return true;
	}

	if ( Other.PlayerReplicationInfo.Team == 255 )
	{
		AddToTeam(Smallest, Other);
		return true;
	}
	return false;
}

function PlayStartUpMessage(PlayerPawn NewPlayer)
{
	local int i;

	NewPlayer.ClearProgressMessages();

	// Game Name
	NewPlayer.SetProgressMessage(GameName, i++);
/*
	//Aaand... CYA !
	// Optional FragLimit
	if ( fraglimit > 0 )
		NewPlayer.SetProgressMessage(FragLimit@GameGoal, i++);

	if ( Level.NetMode == NM_Standalone )
		NewPlayer.SetProgressMessage(SingleWaitingMessage, i++);
	else if ( bRequireReady )
		NewPlayer.SetProgressMessage(TourneyMessage, i++);
*/
}

event PostLogin( playerpawn NewPlayer )
{
	Super(TeamGamePlus).PostLogin(NewPlayer);
	BroadcastMessage(NewPlayer.GetHumanName()$" joined to the party.");
}

function AddDefaultInventory( pawn PlayerPawn )
{
	local Weapon NewWeapon;
	local Bot B;

	if ( PlayerPawn.IsA('Spectator') || (bRequireReady && (CountDown > 0)) || PlayerPawn.IsA('ScriptedPawn'))
		return;
	Super(GameInfo).AddDefaultInventory(PlayerPawn); //Go to where I need... right now.
	if ( bUseTranslocator && (!bRatedGame || bRatedTranslocator) )
	{
		// Spawn Translocator.
		if( PlayerPawn.FindInventoryType(class'CTFTranslocator') == None )
		{
			newWeapon = Spawn(class'CTFTranslocator');
			if( newWeapon != None )
			{
				newWeapon.Instigator = PlayerPawn;
				newWeapon.BecomeItem();
				PlayerPawn.AddInventory(newWeapon);
				newWeapon.GiveAmmo(PlayerPawn);
				newWeapon.SetSwitchPriority(PlayerPawn);
				newWeapon.WeaponSet(PlayerPawn);
			}
		}
	}
	GiveWeapon(PlayerPawn, "UnrealShare.DispersionPistol");
	B = Bot(PlayerPawn);
	if ( B != None )
		B.bHasImpactHammer = (B.FindInventoryType(class'ImpactHammer') != None);
}

function ScoreKill(pawn Killer, pawn Other)
{
	local TournamentPlayer TP;

	Other.DieCount++;	
	if ((killer == None && Other.PlayerReplicationInfo != None ) || ( killer != Other && Other.PlayerReplicationInfo != None ) )
		Other.PlayerReplicationInfo.Score -= 1;

	if ( Killer != None )
	{
		Killer.KillCount++;
		if ( Killer.PlayerReplicationInfo != None
			&& Other.PlayerReplicationInfo != None
			&& (Killer.PlayerReplicationInfo.Team != Other.PlayerReplicationInfo.Team) )
			Killer.PlayerReplicationInfo.Score += 1;
		else
		if ( (ScriptedPawn(Other) != None || Other.PlayerReplicationInfo == None ) && Killer.PlayerReplicationInfo != None )
		{
//			BroadcastMessage(Killer.GetHumanName()@"killed "$Other.GetHumanName());
			if (Killer.IsA('TournamentPlayer'))
			{
				TP = TournamentPlayer(Killer);
				if ( TP.Level.TimeSeconds - TP.LastKillTime < 3 )
				{
					TP.MultiLevel++;
					TP.ReceiveLocalizedMessage( class'MultiKillMessage', TP.MultiLevel );
				} 
				else
					TP.MultiLevel = 0;
				TP.LastKillTime = TP.Level.TimeSeconds;
			}
			Killer.PlayerReplicationInfo.Score += 1;
		}
	}
	if ( bAltScoring && (killer != None) && (Killer != Other) && Other.PlayerReplicationInfo != None )
	{
		Other.PlayerReplicationInfo.Score -= 1;
	}
	BaseMutator.ScoreKill(Killer, Other);
}

function Killed(pawn killer, pawn Other, name damageType)
{
	local int NextTaunt, i;
//	local bool bAutoTaunt;
	local Projectile Pr;
//Section monkey killed, a simple and enough important fix not used by some idiots who coded Shit projectiles
	if ( Other == None || Other.bDeleteMe ) return;
	if ( Other.IsA('ScriptedPawn')
		&& Other.PlayerReplicationInfo != None
		&& Other.PlayerReplicationInfo.PlayerName != "")
	{
		Other.bIsPlayer=False;
		Other.PlayerReplicationInfo.Destroy();
	}
//Slow here - in hoping to destroy that fart during this time
	foreach Other.RadiusActors ( class'Projectile',Pr,Other.Default.SightRadius )
	{
		if ( Pr != None && Pr.Instigator == Other )
		{
			Pr.Destroy();
		}
	}
//	log ( Other.GetHumanName()$" died simply...");
//End of monkey killed (any)... Could be good only for Monsters but I don't need other check(s ?)
	if ( Killer != None && ( !Killer.bIsPlayer || Killer.PlayerReplicationInfo == None )
		&& Other.PlayerReplicationInfo != None && Other.bIsPlayer && Other.PlayerReplicationInfo.PlayerName != "" )
	{
		Other.DieCount++;
		Other.PlayerReplicationInfo.Deaths += 1;
		Other.PlayerReplicationInfo.Score -= 1;
//		log (Other.GetHumanName()$" died having "$Other.PlayerReplicationInfo.Deaths$" deaths.");
	}
	if ( Other.bIsPlayer && Other.PlayerReplicationInfo != None
		&& Other.PlayerReplicationInfo.HasFlag != None && Other.PlayerReplicationInfo.PlayerName != "")
	{
		if ( Killer != None 
		&& Killer.PlayerReplicationInfo != None && Killer.PlayerReplicationInfo.PlayerName != ""
			&& Killer.bIsPlayer && Killer != Other
			&& Killer.PlayerReplicationInfo.Team != Other.PlayerReplicationInfo.Team )
			Killer.PlayerReplicationInfo.Score += 4;
		if ( (Killer != None && Killer != Other) || Killer == None )
			Other.PlayerReplicationInfo.Score -= 2;
		CTFFlag(Other.PlayerReplicationInfo.HasFlag).Drop(0.5 * Other.Velocity);
	}

	if ( Killer == None )
	{
		if ( ScriptedPawn(Other) != None || !Other.bIsPlayer || Other.PlayerReplicationInfo == None )
		{
			if (DamageType == 'Exploded')
				BroadcastMessage(Other.GetHumanName()@" had a strange explosion.");
			else if (DamageType == 'Burned')
				BroadcastMessage(Other.GetHumanName()@" was burned by a hostile environment.");
			else if (DamageType == 'Corroded')
				BroadcastMessage(Other.GetHumanName()@" was corroded by a hostile fluid.");
			else if (DamageType == 'Mortared')
				BroadcastMessage(Other.GetHumanName()@" was blown up by a mortar.");
			else if (DamageType == 'Drowned')
				BroadcastMessage(Other.GetHumanName()@" forgot to come up for air.");
			else if (DamageType == 'Fell')
				BroadcastMessage(Other.GetHumanName()@" crashed falling.");
			else if (DamageType == 'Eradicated')
				BroadcastMessage(Other.GetHumanName()@" has been eradicated.");
			else if (DamageType == 'Suicided')						//Can be ? Movers ? Others ?
				BroadcastMessage(Other.GetHumanName()@" suffered a self damage.");
			else if (DamageType == 'Crushed')
				BroadcastMessage(Other.GetHumanName()@" died crushed.");
			else
				BroadcastMessage(Other.GetHumanName()@" died.");
			if ( Other.IsA('ScriptedPawn') && ScriptedPawn(Other).CarcassType != None )
				ScriptedPawn(Other).SpawnGibbedCarcass();
			Other.Destroy(); //Done
			return;
		}
		if (Other == None) return;
	}
	
	if ( Killer != None )
	{
		if ( Killer.PlayerReplicationInfo != None && Killer.PlayerReplicationInfo.PlayerName ~= "" && !Killer.PlayerReplicationInfo.bIsABot )
		{
			Killer.bIsPlayer = False;
			Killer.PlayerReplicationInfo.Destroy();
		}
		if ( Killer == Other && ( ScriptedPawn(Other) != None || Other.PlayerReplicationInfo == None ) )
		{
			BroadcastMessage(Killer.GetHumanName()$" suffered a self deadly pain."); return;
		}

		if ( Killer != Other && ( ScriptedPawn(Other) != None || Other.PlayerReplicationInfo == None ) )
		{
			BroadcastMessage(Killer.GetHumanName()$" killed "$Other.GetHumanName());
			if ( Killer.IsA('ScriptedPawn') ) return;
		}
		if ( !bFirstBlood )
			if ( Killer.PlayerReplicationInfo != None && Killer != Other )
			if (!Self.IsA('TrainingDM'))
			{
					bFirstBlood = True;
					BroadcastLocalizedMessage( class'FirstBloodMessage', 0, Killer.PlayerReplicationInfo );
			}
		if ( Killer.bIsPlayer && Killer.PlayerReplicationInfo != None && Killer != Other)
			Killer.Spree++;
		if (Killer.bIsPlayer && Killer.PlayerReplicationInfo != None && damageType == 'Decapitated' && Killer != Other )
		{
			if ( Killer.bIsHuman ) //Bot doesn't give a shit on this fart - FUNCTION MODIFIED
				Killer.ReceiveLocalizedMessage( class'DecapitationMessage' );
		}

		if ( Other.Spree > 4 && Other.PlayerReplicationInfo != None && Other.bIsPlayer)
		{
			if ( Killer.bIsPlayer && Killer.PlayerReplicationInfo != None )
				EndSpree(Killer, Other);
		}
		
		if ( Killer.bIsPlayer && ( Killer.PlayerReplicationInfo != None && Killer != Other ) 
			&& ( !bTeamGame || ( Other.PlayerReplicationInfo != None && Other.PlayerReplicationInfo.Team != Killer.PlayerReplicationInfo.Team )
				|| Other.PlayerReplicationInfo == None ))
		{
			if ( Killer.Spree > 4 )
				NotifySpree(Killer, Killer.Spree);
		}
		if ( bRatedGame )
			RateVs(Other, Killer);
	}
	Other.Spree = 0;
	Super(GameInfo).Killed(Killer, Other, damageType);
}

function NotifySpree(Pawn Other, int num)
{
	local Pawn P;

	if ( num == 5 )
		num = 0;
	else if ( num == 10 )
		num = 1;
	else if ( num == 15 )
		num = 2;
	else if ( num == 20 )
		num = 3;
	else if ( num == 25 )
		num = 4;
	else
		return;

	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
		if ( P.IsA('TournamentPlayer') )
			P.ReceiveLocalizedMessage( class'KillingSpreeMessage', Num, Other.PlayerReplicationInfo );
}

function byte AssessBotAttitude(Bot aBot, Pawn Other)
{
	if ( (Other.PlayerReplicationInfo != None && aBot.PlayerReplicationInfo.Team == Other.PlayerReplicationInfo.Team) || ( Other.IsA('ScriptedPawn') && ScriptedPawn(Other).Team == aBot.PlayerReplicationInfo.Team ) )
	{
		return 3; //teammate
	}
	else if ( Other.IsA('ScriptedPawn') && ScriptedPawn(Other).Team != aBot.PlayerReplicationInfo.Team )
	{
		return 1;
	}
	else if ( (Other.bIsPlayer && Other.PlayerReplicationInfo.HasFlag != None && Other.PlayerReplicationInfo != None) 
				|| ( aBot.PlayerReplicationInfo.HasFlag != None ) )
	{
		return 1;
	}
	return Super(DeathMatchPlus).AssessBotAttitude(aBot, Other);
}

function bool FindSpecialAttractionFor(Bot aBot)
{
	local CTFFlag FriendlyFlag, EnemyFlag;
	local bool bSeeFlag, bReachHome, bOrdered;
	local float Dist;
	local Pawn P;
	local Mover aMover;
	local NavigationPoint NP;
	local CTFTranslocatorTarget TT;
	local vector speed;

	if ( aBot.LastAttractCheck == Level.TimeSeconds )
		return false;

	aBot.LastAttractCheck = Level.TimeSeconds;

//	log(aBot.GetHumanName()@" find special attraction in state "@aBot.GetStateName()@" at "@Level.TimeSeconds);	
	FriendlyFlag = CTFReplicationInfo(GameReplicationInfo).FlagList[aBot.PlayerReplicationInfo.Team];
	
	if ( aBot.PlayerReplicationInfo.Team == 0 )
		EnemyFlag = CTFReplicationInfo(GameReplicationInfo).FlagList[1];
	else
		EnemyFlag = CTFReplicationInfo(GameReplicationInfo).FlagList[0];

//Add-on: Attempt to teleport out of damage zone even if has flag - LIFE is Priority, flag will return anyway
//Step 1) Try to ignore flag and go higher for less damage, first prevent lost craps to stay around
	if ( VSize(aBot.Velocity) > 300 )
		foreach aBot.VisibleCollidingActors(class'CTFTranslocatorTarget',TT,900)
		{
			if ( TT != None && TT.Instigator == aBot && TT.Instigator != None && VSize(TT.velocity) < 5 )
				TT.Destroy();
				break;
		}

	if ( aBot.MyTranslocator != None )
	{
		if (aBot.Region.Zone.bWaterZone && aBot.Region.Zone.bPainZone && aBot.FootRegion.Zone.bPainZone)
		{
			if ( aBot.MyTranslocator != None && !aBot.bCanTranslocate && EnemyFlag.Holder != None && EnemyFlag.Holder == aBot ) //even if has flag has chances to save life since flag will return anyway
			{
				aBot.bCanTranslocate = True;
				aBot.velocity.Z = 380;
			}
		}
//Step 2) A NavigationPoint in closer range and visible is a target for my translocation
		if (!aBot.HeadRegion.Zone.bWaterZone && aBot.FootRegion.Zone.bWaterZone && aBot.FootRegion.Zone.bPainZone)
		{
			foreach aBot.RadiusActors (class 'NavigationPoint',NP,900)
			{
				if (NP != None && !NP.Region.Zone.bWaterZone && aBot.LineOfSightTo(NP) && aBot.bCanTranslocate )
				{
					aBot.MoveTarget = NP;
					aBot.MoveTimer = 1.00;
					aBot.TranslocateToTarget(NP);
					break;
				}
			}
		}
	}

	bOrdered = aBot.bSniping || (aBot.Orders == 'Follow') || (aBot.Orders == 'Hold');

	if ( !FriendlyFlag.bHome  )
	{
		bSeeFlag = aBot.LineOfSightTo(FriendlyFlag.Position());
		FriendlyFlag.bKnownLocation = FriendlyFlag.bKnownLocation || bSeeFlag;
		if ( aBot.ActorReachable(EnemyFlag) && ( EnemyFlag.Holder == None || EnemyFlag.Holder != aBot ) )
		{
			aBot.MoveTarget = EnemyFlag;
			aBot.RoamTarget = EnemyFlag;
			if ( aBot.MoveTarget != None && FRand() > 0.5 )
			{
				SetAttractionStateFor(aBot);
				return True;
			}
			else
				if ( aBot.bCanTranslocate && !EnemyFlag.Region.Zone.bWaterZone && !NearMover(aBot))
				{
					aBot.Target = EnemyFlag;
					aBot.TranslocateToTarget(EnemyFlag);
				}
		}

		if ( bSeeFlag && (FriendlyFlag.Holder == None) )
		{
			if (!aBot.ActorReachable(FriendlyFlag))
			{
				if (aBot.bVerbose)
					log(aBot.GetHumanName()$" Scan Flag In Range.");
				
				if (VSize(aBot.Location - FriendlyFlag.Location) < 910 && aBot.bCanTranslocate )
				{
					if (aBot.bVerbose)
						log (aBot.GetHumanName()$" attempt to perform translocation.");
					if ( !aBot.Region.Zone.bWaterZone && !FriendlyFlag.Region.Zone.bWaterZone && !NearMover(aBot))
					{
						aBot.Target = FriendlyFlag;
						aBot.RoamTarget = FriendlyFlag;
						aBot.TranslocateToTarget(FriendlyFlag);
					}
					else //if cannot recover flag just mind whatever...
					{
						if (aBot.bVerbose)
							log(aBot$" seems in water or flag is in water or is a door around - no translocation.");
						return False;
					}
				}
				else
					FindPathToThreat(aBot);
			}
			if (aBot.ActorReachable(FriendlyFlag))
			{
				if ( FastTrace(FriendlyFlag.Location,aBot.Location) && aBot.MyTranslocator != None
				&& aBot.bCanTranslocate && FRand() > 0.5 && !FriendlyFlag.Region.Zone.bWaterZone
				&& !aBot.Region.Zone.bWaterZone && !NearMover(aBot))
				{
					aBot.Target = FriendlyFlag;
					aBot.RoamTarget = FriendlyFlag;
					aBot.TranslocateToTarget(FriendlyFlag);
					
				}
				else
					aBot.MoveTarget = FriendlyFlag;
					aBot.RoamTarget = FriendlyFlag;
				if (aBot.MoveTarget != None)
				{
					if ( Level.TimeSeconds - LastGotFlag > 6 )
					{	
						LastGotFlag = Level.TimeSeconds;
						aBot.SendTeamMessage(None, 'OTHER', 8, 20);
					}
					SetAttractionStateFor(aBot); //Let me see this
					if ( VSize(aBot.Velocity) > 50 || FRand() > 0.3 )
						return True;
					else
					{
						aBot.GoToState('Roaming','Camp');
					}
				}
			}
		}

		if ( EnemyFlag.Holder != aBot )
		{
			if ( bSeeFlag && (FriendlyFlag.Holder != None) )
			{
				FriendlyFlag.bKnownLocation = true;
				if ( Level.TimeSeconds - LastSeeFlagCarrier > 6 )
				{
					LastSeeFlagCarrier = Level.TimeSeconds;
					aBot.SendTeamMessage(None, 'OTHER', 12, 10);
				}
				aBot.SetEnemy(FriendlyFlag.Holder);
				aBot.Orders = 'Freelance';
				aBot.MoveTarget = FriendlyFlag.Holder;
				if ( aBot.IsInState('Attacking') )
					return false;
				else
				{
					aBot.GotoState('Attacking');
					return true;
				}
			}
			else if ( aBot.Orders == 'Attack' )
			{
				// break off attack only if needed
				if ( bSeeFlag || (EnemyFlag.Holder != None) 
					|| (((FriendlyFlag.Position().Region.Zone != FriendlyFlag.Homebase.Region.Zone) || (VSize(FriendlyFlag.Homebase.Location - FriendlyFlag.Position().Location) > 1000)) 
						&& ((aBot.Region.Zone != EnemyFlag.Region.Zone)
							|| (VSize(aBot.Location - EnemyFlag.Location) > 1600) || (VSize(aBot.Location - FriendlyFlag.Position().Location) < 1200))) )
				{
					FriendlyFlag.bKnownLocation = True;
					aBot.MoveTarget = aBot.FindPathToward(FriendlyFlag.Position());
					aBot.AlternatePath = None;
					if ( aBot.MoveTarget == None )
						FindPathToThreat(aBot);
					if ( aBot.MoveTarget != None )
					{
//Marker1
						if (aBot.bVerbose)
							log (aBot.GetHumanName()$" with order attack, will try to recover flag.");
						if ( FRand() > 0.5 && aBot.MyTranslocator != None
						&& aBot.bCanTranslocate && !aBot.Region.Zone.bWaterZone
						&& !NearMover(aBot) && !aBot.MoveTarget.Region.Zone.bWaterZone
						&& VSize( aBot.MoveTarget.Location - aBot.Location) > 250
						&& FastTrace(aBot.Location,aBot.MoveTarget.Location))
						{
							aBot.TranslocateToTarget(aBot.MoveTarget);
						}
						else
						{
							SetAttractionStateFor(aBot);
							return true;
						}
					}
				}
			}
			else if ( (!bOrdered || aBot.OrderObject.IsA('Bot')) 
				&& (FriendlyFlag.bKnownLocation || (FRand() < 0.1)) ) 
			{
				FriendlyFlag.bKnownLocation = true;
				aBot.MoveTarget = aBot.FindPathToward(FriendlyFlag.Position());
				if ( aBot.MoveTarget == None )
				{
					if (aBot.bVerbose)
						log(aBot.GetHumanName()$" wants a reference node, is not ordered by any Player.");
					FindPathToThreat(aBot);
				}
				if ( aBot.MoveTarget != None )
				{
//Marker1
					if (aBot.bVerbose)
						log(aBot.GetHumanName()$" without Player's order is moving to recover Flag.");
					if ( FRand() > 0.5 && aBot.MyTranslocator != None
					&& aBot.bCanTranslocate && !aBot.Region.Zone.bWaterZone
					&& !NearMover(aBot) && !aBot.MoveTarget.Region.Zone.bWaterZone
					&& VSize( aBot.MoveTarget.Location - aBot.Location) > 250
					&& FastTrace(aBot.Location,aBot.MoveTarget.Location))
					{
						aBot.TranslocateToTarget(aBot.MoveTarget);
					}
					else
					{
						SetAttractionStateFor(aBot);
						return true;
					}
				}
			}
		}
// Just recover the fucking flag if is not in right place - HOME and you aren't closer to enemy flag
		if ( !bSeeFlag && ( FriendlyFlag.Holder == None || FriendlyFlag.Holder != None ) && !aBot.ActorReachable(EnemyFlag))
		{
			if (aBot.bVerbose)
				log (aBot.GetHumanName()$" detected Flag taken. Attempt to gain a reference to recover it.");
			FindPathToThreat(aBot);
			if ( aBot.MoveTarget != None )
			{
//Marker1
				if (aBot.bVerbose)
					log (aBot.GetHumanName()$" cannot see flag but is engaged in recovering.");
				if ( FRand() > 0.5 && aBot.MyTranslocator != None
				&& aBot.bCanTranslocate && !aBot.Region.Zone.bWaterZone
				&& !NearMover(aBot) && !aBot.MoveTarget.Region.Zone.bWaterZone
				&& VSize( aBot.MoveTarget.Location - aBot.Location) > 250
				&& FastTrace(aBot.Location,aBot.MoveTarget.Location))
				{
					aBot.TranslocateToTarget(aBot.MoveTarget);
				}
				else
				{
					if ( FRand() > 0.2 )
					{
						SetAttractionStateFor(aBot);
						return true;
					}
				}
			}
		}
	}
	if ( EnemyFlag.Holder == aBot && ( FriendlyFlag.bHome || NumPlayers + NumBots > 3 && bBalanceTeams ))
	{
		aBot.bCanTranslocate = false;
		bReachHome = aBot.ActorReachable(FriendlyFlag.HomeBase);
		if ( bReachHome && !FriendlyFlag.bHome )
		{
			aBot.SendTeamMessage(None, 'OTHER', 1, 25);
			aBot.Orders = 'Freelance';
			return false;
		}
		if ( bReachHome && (VSize(aBot.Location - FriendlyFlag.Location) < 30) )
			FriendlyFlag.Touch(aBot);
		if ( aBot.Enemy != None )
		{
			if ( aBot.Health < 60 )
				aBot.SendTeamMessage(None, 'OTHER', 13, 25);
			if ( !aBot.IsInState('FallBack') )
			{
				aBot.bNoClearSpecial = true;
				aBot.TweenToRunning(0.1);
				aBot.GotoState('Fallback', 'SpecialNavig');
			}
			if ( bReachHome )
				aBot.MoveTarget = FriendlyFlag.HomeBase;
			else
				return FindPathToBase(aBot, FriendlyFlag.HomeBase);
		}
		else
		{
			if ( !aBot.IsInState('Roaming') )
			{
				aBot.bNoClearSpecial = true;
				aBot.TweenToRunning(0.1);
				aBot.GotoState('Roaming', 'SpecialNavig');
			}
			if ( bReachHome )
				aBot.MoveTarget = FriendlyFlag.HomeBase;
			else
				return FindPathToBase(aBot, FriendlyFlag.HomeBase);
		}		
		return true;
	}

	if ( EnemyFlag.Holder == None && FriendlyFlag.bHome )
	{
		if ( aBot.ActorReachable(EnemyFlag) ) //I think I can get EnemyFlag
		{
			foreach EnemyFlag.VisibleCollidingActors ( class 'Pawn',P,1000) //Check nearby turds defending first, not turn the butt at them
			{
				if ( P != None && P.Health > 0 && VSize(P.Velocity) < 250 && P.LineOfSightTo(EnemyFlag) && aBot.LineOfSightTo(P) && 
				( ( P.PlayerReplicationInfo != None && P.PlayerReplicationInfo.Team != aBot.PlayerReplicationInfo.Team )
				 ) ) //If found whatever monkey... watching Flag... and visible to me
				{
					if (aBot.bVerbose)
						log (aBot.GetHumanName()$" presumes an enemy around flag, launch attack.");
					aBot.Target = P;
					aBot.RoamTarget = P;
					aBot.SetEnemy(P);
					aBot.GotoState('Attacking'); //Just want to eliminate the turd in here
					break;
				}
			}
			if ( aBot.Enemy == None ) //It looks unguarded ?
			{
				aBot.MoveTarget = EnemyFlag; //go for it
				SetAttractionStateFor(aBot);
				return true;
			}
// To do:
// Stupid pathing to flag a la GlacierCE105 must be solved ? Is an assumed Baiter stock map ? Are you fucking kidding me ?
// Find a nearest node at 300 - 500 range with direct view to flag
// If Bot is in point, translocate to a temporary false very near target flag to touch it...
// If not move to point
// If is not closer, find path to that point - assuming we have a map not manure.
// Let me see if another stupid will climb flag on a lamp ... you are pathetic.
// Problem: Got enemy flag, then need a path to self base which is pretty stupid again,
// so here might be a problem, a big one. Probably I have to define a NavigationPoint in Range 300 - 500 with Direct Line to flag
// - then use brute force moving to flag in hope to touch it at least with head, and... if not falls into a shit hole.
// Eh ? ImpactJumping ? Whatever Jump_Boots ?
// Deserve this stupid code ? I think no because I'm not using farts, I'm using the mostly maps :|
		}
		else if ( (aBot.Orders == 'Attack')
				 || ((aBot.Orders == 'Follow') && aBot.OrderObject.IsA('Bot')
					&& ((Pawn(aBot.OrderObject).Health <= 0) 
						 || ((EnemyFlag.Region.Zone == aBot.Region.Zone) && (VSize(EnemyFlag.Location - aBot.Location) < 2000)))) )
		{
			if ( !aBot.bKamikaze
				&& ( (aBot.Weapon == None) || (aBot.Weapon.AIRating < 0.4)) )
			{
				aBot.bKamikaze = ( FRand() < 0.1 );
				return false;
			}

			if ( (aBot.Enemy != None) 
				&& (aBot.Enemy.IsA('PlayerPawn') || (aBot.Enemy.IsA('Bot') && (Bot(aBot.Enemy).Orders == 'Attack')))
				&& (((aBot.Enemy.Region.Zone == FriendlyFlag.HomeBase.Region.Zone) && (EnemyFlag.HomeBase.Region.Zone != FriendlyFlag.HomeBase.Region.Zone)) 
					|| (VSize(aBot.Enemy.Location - FriendlyFlag.HomeBase.Location) < 0.6 * VSize(aBot.Location - EnemyFlag.HomeBase.Location))) )
				{
					aBot.SendTeamMessage(None, 'OTHER', 14, 15); //"Incoming!"
					aBot.Orders = 'Freelance';
					return false;
				}

			if ( EnemyFlag.bHome )
				FindPathToBase(aBot, EnemyFlag.HomeBase);
			else
				aBot.MoveTarget = aBot.FindPathToward(EnemyFlag);
			if ( aBot.MoveTarget != None )
			{
				SetAttractionStateFor(aBot);
				return true;
			}
			else
			{
				if ( aBot.bVerbose )
					log(aBot$" no path to flag. I need sleep.");
				return false;
			}
		}
		return false;
	}

	if ( (bOrdered && !aBot.OrderObject.IsA('Bot')) || (aBot.Weapon == None) || (aBot.Weapon.AIRating < 0.4) )
		return false;

	if ( (aBot.Enemy == None) && (aBot.Orders != 'Defend') && FriendlyFlag.bHome )
	{
		Dist = VSize(aBot.Location - EnemyFlag.Holder.Location);
		if ( (Dist > 500) || (VSize(EnemyFlag.Holder.Velocity) > 230)
			|| !aBot.LineOfSightTo(EnemyFlag.Holder) )
		{
			aBot.MoveTarget = aBot.FindPathToward(EnemyFlag.Holder);
			if ( !aBot.IsInState('Roaming') )
			{
				aBot.bNoClearSpecial = true;
				aBot.TweenToRunning(0.1);
				aBot.GotoState('Roaming', 'SpecialNavig');
				return true;
			}
			return (aBot.MoveTarget != None);
		}
		else
		{
			if ( !aBot.bInitLifeMessage )
			{
				aBot.bInitLifeMessage = true;
				aBot.SendTeamMessage(EnemyFlag.Holder.PlayerReplicationInfo, 'OTHER', 3, 10);
			}
			if ( FRand() < 0.35 )
				aBot.GotoState('Wandering');
			else
			{
				aBot.CampTime = 1.0;
				aBot.bCampOnlyOnce = true;
				aBot.GotoState('Roaming', 'Camp');
			}
			return true;
		}
	}
	return false;
}

function FindPathToThreat(Bot aBot)
{
	local CTFFlag FriendlyFlag;
	local NavigationPoint N, TPoint;
	local int Dist,GoodDist,x,y;

	FriendlyFlag = CTFReplicationInfo(GameReplicationInfo).FlagList[aBot.PlayerReplicationInfo.Team];
	GoodDist = 4000; //Assuming some weapons high rated are shit in fact :|
	for ( N=Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
	{
		if (N != None && !N.IsA('Teleporter') && !N.IsA('PlayerStart')&& VSize(FriendlyFlag.Position().Location - N.Location) < 4000 && FastTrace(FriendlyFlag.Position().Location,N.Location))
		Dist = VSize(FriendlyFlag.Position().Location - N.Location);
		if ( GoodDist > Dist && Dist > 100)
		{
			TPoint = N;
			GoodDist = Dist;
		}
	}
	if ( TPoint != None )
	{
		if (aBot.bVerbose)
			log (aBot.GetHumanName()$" has a point for Flag "$TPoint);
		aBot.RoamTarget = TPoint;
/*
		if (VSize( TPoint.Location-aBot.Location ) < 80 && FastTrace(TPoint.Location,aBot.Location) )
		{
			if (FriendlyFlag.bHeld && FriendlyFlag.Holder.Health > 0 && FriendlyFlag.Holder != None )
			{
				aBot.Target = FriendlyFlag.Holder;
			}
			if ( !FriendlyFlag.bHeld && FriendlyFlag.Holder == None )
				if ( FriendlyFlag.Location.Z > aBot.Location.Z+10 && FriendlyFlag.Location.Z < aBot.Location.Z+900 && Dist < 1000 )
			{
			if (aBot.bVerbose)
				log ("No holder for flag detected by "$aBot.GetHumanName()$", attempt to spawn a DummyTarget for recover.");
// DummyTarget purpose:
// It looks like not always Can translocate at Flag, collision trouble, whatever problem in high spots
// Attempt to assign a temporary target like a JumpSpot closer to flag
				Tr = Spawn(class'DummyTarget',aBot,,FriendlyFlag.Location + (FriendlyFlag.CollisionRadius + 5) * Normal(FriendlyFlag.Location-aBot.Location));
				if ( Tr != None )
				{
					if (aBot.bVerbose)
						log ( Tr$ " spawned for Bot "$aBot.GetHumanName()$" at " $Tr.Location$" for Flag placed at "$FriendlyFlag.Location );
					if ( aBot.MyTranslocator != None && aBot.bCanTranslocate )
					{
						aBot.TranslocateToTarget(Tr);
					}
				}
				else
				{
					if (aBot.bVerbose)
						log ("Unable to spawn DummyTarget,"$aBot.GetHumanName()$" will try a direct translocation.");
					if ( aBot.MyTranslocator != None && aBot.bCanTranslocate && aBot.LineOfSightTo(FriendlyFlag) )
					{
						aBot.TranslocateToTarget(FriendlyFlag);
					}
				}
			}
		}
		else
*/

		if ( VSize( TPoint.Location - aBot.Location ) < 50 && aBot.CanSee(TPoint))
		{ aBot.MoveTarget = None; aBot.Target = FriendlyFlag.Position(); }; //Won't do shite
		if ( aBot.ActorReachable(TPoint) )
		{
			aBot.MoveTarget = TPoint;
		}
		else
		{
			aBot.MoveTarget = aBot.FindPathToWard(TPoint);
			if ( FriendlyFlag.Holder != None )
			{
				aBot.SetEnemy(FriendlyFlag.Holder);
				aBot.LastSeenPos = TPoint.Location;
			}
		}
	}
}

function bool FindPathToBase(Bot aBot, FlagBase aBase)
{
	local CTFFlag FriendlyFlag, EnemyFlag;

	if ( aBot.PlayerReplicationInfo.Team == 0 )
		EnemyFlag = CTFReplicationInfo(GameReplicationInfo).FlagList[1];
	else
		EnemyFlag = CTFReplicationInfo(GameReplicationInfo).FlagList[0];

	FriendlyFlag = CTFReplicationInfo(GameReplicationInfo).FlagList[aBot.PlayerReplicationInfo.Team];

	if ( FriendlyFlag.bHome )
	{
		if ( (aBot.AlternatePath != None) 
			&& ((aBot.AlternatePath.team == aBase.team) || aBot.AlternatePath.bTwoWay) )
		{
			if ( aBot.ActorReachable(aBot.AlternatePath) )
			{
				aBot.MoveTarget = aBot.AlternatePath;
				aBot.AlternatePath = None;
			}
			else
			{
				aBot.MoveTarget = aBot.FindPathToward(aBot.AlternatePath);
				if ( aBot.MoveTarget == None )
				{
					aBot.AlternatePath = None;
					aBot.MoveTarget = aBot.FindPathToward(aBase);
				}
			}
		}
		else
		{
	//		log (aBot.GetHumanName()$" Attempt translocate to Route2 having orders "$aBot.Orders);
			if ( FRand() > 0.3 && aBot.MyTranslocator != None &&
			aBot.bCanTranslocate && aBot.RouteCache[2] != None && !aBot.Region.Zone.bWaterZone &&
			/*!aBot.IsInState('Attacking') &&*/ !NearMover(aBot) && //Accesed nones - removed test state
			VSize(aBot.RouteCache[2].Location-aBot.Location) > 350 &&
			VSize(aBot.RouteCache[2].Location-aBot.Location) < 910 &&
			FastTrace(aBot.RouteCache[2].Location,aBot.Location) &&
			!aBot.RouteCache[2].Region.Zone.bWaterZone )
			{
	//			log (aBot.GetHumanName()$" start to translocate at Route2.");
				aBot.TranslocateToTarget(aBot.RouteCache[2]);
			}
			else
			{
	//			log(aBot.GetHumanName()$" is moving normally to the "$aBase$" Base.");
				aBot.MoveTarget = aBot.FindPathToward(aBase); //Original line
			}
		}
		return (aBot.bNoClearSpecial || (aBot.MoveTarget != None));
	}
}

function bool NearMover (Bot aBot)
{
	local Mover M;
	local bool response;

//	log (aBot.GetHumanName()$" test nearby movers." );
	response = False;
	foreach aBot.RadiusActors(class 'Mover', M, 600)
	{
		if ( M != None )
		{
			response = True;
			break;
		}
	}
	return response;
}
/*
function timer()
{
	local int RTC, BTC, GTC, GOTC, HUMAN, BOTSI;
	local Pawn P;

	RTC = 0; BTC = 0; GTC = 0; GOTC = 0;
	HUMAN = 0; BOTSI = 0;
	For ( P=Level.PawnList; P!=None; P=P.NextPawn )
	{
		if (!P.bIsPlayer || P.PlayerReplicationInfo == None)
			continue;
		if ( P.PlayerReplicationInfo != None && P.bIsPlayer )
		{
			if ( P.PlayerReplicationInfo.Team == 0 )
			{
				RTC++;
			}
			if ( P.PlayerReplicationInfo.Team == 1 )
			{
				BTC++;
			}
			if ( P.PlayerReplicationInfo.Team == 2 )
			{
				GTC++;
			}
			if ( P.PlayerReplicationInfo.Team == 3 )
			{
				GOTC++;
			}
			if (P.IsA('TournamentPlayer'))
				HUMAN++;
			if (P.IsA('Bot'))
				BOTSI++;
		}
	}
	Teams[0].Size = RTC;
	Teams[1].Size = BTC;
	Teams[2].Size = GTC;
	Teams[3].Size = GOTC;
	NumPlayers = HUMAN;
	NumBots = BOTSI;
	if (!bGameEnded && !bRatedGame && bPlayersBalanceTeams && NumBots == 0 && NumPlayers > 1)
	{
		if ( RTC-1 > BTC || BTC-1 > RTC ) //let me see for 2 teams
			Rebalance();
	}
	Super.Timer();
}
*/
/*
function int ReduceDamage(int Damage, name DamageType, pawn injured, pawn instigatedBy)
{
	Damage = Super(DeathMatchPlus).ReduceDamage(Damage, DamageType, injured, instigatedBy);

	if ( instigatedBy == None )
		return Damage;
/*
	if ((instigatedBy != injured) && (injured.PlayerReplicationInfo.Team != instigatedBy.PlayerReplicationInfo.Team)
		&& injured.IsA('Bot') && ((injured.health < 35) || (injured.PlayerReplicationInfo.HasFlag != None))
		&& injured.PlayerReplicationInfo != None && instigatedBy.PlayerReplicationInfo != None )
	{
			Bot(injured).SendTeamMessage(None, 'OTHER', 4, 15);
			return Damage;
	}
*/
	if ( (instigatedBy != injured) && injured.bIsPlayer && instigatedBy.bIsPlayer 
		&& (injured.PlayerReplicationInfo.Team == instigatedBy.PlayerReplicationInfo.Team)
		&& injured.PlayerReplicationInfo != None && instigatedBy.PlayerReplicationInfo != None )
	{
		if ( injured.IsA('Bot') )
			Bot(Injured).YellAt(instigatedBy);
		return (Damage * FriendlyFireScale);
	}
	else
		return Damage;
}
*/
function int ReduceDamage(int Damage, name DamageType, pawn injured, pawn instigatedBy)
{
//	Damage = Super(DeathMatchPlus).ReduceDamage(Damage, DamageType, injured, instigatedBy);
//	log ("Reduce Damage Report Instigator is "$InstigatedBy/*.GetHumanName()*/$" attempting hit to "$Injured/*.GetHumanName()*/);
	if (injured.Region.Zone.bNeutralZone)
		return 0;
	if ( instigatedBy == None)
		return Damage;
	Damage *= InstigatedBy.DamageScaling;
	if ( bHardCoreMode )
		Damage *= 1.5;
	if ( bNoviceMode && !bThreePlus )
	{
		if ( instigatedBy.bIsPlayer && instigatedby.PlayerReplicationInfo != None && (injured == instigatedby) && (Level.NetMode == NM_Standalone) )
			Damage *= 0.5;

		//skill level modification
		if ( instigatedBy.IsA('Bot') && injured.IsA('PlayerPawn') )
		{
			if ( ((instigatedBy.Weapon != None) && instigatedBy.Weapon.bMeleeWeapon) 
				|| ((injured.Weapon != None) && injured.Weapon.bMeleeWeapon && (VSize(injured.location - instigatedBy.Location) < 600)) )
				Damage = Damage * (0.76 + 0.08 * instigatedBy.skill);
			else
				Damage = Damage * (0.25 + 0.15 * instigatedBy.skill);
		}
	}
	if ( instigatedBy != None && injured != None && ( injured == InstigatedBy || injured != instigatedBy ) && instigatedby.PlayerReplicationInfo == None ) return Damage;
/*
	if ( instigatedBy == None )
		return Damage;
*/
	if ( (instigatedBy != injured) && injured.PlayerReplicationInfo != None && instigatedBy.PlayerReplicationInfo != None
		&& (injured.PlayerReplicationInfo.Team ~= instigatedBy.PlayerReplicationInfo.Team) )
	{
		if ( injured.IsA('Bot') )
			Bot(Injured).YellAt(instigatedBy);
		return (Damage * FriendlyFireScale);
	}
	return Damage;
}

function CalcEndStats()
{
//	Do not scream as retard, is only a game and I don't care what are you clocking
//	That one should be configurable...
	log ("We suppose to calculate farts... oops stats ?");
}

defaultproperties
{
     bSpawnInTeamArea=True
     bScoreTeamKills=False
     MaxTeams=2
     MaxAllowedTeams=2
     GoalTeamScore=10.000000
     TimeLimit=30
     bRatedTranslocator=False
     StartUpMessage=" Capture Enemy Flag and Defend Yours !"
     gamegoal="captures wins the match!"
     LadderTypeIndex=2
     ScoreBoardType=Class'Botpack.UnrealCTFScoreboard'
     HUDType=Class'Botpack.ChallengeCTFHUD'
     MapListType=Class'Botpack.CTFMapList'
     MapPrefix="CTF"
     BeaconName="CTF"
     GameName="Capture the Flag NS version"
     ExplodeMessage=" was directly blown up"
     FallMessage=" left just a small crater."
     DrownedMessage=" has drowned because of missing air."
     BurnedMessage=" was so incinerated"
     CorrodedMessage=" was nasty slimed"
     HackedMessage=" was successfully hacked"
     MortarMessage=" was blasted by a mortar."
     GameReplicationInfoClass=Class'Botpack.CTFReplicationInfo'
     MutatorClass=Class'NsCTF.NsDmMutator'
}
