class XC_Boost expands Info;

var MBot_E Ow;
var bool bWasCarrier;
var int BlkCycles, SlantCycles;

native(3540) final iterator function PawnActors( class<Pawn> PawnClass, out pawn P, optional float Distance,
optional vector VOrigin, optional bool bHasPRI);

native(3541) final iterator function NavigationActors( class<NavigationPoint> NavClass, out NavigationPoint P,
optional float Distance, optional vector VOrigin, optional bool bVisible);

native(3542) final iterator function InventoryActors( class<Inventory> InvClass, out Inventory Inv,
optional bool bSubclasses, optional Actor StartFrom);

function DoTracking()
{
	local Pawn P;

	if ( Ow != None && Ow.Health > 0 && !Ow.bHidden )
	{
		if ( Ow.IsInState('Roaming') || Ow.IsInState('Wandering') )
		{
			if ( Ow.Enemy == None || !Ow.ValidSight( Ow.Enemy ))
			{
				foreach PawnActors ( class 'Pawn',P,Ow.SightRadius,Ow.Location )
				{
					if ( Ow != P && Ow.ValidSight(P) && P.Health > 0 && P.bCollideActors
						&& !P.bHidden && P.DrawType == DT_Mesh && FlockPawn(P) == None )
					{
						if (Ow.AttitudeTo(P) < ATTITUDE_Ignore)
						{
							Ow.SeePlayer(P);
//							log (Ow.GetHumanName()@"see"@P.GetHumanName());
							break;
						}
					}
				}
			}
		}
	}
}

function CheckCarry()
{
	local AlternatePath Ap;

	if ( Ow.PlayerReplicationInfo != None && Ow.PlayerReplicationInfo.HasFlag != None
		&& Ow.IsInstate('Roaming') && Ow.Health > 0 && !Ow.bHidden )
		bWasCarrier = True;
	if ( bWasCarrier )
	{
		if ( Ow.PlayerReplicationInfo != None && Ow.PlayerReplicationInfo.HasFlag == None
		&& Ow.IsInstate('Roaming') && Ow.Health > 0 && !Ow.bHidden )
		{
//			log ("Find Alternate Path for"@Ow.GetHumanName());
			bWasCarrier = False;
			if ( Ow.AlternatePath == None )
			{
				foreach NavigationActors( class 'AlternatePath', Ap )
				{
					if ( FRand() > 0.3 && Ap.Team != Ow.PlayerReplicationInfo.Team )
					{
						Ow.AlternatePath = Ap;
						break;
					}
				}
			}
		}
	}
}

function CheckMovement()
{
	local Weapon W;
	local float ZPower;
	local Actor TheGoal;
	local LiftExit Le;
	local vector Direction;

//	log ("MoveCheck");
	if ( Ow != None && Ow.Health > 0 && !Ow.Region.Zone.bWaterZone )
	{
		if ( ( Ow.Enemy == None || !Ow.LineOfSightTo(Ow.Enemy)) && Ow.IsInState('Roaming')
		&& Ow.MoveTarget != None && Ow.SpecialPause == 0 
		&& FastTrace( Ow.Location+vect(0,0,40),Ow.MoveTarget.Location )
		&& !FastTrace(Ow.Location+vect(0,0,-25),Ow.MoveTarget.Location )
		&& !Ow.bCamping )
			if ( VSize( Ow.Velocity ) < 10 )
				BlkCycles++;
			else
			{
				if ( BlkCycles > 0 )
					BlkCycles--;
			}
			if ( BlkCycles >= 8 ) //aprox. 2+ seconds obstructed ?
			{
				Ow.BigJump(Ow.MoveTarget); //Try a jump - my owner is a fagitron (not the mapper, of course...)
				BlkCycles = 0;
			}
		if ( Ow.MoveTarget != None && !Ow.Region.Zone.bWaterZone && Ow.SpecialPause == 0 ) //jumping at higher spots in small spots - over goal = FALL
		{
			if ( FastTrace(Ow.MoveTarget.Location,Ow.Location )
				&& VSize(Ow.MoveTarget.Location - Ow.Location) < 20 
				&& Ow.IsInState('FallingState') ) //Block it instantly - Fall to target and not beyond it
			{
				Ow.Velocity.X = 0;
				Ow.Velocity.Y = 0;
				Ow.Acceleration = vect(0,0,0);
				Ow.GotoState('FallingState','PlayFall');
				Ow.SpecialPause = 0.2;
			}
		}
/*
//I'm not sure about owner check - it's the second failure - or I might need a different deal...
		if ( Ow.Enemy == None && Ow.IsInState('Wandering')
			&& Ow.MoveTarget == None && Ow.Weapon != None
			&& Ow.Weapon.AIRating < 0.3 )
		{
			foreach InventoryActors(class'Weapon', W)
			{
				if ( W.AIRating > Ow.Weapon.AIRating && W.Owner != None && W.Owner == Ow )
				{
					Ow.SwitchToBestWeapon();
						break;
				}
			}
		}
*/
		if ( Ow.MoveTarget != None && Mover(Ow.Base) != None 
		&& ( Mover(Ow.Base).Velocity.Z > 80 && Mover(Ow.Base).Velocity.Z < 400 )
		&& FRand() < 0.7 && !Ow.Region.Zone.bWaterZone )
		{
//			log (Self.Name@Ow.getHumanName()@"jumping from lift");
//			log (Ow.getHumanName()@" has velocity z"@Ow.Velocity.Z);
//			log ("Lift Velocity on Z is"@Mover(Ow.Base).Velocity.Z);
			foreach RadiusActors(class'LiftExit',Le,300,Ow.Location )
			{
				if ( Le.Location.Z > Ow.Location.Z
					&& FastTrace(Le.Location,Ow.Location+vect(0,0,12))
					&& Ow.Location.Z+150 > Le.Location.Z )
				{
					TheGoal=Le;
					break;
				}
			}
			if ( TheGoal != None )
			{
				ZPower = Ow.JumpZ;
				Ow.JumpZ = ZPower+Mover(Ow.Base).Velocity.Z+50;
				Ow.StopWaiting();
				Ow.SetBase(None);
				Ow.SpecialPause = 0;
				Ow.PlayRunning();
				Ow.MoveTarget = TheGoal;
				Ow.Destination = Ow.MoveTarget.Location;
//				log (Ow.GetHumanName()@"has"@TheGoal);
				Ow.BigJump(Ow.MoveTarget);
				Ow.MoveTarget = TheGoal; //Regain this after jump
				Ow.JumpZ = ZPower; //restore jump
				Ow.EAdjustJump();
				Ow.SetFall();
			}
		}
		if ( Ow.MoveTarget != None && Ow.MoveTarget.Location.Z+40 < Ow.Location.Z
			&& FRand() < 0.6 )
		{
			if ( Ow.Velocity.Z > 10 && Ow.Base == None )
			{
				Ow.EAdjustJump();
			}
		}
		if ( Ow.MoveTarget != None
			&& !FastTrace(Ow.Location,Ow.MoveTarget.Location)
				&& Ow.SpecialPause == 0 && Ow.Enemy == None )
		{
			if ( Ow.IsInState('FallingState') )
				SlantCycles++;
			if ( SlantCycles >= 24 )
			{
				Ow.MoveTarget = None;
				Ow.GotoState('Wandering');
				log (Self.Name@" slant hit ?"@Ow.GetHumanName());
				SlantCycles = 0;
			}
		}
	}
}

Auto State Boosting
{
Begin:
	Sleep(1.00);
//	log(Self.Name@"start Tracking"@Ow.GetHumanName());
Looping:
	Sleep (0.3);
	if ( Ow == None )
		Goto('End');
	DoTracking();
	CheckCarry();
	CheckMovement();
	GoTo('Looping');
End:
	Destroy();
}

defaultproperties
{
	bGameRelevant=True
}