//=============================================================================
// FemaleBotPlus.
//=============================================================================
class MFemaleBotPlus expands MHumanBotPlus
	abstract;

function PlayRightHit(float tweentime)
{
	if ( AnimSequence == 'RightHit' )
		TweenAnim('GutHit', tweentime);
	else
		TweenAnim('RightHit', tweentime);
}

function PlayChallenge()
{
	TweenToWaiting(0.17);
}

function PlayVictoryDance()
{
	local float decision;

	decision = FRand();

	if ( decision < 0.25 )
		PlayAnim('Victory1',0.7, 0.2);
	else if ( decision < 0.5 )
		PlayAnim('Thrust',0.7, 0.2);
	else if ( decision < 0.75 )
		PlayAnim('Taunt1',0.7, 0.2);
	else
		TweenAnim('Taunt1', 0.2);
}

function PlayDying(name DamageType, vector HitLoc)
{
	local carcass carc;

	BaseEyeHeight = Default.BaseEyeHeight;
	PlayDyingSound();

	if ( DamageType == 'Suicided' )
	{
		PlayAnim('Dead3',, 0.1);
		GoTo JL105;
	}

	// check for head hit
	if ( (DamageType == 'Decapitated') && !Level.Game.bVeryLowGore )
	{
		PlayDecap();
		GoTo JL105;
	}

	if ( FRand() < 0.15 )
	{
		PlayAnim('Dead7',,0.1);
		GoTo JL105;
	}

	// check for big hit
	if ( (Velocity.Z > 250) && (FRand() < 0.75) )
	{
		if ( (HitLoc.Z < Location.Z) && !Level.Game.bVeryLowGore && (FRand() < 0.6) )
		{
			PlayAnim('Dead5',,0.05);
			if ( Level.NetMode != NM_Client )
			{
				carc = Spawn(class 'UT_FemaleFoot',,, Location - CollisionHeight * vect(0,0,0.5));
				if (carc != None)
				{
					carc.Initfor(self);
					carc.Velocity = Velocity + VSize(Velocity) * VRand();
					carc.Velocity.Z = FMax(carc.Velocity.Z, Velocity.Z);
				}
			}
		}
		else
			PlayAnim('Dead2',, 0.1);
		GoTo JL105;
	}

	// check for repeater death
	if ( (Health > -10) && ((DamageType == 'shot') || (DamageType == 'zapped')) )
	{
		PlayAnim('Dead9',, 0.1);
		GoTo JL105;
	}

	if ( (HitLoc.Z - Location.Z > 0.7 * CollisionHeight) && !Level.Game.bVeryLowGore )
	{
		if ( FRand() < 0.5 )
			PlayDecap();
		else
			PlayAnim('Dead3',, 0.1);
		GoTo JL105;
	}

	//then hit in front or back	
	if ( FRand() < 0.5 ) 
		PlayAnim('Dead4',, 0.1);
	else
		PlayAnim('Dead1',, 0.1);
JL105:
}

function PlayDecap()
{
	local carcass carc;

	PlayAnim('Dead6',, 0.1);
	if ( Level.NetMode != NM_Client )
	{
		carc = Spawn(class 'UT_HeadFemale',,, Location + CollisionHeight * vect(0,0,0.8), Rotation + rot(3000,0,16384) );
		if (carc != None)
		{
			carc.Initfor(self);
			carc.Velocity = Velocity + VSize(Velocity) * VRand();
			carc.Velocity.Z = FMax(carc.Velocity.Z, Velocity.Z);
		}
	}
}

defaultproperties
{
     CarcassType=Class'Botpack.TFemale1Carcass'
     drown=Sound'MBot_E.mdrown2fem'
     breathagain=Sound'MBot_E.hgasp3'
     HitSound3=Sound'MBot_E.linjur4'
     HitSound4=Sound'MBot_E.hinjur4'
     Deaths(0)=Sound'MBot_E.death1d'
     Deaths(1)=Sound'MBot_E.death2a'
     Deaths(2)=Sound'MBot_E.death3c'
     Deaths(3)=Sound'MBot_E.decap01'
     Deaths(4)=Sound'MBot_E.death41'
     Deaths(5)=Sound'MBot_E.death42'
     GaspSound=Sound'MBot_E.lgasp1'
     UWHit1=Sound'MBot_E.UWhit01'
     UWHit2=Sound'MBot_E.MUWHit2'
     LandGrunt=Sound'MBot_E.lland1'
     JumpSound=Sound'MBot_E.Fjump1'
     StatusDoll=Texture'Botpack.Icons.Woman'
     StatusBelt=Texture'Botpack.Icons.WomanBelt'
     VoicePackMetaClass="BotPack.VoiceFemale"
     bIsFemale=True
     HitSound1=Sound'MBot_E.linjur2'
     HitSound2=Sound'MBot_E.linjur3'
     Die=Sound'MBot_E.death1d'
}
