class MBot_E expands Bot abstract;

/*
	Sounds seems to cause troubles when package is recompiled, default properties will be getting lost.
	I don't dig right now for that why happens... Neither to redefine them each time.
	I prefer to implement them separate importing them faster.
*/

#exec AUDIO IMPORT FILE="Sounds\LSplash.wav" NAME="LSplash"
#exec AUDIO IMPORT FILE="Sounds\Land1.wav" NAME="Land1"
#exec AUDIO IMPORT FILE="Sounds\UWhit01.wav" NAME="UWhit01"
#exec AUDIO IMPORT FILE="Sounds\stone05.wav" NAME="stone05"
#exec AUDIO IMPORT FILE="Sounds\stone04.wav" NAME="stone04"
#exec AUDIO IMPORT FILE="Sounds\stone02.wav" NAME="stone02"
#exec AUDIO IMPORT FILE="Sounds\lland1.wav" NAME="lland1"
#exec AUDIO IMPORT FILE="Sounds\linjur4.wav" NAME="linjur4"
#exec AUDIO IMPORT FILE="Sounds\linjur3.wav" NAME="linjur3"
#exec AUDIO IMPORT FILE="Sounds\linjur2.wav" NAME="linjur2"
#exec AUDIO IMPORT FILE="Sounds\lgasp1.wav" NAME="lgasp1"
#exec AUDIO IMPORT FILE="Sounds\hinjur4.wav" NAME="hinjur4"
#exec AUDIO IMPORT FILE="Sounds\hgasp3.wav" NAME="hgasp3"
#exec AUDIO IMPORT FILE="Sounds\Fjump1.wav" NAME="Fjump1"
#exec AUDIO IMPORT FILE="Sounds\decap01.wav" NAME="decap01"
#exec AUDIO IMPORT FILE="Sounds\death42.wav" NAME="death42"
#exec AUDIO IMPORT FILE="Sounds\death41.wav" NAME="death41"
#exec AUDIO IMPORT FILE="Sounds\death3c.wav" NAME="death3c"
#exec AUDIO IMPORT FILE="Sounds\death2a.wav" NAME="death2a"
#exec AUDIO IMPORT FILE="Sounds\death1d.wav" NAME="death1d"
#exec AUDIO IMPORT FILE="Sounds\BNewGib.wav" NAME="BNewGib"
#exec AUDIO IMPORT FILE="Sounds\Bland01.wav" NAME="Bland01"
#exec AUDIO IMPORT FILE="Sounds\BJump1.wav" NAME="BJump1"
#exec AUDIO IMPORT FILE="Sounds\BInjur4.wav" NAME="BInjur4"
#exec AUDIO IMPORT FILE="Sounds\BInjur3.wav" NAME="BInjur3"
#exec AUDIO IMPORT FILE="Sounds\BInjur2.wav" NAME="BInjur2"
#exec AUDIO IMPORT FILE="Sounds\BInjur1.wav" NAME="BInjur1"
#exec AUDIO IMPORT FILE="Sounds\BFootstep.wav" NAME="BFootstep"
#exec AUDIO IMPORT FILE="Sounds\BDeath4.wav" NAME="BDeath4"
#exec AUDIO IMPORT FILE="Sounds\BDeath3.wav" NAME="BDeath3"
#exec AUDIO IMPORT FILE="Sounds\BDeath1.wav" NAME="BDeath1"
#exec AUDIO IMPORT FILE="Sounds\UWinjur42.wav" NAME="UWinjur42"
#exec AUDIO IMPORT FILE="Sounds\UWinjur41.wav" NAME="UWinjur41"
#exec AUDIO IMPORT FILE="Sounds\land10.wav" NAME="land10"
#exec AUDIO IMPORT FILE="Sounds\land01.wav" NAME="land01"
#exec AUDIO IMPORT FILE="Sounds\jump1.wav" NAME="jump1"
#exec AUDIO IMPORT FILE="Sounds\injurM04.wav" NAME="injurM04"
#exec AUDIO IMPORT FILE="Sounds\injurL2.wav" NAME="injurL2"
#exec AUDIO IMPORT FILE="Sounds\injurL04.wav" NAME="injurL04"
#exec AUDIO IMPORT FILE="Sounds\injurH5.wav" NAME="injurH5"
#exec AUDIO IMPORT FILE="Sounds\hgasp1.wav" NAME="hgasp1"
#exec AUDIO IMPORT FILE="Sounds\gasp02.wav" NAME="gasp02"
#exec AUDIO IMPORT FILE="Sounds\drownM02.wav" NAME="drownM02"
#exec AUDIO IMPORT FILE="Sounds\deathc53.wav" NAME="deathc53"
#exec AUDIO IMPORT FILE="Sounds\deathc52.wav" NAME="deathc52"
#exec AUDIO IMPORT FILE="Sounds\deathc51.wav" NAME="deathc51"
#exec AUDIO IMPORT FILE="Sounds\deathc4.wav" NAME="deathc4"
#exec AUDIO IMPORT FILE="Sounds\deathc3.wav" NAME="deathc3"
#exec AUDIO IMPORT FILE="Sounds\deathc1.wav" NAME="deathc1"
#exec AUDIO IMPORT FILE="Sounds\MLand3.wav" NAME="MLand3"
#exec AUDIO IMPORT FILE="Sounds\TMJump3.wav" NAME="TMJump3"
#exec AUDIO IMPORT FILE="Sounds\mdrown2fem.wav" NAME="mdrown2fem"
#exec AUDIO IMPORT FILE="Sounds\MUWHit2.wav" NAME="MUWHit2"
#exec AUDIO IMPORT FILE="Sounds\MUWHit1.wav" NAME="MUWHit1"

//=======

var bool bXCGE;
var float LastInvTime;
var Actor OldMoveTarget;
var MyKick mk;
var int HW, Dotus, OldDotus; //Used for toggling methods at HitWall craps

//---------------------
native(3540) final iterator function PawnActors( class<Pawn> PawnClass, out pawn P, optional float Distance, optional vector VOrigin,
 optional bool bHasPRI, optional Pawn StartAt );

native(3541) final iterator function NavigationActors( class<NavigationPoint> NavClass, out NavigationPoint P, optional float Distance,
 optional vector VOrigin, optional bool bVisible );

native(3542) final iterator function InventoryActors( class<Inventory> InvClass, out Inventory Inv, optional bool bSubclasses,
 optional Actor StartFrom );

native(3552) final iterator function CollidingActors( class<actor> BaseClass, out actor Actor,
 float Radius, optional vector Loc );

native(3553) final iterator function DynamicActors( class<actor> BaseClass,
 out actor Actor, optional name MatchTag );
//---------------------

function PreBeginPlay()
{
	bIsPlayer = true;
	mk = Spawn( class 'MyKick',Self,,Location+Vect(0,0,100),Rotation);
	Super(Pawn).PreBeginPlay();
	if (Orders == '')
		Orders = 'FreeLance';
	SeekXCGE();
	if ( bXCGE )
		Spawn(class'XC_Boost',Self,,vect(0,0,0)).Ow = Self;
}

simulated function PostBeginPlay()
{
	if ( class'GameInfo'.Default.bVeryLowGore )
		bGreenBlood = true;
	InitRating();
	Super(Pawn).PostBeginPlay();
	if ( Level.NetMode != NM_DedicatedServer )
		Shadow = Spawn(class'PlayerShadow',self);
}

function SeekXCGE()
{
	if ( int(ConsoleCommand("GET INI:ENGINE.ENGINE.GAMEENGINE XC_VERSION")) >= 19 )
	{
		if ( int(ConsoleCommand("GET INI:ENGINE.ENGINE.GAMEENGINE XC_CORE_VERSION")) >= 7 )
		{
			bXCGE=True;
		}
	}
}

//== This thing was a lil messy - if not even doing sucks 
function bool CanFireAtEnemy()
{
	local vector HitLocation, HitNormal, X,Y,Z, projStart;
	local actor HitActor;
	local bool bPrecheck;

	if ( Weapon == None )
		return false;

	if ( Target == None && ( Enemy != None && ValidSight(Enemy)) )
		Target = Enemy;

	if ( Target != None )
	{
		if ( Target == Self )
			return False;
		HitActor = Trace(HitLocation, HitNormal, Target.Location, Location, false);
		if ( HitActor == None )
			bPreCheck=True;
		if ( bPrecheck )
		{
			GetAxes(Rotation,X,Y,Z);
			projStart = Location + Weapon.CalcDrawOffset() + Weapon.FireOffset.X * X + 1.2 * Weapon.FireOffset.Y * Y + Weapon.FireOffset.Z * Z;
			if ( Weapon.bInstantHit )
				HitActor = Trace(HitLocation, HitNormal, Target.Location + Target.CollisionHeight * vect(0,0,0.7), projStart, true);
			else
				HitActor = Trace(HitLocation, HitNormal, 
					projStart + FMin(280, VSize(Target.Location - Location)) * Normal(Target.Location + Target.CollisionHeight * vect(0,0,0.7) - Location), 
						projStart, true);
			if ( HitActor == Target )
				return true;
			if ( (Pawn(HitActor) != None) && (AttitudeTo(Pawn(HitActor)) < ATTITUDE_Ignore) )
				return true;
			if ( HitActor != None )
				return false;
		}
	}
	return false;
}

function BigJump(Actor JumpDest)
{
	if ( Region.Zone.bWaterZone )
		GoTo DoNotShitIntoSea;
	SetPhysics(PHYS_Falling);
	Velocity = GroundSpeed * Normal(JumpDest.Location - Location);
	if ( JumpDest.IsA('JumpSpot') && JumpSpot(JumpDest).bAlwaysAccel )
	{
		bBigJump = true;
		Acceleration = AccelRate * Normal(Destination - Location);
	}
	else
		Acceleration = vect(0,0,0);
	if ( bCountJumps )
		Inventory.OwnerJumped();
/*	if ( HW == 0 )
		Velocity += Normal(JumpZ * (5*VRand()));
	else
*/
		Velocity.Z = JumpZ;
	Velocity = EAdjustJump();
	bJumpOffPawn = true;
	DesiredRotation = Rotator(JumpDest.Location - Location);

	if ( Region.Zone.ZoneGravity == Region.Zone.Default.ZoneGravity )
		MoveTarget = None;

DoneJump:
	SetFall();
DoNotShitIntoSea:
}

function bool AdjustHitLocation(out vector HitLocation, vector TraceDir) //Hello anybody was crashing?
{
	local float adjZ, maxZ;

	if ( bHidden ) return False;
	if ( bDeleteMe ) return False;
	if ( Health <= 0 ) return False;
	if ( Mesh == None ) return False;
	if ( !bCollideActors) return False;
	if ( Animsequence == '' ) return False;

	TraceDir = Normal(TraceDir);
	HitLocation = HitLocation + 0.5 * CollisionRadius * TraceDir;
	if ( BaseEyeHeight == Default.BaseEyeHeight )
		return true;

	maxZ = Location.Z + BaseEyeHeight + 0.25 * CollisionHeight;
	if ( HitLocation.Z > maxZ )
	{
		if ( TraceDir.Z >= 0 )
			return false;
		adjZ = (maxZ - HitLocation.Z)/TraceDir.Z;
		HitLocation.Z = maxZ;
		HitLocation.X = HitLocation.X + TraceDir.X * adjZ;
		HitLocation.Y = HitLocation.Y + TraceDir.Y * adjZ;
		if ( VSize(HitLocation - Location) > CollisionRadius )
			return false;
	}
	return true;
}

function bool CloseToPointMan(Pawn Other)
{
	local float dist;

	// for certain games, have bots wait for leader for a while
	if ( TeamGamePlus(Level.Game) != None && TeamGamePlus(Level.Game).WaitForPoint(self) )
		return true;

	if ( Other == None )
		return False;

	if ( (Base != None) && (Other.Base != None) && (Other.Base != Base) )
		return false;

	dist = VSize(Location - Other.Location);
	if ( dist > 400 )
		return false;

	//check if point is moving away
	if ( (Region.Zone.bWaterZone || (dist > 200)) && (((Other.Location - Location) Dot Other.Velocity) > 0) )
		return false;

	return ( Other != None && LineOfSightTo(Other) );
}

function bool NearbyNode()
{
	local bool bIsNearby;
	local NavigationPoint P;
	bIsNearby = False;
	if ( bXCGE )
	{
		foreach NavigationActors( class 'NavigationPoint',P,710,Location )
		{
			if ( ValidSight(P) )
			{
				bIsNearby = True;
//					log (Self.GetHumanName()@" > I'm Nearby a Net-Node...");
				break;
			}
		}
	}
	else
	{
		foreach RadiusActors( class 'NavigationPoint',P,710,Location )
		{
			if ( ValidSight(P) )
			{
				bIsNearby = True;
//					log (Self.GetHumanName()@" > I'm Nearby a Net-Node...");
				break;
			}
		}
	}
	return bIsNearby;
}

function bool ActorReachableMore(Actor A)
{
	local vector EndTrace, fireDir;
	local vector HitNormal, HitLocation;
	local actor HitActor;
	local rotator AdjRot;
	local vector X,Y,Z;
	local bool bSee;

	if ( !bCollideActors || bHidden || Health <= 0 )
		return False;
	fireDir = A.Location-Location;
	EndTrace = Location + VSize(A.Location-Location) * fireDir; 
	HitActor = TraceShot(HitLocation,HitNormal,EndTrace,Location);

/*	if (!CanSee(A))
		log (GetHumanName()@"cannot see"@A.Name);
*/
//	log ( GetHumanName()@" hitting"@HitActor.Name );
	if ( HitActor == A )
	{
//		log ( GetHumanName()@" hitting"@A );
		bSee = True;
	}
	return bSee;
}

function TryNoLost()
{
	local NavigationPoint N, N1;
	local int BestPointDist;

	BestPointDist = 3510;

	//		log (Self.GetHumanName()@" testing lost path-net... ");
	if ( bXCGE )
	{
		foreach NavigationActors ( class 'NavigationPoint',N,3510,Location )
		{
			if ( Teleporter(N) == None && SpawnPoint(N) == None )
			{
				if (VSize(N.Location-Location) <= BestPointDist && ValidSight(N))
				{
					N1 = N;
					BestPointDist = Vsize(N.Location - Location);
				}
			}
		}
	}
	else
	{
		foreach RadiusActors ( class 'NavigationPoint',N,3510,Location )
		{
			if ( Teleporter(N) == None && SpawnPoint(N) == None )
			{
				if (VSize(N.Location-Location) <= BestPointDist && ValidSight(N))
				{
					N1 = N;
					BestPointDist = Vsize(N.Location - Location);
				}
			}
		}
	}
	if ( N1 != None && ValidSight(N1))
	{
		MoveTarget = N1;
	}
}

function bool FindBestPathToward(actor desired, bool bClearPaths)
{
	local Actor path, desiredPath;
	local bool success;

	if ( desired == None )
		return False; //LOL
	if ( Physics == PHYS_Falling || Physics == PHYS_None )
		return False;
	if ( SpecialGoal != None )
		desired = SpecialGoal;
	bClearPaths = False; //Must be sick to run in wall but... anyway... I'm f.k.n disappointed more than expected
	path = None;
	path = FindPathToward(desired,,bClearPaths);
	success = ( path != None );
	if ( success )
	{
		MoveTarget = path; 
		Destination = path.Location;
	}
	return success;
}

function TranslocateToTarget(Actor Destn)
{
	local float Distance;
	local bool bAllowedMooing;

//== Attach conditions
// #1 - UnReachable - 
	if ( !bAllowedMooing )
		if ( !ActorReachable( Destn ) )
			bAllowedMooing = True;

// #2 - Target it's far to worth translocator - else it's pointless
	if ( !bAllowedMooing )
		if ( VSize( Destn.Location-Location ) > 280 )
			bAllowedMooing = True;

// #3 - Should be higher than my tiny jump capabilities
	if ( !bAllowedMooing )
		if ( Destn.Location.Z > Location.Z + CollisionHeight )
			bAllowedMooing = True;

// #4 - Prevent sucking with Flag into mouth
	if ( !bAllowedMooing ) //if none of above
		if ( PlayerReplicationInfo != None && PlayerReplicationInfo.HasFlag == None )
			bAllowedMooing = True;
	if ( bAllowedMooing ) //if one of above 1,2,3 conditions has allowed a crap
		if ( PlayerReplicationInfo != None && PlayerReplicationInfo.HasFlag != None )
			bAllowedMooing = False;

// #5 - Enemy is the target - kill it with any matter even discarding flag
	if ( Enemy != None && Destn == Enemy ) 
		bAllowedMooing = True;

//== Now... let me look what goes wrong

	if ( bAllowedMooing )
	{
		PendingWeapon = MyTranslocator;
		MyTranslocator.DesiredTarget = Destn;
		if ( Weapon == None )
			ChangedWeapon();
		else if ( Weapon != PendingWeapon )
			Weapon.PutDown();
		else
			MyTranslocator.PlayPostSelect();
		MoveTarget = Destn;
		DesiredRotation = rotator(MoveTarget.Location - Location);
		Distance = VSize(MoveTarget.Location - Location);
		if ( Enemy == None || ( Enemy != None && !LineOfSightTo(Enemy) ) || !ActorReachable(destn) )
			SpecialPause = (Distance*1.7)/450; //Presuming at 450 we need 1.7 seconds then... for 1100 we do need more
	}
	else //Else just do a damn normal jump and stop crapping my game
	{
		MoveTarget=Destn;
		BigJump(Destn);
	}
//	SpecialPause = 1.5; //Drop this in toilette... Flush it.
}

function WhatToDoNext(name LikelyState, name LikelyLabel)
{
	if ( bVerbose )
	{
		log(self$" what to do next");
		log("enemy "$Enemy);
		log("old enemy "$OldEnemy);
		Stimulus = 0;
	}
	if ( ( Level.NetMode != NM_Standalone ) 
		&& DeathMatchPlus(Level.Game) != None
		&& DeathMatchPlus(Level.Game).TooManyBots() )
	{
		Destroy();
		GoTo JL321;
	}
	BlockedPath = None;
	bDevious = false;
	bFire = 0;
	bAltFire = 0;
	bComboPaused = False;
	bFiringPaused = False;
	bKamikaze = false;
	if ( BotReplicationInfo(PlayerReplicationInfo) != None )
		SetOrders(BotReplicationInfo(PlayerReplicationInfo).RealOrders, BotReplicationInfo(PlayerReplicationInfo).RealOrderGiver, true);
	Enemy = OldEnemy;
	OldEnemy = None;
	bReadyToAttack = false;
	if ( Enemy != None )
	{
		bReadyToAttack = !bNovice;
		GotoState('Attacking');
	}
	else if ( (Orders == 'Hold') && (Weapon.AIRating > 0.4) && (Health > 70) )
			GotoState('Hold');
	else
	{
		GotoState('Roaming');
		if ( Skill > 2.7 )
			bReadyToAttack = true; 
	}
JL321:
}

function bool ValidSight(Actor SeenPlayer)
{
	local bool result;
	local actor HitActor;
	local vector HitLocation, HitNormal;

	result = False;
	if ( SeenPlayer == None )
		result = False;
	HitActor = Trace(HitLocation, HitNormal, SeenPlayer.Location, Location, false);
	if ( HitActor == None )
		result = True;
	return result;
}

function SeePlayer(Actor SeenPlayer)
{
	if ( Pawn(SeenPlayer) != None && ValidSight(SeenPlayer)
		&& SeenPlayer.mesh != None && SeenPlayer.DrawType == DT_Mesh )
		SetEnemy(Pawn(SeenPlayer));
}

function bool CheckBumpAttack(Pawn Other)
{
	local pawn CurrentEnemy;

	CurrentEnemy = Enemy;

	if ( Enemy != None && Other == Enemy )
	{
		if ( Weapon != None )
		{
			bReadyToAttack = true;
			Target = Other;
			bCanFire = True;
			return true;
		}
		else
			return False;
	}

	if ( SetEnemy(Other) )
	{
		if ( Weapon != None )
		{
			bReadyToAttack = true;
			Target = Other;
			bCanFire = True;
			return true;
		}
		else 
		{
			if ( CurrentEnemy != None )
			{
				Enemy = CurrentEnemy;
			if (OldEnemy != None && OldEnemy == CurrentEnemy )
				Enemy = OldEnemy;
				OldEnemy = None;
			}
		}
	}
	return false;
}

function Bump(actor Other)
{
	local vector VelDir, OtherDir;
	local float speed, dist;
	local Pawn P, M;
	local bool bDestinationObstructed, bAmLeader;
	local int num;

	if ( BlockMonsters(Other) != None )
	{
		BlockMonsters(Other).SetCollision(False,False,False);
		Other.SetCollisionSize(0,1);
		Other.Disable('Touch');
		Other.Disable('UnTouch');
		Other.Tag = 'A_Trash';
	}

	P = Pawn(Other);
	if ( ( P != None && P.Health > 0 ) && CheckBumpAttack(P) )
		GoTo JL489;
	if ( TimerRate <= 0 )
		setTimer(1.0, false);

	if ( Level.Game != None && Level.Game.bTeamGame && ( P != None && P.Health > 0) && ( MoveTarget != None ) )
	{
		OtherDir = P.Location - MoveTarget.Location;
		if ( abs(OtherDir.Z) < P.CollisionHeight )
		{
			OtherDir.Z = 0;
			dist = VSize(OtherDir);
			bDestinationObstructed = ( VSize(OtherDir) < P.CollisionRadius );

			if ( Bot(P) != None )
//			if ( P.IsA('Bot') )
				bAmLeader = ( Bot(P).DeferTo(self) || (PlayerReplicationInfo.HasFlag != None) );
			// check if someone else is on destination or within 3 * collisionradius
			foreach VisibleCollidingActors(class'Pawn',M,CollisionRadius*10)
			{
				if ( M != None && M != Self )
//			for ( M=Level.PawnList; M!=None; M=M.NextPawn )
//				if ( M != self )
				{
					dist = VSize(M.Location - MoveTarget.Location);
					if ( dist < M.CollisionRadius )
					{
						bDestinationObstructed = true;
						if ( Bot(M) != None )
//						if ( M.IsA('Bot') )
							bAmLeader = Bot(M).DeferTo(self) || bAmLeader;
					}
					if ( dist < 3 * M.CollisionRadius ) 
					{
						num++;
						if ( num >= 2 )
						{
							bDestinationObstructed = true;
							if ( Bot(M) != None )
//							if ( M.IsA('Bot') )
								bAmLeader = Bot(M).DeferTo(self) || bAmLeader;
						}
					}
				}
			}
			if ( bDestinationObstructed && !bAmLeader )
			{
				// P is standing on my destination
				MoveTimer = -1;
				if ( Enemy != None )
				{
					if ( LineOfSightTo(Enemy) )
					{
						if ( !IsInState('TacticalMove') )
							GotoState('TacticalMove', 'NoCharge');
					}
					else if ( !IsInState('StakeOut') && (FRand() < 0.5) )
					{
						GotoState('StakeOut');
						LastSeenTime = 0;
						bClearShot = false;
					}
				}
				else if ( (Health > 0) && !IsInState('Wandering') || (Acceleration == vect(0,0,0)) )
				{
					WanderDir = Normal(Location - P.Location);
					GotoState('Wandering', 'Begin');
				}
			}
		}
	}
	speed = VSize(Velocity);
	if ( speed > 10 )
	{
		VelDir = Velocity/speed;
		VelDir.Z = 0;
		OtherDir = Other.Location - Location;
		OtherDir.Z = 0;
		OtherDir = Normal(OtherDir);
		if ( (VelDir Dot OtherDir) > 0.8 )
		{
			Velocity.X = VelDir.Y;
			Velocity.Y = -1 * VelDir.X;
			Velocity *= FMax(speed, 280);
		}
	} 
	else if ( (Health > 0) && (Enemy == None) && (bCamping 
				|| ((MoveTarget != None) && (OrderObject != None) && (Orders == 'Follow') && (MoveTarget == OrderObject) && (MoveTarget.Acceleration == vect(0,0,0)))) )
		GotoState('Wandering', 'Begin');
	Disable('Bump');
JL489:
}

//  ASMD combo move
function SpecialFire()
{
	if ( Enemy == None || Weapon == None )
		GoTo JL506;
	bComboPaused = true;
	if ( Target != None ) //Added
		SpecialPause = 0.75 + VSize(Target.Location - Location)/Weapon.AltProjectileSpeed;
	NextState = 'Attacking';
	NextLabel = 'Begin'; 
	Acceleration = vect(0,0,0);
	GotoState('RangedAttack');
JL506:
}

function FireWeapon()
{
	local bool bUseAltMode;
	local Weapon MyAutomag;

	if ( Weapon == None) GoTo JL565;
	if ( (Enemy == None) && bShootSpecial )
	{
		goalstring = "FireWeapon Special";
		//fake use automag 
		// Ns: NO, no bullshit in first moment, please
		if ( !Weapon.bSplashDamage )
		{
			PlayFiring();
			bFire = 1;
			bAltFire = 0;
			Weapon.Fire(1.0);
		}
		else
		{
			MyAutomag = Weapon(FindInventoryType(class'Enforcer'));
			if ( MyAutoMag == None )
				Spawn(class'PlasmaSphere',,, Location,Rotator(Target.Location - Location));
			else
				MyAutoMag.TraceFire(0);
		}
		GoTo JL565;
	}

	bUseAltMode = SwitchToBestWeapon();

	if( Weapon!=None )
	{
		goalstring = "FireWeapon";
		if ( (Weapon.AmmoType != None) && (Weapon.AmmoType.AmmoAmount <= 0) )
		{
			bReadyToAttack = true;
			GoTo JL565;
		}

		if ( !bComboPaused && !bShootSpecial && ( Enemy != None ) )
			Target = Enemy;
		ViewRotation = Rotation;
		PlayFiring();
		if ( bUseAltMode )
		{
			bFire = 0;
			bAltFire = 1;
			Weapon.AltFire(1.0);
		}
		else
		{
			bFire = 1;
			bAltFire = 0;
			Weapon.Fire(1.0);
		}
	}
	bShootSpecial = false;
JL565:
}

function HaltFiring()
{
	goalstring = "Halt Firing";
	bCanFire = false;
	bFire = 0;
	bAltFire = 0;
	SetTimer((0.75 + 0.5 * FRand()) * TimeBetweenAttacks, false);
	if ( Weapon != None )
		Weapon.Tick(0.0005); //Updated
}

function SetOrders(name NewOrders, Pawn OrderGiver, optional bool bNoAck)
{
	local Pawn P;
	local Bot B;

	if ( Level.Game != None && Level.Game.bGameEnded ) GoTo JL668;

	if ( BotReplicationInfo(PlayerReplicationInfo) != None )
	if ( NewOrders != BotReplicationInfo(PlayerReplicationInfo).RealOrders )
	{ 
		if ( (IsInState('Roaming') && bCamping) || IsInState('Wandering') )
			GotoState('Roaming', 'PreBegin');
		else if ( !IsInState('Dying') )
			GotoState('Attacking');
	}

	bLeading = false;
	if ( NewOrders == 'Point' )
	{
		NewOrders = 'Attack';
		SupportingPlayer = PlayerPawn(OrderGiver);
	}
	else
		SupportingPlayer = None;

	if ( bSniping && (NewOrders != 'Defend') )
		bSniping = false;
	bStayFreelance = false;
	if ( !bNoAck && (OrderGiver != None) )
		SendTeamMessage(OrderGiver.PlayerReplicationInfo, 'ACK', Rand(class<ChallengeVoicePack>(PlayerReplicationInfo.VoiceType).Default.NumAcks), 5);

	BotReplicationInfo(PlayerReplicationInfo).SetRealOrderGiver(OrderGiver);
	BotReplicationInfo(PlayerReplicationInfo).RealOrders = NewOrders;

	Aggressiveness = BaseAggressiveness;
	if ( Orders == 'Follow' )
		Aggressiveness -= 1;
	Orders = NewOrders;
	if ( !bNoAck && (HoldSpot(OrderObject) != None) )
	{
		OrderObject.Destroy();
		OrderObject = None;
	}
	if ( Orders == 'Hold' )
	{
		Aggressiveness += 1;
		if ( !bNoAck )
			OrderObject = OrderGiver.Spawn(class'HoldSpot');
	}
	else if ( Orders == 'Follow' )
	{
		Aggressiveness += 1;
		OrderObject = OrderGiver;
	}
	else if ( Orders == 'Defend' )
	{
		if ( TeamGamePlus(Level.Game) != None )
			OrderObject = TeamGamePlus(Level.Game).SetDefenseFor(self);
		else
			OrderObject = None;
		if ( OrderObject == None )
		{
			Orders = 'Freelance';
			if ( bVerbose )
				log(self.GetHumanName()$" defender couldn't find defense object");
		}
		else
			CampingRate = 1.0;
	}
	else if ( Orders == 'Attack' )
	{
		CampingRate = 0.0;
		// set bLeading if have supporters
		if ( Level.Game != None && Level.Game.bTeamGame )
		{
			if ( bXCGE )
			{
				foreach PawnActors( class'Pawn',P )
//				for ( P=Level.PawnList; P!=None; P=P.NextPawn )
				{
					if ( P.bIsPlayer && P.PlayerReplicationInfo != None && (P.PlayerReplicationInfo.Team == PlayerReplicationInfo.Team) )
					{
						B = Bot(P);
						if ( (B != None) && (B.OrderObject == self) && (BotReplicationInfo(B.PlayerReplicationInfo).RealOrders == 'Follow') )
						{
							bLeading = true;
							break;
						}
					}
				}
			}
			else
			{
				foreach AllActors ( class 'Pawn',P )
//				for ( P=Level.PawnList; P!=None; P=P.NextPawn )
				{
					if ( P.bIsPlayer && P.PlayerReplicationInfo != None && (P.PlayerReplicationInfo.Team == PlayerReplicationInfo.Team) )
					{
						B = Bot(P);
						if ( (B != None) && (B.OrderObject == self) && (BotReplicationInfo(B.PlayerReplicationInfo).RealOrders == 'Follow') )
						{
							bLeading = true;
							break;
						}
					}
				}
			}
		}
	}
	BotReplicationInfo(PlayerReplicationInfo).OrderObject = OrderObject;
JL668:
}

event UpdateEyeHeight(float DeltaTime)
{
	local float smooth, bound, TargetYaw, TargetPitch;
	local Pawn P;
	local rotator OldViewRotation;
	local vector T;

	// update viewrotation
	OldViewRotation = ViewRotation;
	if ( (bFire == 0) && (bAltFire == 0) )
		ViewRotation = Rotation;

	//check if still viewtarget
	bViewTarget = false;
	if (bXCGE)
	{
		foreach PawnActors( class'Pawn',P )
		{
			if ( PlayerPawn(P) != None && (PlayerPawn(P).ViewTarget == self) )
			{
				bViewTarget = true;
				if ( bVerbose )
				{
					if ( Enemy != None && Enemy.PlayerReplicationInfo != None )
						P.ClientMessage(PlayerReplicationInfo.PlayerName@"Orders"@orders@"State"@GetStateName()@"MoveTarget"@MoveTarget@"AlternatePath"@AlternatePath@"Enemy"@Enemy.PlayerReplicationInfo.PlayerName@"See"@LineOfSightTo(Enemy)@"RoamTarget"@RoamTarget@"Goal >"@GoalString@"Stimulus >"@Stimulus@"Hunting Mode:"@bHunting@"using XCGE SpecialPause >"@SpecialPause, 'CriticalEvent' );
					else
						P.ClientMessage(PlayerReplicationInfo.PlayerName@"Orders"@orders@"State"@GetStateName()@"MoveTarget"@MoveTarget@"AlternatePath"@AlternatePath@"Enemy"@Enemy@"RoamTarget"@RoamTarget@"Goal >"@GoalString@"Stimulus >"@Stimulus@"Hunting Mode:"@bHunting@"using XCGE SpecialPause >"@SpecialPause, 'CriticalEvent' );
				}
				break;
			}
		}
	}
	else
	{
		for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			if ( PlayerPawn(P) != None && (PlayerPawn(P).ViewTarget == self) )
			{
				bViewTarget = true;
				if ( bVerbose )
				{
					if ( Enemy != None && Enemy.PlayerReplicationInfo != None )
						P.ClientMessage(PlayerReplicationInfo.PlayerName@"Orders"@orders@"State"@GetStateName()@"MoveTarget"@MoveTarget@"AlternatePath"@AlternatePath@"Enemy"@Enemy.PlayerReplicationInfo.PlayerName@"See"@LineOfSightTo(Enemy)@"RoamTarget"@RoamTarget@"Goal >"@GoalString@"Stimulus >"@Stimulus@"Hunting Mode:"@bHunting, 'CriticalEvent' );
					else
						P.ClientMessage(PlayerReplicationInfo.PlayerName@"Orders"@orders@"State"@GetStateName()@"MoveTarget"@MoveTarget@"AlternatePath"@AlternatePath@"Enemy"@Enemy@"RoamTarget"@RoamTarget@"Goal >"@GoalString@"Stimulus >"@Stimulus@"Hunting Mode:"@bHunting, 'CriticalEvent' );
				}
				break;
			}
	}

	if ( !bViewTarget )
	{
		bVerbose = false;
		GoTo JL756;
	}

	if ( Enemy == None )
	{
		ViewRotation.Roll = 0;
		if ( DeltaTime < 0.2 )
		{
			OldViewRotation.Yaw = OldViewRotation.Yaw & 65535;
			OldViewRotation.Pitch = OldViewRotation.Pitch & 65535;
			TargetYaw = float(ViewRotation.Yaw & 65535);
			if ( Abs(TargetYaw - OldViewRotation.Yaw) > 32768 )
			{
				if ( TargetYaw < OldViewRotation.Yaw )
					TargetYaw += 65536;
				else
					TargetYaw -= 65536;
			}
			TargetYaw = float(OldViewRotation.Yaw) * (1 - 5 * DeltaTime) + TargetYaw * 5 * DeltaTime;
			ViewRotation.Yaw = int(TargetYaw);

			TargetPitch = float(ViewRotation.Pitch & 65535);
			if ( Abs(TargetPitch - OldViewRotation.Pitch) > 32768 )
			{
				if ( TargetPitch < OldViewRotation.Pitch )
					TargetPitch += 65536;
				else
					TargetPitch -= 65536;
			}
			TargetPitch = float(OldViewRotation.Pitch) * (1 - 5 * DeltaTime) + TargetPitch * 5 * DeltaTime;
			ViewRotation.Pitch = int(TargetPitch);
		}
	}

	smooth = FMin(1.0, 10.0 * DeltaTime/Level.TimeDilation);
	// smooth up/down stairs
	If ( (Physics == PHYS_Walking) && !bJustLanded)
	{
		EyeHeight = (EyeHeight - Location.Z + OldLocation.Z) * (1 - smooth) + BaseEyeHeight * smooth;
		bound = -0.5 * CollisionHeight;
		if (EyeHeight < bound)
			EyeHeight = bound;
		else
		{
			bound = CollisionHeight + FMin(FMax(0.0,(OldLocation.Z - Location.Z)), MaxStepHeight); 
			 if ( EyeHeight > bound )
				EyeHeight = bound;
		}
	}
	else
	{
		smooth = FMax(smooth, 0.35);
		bJustLanded = false;
		EyeHeight = EyeHeight * ( 1 - smooth) + BaseEyeHeight * smooth;
	}
JL756:
}

function bool CheckFutureSight(float deltatime)
{
	local vector FutureLoc, FireSpot;

	if ( Target == None && Enemy != None )
		Target = Enemy;
	if ( Target == None )
		return false;

	if ( Acceleration == vect(0,0,0) )
		FutureLoc = Location;
	else
		FutureLoc = Location + GroundSpeed * Normal(Acceleration) * deltaTime;

	if ( Base != None ) 
		FutureLoc += Base.Velocity * deltaTime;
	//make sure won't run into something
	if ( !FastTrace(FutureLoc, Location) && (Physics != PHYS_Falling) )
		return false;

	//check if can still see target
	if ( FastTrace(Target.Location + Target.Velocity * deltatime, FutureLoc) )
		return true;

	return false;
}

function rotator AdjustToss(float projSpeed, vector projStart, int aimerror, bool leadTarget, bool warnTarget)
{
	local rotator FireRotation;
	local vector FireSpot;
	local actor HitActor;
	local vector HitLocation, HitNormal, FireDir;
	local float TargetDist, TossSpeed, TossTime;
	local int realYaw;

	if ( projSpeed == 0 )
		return AdjustAim(projSpeed, projStart, aimerror, leadTarget, warnTarget);
	if ( Target == None && (Enemy != None && LineOfSightTo(Enemy)))
		Target = Enemy;
	if ( Target == None )
		return Rotation;
	FireSpot = Target.Location;
	TargetDist = VSize(Target.Location - ProjStart);

	if ( !Target.bIsPawn )
	{
		if ( (Region.Zone.ZoneGravity.Z != Region.Zone.Default.ZoneGravity.Z) 
			|| (TargetDist > projSpeed) )
		{
			TossTime = TargetDist/projSpeed;
			FireSpot.Z -= ((0.25 * Region.Zone.ZoneGravity.Z * TossTime + 200) * TossTime + 60);
		}
		viewRotation = Rotator(FireSpot - ProjStart);
		return viewRotation;
	}
	aimerror = aimerror * (11 - 10 *  
		((Target.Location - Location)/TargetDist 
			Dot Normal((Target.Location + 1.2 * Target.Velocity) - (ProjStart + Velocity)))); 

	if ( bNovice )
	{
		if ( (Target != Enemy) || (Enemy.Weapon == None) || !Enemy.Weapon.bMeleeWeapon || (TargetDist > 650) )
			aimerror = aimerror * (2.1 - 0.2 * (skill + FRand()));
		else
			aimerror *= 0.75;
		if ( Level.TimeSeconds - LastPainTime < 0.15 )
			aimerror *= 1.3;
	}
	else
	{
		aimerror = aimerror * (1.5 - 0.35 * (skill + FRand()));
		if ( (Skill < 2) && (Level.TimeSeconds - LastPainTime < 0.15) )
			aimerror *= 1.2;
	}
	if ( (bNovice && (LastAcquireTime > Level.TimeSeconds - 5 + 0.6 * Skill))
		|| (LastAcquireTime > Level.TimeSeconds - 2.5 + Skill) )
	{
		LastAcquireTime = Level.TimeSeconds - 5;
		aimerror *= 1.75;
	}

	if ( !leadTarget || (accuracy < 0) )
		aimerror -= aimerror * accuracy;

	if ( leadTarget )
	{
		FireSpot += FMin(1, 0.7 + 0.6 * FRand()) * (Target.Velocity * TargetDist/projSpeed);
		if ( !FastTrace(FireSpot, ProjStart) )
			FireSpot = 0.5 * (FireSpot + Target.Location);
	}

	//try middle
	FireSpot.Z = Target.Location.Z;

	if ( (Target == Enemy) && !FastTrace(FireSpot, ProjStart) )
	{
		FireSpot = LastSeenPos;
	 	HitActor = Trace(HitLocation, HitNormal, FireSpot, ProjStart, false);
		if ( HitActor != None )
		{
			bFire = 0;
			bAltFire = 0;
			FireSpot += 2 * Target.CollisionHeight * HitNormal;
			SetTimer(TimeBetweenAttacks, false);
		}
	}

	// adjust for toss distance (assume 200 z velocity add & 60 init height)
	if ( FRand() < 0.75 )
	{
		TossSpeed = projSpeed + 0.4 * VSize(Velocity); 
		if ( (Region.Zone.ZoneGravity.Z != Region.Zone.Default.ZoneGravity.Z) 
			|| (TargetDist > TossSpeed) )
		{
			TossTime = TargetDist/TossSpeed;
			FireSpot.Z -= ((0.25 * Region.Zone.ZoneGravity.Z * TossTime + 200) * TossTime + 60);	
		}
	}

	FireRotation = Rotator(FireSpot - ProjStart);
	realYaw = FireRotation.Yaw;
	aimerror = Rand(2 * aimerror) - aimerror;
	FireRotation.Yaw = (FireRotation.Yaw + aimerror) & 65535;

	if ( (Abs(FireRotation.Yaw - (Rotation.Yaw & 65535)) > 8192)
		&& (Abs(FireRotation.Yaw - (Rotation.Yaw & 65535)) < 57343) )
	{
		if ( (FireRotation.Yaw > Rotation.Yaw + 32768) || 
			((FireRotation.Yaw < Rotation.Yaw) && (FireRotation.Yaw > Rotation.Yaw - 32768)) )
			FireRotation.Yaw = Rotation.Yaw - 8192;
		else
			FireRotation.Yaw = Rotation.Yaw + 8192;
	}
	FireDir = vector(FireRotation);
	// avoid shooting into wall
	HitActor = Trace(HitLocation, HitNormal, ProjStart + FMin(VSize(FireSpot-ProjStart), 400) * FireDir, ProjStart, false); 
	if ( (HitActor != None) && (HitNormal.Z < 0.7) )
	{
		FireRotation.Yaw = (realYaw - aimerror) & 65535;
		if ( (Abs(FireRotation.Yaw - (Rotation.Yaw & 65535)) > 8192)
			&& (Abs(FireRotation.Yaw - (Rotation.Yaw & 65535)) < 57343) )
		{
			if ( (FireRotation.Yaw > Rotation.Yaw + 32768) || 
				((FireRotation.Yaw < Rotation.Yaw) && (FireRotation.Yaw > Rotation.Yaw - 32768)) )
				FireRotation.Yaw = Rotation.Yaw - 8192;
			else
				FireRotation.Yaw = Rotation.Yaw + 8192;
		}
		FireDir = vector(FireRotation);
	}

	if ( warnTarget && (Pawn(Target) != None) ) 
		Pawn(Target).WarnTarget(self, projSpeed, FireDir); 

	viewRotation = FireRotation;
	return FireRotation;
}

function rotator AdjustAim(float projSpeed, vector projStart, int aimerror, bool leadTarget, bool warnTarget)
{
	local rotator FireRotation, TargetLook;
	local vector FireSpot, FireDir, TargetVel;
	local float FireDist, TargetDist;
	local actor HitActor;
	local vector HitLocation, HitNormal;
	local int realYaw;
	local bool bDefendMelee, bClean;

	// make sure bot has a valid target
	if ( Target == None && Enemy != None )
		Target = Enemy;
	if ( Target == None )
	{
		bFire = 0;
		bAltFire = 0;
		return Rotation;
	}
	// perfect aim at stationary objects
	if ( !Target.bIsPawn || Target.IsA('FortStandard') )
		return rotator(Target.Location - projstart);

	FireSpot = Target.Location;
	TargetDist = VSize(Target.Location - Location);

	// figure out the relative motion of the target across the bots view, and adjust aim error
	// based on magnitude of relative motion
	aimerror = aimerror * (5 - 4 *  //Changed (11 - 10 * 
		((Target.Location - Location)/TargetDist 
			Dot Normal((Target.Location + 1.25 * Target.Velocity) - (Location + Velocity)))); 

	// if enemy is charging straight at bot with a melee weapon, improve aim
	bDefendMelee = ( (Target == Enemy) && (Enemy.Weapon != None) && Enemy.Weapon.bMeleeWeapon && (TargetDist < 700) );
	if ( bDefendMelee )
		aimerror *= 0.5;

	// if instant hit weapon, then adjust aim error based on skill
	// the initial aim error passed in is much higher for instant hit weapons than for other weapons
	if ( ((projSpeed == 0) || (Projspeed >= 1000000)) )
	{
		if ( bNovice )
			aimerror *= 0.5;
		else
			aimerror *= 0.5 + 0.19 * skill;
	}

	if ( bNovice )
	{
		// adjust aim error based on skill
		if ( !bDefendMelee )
			aimerror = aimerror * (2.4 - 0.2 * (skill + FRand()));
		// Bots don't aim as well if recently hit, or if they or their target is flying through the air
		if ( (Level.TimeSeconds - LastPainTime < 0.2) || (Physics == PHYS_Falling) || (Target.Physics == PHYS_Falling) )
			aimerror *= 1.5;
	}
	else
	{
		// adjust aim error based on skill
		aimerror = aimerror * (1.7 - 0.4 * (skill + FRand()));
		// Bots don't aim as well if recently hit, or if they or their target is flying through the air
		if ( (Skill < 2) 
			&& ((Level.TimeSeconds - LastPainTime < 0.15) || (Physics == PHYS_Falling) || (Target.Physics == PHYS_Falling)) )
			aimerror *= 1.2;
	}

	// Bots don't aim as well at recently acquired targets (because they haven't had a chance to lock in to the target)
	if ( (bNovice && (LastAcquireTime > Level.TimeSeconds - 5 + 0.5 * skill))
		|| (LastAcquireTime > Level.TimeSeconds - 2.5 + skill) )
	{
		LastAcquireTime = Level.TimeSeconds - 5;
		if ( bDefendMelee )
			aimerror *= 1.3;
		else
			aimerror *= 2;
	}
	
	// adjust aim error based on bot accuracy rating 
	if ( !leadTarget || (accuracy < 0) )
		aimerror -= aimerror * accuracy;

	// lead target with non instant hit projectiles
	if (leadTarget && (projSpeed > 0))
	{
		TargetVel = Target.Velocity;
		// hack guess at projecting falling velocity of target
		if ( Target.Physics == PHYS_Falling )
		{
			if ( Target.Region.Zone.ZoneGravity == Target.Region.Zone.Default.ZoneGravity )
				TargetVel.Z = FMin(-160, TargetVel.Z);
			else
				TargetVel.Z = FMin(0, TargetVel.Z);
		}
		// more or less lead target (with some random variation)
		FireSpot += FMin(1, 0.7 + 0.6 * FRand()) * TargetVel * TargetDist/projSpeed;
		FireSpot.Z = FMin(Target.Location.Z, FireSpot.Z);

		if ( (Target.Physics != PHYS_Falling) && (FRand() < 0.55) && (VSize(FireSpot - ProjStart) > 1000) )
		{
			// don't always lead far away targets, especially if they are moving sideways with respect to the bot
			TargetLook = Target.Rotation;
			if ( Target.Physics == PHYS_Walking )
				TargetLook.Pitch = 0;
			if ( ((Vector(TargetLook) Dot Normal(Target.Velocity)) < 0.71) )
				bClean = false;
			else
				bClean = FastTrace(FireSpot, ProjStart);
		}
		else // make sure that bot isn't leading into a wall

			bClean = FastTrace(FireSpot, ProjStart);
		if ( !bClean)
		{
			// reduce amount of leading
			if ( FRand() < 0.3 )
				FireSpot = Target.Location;
			else
				FireSpot = 0.5 * (FireSpot + Target.Location);
		}
	}

	bClean = false; //so will fail first check unless shooting at feet  
	if ( Target.bIsPawn && (!bNovice || bDefendMelee) 
		&& (Weapon != None) 
		&& (Weapon.bRecommendSplashDamage || (Weapon.bRecommendAltSplashDamage && (bAltFire != 0))) 
		&& (((Target.Physics == PHYS_Falling) && (Location.Z + 80 >= Target.Location.Z))
			|| ((Location.Z + 19 >= Target.Location.Z) && (bDefendMelee || (skill > 2.5 * FRand() - 0.5)))) )
	{
	 	HitActor = Trace(HitLocation, HitNormal, FireSpot - vect(0,0,1) * (Target.CollisionHeight + 6), FireSpot, false);
 		bClean = (HitActor == None);
		if ( !bClean )
		{
			FireSpot = HitLocation + vect(0,0,3);
			bClean = FastTrace(FireSpot, ProjStart);
		}
		else if ( Target.Physics == PHYS_Falling )
			bClean = FastTrace(FireSpot, ProjStart);
		else
			bClean = false;
	}
	if ( !bClean )
	{
		//try middle
		FireSpot.Z = Target.Location.Z;
		bClean = FastTrace(FireSpot, ProjStart);
	}
	if( !bClean ) 
	{
		////try head
		FireSpot.Z = Target.Location.Z + 0.9 * Target.CollisionHeight;
		bClean = FastTrace(FireSpot, ProjStart);
	}
	if ( !bClean && (Target == Enemy) )
	{
		FireSpot = LastSeenPos;
		if ( Location.Z >= LastSeenPos.Z )
			FireSpot.Z -= 0.7 * Enemy.CollisionHeight;
	 	HitActor = Trace(HitLocation, HitNormal, FireSpot, ProjStart, false);
		if ( HitActor != None )
		{
			FireSpot = LastSeenPos + 2 * Enemy.CollisionHeight * HitNormal;
			if ( Weapon.bSplashDamage && !bNovice )
			{
			 	HitActor = Trace(HitLocation, HitNormal, FireSpot, ProjStart, false);
				if ( HitActor != None )
					FireSpot += 2 * Enemy.CollisionHeight * HitNormal;
			}
			if ( Weapon.RefireRate < 0.99 )
				bFire = 0;
			if ( Weapon.AltRefireRate < 0.99 )
				bAltFire = 0;
			SetTimer(TimeBetweenAttacks, false);
		}
	}

	FireRotation = Rotator(FireSpot - ProjStart);
	realYaw = FireRotation.Yaw;
	aimerror = Rand(2 * aimerror) - aimerror;
	FireRotation.Yaw = (FireRotation.Yaw + aimerror) & 65535;

	if ( (Abs(FireRotation.Yaw - (Rotation.Yaw & 65535)) > 8192)
		&& (Abs(FireRotation.Yaw - (Rotation.Yaw & 65535)) < 57343) )
	{
		if ( (FireRotation.Yaw > Rotation.Yaw + 32768) || 
			((FireRotation.Yaw < Rotation.Yaw) && (FireRotation.Yaw > Rotation.Yaw - 32768)) )
			FireRotation.Yaw = Rotation.Yaw - 8192;
		else
			FireRotation.Yaw = Rotation.Yaw + 8192;
	}
	FireDir = vector(FireRotation);
	// avoid shooting into wall
	FireDist = FMin(VSize(FireSpot-ProjStart), 400);
	FireSpot = ProjStart + FireDist * FireDir;
	HitActor = Trace(HitLocation, HitNormal, FireSpot, ProjStart, false); 
	if ( HitActor != None )
	{
		if ( HitNormal.Z < 0.7 )
		{
			FireRotation.Yaw = (realYaw - aimerror) & 65535;
			if ( (Abs(FireRotation.Yaw - (Rotation.Yaw & 65535)) > 8192)
				&& (Abs(FireRotation.Yaw - (Rotation.Yaw & 65535)) < 57343) )
			{
				if ( (FireRotation.Yaw > Rotation.Yaw + 32768) || 
					((FireRotation.Yaw < Rotation.Yaw) && (FireRotation.Yaw > Rotation.Yaw - 32768)) )
					FireRotation.Yaw = Rotation.Yaw - 8192;
				else
					FireRotation.Yaw = Rotation.Yaw + 8192;
			}
			FireDir = vector(FireRotation);
			FireSpot = ProjStart + FireDist * FireDir;
			HitActor = Trace(HitLocation, HitNormal, FireSpot, ProjStart, false); 
		}
		if ( HitActor != None )
		{
			FireSpot += HitNormal * 2 * Target.CollisionHeight;
			if ( !bNovice )
			{
				HitActor = Trace(HitLocation, HitNormal, FireSpot, ProjStart, false); 
				if ( HitActor != None )
					FireSpot += Target.CollisionHeight * HitNormal; 
			}
			FireDir = Normal(FireSpot - ProjStart);
			FireRotation = rotator(FireDir);
		}
	}

	if ( warnTarget && (Pawn(Target) != None) ) 
		Pawn(Target).WarnTarget(self, projSpeed, FireDir); 

	viewRotation = FireRotation;
	return FireRotation;
}

function bool CanStakeOut()
{
	if ( Enemy == None ) return False;
	else
	{
		if ( VSize(Enemy.Location - LastSeenPos) > 800 )
			return false;
		return ( FastTrace(LastSeenPos, Location + EyeHeight * vect(0,0,1))
			&& FastTrace(LastSeenPos , Enemy.Location + Enemy.BaseEyeHeight * vect(0,0,1)) );
	}
}

function eAttitude AttitudeTo(Pawn Other)
{
	local byte result;

	if ( DeathMatchPlus(Level.Game) != None )
	{
		result = DeathMatchPlus(Level.Game).AssessBotAttitude(self, Other);
		Switch (result)
		{
			case 0: return ATTITUDE_Fear;
			case 1: return ATTITUDE_Hate;
			case 2: return ATTITUDE_Ignore;
			case 3: return ATTITUDE_Friendly;
		}
	}
	if ( Level.Game != None && Level.Game.bTeamGame
		&& ( PlayerReplicationInfo.Team == Other.PlayerReplicationInfo.Team) && Other.PlayerReplicationInfo != None )
		return ATTITUDE_Friendly; //teammate

	return ATTITUDE_Hate;
}

function bool SetEnemy( Pawn NewEnemy )
{
	local bool result, bNotSeen;
	local eAttitude newAttitude, oldAttitude;
	local float newStrength;
	local Pawn Friend;

	if (Enemy == NewEnemy)
		return true;
	if ( (NewEnemy == Self) || (NewEnemy == None) || (NewEnemy.Health <= 0) || /*NewEnemy.IsA('FlockPawn')*/ NewEnemy.bHidden )
		return false;
	result = false;
	newAttitude = AttitudeTo(NewEnemy);
	if ( newAttitude == ATTITUDE_Friendly )
	{
		Friend = NewEnemy;
		if ( Level.TimeSeconds - Friend.LastSeenTime > 5 )
			return false;
		NewEnemy = NewEnemy.Enemy;
		if ( (NewEnemy == None) || (NewEnemy == Self) || (NewEnemy.Health <= 0) || NewEnemy.IsA('FlockPawn') || NewEnemy.IsA('StationaryPawn') )
			return false;
		if (Enemy == NewEnemy)
			return true;
		bNotSeen = true;
		newAttitude = AttitudeTo(NewEnemy);
	}

	if ( newAttitude >= ATTITUDE_Ignore )
		return false;

	if ( Enemy != None )
	{
		if ( AssessThreat(NewEnemy) > AssessThreat(Enemy) )
		{
			OldEnemy = Enemy;
			Enemy = NewEnemy;
			result = true;
		}
		else if ( OldEnemy == None )
			OldEnemy = NewEnemy;
	}
	else
	{
		result = true;
		Enemy = NewEnemy;
	}

	if ( result )
	{
		if ( bNotSeen )
		{
			LastSeenTime = Friend.LastSeenTime;
			LastSeeingPos = Friend.LastSeeingPos;
			LastSeenPos = Friend.LastSeenPos;
		}
		else
		{
			LastSeenTime = Level.TimeSeconds;
			LastSeeingPos = Location;
			LastSeenPos = Enemy.Location;
		}
		EnemyAcquired();
	}

	return result;
}

function Killed(pawn Killer, pawn Other, name damageType)
{
	local Pawn aPawn;

	if ( Killer == self )
		Other.Health = FMin(Other.Health, -11); // don't let other do stagger death

	if ( Health <= 0 )
	{
		if ( RoamTarget != None && !RoamTarget.bIsPawn )
			RoamTarget = None;
		GoTo JL1310;
	}
//Test
	ClearPaths();
//Off Test
	if ( OldEnemy == Other )
		OldEnemy = None;

	if ( Enemy == Other )
	{
		bFire = 0;
		bAltFire = 0;
		if ( RoamTarget != None && RoamTarget == Other )
			RoamTarget = None;
		bReadyToAttack = ( skill > 3 * FRand() );
		EnemyDropped = Enemy.Weapon;
		Enemy = None;
		bHunting = False;
		if ( (Killer == self) && (OldEnemy == None) )
		{
			if (bXCGE)
			{
				goalstring = "Look for Pawns using XCGE";
				foreach PawnActors(class 'Pawn', aPawn, 1600, Location)
//				for ( aPawn=Level.PawnList; aPawn!=None; aPawn=aPawn.nextPawn )
					if ( aPawn.bCollideActors && !aPawn.bHidden /*&& (VSize(Location - aPawn.Location) < 1600)
					&& LineOfSightTo(aPawn)*/ && SetEnemy(aPawn) )
					{
						GotoState('Attacking');
						return;
					}
			}
			else
			{
				goalstring = "Look for Pawns";
				foreach VisibleCollidingActors(class 'Pawn', aPawn, 1600)
//				for ( aPawn=Level.PawnList; aPawn!=None; aPawn=aPawn.nextPawn )
					if ( aPawn.bCollideActors && !aPawn.bHidden /*&& (VSize(Location - aPawn.Location) < 1600)
					&& LineOfSightTo(aPawn)*/ && SetEnemy(aPawn) )
					{
						GotoState('Attacking');
						return;
					}
			}
			MaybeTaunt(Other);
		}
		else 
			GotoState('Attacking');
	}
	else if ( Level.Game != None && Level.Game.bTeamGame && Other.PlayerReplicationInfo != None
			&& (Other.PlayerReplicationInfo.Team == PlayerReplicationInfo.Team) )
	{
		if ( Other == Self )
			GoTo JL1310;
		else
		{
			if ( (VSize(Location - Other.Location) < 1400)
				&& LineOfSightTo(Other) )
				SendTeamMessage(None, 'OTHER', 5, 10);
			if ( (Orders == 'follow') && (Other == OrderObject) )
				PointDied = Level.TimeSeconds;
		}
	}
JL1310:
}

function ImpactJump(Actor JumpDest)
{
	if ( Health < 90 )
		GoTo JL1321;

	SetFall();
	ImpactTarget = JumpDest;
	GotoState('ImpactJumping');
JL1321:
}

function bool PickLocalInventory(float MaxDist, float MinDistraction)
{
	local vector HitLocation, HitNormal, X, Y, Z;
	local inventory Inv, BestInv, KnowPath;
	local float NewWeight, DroppedDist, BestWeight;
	local actor HitActor;
	local actor BestPath;
	local bool bCanReach, bInvObstructed;
	local NavigationPoint N;

	if ( (EnemyDropped != None) && !EnemyDropped.bDeleteMe 
		&& ( EnemyDropped.Owner == None )
		&& !EnemyDropped.Region.Zone.bKillZone && !EnemyDropped.Region.Zone.bPainZone ) //Don't pick weapons from there, right ? LOL Pinatas...
	{
		DroppedDist = VSize(EnemyDropped.Location - Location);
		NewWeight = EnemyDropped.BotDesireability(self);
		if ( (DroppedDist < MaxDist) 
			&& ((NewWeight > MinDistraction) || (DroppedDist < 0.5 * MaxDist))
			&& ((EnemyDropped.Physics != PHYS_Falling) || (Region.Zone.ZoneGravity.Z == Region.Zone.Default.ZoneGravity.Z))
			&& ActorReachable(EnemyDropped) )
		{
			BestWeight = NewWeight; 
			if ( BestWeight > 0.4 )
			{
				MoveTarget = EnemyDropped;
				EnemyDropped = None;
				return true; 
			}
			BestInv = EnemyDropped;
			BestWeight = BestWeight/DroppedDist;
			KnowPath = BestInv;
		}
	}
	EnemyDropped = None;

	//first look at nearby inventory < MaxDist
	//Nelsona: Modification - looks like a wick Bot try to jump as moron at walls at something not very visible
	GetAxes(Rotation,X,Y,Z);
	foreach VisibleCollidingActors(class'Inventory', Inv, MaxDist,Location,True)
	{
		if ( Inv != None && BestInv == None && VSize(Inv.Location - Location) > CollisionRadius*0.9 
		&& !Inv.Region.Zone.bKillZone && !Inv.Region.Zone.bPainZone )
		{
			HitActor = Trace(HitLocation, HitNormal, Inv.Location, Location, false);
			bInvObstructed = HitActor != None;
			if ( !bInvObstructed ) //Trace Head - collisionheight is 39, get 40 for safety
				HitActor = Trace(HitLocation, HitNormal, Inv.Location, Location+vect(0,0,40), false);
			bInvObstructed = HitActor != None;
			if ( !bInvObstructed ) //Trace Mid
				HitActor = Trace(HitLocation, HitNormal, Inv.Location, Location+vect(0,0,18), false);
			bInvObstructed = HitActor != None;
			if ( !bInvObstructed )
				HitActor = Trace(HitLocation, HitNormal, Inv.Location, Location+vect(0,22,0), false);
			bInvObstructed = HitActor != None;
			if ( !bInvObstructed )
				HitActor = Trace(HitLocation, HitNormal, Inv.Location, Location+vect(0,-22,0), false);
			bInvObstructed = HitActor != None;
/*
	And now I have to see managing stupid columns if do still bug local pickup.
	Tracing only location seems to not be enough for preventing being retarded.
*/
			if ( !bInvObstructed )
			{
				if ( (Inv.IsInState('PickUp')) && (Inv.MaxDesireability/60 > BestWeight)
					&& ( Inv.Physics != PHYS_Falling )
					&& (Inv.Location.Z <= ((Location.Z + MaxStepHeight + CollisionHeight)*1.5 )) )
				{
					NewWeight = inv.BotDesireability(self);
					if ( (NewWeight > MinDistraction) 
						|| (/*Inv.bHeldItem && */Inv.IsA('Weapon') && (VSize(Inv.Location - Location) < 0.6 * MaxDist)) )
					{
						NewWeight = NewWeight/VSize(Inv.Location - Location);
						if ( NewWeight > BestWeight )
						{
//							log ("Roaming check >>"@inv@"MaxDesireability>> "@inv.MaxDesireability@" NewWeight >>"@NewWeight);
							BestWeight = NewWeight;
//							log ("Roaming check >>"@inv.MaxDesireability@"BestWeight >>"@BestWeight);
							BestInv = Inv;
						}
					}
				}
			}
		}
	}
	if ( BestInv != None && FRand() > 0.4 )
	{
		bCanJump = ( bCanTranslocate || (( BestInv.Location.Z > Location.Z - CollisionHeight - MaxStepHeight ) && BestInv.Location.Z < Location.Z + 180 ) );
		bCanReach = ActorReachable( BestInv )
		|| ( BestInv.Location.Z < Location.Z + ( CollisionHeight*1.5)+ MaxStepHeight && VSize(BestInv.Location - Location) < 200 );
	}
	else
		bCanReach = false;
	bCanJump = true;
	if ( bCanReach )
	{
		//GoalString = "local"@BestInv;
		MoveTarget = BestInv;
		return true;
	}
	else if ( KnowPath != None )
	{
		//GoalString = "local"@KnowPath;
		MoveTarget = KnowPath;
		return true;
	}
	//GoalString="No local";
NoLocalAvailable:
	return false;
}

function bool SwitchToBestWeapon()
{
	local float rating;
	local int usealt, favalt;
	local inventory MyFav;

	if ( Inventory == None )
		return false;
	else
		PendingWeapon = Inventory.RecommendWeapon( rating, usealt );

	if ( PendingWeapon == None )
		return false;
	if ( (FavoriteWeapon != None) && (PendingWeapon.class != FavoriteWeapon) )
	{
		MyFav = FindInventoryType(FavoriteWeapon);
		if ( (MyFav != None) && (Weapon(MyFav).RateSelf(favalt) + 0.22 > PendingWeapon.RateSelf(usealt)) )
		{
			usealt = favalt;
			PendingWeapon = Weapon(MyFav);
		}
	}
	if ( Weapon == None )
		ChangedWeapon();
	else if ( Weapon != PendingWeapon )
		Weapon.PutDown();

	return (usealt > 0);
}

function SortAnotherPoint()
{
	local NavigationPoint N;
	local Actor APoint;

	if ( NavigationPoint(MoveTarget) != None )
	foreach RadiusActors (class 'NavigationPoint',N,500,Location)
	{
		if ( Vsize(Location - N.Location ) > 150 && ActorReachable(N) && ActorReachableMore(N) )
		{
			Apoint = N;
			break;
		}
	}
	else
		APoint = MoveTarget;

	MoveTarget = APoint;
//	log (GetHumanName()@"moving to"@Apoint.Name);
}

state TakeHit 
{
ignores seeplayer, hearnoise, bump, hitwall;

	function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
	{
		Global.TakeDamage(Damage, instigatedBy, hitlocation, momentum, damageType);
	}

	function Landed(vector HitNormal)
	{
		if (Velocity.Z < -1.4 * JumpZ)
			MakeNoise(-0.5 * Velocity.Z/(FMax(JumpZ, 150.0)));
		bJustLanded = true;
	}

	function Timer()
	{
		if ( Enemy != None )
			bReadyToAttack = true;
	}

	function PlayHitAnim(vector HitLocation, float Damage)
	{
		if ( LastPainTime - Level.TimeSeconds > 0.1 )
		{
			PlayTakeHit(0.1, hitLocation, Damage);
			BeginState();
			GotoState('TakeHit', 'Begin');
		} 
	}

	function BeginState()
	{
		LastPainTime = Level.TimeSeconds;
		LastPainAnim = AnimSequence;
		if ( (NextState == 'TacticalMove') && (Region.Zone.ZoneGravity.Z > Region.Zone.Default.ZoneGravity.Z) )
			Destination = location;
	}

Begin:
	if ( bFireFalling )
	{
		bFireFalling = false;
		GotoState('FallingState', 'Ducking');
	}
	FinishAnim();
	if ( bNovice || (Skill < 2) )
		Sleep(0.05);
	else
		Sleep(0.03); //Little break anyway
	if ( (Physics == PHYS_Falling) && !Region.Zone.bWaterZone )
	{
		NextAnim = '';
		GotoState('FallingState', 'Ducking');
	}
	else if (NextState != '')
		GotoState(NextState, NextLabel);
	else
	{
		GotoState('Attacking');
	}
}

state Dying
{
ignores SeePlayer, EnemyNotVisible, HearNoise, Died, Bump, Trigger, HitWall, HeadZoneChange, FootZoneChange, ZoneChange, Falling, WarnTarget, LongFall, SetFall, PainTimer;

	function ReStartPlayer()
	{
		if( Level.Game != None && bHidden && Level.Game.RestartPlayer(self) )
		{
			if ( bNovice )
				bDumbDown = ( FRand() < 0.5 );
			else
				bDumbDown = ( FRand() < 0.35 );
			Velocity = vect(0,0,0);
			Acceleration = vect(0,0,0);
			ViewRotation = Rotation;
			ReSetSkill();
			SetPhysics(PHYS_Falling);
			if ( BotReplicationInfo(PlayerReplicationInfo) != None )
				SetOrders(BotReplicationInfo(PlayerReplicationInfo).RealOrders, BotReplicationInfo(PlayerReplicationInfo).RealOrderGiver, true);
			GotoState('Roaming','');
		}
		else if ( !IsInState('GameEnded') )
			GotoState('Dying', 'TryAgain');
	}

	function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
							Vector momentum, name damageType)
	{
		if ( !bHidden )
			Super.TakeDamage(Damage, instigatedBy, hitlocation, momentum, damageType);
	}

	function BeginState()
	{
		if ( (Level.NetMode != NM_Standalone) 
			&& DeathMatchPlus(Level.Game) != None
			&& DeathMatchPlus(Level.Game).TooManyBots() )
		{
			Destroy();
			GoTo JL1578;
		}
		SetTimer(0, false);
		Enemy = None;
		if ( bSniping && (AmbushSpot != None) )
			AmbushSpot.taken = false;
		AmbushSpot = None;
		PointDied = -1000;
		bFire = 0;
		bAltFire = 0;
		bSniping = false;
		bKamikaze = false;
		bDevious = false;
		bDumbDown = false;
		BlockedPath = None;
		bInitLifeMessage = false;
		MyTranslocator = None;
JL1578:
	}

Begin:
	if ( Level.Game != None && Level.Game.bGameEnded )
		GotoState('GameEnded');
	goalstring = " I'm Dead ";
	Sleep(0.2);
	if ( !bHidden )
		SpawnCarcass();
TryAgain:
	if ( !bHidden )
		HidePlayer();
	goalstring = " Wait Respawn ";
	if ( DeathMatchPlus(Level.Game) != None )
		Sleep(0.25 + DeathMatchPlus(Level.Game).SpawnWait(self));
	ReStartPlayer();
	Goto('TryAgain');
WaitingForStart:
	bHidden = true;
}

state Hold
{
	function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
							Vector momentum, name damageType)
	{
		Global.TakeDamage(Damage, instigatedBy, hitlocation, momentum, damageType);
		if ( health <= 0 )
			GoTo JL1620;
		if ( (Enemy != None) && (Enemy == InstigatedBy) )
		{
			LastSeenPos = Enemy.Location;
			LastSeenTime = Level.TimeSeconds;
		}
		if (NextState == 'TakeHit')
		{
			NextState = 'Attacking'; 
			NextLabel = 'Begin';
			GotoState('TakeHit'); 
		}
		else if ( Enemy != None )
			GotoState('Attacking');
JL1620:
	}

	function HandleHelpMessageFrom(Pawn Other)
	{
		if ( (Health > 70) && (Weapon.AIRating > 0.5) && (Other.Enemy != None)
			&& ((Other.PlayerReplicationInfo != None && (Other.PlayerReplicationInfo.Team == PlayerReplicationInfo.Team)))
			//	|| (Other.IsA('StationaryPawn') && StationaryPawn(Other).SameTeamAs(PlayerReplicationInfo.Team)))
			&& (VSize(Other.Enemy.Location - Location) < 1600) )
			{
				if ( Other.PlayerReplicationInfo != None )
					SendTeamMessage(Other.PlayerReplicationInfo, 'OTHER', 10, 10);
				SetEnemy(Other.Enemy);
				GotoState('Attacking');
			}
	}

	function FearThisSpot(Actor aSpot)
	{
		Destination = Location + 120 * Normal(Location - aSpot.Location); 
		GotoState('Wandering', 'Moving');
	}

	function Timer()
	{
		bReadyToAttack = True;
		Enable('Bump');
	}

	function SetFall()
	{
		NextState = 'Hold'; 
		NextLabel = 'Landed';
		NextAnim = AnimSequence;
		GotoState('FallingState'); 
	}

	function EnemyAcquired()
	{
		GotoState('Acquisition');
	}

	function HitWall(vector HitNormal, actor Wall)
	{
		if ( Physics == PHYS_Falling )
			GoTo JL1820;
		if ( Wall != None && Wall.IsA('Mover') && Mover(Wall).HandleDoor(self) )
		{
			if ( SpecialPause > 0 )
				Acceleration = vect(0,0,0);
			GotoState('Hold', 'SpecialNavig');
			GoTo JL1820;
		}
		Focus = Destination;
		if ( PickWallAdjust() )
		{
			if ( Physics == PHYS_Falling )
				SetFall();
			else
				GotoState('Hold', 'AdjustFromWall');
		}
		else
			MoveTimer = -1.0;
JL1820:
	}

	function PickDestination()
	{
		local Vector Direction;

		if ( (HoldSpot(OrderObject) == None) )
		{
			SetOrders('Freelance', None);
			GotoState('Roaming');
		} 
		Direction = Location - OrderObject.Location;
		if ( (Direction.X * Direction.X + Direction.Y * Direction.Y < 256) 
			&& (Abs(Direction.Z) < 48) )
		{
			SendTeamMessage(None, 'OTHER', 9, 45);
			if ( !bInitLifeMessage )
			{
				bInitLifeMessage = true;
				PlayWaving();
			}
			else
				TweenToWaiting(0.25);
			GotoState('Holding', 'Waving');
			return;
		}
		if ( ActorReachable(OrderObject) )
		{
			if ( HoldSpot(OrderObject).Holder != None )
				GotoState('Wandering');
			MoveTarget = OrderObject;
			return;
		}
		MoveTarget = FindPathToward(OrderObject);
		if ( MoveTarget == None ) 
		{
			SetOrders('Freelance', None);
			GotoState('Roaming');
		} 
	}

	function AnimEnd()
	{
		PlayRunning();
	}
 
	function Landed(vector HitNormal)
	{
		SetPhysics(PHYS_None);
	}

	function BeginState()
	{
		SpecialGoal = None;
		SpecialPause = 0.0;
		bSpecialGoal = false;
	}

TurnFromWall:
	if ( NearWall(2 * CollisionRadius + 50) )
	{
		PlayTurning();
		TurnTo(Focus);
	}
Begin:
	SwitchToBestWeapon();
	TweenToRunning(0.1);
	WaitForLanding();

RunAway:
	PickDestination();
SpecialNavig:
	if (SpecialPause > 0.0)
	{
		Disable('AnimEnd');
		Acceleration = vect(0,0,0);
		TweenToPatrolStop(0.3);
		Sleep(SpecialPause);
		SpecialPause = 0.0;
		Enable('AnimEnd');
		TweenToRunning(0.1);
		Goto('RunAway');
	}
Moving:
	if ( !IsAnimating() )
		AnimEnd();
	if ( MoveTarget == None )
	{
		Acceleration = vect(0,0,0);
		Sleep(0.1);
		Goto('RunAway');
	}
	MoveToward(MoveTarget);
	Goto('RunAway');

TakeHit:
	TweenToRunning(0.12);
	Goto('Moving');

Landed:
	if ( MoveTarget == None )
		Goto('RunAway');
	Goto('Moving');

AdjustFromWall:
	if ( !IsAnimating() )
		AnimEnd();
	bCamping = false;
	StrafeTo(Destination, Focus); 
	Destination = Focus; 
	MoveTo(Destination);
	Goto('Moving');
}

/* Acquisition - 
Creature has just reacted to stimulus, and set an enemy
- depending on strength of stimulus, and ongoing stimulii, vary time to focus on target and start attacking (or whatever.  FIXME - need some acquisition specific animation
HearNoise and SeePlayer used to improve/change stimulus
*/

state Acquisition
{
ignores falling, landed; 

	function WarnTarget(Pawn shooter, float projSpeed, vector FireDir)
	{
	}

	function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
							Vector momentum, name damageType)
	{
		if (Enemy != None)
		{
			LastSeenPos = Enemy.Location;
			LastSeenTime = Level.TimeSeconds;
		}
		Global.TakeDamage(Damage, instigatedBy, hitlocation, momentum, damageType);
		if ( health <= 0 )
			GoTo JL1830;
		if (NextState == 'TakeHit')
		{
			NextState = 'Attacking'; 
			NextLabel = 'Begin';
			GotoState('TakeHit'); 
		}
		else
			GotoState('Attacking');
JL1830:
	}

	singular function HearNoise(float Loudness, Actor NoiseMaker)
	{
		local vector OldLastSeenPos;

		if ( NoiseMaker.Instigator != None && SetEnemy(NoiseMaker.instigator) )
		{
			OldLastSeenPos = LastSeenPos;
			if ( Enemy ==  NoiseMaker.instigator  )
				LastSeenPos = 0.5 * (NoiseMaker.Location + VSize(NoiseMaker.Location - Location) * vector(Rotation));
			else if ( (Pawn(NoiseMaker) != None) && (Enemy == Pawn(NoiseMaker).Enemy) )
				LastSeenPos = 0.5 * (Pawn(NoiseMaker).Enemy.Location + VSize(Pawn(NoiseMaker).Enemy.Location - Location) * vector(Rotation));
			if ( VSize(OldLastSeenPos - Enemy.Location) < VSize(LastSeenPos - Enemy.Location) )
				LastSeenPos = OldLastSeenPos;
		}
	}

	function SeePlayer(Actor SeenPlayer)
	{
		if (ValidSight(SeenPlayer))
		if ( SetEnemy(Pawn(SeenPlayer)) )
		{
			MakeNoise(1.0);
			NextAnim = '';
			GotoState('Attacking');
		}
	} 

	function BeginState()
	{
		Disable('Tick'); //only used for bounding anim time
		SetAlertness(-0.5);
	}

	function EndState()
	{
		LastAcquireTime = Level.TimeSeconds;
	}

PlayOut:
	Acceleration = vect(0,0,0);
	if ( (AnimFrame < 0.6) && IsAnimating() )
	{
		Sleep(0.05);
		if ( Enemy != None && ((Level.TimeSeconds - LastSeenTime) > 10) )
			Enemy = None; //Added
		Goto('PlayOut');
	}

Begin:
	Acceleration = vect(0,0,0);
	if (NeedToTurn(LastSeenPos))
	{
		PlayTurning();
		TurnTo(LastSeenPos);
	}
	DesiredRotation = Rotator(LastSeenPos - Location);
	TweenToFighter(0.2); 
	FinishAnim();
	if ( Enemy == None )
	{
		if (OldEnemy != None)
			Enemy = OldEnemy;
		WhatToDoNext('','');
	}
//	if ( Enemy.IsA('StationaryPawn') )
	if ( StationaryPawn(Enemy) != None )
		GotoState('Attacking');
	if (bVerbose)
		log(Self.GetHumanName()$" > Stimulus="$Stimulus);
	if ( AttitudeTo(Enemy) == ATTITUDE_Fear )  //will run away from noise
	{
		LastSeenPos = Enemy.Location; 
		NextAnim = '';
		GotoState('Attacking');
	}
	else if ( !bNovice )
	{
		bMustHunt = true;
		GotoState('Attacking');
	}
	else
		WhatToDoNext('','');
}

/* Acquisition - 
Creature has just reacted to stimulus, and set an enemy
- depending on strength of stimulus, and ongoing stimulii, vary time to focus on target and start attacking (or whatever.  FIXME - need some acquisition specific animation
HearNoise and SeePlayer used to improve/change stimulus
*/

state FallingState 
{
ignores Bump, Hitwall, WarnTarget;

	singular event BaseChange()
	{
		local actor HitActor;
		local vector HitNormal, HitLocation;

		if ( (Base != None) && Base.IsA('Mover')
			&& ((MoveTarget == Base) 
				|| ((MoveTarget != None) && (MoveTarget == Mover(Base).myMarker))) )
		{
			MoveTimer = -1.0;
			MoveTarget = None;
			acceleration = vect(0,0,0);
		}
		else
			Super.BaseChange();
	}

	function AnimEnd()
	{
		PlayInAir();
	}

	function ZoneChange(ZoneInfo newZone)
	{
		Global.ZoneChange(newZone);
		if (newZone.bWaterZone)
		{
			TweenToWaiting(0.15);
			GotoState('FallingState', 'Splash');
		}
	}

	//choose a jump velocity
	function adjustJump()
	{
		local float velZ;
		local vector FullVel;

		velZ = Velocity.Z;
		FullVel = Normal(Velocity) * GroundSpeed;
		Acceleration = vect(0,0,0);
		If (Location.Z > Destination.Z + CollisionHeight + 2 * MaxStepHeight)
		{
			Velocity = FullVel;
			Velocity.Z = velZ;
			Velocity = EAdjustJump();
			Velocity.Z = 0;
			if ( VSize(Velocity) < 0.9 * GroundSpeed )
			{
				Velocity.Z = velZ;
				GoTo JL1979;
			}
JL1979:
		}

		PlaySound(JumpSound, SLOT_Talk, 1.5, true, 1200, 1.0 );
		Velocity = FullVel;
		Velocity.Z = Default.JumpZ + velZ;
		Velocity = EAdjustJump();
	}

	function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
							Vector momentum, name damageType)
	{
		Global.TakeDamage(Damage, instigatedBy, hitlocation, momentum, damageType);

		if (Enemy == None)
		{
			SetEnemy(instigatedBy);
			if ( Enemy != None )
			{ 
				NextState = 'Attacking'; 
				NextLabel = 'Begin';
			}
		}
		if ( (Enemy != None) && (instigatedBy == Enemy) )
		{
			LastSeenTime = Level.TimeSeconds;
			LastSeenPos = Enemy.Location;
		}
		if (NextState == 'TakeHit')
		{
			NextState = 'Attacking'; 
			NextLabel = 'Begin';
			GotoState('TakeHit'); 
		}
	}

	function bool SetEnemy(Pawn NewEnemy)
	{
		local bool result;
		result = false;
		if ( Global.SetEnemy(NewEnemy))
		{
			result = true;
			NextState = 'Attacking'; 
			NextLabel = 'Begin';
		}
		return result;
	} 

	function Timer()
	{
		if ( Enemy != None )
		{
			bReadyToAttack = true;
			if ( CanFireAtEnemy() )
				GotoState('FallingState', 'FireWhileFalling');
		}
	}

	function Landed(vector HitNormal)
	{
		local vector Vel2D;

		if ( MoveTarget != None )
		{
			Vel2D = Velocity;
			Vel2D.Z = 0;
			if ( (Vel2D Dot (MoveTarget.Location - Location)) < 0 )
				Acceleration = vect(0,0,0);
		}
		//Note - physics changes type to PHYS_Walking by default for landed pawns
		PlayLanded(Velocity.Z);
		TakeFallingDamage();
		if (Velocity.Z < -1.4 * JumpZ)
		{
			if ( health > 0 )
				GotoState('FallingState', 'Landed');
		}
		else 
			GotoState('FallingState', 'Done');
	}

	function SeePlayer(Actor SeenPlayer)
	{
		Global.SeePlayer(SeenPlayer);
		disable('SeePlayer');
		disable('HearNoise');
	}

	function EnemyNotVisible()
	{
		enable('SeePlayer');
		enable('HearNoise');
	}

	function SetFall()
	{
		if (!bUpAndOut)
			GotoState('FallingState');
	}

	function EnemyAcquired()
	{
		NextState = 'Acquisition';
		NextLabel = 'Begin';
	}

	function FindNewJumpDest()
	{
		local NavigationPoint N, Best;
		local float BestRating, Rating;
		local vector Dist;

		// look for pathnode bellow current location and visible
		BestRating = 1;
		if (bXCGE)
		{
			foreach NavigationActors ( class 'NavigationPoint',N )
				if ( N.Location.Z + 100 < Location.Z )
				{
					Dist = Location - N.Location;
					Rating = Dist.Z * Dist.Z/(Dist.X * Dist.X + Dist.Y * Dist.Y); 
					if ( (Rating > BestRating) && FastTrace(N.Location, Location) )
					{
						BestRating = Rating;
						Best = N;
					}
				}
		}
		else
		{
			for ( N=Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
				if ( N.Location.Z + 100 < Location.Z )
				{
					Dist = Location - N.Location;
					Rating = Dist.Z * Dist.Z/(Dist.X * Dist.X + Dist.Y * Dist.Y); 
					if ( (Rating > BestRating) && FastTrace(N.Location, Location) )
					{
						BestRating = Rating;
						Best = N;
					}
				}
		}
		if ( Best != None )
			Destination = Best.Location;
	}

	function BeginState()
	{
		if (Enemy == None)
			Disable('EnemyNotVisible');
		else
		{
			Disable('HearNoise');
			Disable('SeePlayer');
		}
		if ( (bFire > 0) || (bAltFire > 0) || (Skill == 3) )
			SetTimer(0.01, false);
	}

	function EndState()
	{
		//log(self$" left falling state ");
		bUpAndOut = false;
		bJumpOffPawn = false;
		bBigJump = false;
		if ( bImpactJumping )
		{
			bImpactJumping = false;
			SwitchToBestWeapon();
		}
		if ( (MoveTarget != None) && (MoveTarget.Location.Z - Location.Z > 256) )
			MoveTarget = None;
	}

FireWhileFalling:
	Sleep(0.00);
	Disable('HearNoise');
	Disable('SeePlayer');
	if ( Physics != PHYS_Falling )
		Goto('Done');
	if ( Enemy == None )
		Goto('LongFall');
	TurnToward(Enemy);
	if ( CanFireAtEnemy() )
		FireWeapon();
	if ( Region.Zone.ZoneGravity.Z > Region.Zone.Default.ZoneGravity.Z )
	{
		if ( (Velocity.Z < 0) && (Destination.Z > Location.Z + MaxStepHeight + CollisionHeight) )
			FindNewJumpDest();
		StrafeFacing(Destination, Enemy);
	}
	else
		Sleep(0.5 + 0.2 * FRand());
	if ( LineOfSightTo(Enemy) )
		Goto('FireWhileFalling');

LongFall:
	Sleep(0.00);
	if ( (Region.Zone.ZoneGravity.Z > Region.Zone.Default.ZoneGravity.Z)
		&& (Velocity.Z < 0) && (Destination.Z > Location.Z + MaxStepHeight + CollisionHeight) )
	{
		FindNewJumpDest();
		MoveTo(Destination);
	}
// ?????????? WTF !?
	if ( bCanFly )
	{
		SetPhysics(PHYS_Flying);
		Goto('Done');
	}
	Sleep(0.5);
	if ( Enemy != None )
	{
		TurnToward(Enemy);
		if ( CanFireAtEnemy() )
		{
			PlayRangedAttack();
		}
	}
	if ( (Velocity.Z > -150) && (Region.Zone.ZoneGravity.Z <= Region.Zone.Default.ZoneGravity.Z) ) //stuck
	{
		SetPhysics(PHYS_Falling);
		if ( Enemy != None )
			Velocity = groundspeed * normal(Enemy.Location - Location);
		else
			Velocity = groundspeed * VRand();
		Velocity.Z = FMax(JumpZ, 250);
	}
	Goto('LongFall');

Landed:
	//log("Playing"@animsequence@"at"@animframe);
	Disable('AnimEnd');
	Sleep(0.00);
	FinishAnim();
	//log("Finished"@animsequence@"at"@animframe);
Done:
	Sleep(0.00);
	//log("After fall"@NextState@NextLabel);
	if ( NextAnim == '' )
	{
		bUpAndOut = false;
		if ( (NextState != '') && (NextState != 'FallingState') )
			GotoState(NextState, NextLabel);
		else 
			GotoState('Attacking');
	}
	if ( !bUpAndOut )
	{
		if ( NextAnim == 'Fighter' )
			TweenToFighter(0.2);
		else
			TweenAnim(NextAnim, 0.12);
	} 

Splash:
	bUpAndOut = false;
	if ( NextState != '' )
		GotoState(NextState, NextLabel);
	else 
		GotoState('Attacking');

Begin:
	if (Enemy == None)
		Disable('EnemyNotVisible');
	else
	{
		Disable('HearNoise');
		Disable('SeePlayer');
	}
	if ( !bUpAndOut ) // not water jump
	{
		if ( Region.Zone.bWaterZone )
		{
			SetPhysics(PHYS_Swimming);
			GotoState(NextState, NextLabel);
		}
		if ( !bJumpOffPawn )
			AdjustJump();
PlayFall:
		Sleep(0.00);
		if ( (Velocity.Z > 300) && (MoveTarget != None)
			&& ((FRand() < 0.13) || ((Region.Zone.ZoneGravity.Z > Region.Zone.Default.ZoneGravity.Z) && (FRand() < 0.2)))
			&& (VSize(Destination - Location) > 160)
			&& ((Vector(Rotation) Dot (Destination - Location)) > 0) )
			PlayFlip();
		else
			TweenToFalling();
	}
	if (Physics != PHYS_Falling)
		Goto('Done');
	if ( !bNovice && (Enemy != None) && (Region.Zone.ZoneGravity.Z > Region.Zone.Default.ZoneGravity.Z) )
	{
		Acceleration = AccelRate * Normal(Destination - Location);
		Goto('FireWhileFalling');
	}

	if ( bJumpOffPawn )
	{
		if ( bBigJump )
		{
			While( bBigJump )
			{
				Sleep(0.35); //0.25
				Acceleration = AccelRate * Normal(Destination - Location);
			}
		}
		else
		{
			Sleep(0.2); //0.2
			While ( (Abs(Velocity.X) < 60) && (Abs(Velocity.Y) < 60) )
				Sleep(0.1);
			Acceleration = vect(0,0,0);
			Sleep(1.5);
		}
		bBigJump = false;
		bJumpOffPawn = false;
	}
	else
		Sleep(1.50); //2.00
	Goto('LongFall');

Ducking:
	Sleep(0.00);
	if ( Region.Zone.ZoneGravity.Z > Region.Zone.Default.ZoneGravity.Z )
	{
		Acceleration = AccelRate * Normal(Destination - Location);
		if ( bNovice )
			Sleep(0.4);
		PlayInAir();
		if ( Enemy != None )
			Goto('FireWhileFalling');
	}
}

state Wandering
{
	ignores EnemyNotVisible;

	function bool DeferTo(Bot Other)
	{
		if ( Acceleration == vect(0,0,0) )
			return Global.DeferTo(Other);

		return false;
	}

	function SetOrders(name NewOrders, Pawn OrderGiver, optional bool bNoAck)
	{
		Global.SetOrders(NewOrders, OrderGiver, bNoAck);
		if ( (Orders == 'Hold') || (Orders == 'Follow') )
			GotoState('Roaming');
	}

	singular event BaseChange()
	{
		if ( (Base != None) && Base.IsA('Mover') )
			Destination = Location - 300 * Normal(Velocity);
		else
			Super.BaseChange();
	}

	function ShootTarget(Actor NewTarget)
	{
		Target = NewTarget;
		bFiringPaused = true;
		SpecialPause = 2.0;
		NextState = GetStateName();
		NextLabel = 'Begin';
		GotoState('RangedAttack');
	}

	function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
	{
		Global.TakeDamage(Damage, instigatedBy, hitlocation, momentum, damageType);
		if ( health <= 0 )
			GoTo JL2351;
		if ( (Enemy != None) && (Enemy == InstigatedBy) )
		{
			LastSeenPos = Enemy.Location;
			LastSeenTime = Level.TimeSeconds;
		}

		if ( NextState == 'TakeHit' )
			{
			NextState = 'Attacking'; 
			NextLabel = 'Begin';
			GotoState('TakeHit'); 
			}
		else
			GotoState('Attacking');
JL2351:
	}

	function Timer()
	{
		Enable('Bump');
	}

	function SetFall()
	{
		NextState = 'Wandering'; 
		NextLabel = 'ContinueWander';
		NextAnim = AnimSequence;
		GotoState('FallingState'); 
	}

	function EnemyAcquired()
	{
		GotoState('Acquisition');
	}

	function HitWall(vector HitNormal, actor Wall)
	{
		if (Physics == PHYS_Falling)
			return;
		if ( Wall.IsA('Mover') && Mover(Wall).HandleDoor(self) )
		{
			if ( SpecialPause > 0 )
				Acceleration = vect(0,0,0);
			GotoState('Wandering', 'Pausing');
			return;
		}
		Focus = Destination;
		if ( PickWallAdjust() && (FRand() < 0.7) )
		{
			if ( Physics == PHYS_Falling )
				SetFall();
			else
				GotoState('Wandering', 'AdjustFromWall');
		}
		else
			MoveTimer = -1.0;
	}

	function bool TestDirection(vector dir, out vector pick)
	{
		local vector HitLocation, HitNormal, dist;
		local float minDist;
		local actor HitActor;

		minDist = FMin(150.0, 4*CollisionRadius);
		if ( (Orders == 'Follow') && (VSize(Location - OrderObject.Location) < 500) )
			pick = dir * (minDist + (200 + 6 * CollisionRadius) * FRand());
		else
			pick = dir * (minDist + (450 + 12 * CollisionRadius) * FRand());

		HitActor = Trace(HitLocation, HitNormal, Location + pick + 1.5 * CollisionRadius * dir , Location, false);
		if (HitActor != None)
		{
			pick = HitLocation + (HitNormal - dir) * 2 * CollisionRadius;
			if ( !FastTrace(pick, Location) )
				return false;
		}
		else
			pick = Location + pick;

		dist = pick - Location;
		if (Physics == PHYS_Walking)
			dist.Z = 0;

		return (VSize(dist) > minDist); 
	}

	function PickDestination()
	{
		local vector pick, pickdir;
		local bool success, bMustWander;
		local float XY;

		//Favor XY alignment
		XY = FRand();
		if ( WanderDir != vect(0,0,0) )
		{
			pickdir = WanderDir;
			XY = 1;
			bMustWander = true;
		}
		else if (XY < 0.3)
		{
			pickdir.X = 1;
			pickdir.Y = 0;
		}
		else if (XY < 0.6)
		{
			pickdir.X = 0;
			pickdir.Y = 1;
		}
		else
		{
			pickdir.X = 2 * FRand() - 1;
			pickdir.Y = 2 * FRand() - 1;
		}
		if (Physics != PHYS_Walking)
		{
			pickdir.Z = 2 * FRand() - 1;
			pickdir = Normal(pickdir);
		}
		else
		{
			pickdir.Z = 0;
			if (XY >= 0.6)
				pickdir = Normal(pickdir);
		}

		success = TestDirection(pickdir, pick);
		if (!success)
			success = TestDirection(-1 * pickdir, pick);
		
		if (success)
			Destination = pick;
		else if ( bMustWander )
		{
			WanderDir = Normal(WanderDir + VRand());
			WanderDir.Z = 0;
			Destination = Location + 100 * WanderDir;
		}
		else
			GotoState('Wandering', 'Turn');

		WanderDir = vect(0,0,0);
	}

	function AnimEnd()
	{
		PlayPatrolStop();
	}

	function FearThisSpot(Actor aSpot)
	{
		Destination = Location + 120 * Normal(Location - aSpot.Location); 
	}

	function BeginState()
	{
		Enemy = None;
		SetAlertness(0.2);
		bReadyToAttack = false;
		Disable('AnimEnd');
		NextAnim = '';
		bCanJump = false;
		bAvoidLedges = true;
		bStopAtLedges = true;
		MinHitWall += 0.15;
	}

	function EndState()
	{
		MinHitWall -= 0.15;
		bStopAtLedges = false;
		bAvoidLedges = false;
		if (JumpZ > 0)
			bCanJump = true;
	}


Begin:
	//log(class$" Wandering");

Wander: 
	WaitForLanding();
	PickDestination();
	TweenToWalking(0.15);
	FinishAnim();
	PlayWalking();

Moving:
	Enable('HitWall');
	MoveTo(Destination, WalkingSpeed);
Pausing:
	if ( Level.Game != None && Level.Game.bTeamGame 
		&& (bLeading || ((Orders == 'Follow') && Pawn(OrderObject) != None && !CloseToPointMan(Pawn(OrderObject)))) )
		GotoState('Roaming');
	Acceleration = vect(0,0,0);
	if ( NearWall(200) )
	{
		PlayTurning();
		TurnTo(Focus);
	}
	Enable('AnimEnd');
	NextAnim = '';
	TweenToPatrolStop(0.2);
	Sleep(1.0);
	Disable('AnimEnd');
	FinishAnim();
//Screwed here wandering
	bCamping=False;
	PlayRunning();
//
	GotoState('Roaming','Prebegin');

ContinueWander:
	FinishAnim();
	PlayWalking();
	if (FRand() < 0.2)
		Goto('Turn');
	Goto('Wander');

Turn:
	Acceleration = vect(0,0,0);
	PlayTurning();
	TurnTo(Location + 20 * VRand());
	Goto('Pausing');

AdjustFromWall:
	StrafeTo(Destination, Focus); 
	Destination = Focus; 
	Goto('Moving');
}

state Roaming
{
	ignores EnemyNotVisible;

	function SetOrders(name NewOrders, Pawn OrderGiver, optional bool bNoAck)
	{
		Global.SetOrders(NewOrders, OrderGiver, bNoAck);
		if ( bCamping && ((Orders == 'Hold') || (Orders == 'Follow')) )
			GotoState('Roaming', 'PreBegin');
	}

	function HearPickup(Pawn Other)
	{
		if ( bNovice || (Skill < 4 * FRand() - 1) )
			GoTo JL2588;
		if ( (Health > 70) && (Weapon != None && Weapon.AIRating > 0.6) 
			&& (RelativeStrength(Other) < 0) )
			HearNoise(0.5, Other);
JL2588:
	}

	function ShootTarget(Actor NewTarget)
	{
		Target = NewTarget;
		bFiringPaused = true;
		SpecialPause = 2.0;
		NextState = GetStateName();
		NextLabel = 'Begin';
		GotoState('RangedAttack');
	}

	function MayFall()
	{
		bCanJump = ( (MoveTarget != None) 
			&& ((MoveTarget.Physics != PHYS_Falling) || !MoveTarget.IsA('Inventory')) );
	}

	function HandleHelpMessageFrom(Pawn Other)
	{
		if ( (Health > 70) && (Weapon.AIRating > 0.5) && (Other.Enemy != None)
			&& ((Other.PlayerReplicationInfo != None && (Other.PlayerReplicationInfo.Team == PlayerReplicationInfo.Team)))
			//	|| (Other.IsA('StationaryPawn') && StationaryPawn(Other).SameTeamAs(PlayerReplicationInfo.Team)))
			&& (VSize(Other.Enemy.Location - Location) < 1600) )
		{
			if ( Other.PlayerReplicationInfo != None )
				SendTeamMessage(Other.PlayerReplicationInfo, 'OTHER', 10, 10);
			SetEnemy(Other.Enemy);
			GotoState('Attacking');
		}
	}

	function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
							Vector momentum, name damageType)
	{
		Global.TakeDamage(Damage, instigatedBy, hitlocation, momentum, damageType);
		if ( health <= 0 )
			GoTo JL2635;
		if (NextState == 'TakeHit')
		{
			NextState = 'Attacking'; 
			NextLabel = '';
			GotoState('TakeHit'); 
		}
		else if ( !bCanFire && (skill > 3 * FRand()) )
			GotoState('Attacking');
JL2635:
	}

	function FearThisSpot(Actor aSpot)
	{
		Destination = Location + 120 * Normal(Location - aSpot.Location); 
		GotoState('Wandering', 'Moving');
	}

	function Timer()
	{
		bReadyToAttack = True;
		Enable('Bump');
	}

	function SetFall()
	{
		bWallAdjust = false;
		NextState = 'Roaming'; 
		NextLabel = 'Landed';
		NextAnim = AnimSequence;
		GotoState('FallingState'); 
	}

	function EnemyAcquired()
	{
		GotoState('Acquisition');
//		GotoState('TacticalMove');
	}
/*
	function HitWall(vector HitNormal, actor Wall)
	{
		if (Physics == PHYS_Falling)
			return;
		if ( Wall.IsA('Mover') && Mover(Wall).HandleDoor(self) )
		{
			if ( SpecialPause > 0 )
				Acceleration = vect(0,0,0);
			GotoState('Roaming', 'SpecialNavig');
			return;
		}
		Focus = Destination;
		if ( !bWallAdjust && PickWallAdjust() )
		{
			if ( Physics == PHYS_Falling )
				SetFall();
			else
				GotoState('Roaming', 'AdjustFromWall');
		}
		else
		{
			MoveTimer = -1.0;
			bWallAdjust = false;
		}
	}
*/
	function HitWall(vector HitNormal, actor Wall)
	{
		local bool bHasTweak;
		local M_Kicker Mk;

//		log (GetHumanName()@">> Roaming - Hitwall"@HW);
		if (Physics == PHYS_Falling)
			GoTo JL2689;
		if ( Wall.IsA('Mover') && Mover(Wall).HandleDoor(self) )
		{
			if ( SpecialPause > 0 )
				Acceleration = vect(0,0,0);
			GotoState('Roaming', 'SpecialNavig');
			GoTo JL2689;
		}
//=== Changes here
		if ( MoveTarget != None && MoveTarget.Location.Z < ( Location.Z - CollisionHeight ) && FastTrace(Location,MoveTarget.Location) )
		{
			if (bXCGE)
			{
				foreach CollidingActors ( class'M_Kicker',Mk,60,Location )
				{
					bHasTweak=True;
					break;
				}
			}
			else
			{
				foreach RadiusActors ( class'M_Kicker',Mk,80,Location )
				{
					bHasTweak=True;
					break;
				}
			}
			if (!bHasTweak)
			{
				Spawn(class'M_Kicker',,,Location+vect(0,0,-35)).Touch(Self);
//				log (Level.GetURLMap()@">> A HitWall spot has been encountered at Location >>"@Location,'MBot');
			}
		if ( MoveTarget == None )
			PickDestination();
		}
		if ( !bWallAdjust && PickWallAdjust() )
		{
			if ( Physics == PHYS_Falling )
				SetFall();
			else
				GotoState('Roaming', 'AdjustFromWall');
		}
		else
		{
			MoveTimer = -1.0;
			bWallAdjust = false;
		}
	JL2689:
	}
//=== End Changes


	function PickDestination()
	{
		local inventory Inv, BestInv;
		local Weapon W, W1;
		local float Bestweight, NewWeight, DroppedDist, TLocChance;
		local actor BestPath;
		local decoration Dec;
		local NavigationPoint N, Np;
		local int i, LvlCh, LoadCh, numPwn, j, nr;
		local bool bTriedToPick, bLockedAndLoaded, bNearPoint, bReadyToHunt;
		local byte TeamPriority;
		local Pawn P;
//--- I think we might have troubles here randomly
//--- See monster ghosting with negative health, LOL
//--- Bot doesn't seems to include a fix
		if ( Health <= 0)
			GoTo JL3160;
//---
		goalstring = " Choosing a Roam Path ";
		bCanTranslocate = ( !HeadRegion.Zone.bWaterZone
			&& DeathMatchPlus(Level.Game) != None
				&& DeathMatchPlus(Level.Game).CanTranslocate(self) 
					&& ( PlayerReplicationInfo != None && PlayerReplicationInfo.HasFlag == None ) );
// - Long Movers ?
		if ( Mover(Base) != None && VSize( Mover(Base).Velocity ) > 0 && SpecialPause == 0 )
		{
			CampTime = 1.500000;
			GoToState('Roaming','LongCamp');
			GoTo JL3160;
		}
//
		if ( TeamGamePlus(Level.Game) != None )
		{
			if ( (Orders == 'FreeLance') && !bStayFreelance
				&& (Orders != BotReplicationInfo(PlayerReplicationInfo).RealOrders) ) 
				SetOrders(BotReplicationInfo(PlayerReplicationInfo).RealOrders, BotReplicationInfo(PlayerReplicationInfo).RealOrderGiver, true);
			if ( FRand() < 0.5 )
				bStayFreelance = false;
			LastAttractCheck = Level.TimeSeconds - 0.1;
			if (!bCampOnlyOnce)
			if ( TeamGamePlus(Level.Game).FindSpecialAttractionFor(self) && bBlockActors )
			{
				if ( IsInState('Roaming') ) //??
				{
					TeamPriority = TeamGamePlus(Level.Game).PriorityObjective(self);
					if ( TeamPriority > 16 )
					{
						PickLocalInventory(160, 1.8);
						GoTo JL3160;
					}
					else if ( TeamPriority > 1 )
					{
						PickLocalInventory(200, 1);
						GoTo JL3160;
					}
					else if ( TeamPriority > 0 )
					{
						PickLocalInventory(280, 0.55);
						GoTo JL3160;
					}
					PickLocalInventory(450, 0.5);
					GoTo JL3160;
				}
				if ( MoveTarget != None )
				{
					if ( Vsize(Location-MoveTarget.Location) < CollisionRadius )
						SortAnotherPoint();
					GoTo JL3160;
				}
			}
		}
		bLockedAndLoaded = ( ( Weapon != None && Weapon.AIRating > 0.3 ) && (Health > 50) ); //Doh

		if (  Orders == 'Follow' )
		{
			if ( Pawn(OrderObject) == None )
				SetOrders('FreeLance', None);
			else if ( Pawn(OrderObject) != None && (Pawn(OrderObject).Health > 0) )
			{
				bNearPoint = CloseToPointMan(Pawn(OrderObject));
				if ( !bNearPoint )
				{
					if ( !bLockedAndLoaded )
					{
						bTriedToPick = true;
						if ( PickLocalInventory(500, 0) )
							GoTo JL3160;
						if ( !OrderObject.IsA('PlayerPawn') )
						{
							BestWeight = 0;
							BestPath = FindBestInventoryPath(BestWeight, !bNovice && (skill >= 2));
							if ( BestPath != None )
							{
								MoveTarget = BestPath;
								if ( Vsize(Location-BestPath.Location) < CollisionRadius )
									SortAnotherPoint();
								GoTo JL3160;
							}
						}
					}
					if ( ActorReachable(OrderObject) )
						MoveTarget = OrderObject;
					else
						MoveTarget = FindPathToward(OrderObject);
//=========
					if ( (MoveTarget != None) && (VSize(Location - MoveTarget.Location) > 2.0 * CollisionRadius) )
						GoTo JL3160;
					else
						SortAnotherPoint();
					if ( (MoveTarget != None) && (VSize(Location - MoveTarget.Location) >  1.5 * CollisionRadius) )
						GoTo JL3160;
//=========
					if ( (VSize(OrderObject.Location - Location) < 1600) && LineOfSightTo(OrderObject) )
						bNearPoint = true;
					if ( bVerbose )
						log(self.GetHumanName()$" found no path to "$OrderObject);
				}
				else if ( !bInitLifeMessage && (Pawn(OrderObject).Health > 0) 
						&& (VSize(Location - OrderObject.Location) < 500) )
				{
					bInitLifeMessage = true;
					SendTeamMessage(Pawn(OrderObject).PlayerReplicationInfo, 'OTHER', 3, 10);
				}
			}
		}
		if ( (Orders == 'Defend') && bLockedAndLoaded )
		{
			if ( PickLocalInventory(400, 0.55) )
				GoTo JL3160;
			if ( FindAmbushSpot() ) 
				GoTo JL3160;
			if ( OrderObject != None && !LineOfSightTo(OrderObject) )
			{
				MoveTarget = FindPathToward(OrderObject);
				if ( MoveTarget != None )
				{
					if ( Vsize(Location-MoveTarget.Location) < CollisionRadius )
						SortAnotherPoint();
					GoTo JL3160;
				}
			}
			else if ( !bInitLifeMessage )
			{
				bInitLifeMessage = true;
				SendTeamMessage(None, 'OTHER', 9, 10);
			}
		}

		if ( (Orders == 'Hold') && bLockedAndLoaded && OrderObject != None && !LineOfSightTo(OrderObject) )
		{
			GotoState('Hold');
			GoTo JL3160;
		}

		if ( !bTriedToPick && PickLocalInventory(600, 0) )
			GoTo JL3160;

		if ( ( Orders == 'Hold') && bLockedAndLoaded )
		{
			if ( VSize(Location - OrderObject.Location) < 20 && OrderObject != None)
				GotoState('Holding');
			else
				GotoState('Hold');
			GoTo JL3160;
		}

		if ( ((Orders == 'Follow') && (bNearPoint || (Level.Game.IsA('TeamGamePlus') && TeamGamePlus(Level.Game).WaitForPoint(self))))
			|| ((Orders == 'Defend') && bLockedAndLoaded && OrderObject != None && LineOfSightTo(OrderObject)) )
		{
			if ( FRand() < 0.35 )
			{
				GotoState('Wandering');
				GoTo JL3160;
			}
			else
			{
				CampTime = 0.8;
				GotoState('Roaming', 'Camp');
				GoTo JL3160;
			}
		}

		if ( (OrderObject != None) && !OrderObject.IsA('Ambushpoint') )
			bWantsToCamp = false;
		else if ( (Weapon != None && Weapon.AIRating > 0.5) && (Health > 90) && !Region.Zone.bWaterZone )
		{
			bWantsToCamp = ( bWantsToCamp || (FRand() < CampingRate * FMin(1.0, Level.TimeSeconds - LastCampCheck)) );
			LastCampCheck = Level.TimeSeconds;
		}
		else 
			bWantsToCamp = false;
//== Modification down
		if ( bWantsToCamp && FindAmbushSpot() )
		{
			if ( Orders != 'Defend' && FRand() > 0.6 )
				bWantsToCamp = False;
			GoTo JL3160;
		}

		// if none found, check for decorations with inventory
		if ( !bNoShootDecor )
			foreach visiblecollidingactors(class'Decoration', Dec, 700,,true)
				if ( Dec.Contents != None )
				{
					bNoShootDecor = true;
					Target = Dec;
					GotoState('Roaming', 'ShootDecoration');
					Return; //heck
				}

		bNoShootDecor = false;
// Section completed because of bullshit discovered
//If any inventory path is available - in case of perfect Bot Pathing - Bot won't hunt player ever - Loser !
//Now let me see
//End of add-on
//Start Nasty iterator
	LvlCh=0;
	LoadCh=0;
	foreach AllActors (class 'Weapon', W)
	{
		if ( W.Owner == None && !W.bHeldItem )
		{
			if ( FindInventoryType(W.class) != None &&
				( Weapon != None && Weapon.AmmoType != None
					&& Weapon.AmmoType.AmmoAmount > Weapon.PickupAmmoCount/2))
				LoadCh++;
			LvlCh++;
		}
	}
	bReadyToHunt = ( LoadCh >= LvlCh && bLockedAndLoaded );
//decide if need weapons or start hunting some enemy
//look for long distance inventory - Ns:If not enough loaded or such
		if ( !bReadyToHunt && TeamGamePlus(Level.Game) == None )
		{
			bHunting=False;
			goalstring = " Engage to Inventory needed DM type";
			BestWeight = 0;
			BestPath = FindBestInventoryPath(BestWeight, !bNovice && (skill >= 2));
			if ( BestPath != None )
			{
				//log("roam to"@BestPath);
				//log("-----------------------------");
				MoveTarget = BestPath;
				if ( Vsize(Location-BestPath.Location) < CollisionRadius )
					SortAnotherPoint();
				GoTo JL3160;
			}

			else
			{
				if ( bCanTranslocate )
				foreach AllActors(class 'Weapon', W1 )
				{
					if ( W1.MyMarker != None && W1.IsInState('Pickup') && BestPath == None )
					{
						if ( FindInventoryType(W1.Class) == None )
						{
							if ( FastTrace(W1.MyMarker.Location,Location) && VSize(W1.MyMarker.Location-Location) < 710 )
							{
								TranslocateToTarget(W1.MyMarker);
								BestPath=W1;
								break;
							}
							else
							{
							for ( N=Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
							{
								nr=0;
CheckNoReaches:
								if ( N.VisNoReachPaths[nr] == W1.MyMarker
								&& FastTrace(N.Location,W1.MyMarker.Location )
								&& VSize( N.Location-W1.MyMarker.Location ) < 710 )
								{
									if ( FastTrace(N.Location,Location) && VSize(N.Location-Location) < 710 )
									{
										TranslocateToTarget(N);
										BestPath=N;
										break;
									}
									else
									{
										BestPath = FindPathToward(N);
									}
									if ( BestPath != None )
										break;
								}
								nr++;
								if ( nr == 3 )
								{
									nr = 0;
									break;
								}
								else
									goto CheckNoReaches;
							}
							}
						}
					}
				}
				if ( BestPath != None )
				{
//					log (Self.GetHumanName()@" is attempting to reach at Weapon"@W1.Name );
					MoveTarget = BestPath;
					if ( Vsize(Location-BestPath.Location) < CollisionRadius )
						SortAnotherPoint();
					GoTo JL3160;
				}
			}

		}
/*
		{
		BestWeight = 0;
		// look for long distance inventory 
		BestPath = FindBestInventoryPath(BestWeight, !bNovice && (skill >= 2));
		//log("roam to"@BestPath);
		//log("---------------------------------");
		if ( BestPath != None )
		{
			MoveTarget = BestPath;
			if ( Vsize(Location-BestPath.Location) < CollisionRadius )
				SortAnotherPoint();
			GoTo JL3160;
		}
		}
*/
		if (( Orders == 'Attack' || Orders == 'Freelance' ) && Level.Game.bTeamGame )
		{
			if ( !bReadyToHunt )
			{
				goalstring = " Attempt Random Team Default Inventory Navigation ";
				BestWeight = 0.0;
				BestPath = FindBestInventoryPath(BestWeight,!bNovice && (skill >= 2));
				//log("roam to"@BestPath);
				//log("-------------------------------");
				if ( BestPath != None )
				{
					MoveTarget = BestPath;
					if ( Vsize(Location-BestPath.Location) < CollisionRadius )
						SortAnotherPoint();
					GoTo JL3160;
				}
			}

			if ( Enemy == None && MoveTarget == None && !NearbyNode() )
			{
				TryNoLost();
				if ( MoveTarget != None && CanSee(MoveTarget))
					GoTo JL3160;
			}
		}
//-----------
//-----------
		if ( Enemy != None && Enemy.Health > 0 && Pawn(RoamTarget) == None )
			RoamTarget = Enemy;
		// hunt player
		if ( (DeathMatchPlus(Level.Game) != None && DeathMatchPlus(Level.Game).OneOnOne())
			&& ( Weapon != None && Weapon.AIRating > 0.5) && (Health > 60) )
		{
			if ( (Pawn(RoamTarget) != None) && !LineOfSightTo(RoamTarget) )
			{
				bHunting = True;
				BestPath = FindPathToward(RoamTarget);
				if ( BestPath != None )
				{
					goalstring = " Engage to RoamTarget ";
					MoveTarget = BestPath;
					GoTo JL3160;
				}
				else
				{
					if (bXCGE)
					{
						bHunting = True;
						foreach NavigationActors( class'NavigationPoint',Np,1000,RoamTarget.Location )
						{
							if ( FastTrace(Np.Location,RoamTarget.Location) && BestPath == None )
							{
								if (ActorReachable(Np))
									BestPath = Np;
								else
									BestPath = FindPathToward(Np);
								if (bVerbose)
									log (Self.GetHumanName()$" using XCGE wants to reach at "$Np);
								if ( BestPath != None )
									break;
							}
						}
					}
					else
					{
						foreach RadiusActors(class'NavigationPoint',Np,1000,RoamTarget.Location)
						{
							if ( FastTrace(Np.Location,RoamTarget.Location) && BestPath == None )
							{
								if (ActorReachable(Np))
									BestPath = Np;
								else
									BestPath = FindPathToward(Np);
								if (bVerbose)
									log (Self.GetHumanName()$" wants to reach at "$Np);
								if ( BestPath != None )
									break;
							}
						}
					}
				}
				if ( BestPath != None )
				{
					goalstring = " Alternate Seeking RoamTarget ";
					MoveTarget = BestPath;
					if ( Vsize(Location-BestPath.Location) < CollisionRadius )
						SortAnotherPoint();
					GoTo JL3160;
				}
			}
		}
		else if ( bLockedAndLoaded &&
			( PlayerReplicationInfo != None && PlayerReplicationInfo.HasFlag == None )
				&& Pawn(RoamTarget) == None )
		{
			NumPwn=0;
			//high skill bots go hunt player
			if (bXCGE)
			{
				foreach PawnActors(class 'Pawn',P)
				if ( P != Self && P.Health > 0 && !P.bHidden 
						&& !LineOfSightTo(P)
						&& (AttitudeTo(P) < ATTITUDE_Ignore) && FlockPawn(P) == None && P.Mesh != None )
				{
					GoalString = " Using XCGE Test Target "$P;
					NumPwn++;
					if ( NumPwn > 32 ) break;
					bHunting = True;
						BestPath = FindPathToward(P);
					if ( BestPath != None )
					{
						RoamTarget = P;
/*
						if ( Enemy == None )
							Enemy = P;
*/
						bReadyToAttack=True;
						MoveTarget = BestPath;
						break; //Iterator
					}
				}
			}
			else
			{
				foreach AllActors(class 'Pawn',P)
				if ( P != Self && P.Health > 0 && !P.bHidden 
						&& (/*(VSize(P.Location - Location) > 1500) ||*/!LineOfSightTo(P))
						&& (AttitudeTo(P) < ATTITUDE_Ignore) && FlockPawn(P) == None && P.Mesh != None )
//					if ( P.bIsPlayer && P.IsA('PlayerPawn') 
//						&& ((VSize(P.Location - Location) > 1500) || !LineOfSightTo(P)) )
				{
					GoalString = " Test Target "$P;
					NumPwn++;
					if ( NumPwn > 32 ) break;
					bHunting = True;
						BestPath = FindPathToward(P);
					if ( BestPath != None )
					{
						RoamTarget = P;
/*
						if ( Enemy == None )
							Enemy = P;
*/
						bReadyToAttack=True;
						MoveTarget = BestPath;
						break; //Iterator
					}
				}
			}
			if ( BestPath != None )
			{
				GoalString = " Finding RoamTarget "$P;
				GoTo JL3160;
			}
			bWantsToCamp = true; //don't camp if couldn't go to player
		}

		// nothing around - maybe just wait a little
		if ( (FRand() < 0.35) && bNovice 
			&& (!Level.Game.IsA('DeathMatchPlus') || ( DeathMatchPlus(Level.Game) != None && !DeathMatchPlus(Level.Game).OneOnOne())) )
		{
			GoalString = " Nothing cool, so camp ";
			CampTime = 3.5 + FRand() - skill;
			GotoState('Roaming', 'Camp');
		}

		// if roamed to ambush point, stay there maybe
		if ( Level.Game != None )
		if ( !Level.Game.bTeamGame || ( Level.Game.bTeamGame && Orders == 'Defend') ) //Yep...
		{
			if ( (AmbushPoint(RoamTarget) != None)
				&& (VSize(Location - RoamTarget.Location) < 2 * CollisionRadius)
				&& (FRand() < 0.4) )
			{
				GoalString = " Ambush found, camp here ";
				CampTime = 4.0;
				GotoState('Roaming', 'LongCamp');
				GoTo JL3160;
			}
			// look for ambush spot if didn't already try
			if ( !bWantsToCamp && FindAmbushSpot() )
			{
				GoalString = " Moving to AmbushSpot ";
				RoamTarget = AmbushSpot;
				GoTo JL3160;
			}
		}

		// find a roamtarget
		if ( RoamTarget == None )
		{
			if ( Enemy != None )
				RoamTarget = Enemy;
			if ( RoamTarget == None )
			{
				GoalString = " Check InventorySpots ";
				i = 0;
				if ( bXCGE )
				{
					foreach NavigationActors( class'NavigationPoint',N )
						if ( InventorySpot(N) != None )
						{
							i++;
							if ( (RoamTarget == None) || (Rand(i) == 0) )
								RoamTarget = N;
						}
				}
				else
				{
					for ( N=Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
						if ( InventorySpot(N) != None )
						{
							i++;
							if ( (RoamTarget == None) || (Rand(i) == 0) )
								RoamTarget = N;
						}
				}
			}
		}
		// roam around
		if ( RoamTarget != None )
		{
			if ( ActorReachable(RoamTarget) )
			{
				GoalString = " Found Reachable Target ";
				if ( Enemy == None )
				{
					Target = RoamTarget;
					if ( bCanTranslocate && FRand() > 0.4
					&& !RoamTarget.Region.Zone.bWaterZone && !Region.Zone.bWaterZone)
						TranslocateToTarget(RoamTarget);
				}
				MoveTarget = RoamTarget;
				RoamTarget = None;
				if ( VSize(MoveTarget.Location - Location) > 2 * CollisionRadius )
					GoTo JL3160;
			}
			else
			{
				BestPath = FindPathToward(RoamTarget);
				if ( BestPath != None )
				{
					GoalString = " Finding path to RoamTarget ";
					if ( /*FRand() > 0.3 &&*/ !Region.Zone.bWaterZone )
						if ( bCanTranslocate )
						for ( j=15; j>=0; j-- )
						{
							TLocChance = (FRand()+0.2)*j;
							if ( RouteCache[j] != None && TLocChance > 2
							&& VSize(RouteCache[j].Location - Location) < 1000
							&& ValidSight(RouteCache[j])
							&& Enemy == None && !RouteCache[j].Region.Zone.bWaterZone
							&& !Region.Zone.bWaterZone )
							{
								if (bVerbose)
									log(Self.GetHumanName()@" has Transloc chance"@TlocChance@"at RouteCache"@j@" > 2");
								BestPath = RouteCache[j];
								Target = RouteCache[j];
								TranslocateToTarget(RouteCache[j]);
								break;
							}
						}
					MoveTarget = BestPath;
					if ( Vsize(Location-BestPath.Location) < CollisionRadius )
						SortAnotherPoint();
					GoTo JL3160;
				}
				else
				{
					GoalString = " No Roam Target ";
					RoamTarget = None;
				}
			}
		}

		if ( FRand() < 0.35 )
			GotoState('Wandering');
		else
		{
			GoalString = " Nothing cool, so camp ";
			CampTime = 3.5 + FRand() - skill;
			GotoState('Roaming', 'Camp');
			RoamTarget = None;
			bHunting = False;
		}
JL3160:
		if ( MoveTarget != None && FRand() > 0.6 )
		{
			if ( MoveTarget.Base == None 
			&& MoveTarget.Location.Z > Location.Z + CollisionHeight + MaxStepHeight
			&& LineOfSightTo(MoveTarget) && MoveTarget.Location.Z - Location.Z < 801
			&& !FastTrace(FootRegion.Zone.Location, MoveTarget.Location+vect(0,0,-18)) )
			{
				if ( !MoveTarget.Region.Zone.bWaterZone && !HeadRegion.Zone.bWaterZone )
				if ( bCanTranslocate || ( bCanTranslocate && VSize(Velocity) < 30 ) )
					TranslocateToTarget(MoveTarget);
			}
		}
	}

	function AnimEnd() 
	{
		if ( bCamping )
		{
			SetPeripheralVision();
			if ( FRand() < 0.2 )
			{
				PeripheralVision -= 0.5;
				PlayLookAround();
			}
			else
				PlayWaiting();
		}
		else
			PlayRunning();
	}

	function ShareWith(Pawn Other)
	{
		local bool bHaveItem, bIsHealth, bOtherHas, bIsWeapon;
		local Pawn P;

		if ( Weapon(MoveTarget) != None )
		{
			if ( ( Weapon == None ) || (Weapon.AIRating < 0.5) || Weapon(MoveTarget).bWeaponStay )
				GoTo JL3227;
			bIsWeapon = true;
			bHaveItem = ( FindInventoryType(MoveTarget.class) != None );
		}
		else if ( Health(MoveTarget) != None || TournamentHealth(MoveTarget) != None )
		{
			bIsHealth = true;
			if ( Health < 80 )
				GoTo JL3227;
		}

		if ( (Other.Health <= 0) || (Other.PlayerReplicationInfo != None && Other.PlayerReplicationInfo.bIsSpectator) || (VSize(Other.Location - Location) > 1250)
			|| !LineOfSightTo(Other) )
			GoTo JL3227;

		//decide who needs it more
		CampTime = 2.0;
		if ( bIsHealth )
		{
			if ( Health > Other.Health + 10 )
			{
				GotoState('Roaming', 'GiveWay');
				GoTo JL3227;
			}
		}
		else if ( bIsWeapon && (Other.Weapon != None) && (Other.Weapon.AIRating < 0.5) )
		{
			GotoState('Roaming', 'GiveWay');
			GoTo JL3227;
		}
		else
		{
			bOtherHas = (Other.FindInventoryType(MoveTarget.class) != None);
			if ( bHaveItem && !bOtherHas )
			{
				GotoState('Roaming', 'GiveWay');
				GoTo JL3227;
			}
		}
JL3227:
	}

	function BeginState()
	{
		bNoShootDecor = false;
		bCanFire = false;
		bCamping = false;
		MinHitWall += 0.5;
		if ( bNoClearSpecial )
			bNoClearSpecial = false;
		else
		{
			bSpecialPausing = false;
			bSpecialGoal = false;
			SpecialGoal = None;
			SpecialPause = 0.0;
		}
	}

	function EndState()
	{
		SetPeripheralVision();
		if ( !bSniping && (AmbushSpot != None) )
		{
			AmbushSpot.taken = false;
			AmbushSpot = None;
		}
		MinHitWall -= 0.5;
		bCamping = false;
		bWallAdjust = false;
		bCanTranslocate = false;
	}

LongCamp:
//	log ("Roaming - LongCamp");
	bCamping = true;
	Acceleration = vect(0,0,0);
	TweenToWaiting(0.15);
	if ( Ambushspot != None )
		TurnTo(Location + Ambushspot.lookdir);
	Sleep(CampTime);
	Goto('PreBegin');

GiveWay:
//	log ("Roaming - GiveWay");
	//log("sharing");
	bCamping = true;
	Acceleration = vect(0,0,0);
	if ( GetAnimGroup(AnimSequence) != 'Waiting' )
		PlayWaiting();
	if ( NearWall(200) )
	{
		PlayTurning();
		if ( MoveTarget != None )
			TurnTo(MoveTarget.Location);
	}
	Sleep(CampTime);
	Goto('PreBegin');
Camp:
//	log ("Roaming - Camp");
	bCamping = true;
	Acceleration = vect(0,0,0);
	PlayWaiting();
ReCamp:
//	log ("Roaming - ReCamp");
	if ( NearWall(200) )
	{
		PlayTurning();
		TurnTo(Focus);
	}
	Sleep(CampTime);
	if ( bLeading || bCampOnlyOnce )
	{
		bCampOnlyOnce = false;
		Goto('PreBegin');
	}
	if ( ((Orders != 'Follow') || ( Pawn(OrderObject) != None /* LOOL */ && (Pawn(OrderObject).Health > 0) && CloseToPointMan(Pawn(OrderObject)))) 
		&& (Weapon != None) && (Weapon.AIRating > 0.4) && (3 * FRand() > skill + 1) )
		Goto('ReCamp');
PreBegin:
//	log ("Roaming - PreBegin");
	if (health <= 0)
	{
		log ("#1 BORK!!! "$Self.GetHumanName()$" won't roam !!!.");
		GotoState ('Dying');
	}
	goalstring = " Engage Roaming ";
	SetPeripheralVision();
	if ( Mover(Base)!= None && Vsize( Mover(Base).Velocity ) > 0 && SpecialPause == 0 )
	{
		bCamping = True;
		CampTime = 1.500000;
		Goto('LongCamp');
	}
	WaitForLanding();
	CampTime=0;
	bCamping=false;
	PickDestination();
	if ( MoveTimer > -0.1 || MoveTarget != None )
		PlayRunning();
	else
		PlayWaiting();
	bCanTranslocate = false;
	Goto('SpecialNavig');
Begin:
//	log ("Roaming - Begin");
	if (health <= 0)
	{
		log ("#2 BORK!!! "$Self.GetHumanName()$" won't roam !!!.");
		GotoState ('Dying');
	}
	if ( Health >= 1 && ( ( !bBlockActors || !bCollideActors ) && MoveTarget != None ) )
	{
		log ("#3 BORK!!! "$Self.GetHumanName()$" won't roam !!!.");
		Level.Game.RestartPlayer(Self);
	}
	SwitchToBestWeapon();
	bCamping = false;
	PlayRunning();
	WaitForLanding();
RunAway:
//	log ("Roaming - Runaway");
	PlayRunning();
	bCamping = False;
	PickDestination();
	if ( Mover(Base)!= None && Vsize( Mover(Base).Velocity ) > 0 && SpecialPause == 0 )
	{
		bCamping = True;
		CampTime = 1.500000;
		Goto('LongCamp');
	}
	if ( MoveTimer > -0.1 || MoveTarget != None )
		bCamping = False;
	else
		bCamping = True;
	bCanTranslocate = false;
	if ( Enemy != None && ValidSight(Enemy) )
	{
		bReadyToAttack = True;
		EnemyAcquired();
	}
SpecialNavig:
//	log ("Roaming - SpecialNavig");
	if ( MoveTimer > -0.1 || MoveTarget != None )
		bCamping = False;
	else
		bCamping = True;
	if (!bCamping)
		PlayRunning();
	else
	{
		PlayWaiting();
		if ( FRand() > 0.35 )
			GoToState('Wandering');
	}
	if ( SpecialPause > 0.0 )
	{
		Disable('AnimEnd');
		Acceleration = vect(0,0,0);
		TweenToPatrolStop(0.3);
		Sleep(SpecialPause);
		SpecialPause = 0.0;
		Enable('AnimEnd');
		bCamping=False;
		PlayRunning(); //0.1
		Goto('RunAway');
	}
Moving:
//	log ("Roaming - Moving");
	if ( !IsAnimating() )
		if (!bCamping)
			PlayRunning();
		else
		{
			PlayWaiting();
		}
	if ( MoveTarget == None )
	{
		Acceleration = vect(0,0,0);
		Sleep(0.0);
		bCamping=False;
		Goto('RunAway');
	}
	else
	{
		if ( OldMoveTarget == MoveTarget )
		{
//			log (Self.GetHumanName()$" >> Moving identical...");
			if ( LastInvTime + 15 < Level.TimeSeconds ) //if last time was moving with no luck try to quit being retarded
			{
//				log (Self.GetHumanName()@">> AnotherPoint...");
				SortAnotherPoint();
				LastInvTime = Level.TimeSeconds;
			}
//
//		Reserved Section.
//
		}
		if ( OldMoveTarget == None )
			OldMoveTarget = MoveTarget;
		if ( OldMoveTarget != MoveTarget )
		{
			OldMoveTarget = MoveTarget;
			LastInvTime=Level.TimeSeconds;
//			log (Self.GetHumanName()$" >> Moving different...");
		}

	}
	if ( MoveTarget != None && MoveTarget.IsA('InventorySpot') )
	{

		if ( (!Level.Game.IsA('TeamGamePlus') || (TeamGamePlus(Level.Game).PriorityObjective(self) == 0))
			&& (InventorySpot(MoveTarget).markedItem != None)
			&& (InventorySpot(MoveTarget).markedItem.BotDesireability(self) > 0) )
		{
			if ( InventorySpot(MoveTarget).markedItem.GetStateName() == 'Pickup' )
			{
				MoveTarget = InventorySpot(MoveTarget).markedItem;
//***
				if ( VSize(Location-MoveTarget.Location) <= CollisionRadius * 1.5 )
				{
					MoveTarget = None;
					InventorySpot(MoveTarget).markedItem.Touch(Self);
					Goto('Moving');
				}
//***
			}
			else if (	(InventorySpot(MoveTarget).markedItem.LatentFloat < 5.0)
						&& (InventorySpot(MoveTarget).markedItem.GetStateName() == 'Sleeping')
						&& (abs(Location.Z - MoveTarget.Location.Z) < CollisionHeight)
						&& (VSize(Location - MoveTarget.Location + vect(0,0,1)
						* (MoveTarget.Location.Z - Location.Z)) < CollisionRadius * CollisionRadius) )
			{
				CampTime = FMin(5, InventorySpot(MoveTarget).markedItem.LatentFloat + 0.5);
				bCampOnlyOnce = True;
				Disable('AnimEnd');
				Goto('Camp');
			}
		}
		else if ( MoveTarget.IsA('TrapSpringer')
				&& (abs(Location.Z - MoveTarget.Location.Z) < CollisionHeight)
				&& (VSize(Location - MoveTarget.Location + vect(0,0,1) * (MoveTarget.Location.Z - Location.Z)) < CollisionRadius * CollisionRadius) )
		{
			PlayVictoryDance();
			bCampOnlyOnce = true;
			bCamping = true;
			CampTime = 1.2;
			Acceleration = vect(0,0,0);
			Goto('ReCamp');
		}
	}
	else if ( MoveTarget != None && MoveTarget.IsA('Inventory') && Level.Game != None && Level.Game.bTeamGame )
	{
		if ( Orders == 'Follow' && Pawn(OrderObject) != None )
			ShareWith(Pawn(OrderObject));
		else if ( SupportingPlayer != None )
			ShareWith(SupportingPlayer);
	}
	if ( MoveTarget != None )
	{
		Destination = MoveTarget.Location;
		if ( Vector(Rotation) Dot (Destination - Location) > 0 )
		{
			Dotus = Vector(Rotation) Dot ( Destination - Location );
			if ( OldDotus == Dotus )
			{
				if ( mk != None )
				{
					mk.bDemanded = True;
					mk.SetLocation(Location); //Bring to Owner
					mk.Touch(Self); //Call drop
				}
			}
			else
			{
				OldDotus = Dotus;
			}
		}
/*
		if ( !Region.Zone.bWaterZone && Teleporter(MoveTarget) == None )
		{
			if ( MoveTarget.Location.Z < ( Location.Z-50 )
				&& SpecialPause == 0
					&& !FastTrace( MoveTarget.Location,Location+vect(0,0,-35) )
						&& FRand() > 0.85 )
			{
				if ( JumpZ > 200 )
				{
					BigJump(MoveTarget);
/*					if ( mk != None )
					{
//						log (Self.GetHumanName()@"going down way.");
						mk.bDemanded = True;
						mk.SetLocation(Location); //Bring to Owner
						mk.Touch(Self); //Call drop
					}
*/
				}
			}
			if ( Vsize(Velocity) < 10 && FRand() > 0.5 && SpecialPause == 0 )
			{
				if ( !FastTrace( MoveTarget.Location,FootRegion.Zone.Location )
/*				&& ( MoveTarget.Location.Z-Location.Z ) <= ( MaxStepHeight + CollisionHeight )
				&& ( MoveTarget.Location.Z-Location.Z ) > MaxStepHeight */ )
				{
					if ( mk != None )
					{
						mk.bDemanded = True;
						mk.SetLocation(Location);
						mk.Touch(Self);
					}
				}
			}
			if ( Vsize(Velocity) < 100 && SpecialPause == 0 )
			{
				if ( ( Location.Z - MoveTarget.Location.Z ) > CollisionHeight*0.9 && FRand() > 0.8 )
				if ( mk != None )
				{
					mk.bDemanded = True;
					mk.SetLocation(Location);
					mk.Touch(Self);
//					MoveTarget=None;
					Sleep(0);
					GoTo('RunAway');
				}
			}
		}
*/
		if ( VSize(Location-MoveTarget.Location) < CollisionRadius * 0.8
			&& SpecialPause == 0 )
		{
			if ( FRand() > 0.5 )
			{
				CampTime = 1.0;
				bCampOnlyOnce = true;
				GoTo('Camp');
			}
			else
			{
				if ( RouteCache[0] != None && RouteCache[2] != None
				&& RouteCache[0] == RouteCache[2]
				&& MoveTarget == RouteCache[0] )
					SortAnotherPoint();
				else if ( RouteCache[1] != None && RouteCache[3] != None
				&& RouteCache[1] == RouteCache[3]
				&& MoveTarget == RouteCache[1] )
					SortAnotherPoint();
				else SortAnotherPoint();
			}
		}

		if ( InventorySpot(MoveTarget) == None ) //If not moving to an Inventory Leave timer
			LastInvTime = Level.TimeSeconds;

//		else if ( MoveTarget.IsA('Teleporter') || MoveTarget.IsA('LiftCenter')
//			|| MoveTarget.IsA('LiftExit') || ActorReachable(MoveTarget)
//			|| ( NavigationPoint(MoveTarget) == None && ActorReachableMore(MoveTarget)))
			MoveToward(MoveTarget);
//		else 
//		{
//			CampTime = 1.0;
//			Goto('Camp');
//		}
	}
	bCamping = False;
	Goto('RunAway');

TakeHit:
//	log ("Roaming - TakeHit");
	TweenToRunning(0.12);
	Goto('Moving');

Landed:
//	log ("Roaming - Landed");
	if ( MoveTarget == None ) 
		Goto('RunAway');
	Goto('Moving');

AdjustFromWall:
//	log ("Roaming - AdjustFromWall");
	if ( !IsAnimating() )
		AnimEnd();
	bWallAdjust = true;
	bCamping = false;
	bStopAtLedges=False;
	bAvoidLedges=False;
	StrafeTo(Destination, Focus); 
	Destination = Focus; 
	MoveTo(Destination);
	bWallAdjust = false;
//	bStopAtLedges=!bStopAtLedges;
//	bAvoidLedges=!bAvoidLedges;
	Goto('Moving');

ShootDecoration:
//log ("Roaming - ShootDecoration");
	Acceleration = vect(0,0,0);
	MoveTimer = -1.0;
	if ( Decoration(Target) != None && !Target.bHidden )
		TurnToward(Target);
	PlayWaiting();
	if ( Weapon != None )
	{
		bFire = 1;
		bAltFire = 0;
		Weapon.Fire(1.0);
	}
	Sleep(0.7 + FRand());
	bAltFire = 0;
	bFire = 0;
	Sleep(0.5);
	if ( Decoration( Target ) != None && !Target.bHidden )
		Goto('ShootDecoration');
	else
		PlayRunning();
	Goto('RunAway');
}

state TacticalMove
{
ignores SeePlayer, HearNoise;

	function WarnTarget(Pawn shooter, float projSpeed, vector FireDir)
	{
		if ( bCanFire && (FRand() < 0.4) ) 
			GoTo JL3625;
		Super.WarnTarget(shooter, projSpeed, FireDir);
JL3625:
	}

	function SetFall()
	{
		Acceleration = vect(0,0,0);
		Destination = Location;
		NextState = 'Attacking'; 
		NextLabel = 'Begin';
		NextAnim = 'Fighter';
		GotoState('FallingState');
	}

	function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
	{
		Global.TakeDamage(Damage, instigatedBy, hitlocation, momentum, damageType);
		if ( health <= 0 )
			GoTo JL3650;
		if ( NextState == 'TakeHit' )
		{
			NextState = 'TacticalMove'; 
			NextLabel = 'TakeHit';
			GotoState('TakeHit'); 
		}
JL3650:
	}

	function HitWall(vector HitNormal, actor Wall)
	{
		if (Physics == PHYS_Falling)
			GoTo JL3675;
		Focus = Destination;
		if ( Enemy == None )
		{
			GotoState('Attacking');
			GoTo JL3675;
		}
		//if (PickWallAdjust())
		//	GotoState('TacticalMove', 'AdjustFromWall');
		if ( bChangeDir || (FRand() < 0.5) 
			|| (((Enemy.Location - Location) Dot HitNormal) < 0) )
		{
			DesiredRotation = Rotator(Enemy.Location - location);
			GiveUpTactical(false);
		}
		else
		{
			bChangeDir = true;
			Destination = Location - HitNormal * FRand() * 500;
		}
JL3675:
	}

	function FearThisSpot(Actor aSpot)
	{
		Destination = Location + 120 * Normal(Location - aSpot.Location); 
	}

	function AnimEnd() 
	{
		if ( bCanFire && LineOfSightTo(Enemy) )
			PlayCombatMove();
		else if ( (Physics == PHYS_Falling) && (Velocity.Z < -300) )
			FastInAir();
		else
			PlayRunning();
	}

	function Timer()
	{
		bReadyToAttack = True;
		Enable('Bump');
		if ( Enemy == None )
			GoTo JL3713;
		Target = Enemy;
		if (VSize(Enemy.Location - Location) 
				<= (MeleeRange + Enemy.CollisionRadius + CollisionRadius))
			GotoState('RangedAttack');
		else if ( Weapon != None && !Weapon.bMeleeWeapon && ((Enemy.Weapon == None) || !Enemy.Weapon.bMeleeWeapon) )
		{
			if ( bNovice )
			{
				if ( FRand() > 0.4 + 0.18 * skill ) 
					GotoState('RangedAttack');
			}
			else if ( FRand() > 0.5 + 0.17 * skill ) 
				GotoState('RangedAttack');
		}
JL3713:
	}

	function EnemyNotVisible()
	{
		if ( !bGathering && (aggressiveness > relativestrength(enemy)) )
		{
			if ( FastTrace(Enemy.Location, LastSeeingPos) )
			{
				bCanFire = false;
				GotoState('TacticalMove','RecoverEnemy');
			}
			else
				GotoState('Attacking');
		}
		Disable('EnemyNotVisible');
	}

	function GiveUpTactical(bool bNoCharge)
	{
		if ( !bNoCharge && ( Weapon != None && Weapon.bMeleeWeapon || (2 * CombatStyle + 0.1 * Skill > FRand())) )
			GotoState('Charging');
		else if ( bReadyToAttack && Weapon != None && !Weapon.bMeleeWeapon && !bNovice )
			GotoState('RangedAttack');
		else
			GotoState('RangedAttack', 'Challenge'); 
	}

	function bool TryToward(inventory Inv, float Weight)
	{
		local bool success; 
		local vector pickdir, collSpec, minDest, HitLocation, HitNormal;
		local Actor HitActor;

		if ( (Weight < 0.0008) && ((Weight < 0.0008 - 0.0002 * skill) 
				|| !Enemy.LineOfSightTo(Inv)) )
			return false;

		pickdir = Inv.Location - Location;
		if ( Physics == PHYS_Walking )
			pickDir.Z = 0;
		pickDir = Normal(PickDir);

		collSpec.X = CollisionRadius;
		collSpec.Y = CollisionRadius;
		collSpec.Z = FMax(6, CollisionHeight - 18);

		minDest = Location + FMin(160.0, 3*CollisionRadius) * pickDir;
		HitActor = Trace(HitLocation, HitNormal, minDest, Location, false, collSpec);
		if (HitActor == None)
		{
			success = (Physics != PHYS_Walking);
			if ( !success )
			{
				collSpec.X = FMin(14, 0.5 * CollisionRadius);
				collSpec.Y = collSpec.X;
				HitActor = Trace(HitLocation, HitNormal, minDest - (18 + MaxStepHeight) * vect(0,0,1), minDest, false, collSpec);
				success = (HitActor != None);
			}
			if ( success )
			{
				Destination = Inv.Location;
				bGathering = true;
				if ( 2.7 * FRand() < skill )
					GotoState('TacticalMove','DoStrafeMove');
				else
					GotoState('TacticalMove','DoDirectMove');
				return true;
			}
		}

		return false;
	}

	function PainTimer()
	{
		if ( (FootRegion.Zone.bPainZone) && (FootRegion.Zone.DamagePerSec > 0)
			&& (FootRegion.Zone.DamageType != ReducedDamageType) )
			GotoState('Retreating');
		Super.PainTimer();
	}

/* PickDestination()
Choose a destination for the tactical move, based on aggressiveness and the tactical
situation. Make sure destination is reachable
*/
	function PickDestination(bool bNoCharge)
	{
		local inventory Inv, BestInv, SecondInv;
		local float Bestweight, NewWeight, MaxDist, SecondWeight;
		local vector HitLocation, HitNormal;
		local Actor HitActor;

		// possibly pick nearby inventory
		// higher skill bots will always strafe, lower skill
		// both do this less, and strafe less
		if ( Enemy == None || Enemy.Health < 1 || Enemy.bDeleteMe || Enemy == Self )
		{
			WhatToDoNext('','');
			GoTo JL3879;
		}

		if ( !bReadyToAttack && (TimerRate == 0.0) )
			SetTimer(0.7, false);
		if ( bNovice )
		{
			if ( Level.TimeSeconds - LastInvFind < 4 )
			{
				PickRegDestination(bNoCharge);
				GoTo JL3879;
			}
		}
		else if ( Level.TimeSeconds - LastInvFind < 3 - 0.5 * skill )
		{
			PickRegDestination(bNoCharge);
			GoTo JL3879;
		}

		LastInvFind = Level.TimeSeconds;
		bGathering = false;
		MaxDist = 700 + 70 * skill;
		BestWeight = 0.5/MaxDist;
		foreach VisibleCollidingActors(class'Inventory', Inv, MaxDist,Location,True)
//		foreach RadiusActors(class'Inventory', Inv, MaxDist)
		{
			if ( Inv != None && BestInv == None )
			{
				HitActor = Trace(HitLocation, HitNormal, Inv.Location, Location, false);
				if ( HitActor == None )
				{
					if ( (Inv.IsInState('PickUp')) && (Inv.MaxDesireability/200 > BestWeight)
					&& (Inv.Location.Z < Location.Z + MaxStepHeight + CollisionHeight)
					&& (Inv.Location.Z > FMin(Location.Z, Enemy.Location.Z) - CollisionHeight) )
					{
						NewWeight = inv.BotDesireability(self)/VSize(Inv.Location - Location);
						if ( NewWeight > BestWeight )
						{
							SecondWeight = BestWeight;
							BestWeight = NewWeight;
							SecondInv = BestInv;
							BestInv = Inv;
						}
					}
				}
			}
		}
		if ( BestInv == None )
		{
			PickRegDestination(bNoCharge);
			GoTo JL3879;
		}

		if ( TryToward(BestInv, BestWeight) )
			GoTo JL3879;

		if ( SecondInv == None )
		{
			PickRegDestination(bNoCharge);
			GoTo JL3879;
		}

		if ( TryToward(SecondInv, SecondWeight) )
			GoTo JL3879;

		PickRegDestination(bNoCharge);
JL3879:
	}

	function PickRegDestination(bool bNoCharge)
	{
		local vector pickdir, enemydir, enemyPart, X,Y,Z, minDest;
		local actor HitActor;
		local vector HitLocation, HitNormal, collSpec;
		local float Aggression, enemydist, minDist, strafeSize, optDist;
		local bool success, bNoReach;

		if ( Enemy == None || Enemy.Health < 1 || Enemy.bDeleteMe || Enemy == Self )
		{
			WhatToDoNext('','');
			GoTo JL4117;
		}

		if ( Orders == 'Hold' )
			bNoCharge = true;

		bChangeDir = false;
		if (Region.Zone.bWaterZone && !bCanSwim && bCanFly)
		{
			Destination = Location + 75 * (VRand() + vect(0,0,1));
			Destination.Z += 100;
			GoTo JL4117;
		}
		if ( Enemy.Region.Zone.bWaterZone )
			bNoCharge = bNoCharge || !bCanSwim;
		else 
			bNoCharge = bNoCharge || (!bCanFly && !bCanWalk);

		if( Weapon != None && Weapon.bMeleeWeapon && !bNoCharge )
		{
			GotoState('Charging');
			GoTo JL4117;
		}
		enemyDist = VSize(Location - Enemy.Location);
		if ( (bNovice && (FRand() > 0.3 + 0.15 * skill)) || (FRand() > 0.7 + 0.15 * skill) 
			&& ((EnemyDist > 900) || (Enemy.Weapon == None) || !Enemy.Weapon.bMeleeWeapon) 
			&& (!Level.Game.IsA('TeamGamePlus') || (TeamGamePlus(Level.Game).PriorityObjective(self) == 0)) )
			GiveUpTactical(true);

		success = false;
		if ( (bSniping || (Orders == 'Hold'))  
			&& (!Level.Game.IsA('TeamGamePlus') || (TeamGamePlus(Level.Game).PriorityObjective(self) == 0)) )
			bNoCharge = true;
		if ( bSniping && Weapon != None && /*Weapon.IsA('SniperRifle')*/ Weapon.bInstantHit )
		{
			bReadyToAttack = true;
			GotoState('RangedAttack');
			GoTo JL4117;
		}

		Aggression = 2 * (CombatStyle + FRand()) - 1.1;
		if ( Enemy != None && (AttitudeTo(Enemy) == ATTITUDE_Fear) && (CombatStyle > 0) )
			Aggression = Aggression - 2 - 2 * CombatStyle;
		if ( Weapon != None )
			Aggression += 2 * Weapon.SuggestAttackStyle();
		if ( Enemy.Weapon != None )
			Aggression += 2 * Enemy.Weapon.SuggestDefenseStyle();

		if ( enemyDist > 1000 )
			Aggression += 1;
		if ( !bNoCharge )
			bNoCharge = ( Aggression < FRand() );

		if ( (Physics == PHYS_Walking) || (Physics == PHYS_Falling) )
		{
			if (Location.Z > Enemy.Location.Z + 150) //tactical height advantage
				Aggression = FMax(0.0, Aggression - 1.0 + CombatStyle);
			else if (Location.Z < Enemy.Location.Z - CollisionHeight) // below enemy
			{
				if ( !bNoCharge && (Aggression > 0) && (FRand() < 0.6) )
				{
					GotoState('Charging');
					GoTo JL4117;
				}
				else if ( (enemyDist < 1.1 * (Enemy.Location.Z - Location.Z)) 
						&& !actorReachable(Enemy) ) 
				{
					bNoReach = true;
					aggression = -1.5 * FRand();
				}
			}
		}

		if (!bNoCharge && (Aggression > 2 * FRand()))
		{
			if ( bNoReach && (Physics != PHYS_Falling) )
			{
				TweenToRunning(0.1);
				GotoState('Charging', 'NoReach');
			}
			else
				GotoState('Charging');
			GoTo JL4117;
		}

		if ( !bNovice && ((Weapon == None) || !Weapon.bRecommendSplashDamage) && (FRand() < 0.35) && (bJumpy || (FRand()*Skill > 0.4)) )
		{
			GetAxes(Rotation,X,Y,Z);

			if ( FRand() < 0.5 )
			{
				Y *= -1;
				TryToDuck(Y, true);
			}
			else
				TryToDuck(Y, false);
			if ( !IsInState('TacticalMove') )
				GoTo JL4117;
		}

		if (enemyDist > FMax(VSize(OldLocation - Enemy.OldLocation), 240))
			Aggression += 0.4 * FRand();

		enemydir = (Enemy.Location - Location)/enemyDist;
		if ( bJumpy )
			minDist = 160;
		else
			minDist = FMin(160.0, 3*CollisionRadius);
		optDist = 80 + FMin(EnemyDist, 250 * (FRand() + FRand()));  
		Y = (enemydir Cross vect(0,0,1));
		if ( Physics == PHYS_Walking )
		{
			Y.Z = 0;
			enemydir.Z = 0;
		}
		else 
			enemydir.Z = FMax(0,enemydir.Z);

		strafeSize = FMax(-0.7, FMin(0.85, (2 * Aggression * FRand() - 0.3)));
		enemyPart = enemydir * strafeSize;
		strafeSize = FMax(0.0, 1 - Abs(strafeSize));
		pickdir = strafeSize * Y;
		if ( bStrafeDir )
			pickdir *= -1;
		bStrafeDir = !bStrafeDir;
		collSpec.X = CollisionRadius;
		collSpec.Y = CollisionRadius;
		collSpec.Z = FMax(6, CollisionHeight - 18);

		minDest = Location + minDist * (pickdir + enemyPart);
		HitActor = Trace(HitLocation, HitNormal, minDest, Location, false, collSpec);
		if (HitActor == None)
		{
			success = (Physics != PHYS_Walking);
			if ( !success )
			{
				collSpec.X = FMin(14, 0.5 * CollisionRadius);
				collSpec.Y = collSpec.X;
				HitActor = Trace(HitLocation, HitNormal, minDest - (18 + MaxStepHeight) * vect(0,0,1), minDest, false, collSpec);
				success = (HitActor != None);
			}
			if (success)
				Destination = minDest + (pickdir + enemyPart) * optDist;
		}

		if ( !success )
		{
			collSpec.X = CollisionRadius;
			collSpec.Y = CollisionRadius;
			minDest = Location + minDist * (enemyPart - pickdir); 
			HitActor = Trace(HitLocation, HitNormal, minDest, Location, false, collSpec);
			if (HitActor == None)
			{
				success = (Physics != PHYS_Walking);
				if ( !success )
				{
					collSpec.X = FMin(14, 0.5 * CollisionRadius);
					collSpec.Y = collSpec.X;
					HitActor = Trace(HitLocation, HitNormal, minDest - (18 + MaxStepHeight) * vect(0,0,1), minDest, false, collSpec);
					success = (HitActor != None);
				}
				if (success)
					Destination = minDest + (enemyPart - pickdir) * optDist;
			}
			else 
			{
				if ( (CombatStyle <= 0) || (Enemy != None && (AttitudeTo(Enemy) == ATTITUDE_Fear)) )
					enemypart = vect(0,0,0);
				else if ( (enemydir Dot enemyPart) < 0 )
					enemyPart = -1 * enemyPart;
				pickDir = Normal(enemyPart - pickdir + HitNormal);
				minDest = Location + minDist * pickDir;
				collSpec.X = CollisionRadius;
				collSpec.Y = CollisionRadius;
				HitActor = Trace(HitLocation, HitNormal, minDest, Location, false, collSpec);
				if (HitActor == None)
				{
					success = (Physics != PHYS_Walking);
					if ( !success )
					{
						collSpec.X = FMin(14, 0.5 * CollisionRadius);
						collSpec.Y = collSpec.X;
						HitActor = Trace(HitLocation, HitNormal, minDest - (18 + MaxStepHeight) * vect(0,0,1), minDest, false, collSpec);
						success = (HitActor != None);
					}
					if (success)
						Destination = minDest + pickDir * optDist;
				}
			}
		}

		if ( !success )
			GiveUpTactical(bNoCharge);
		else 
		{
			if ( bJumpy || ( Weapon != None && Weapon.bRecommendSplashDamage && !bNovice 
				&& (FRand() < 0.2 + 0.2 * Skill)
				&& (Enemy.Location.Z - Enemy.CollisionHeight <= Location.Z + MaxStepHeight - CollisionHeight)) 
				&& !NeedToTurn(Enemy.Location) )
			{
				FireWeapon();
				if ( (bJumpy && (FRand() < 0.75)) || Weapon.SplashJump() )
				{
					// try jump move
					SetPhysics(PHYS_Falling);
					Acceleration = vect(0,0,0);
					Destination = minDest;
					NextState = 'Attacking'; 
					NextLabel = 'Begin';
					NextAnim = 'Fighter';
					GotoState('FallingState');
					GoTo JL4117;
				}
			}
			pickDir = (Destination - Location);
			enemyDist = VSize(pickDir);
			if ( enemyDist > minDist + 2 * CollisionRadius )
			{
				pickDir = pickDir/enemyDist;
				HitActor = Trace(HitLocation, HitNormal, Destination + 2 * CollisionRadius * pickdir, Location, false);
				if ( (HitActor != None) && ((HitNormal Dot pickDir) < -0.6) )
					Destination = HitLocation - 2 * CollisionRadius * pickdir;
			}
		}
JL4117:
	}

	function BeginState()
	{
		if ( bNovice ) 
			MaxDesiredSpeed = 0.4 + 0.08 * skill;
		MinHitWall += 0.15;
		bAvoidLedges = true;
		bStopAtLedges = true;
		bCanJump = false;
		bCanFire = false;
	}

	function EndState()
	{
		if ( bNovice ) 
			MaxDesiredSpeed = 0.5 + 0.1 * skill;
		bAvoidLedges = false;
		bStopAtLedges = false;
		bQuickFire = false;
		MinHitWall -= 0.15;
		if (JumpZ > 0)
			bCanJump = true;
/*
Checker here
*/
		if ( Enemy == None || !LineOfSightTo(Enemy))
			HaltFiring();
	}

TacticalTick:
	Sleep(0.03); //Screw 0.02
Begin:
	TweenToRunning(0.15);
	Enable('AnimEnd');
	if ( Enemy == None || Enemy.Health < 1 || Enemy.bDeleteMe || Enemy == Self )
	{
		WhatToDoNext('','');
	}
	if (NeedToTurn(LastSeenPos))
	{
		PlayTurning();
		TurnTo(LastSeenPos);
	}
	if (Physics == PHYS_Falling)
	{
		DesiredRotation = Rotator(Enemy.Location - Location);
		Focus = Enemy.Location;
		Destination = Enemy.Location;
		WaitForLanding();
	}
	PickDestination(false);

DoMove:
	if ( !bCanStrafe )
	{ 
DoDirectMove:
		Enable('AnimEnd');
		if ( GetAnimGroup(AnimSequence) == 'MovingAttack' )
		{
			AnimSequence = '';
			TweenToRunning(0.12);
		}
		HaltFiring();
		MoveTo(Destination);
	}
	else
	{
DoStrafeMove:
		Enable('AnimEnd');
		bCanFire = true;
		StrafeFacing(Destination, Enemy);
	}

	if ( (Enemy != None) && !LineOfSightTo(Enemy) && FastTrace(Enemy.Location, LastSeeingPos) )
		Goto('RecoverEnemy');
	else
	{
		bReadyToAttack = true;
		GotoState('Attacking');
	}

NoCharge:
	TweenToRunning(0.1);
	Enable('AnimEnd');
	if (Physics == PHYS_Falling)
	{
		DesiredRotation = Rotator(Enemy.Location - Location);
		Focus = Enemy.Location;
		Destination = Enemy.Location;
		WaitForLanding();
	}
	PickDestination(true);
	Goto('DoMove');
	
AdjustFromWall:
	Enable('AnimEnd');
	StrafeTo(Destination, Focus); 
	Destination = Focus; 
	Goto('DoMove');

TakeHit:
	TweenToRunning(0.12);
	Goto('DoMove');

RecoverEnemy:
	Enable('AnimEnd');
	bReadyToAttack = true;
	HidingSpot = Location;
	bCanFire = false;
	Destination = LastSeeingPos + 4 * CollisionRadius * Normal(LastSeeingPos - Location);
	StrafeFacing(Destination, Enemy);

	if ( Weapon != None && !Weapon.bMeleeWeapon && LineOfSightTo(Enemy) && CanFireAtEnemy() )
	{
		Disable('AnimEnd');
		DesiredRotation = Rotator(Enemy.Location - Location);
		bQuickFire = true;
		FireWeapon();
		bQuickFire = false;
		Acceleration = vect(0,0,0);
		if ( Weapon.bSplashDamage )
		{
			bFire = 0;
			bAltFire = 0;
			bReadyToAttack = true;
			Sleep(0.2);
		}
		else
			Sleep(0.35 + 0.3 * FRand());
		if ( (FRand() + 0.1 > CombatStyle) )
		{
			bFire = 0;
			bAltFire = 0;
			bReadyToAttack = true;
			Enable('EnemyNotVisible');
			Enable('AnimEnd');
			Destination = HidingSpot + 4 * CollisionRadius * Normal(HidingSpot - Location);
			Goto('DoMove');
		}
	}
	GotoState('Attacking');
}

state Attacking
{
ignores SeePlayer, HearNoise, Bump, HitWall;

	function ChooseAttackMode()
	{
		local eAttitude AttitudeToEnemy;
		local float Aggression;
		local pawn changeEn;
		local TeamGamePlus TG;
		local bool bWillHunt;

		bWillHunt = bMustHunt;
		bMustHunt = false;
		if ((Enemy == None) || (Enemy.Health <= 0)
			|| ( Enemy.bHidden && !Enemy.bBlockActors )
				|| ( Enemy == Self) )
		{
			WhatToDoNext('','');
			GoTo JL4371;
		}
		if ( Level.Game.bGameEnded )
		{
			GotoState('GameEnded');
			GoTo JL4371;
		}
		if ( Weapon == None )
		{
			log(self.GetHumanName()$" health "$health$" had no weapon");
			SwitchToBestWeapon();
		}
		AttitudeToEnemy = AttitudeTo(Enemy);
		TG = TeamGamePlus(Level.Game);
		if ( TG != None )
		{
			if ( (Level.TimeSeconds - LastAttractCheck > 0.5)
				|| (AttitudeToEnemy == ATTITUDE_Fear)
				|| (TG.PriorityObjective(self) > 1) ) 
			{
				goalstring = "Attract check";
				if ( TG.FindSpecialAttractionFor(self) )
					GoTo JL4371;
				if ( Enemy == None )
				{
					WhatToDoNext('','');
					goalstring = "See WhatToDoNext";
					GoTo JL4371;
				}
			}
			else
			{
				goalstring = "No attract check";
			}
		}
		if (AttitudeToEnemy == ATTITUDE_Fear)
		{
			GotoState('Retreating');
			GoTo JL4371;
		}
		else if (AttitudeToEnemy == ATTITUDE_Friendly)
		{
			WhatToDoNext('','');
			GoTo JL4371;
		}
		else if ( !LineOfSightTo(Enemy) )
		{
			if ( (OldEnemy != None) 
				&& (AttitudeTo(OldEnemy) == ATTITUDE_Hate) && LineOfSightTo(OldEnemy) )
			{
				changeEn = enemy;
				enemy = oldenemy;
				oldenemy = changeEn;
			}
			else 
			{
				goalstring = " No see enemy ";
				if ( (TG != None) && TG.FindSpecialAttractionFor(self) )
					GoTo JL4371;
				if ( Enemy == None )
				{
					WhatToDoNext('','');
					GoTo JL4371;
				}
				if ( (Orders == 'Hold') && (Level.TimeSeconds - LastSeenTime > 5) )
				{
					NumHuntPaths = 0; 
					GotoState('StakeOut');
				}
				else if ( bWillHunt || (!bSniping && (VSize(Enemy.Location - Location) 
					> 600 + (FRand() * RelativeStrength(Enemy) - CombatStyle) * 600)) )
				{
					bDevious = ( !bNovice && !Level.Game.bTeamGame && Level.Game.IsA('DeathMatchPlus') 
						&& (FRand() < 0.52 - 0.12 * DeathMatchPlus(Level.Game).NumBots) );
					GotoState('Hunting');
				}
				else
				{
					NumHuntPaths = 0; 
					GotoState('StakeOut');
				}
				GoTo JL4371;
			}
		}

		if ( bReadyToAttack && ValidSight(Enemy) )
		{
			////log("Attack!");
			goalstring = "Set Target";
			Target = Enemy;
			if (Enemy.ReducedDamageType != '')
				Enemy.ReducedDamageType = '';
			SetTimer(TimeBetweenAttacks, False);
		}
		GotoState('TacticalMove');
JL4371:
	}

	//EnemyNotVisible implemented so engine will update LastSeenPos
	function EnemyNotVisible()
	{
		////log("enemy not visible");
	}

	function Timer()
	{
		bReadyToAttack = True;
	}

	function BeginState()
	{
		if ( TimerRate <= 0.0 )
			SetTimer(TimeBetweenAttacks  * (1.0 + FRand()),false); 
		if (Physics == PHYS_None)
			SetMovementPhysics(); 
	}

Begin:
	//log(class$" choose Attack");
	Sleep(0.00);
	ChooseAttackMode();
}

state Retreating
{
ignores EnemyNotVisible;

	function MayFall()
	{
		bAdvancedTactics = false;
		if ( bCanFire ) // MoveTarget is player, not destination
			bCanJump = ( (MoveTarget != None) 
						&& ((MoveTarget.Physics != PHYS_Falling) || !MoveTarget.IsA('Inventory')) );
	}

	function WarnTarget(Pawn shooter, float projSpeed, vector FireDir)
	{
		if ( bCanFire && (FRand() < 0.4) ) 
			GoTo JL4416;

		Super.WarnTarget(shooter, projSpeed, FireDir);
JL4416:
	}

	function SeePlayer(Actor SeenPlayer)
	{
		if (ValidSight(SeenPlayer))
		{
			if ( (SeenPlayer == Enemy) || LineOfSightTo(Enemy) )
			{
				LastSeenTime = Level.TimeSeconds;
				GoTo JL4434;
			}
			if ( SetEnemy(Pawn(SeenPlayer)) )
			{
				MakeNoise(1.0);
				GotoState('Attacking');
			}
		}
JL4434:
	}

	singular function HearNoise(float Loudness, Actor NoiseMaker)
	{
		if ( (NoiseMaker.instigator == Enemy) || LineOfSightTo(Enemy) )
			return;

		if ( SetEnemy(NoiseMaker.instigator) )
		{
			MakeNoise(1.0);
			GotoState('Attacking');
		}
	}
	
	function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
							Vector momentum, name damageType)
	{
		Global.TakeDamage(Damage, instigatedBy, hitlocation, momentum, damageType);
		if ( health <= 0 )
			return;
		if (NextState == 'TakeHit')
		{
			NextState = 'Retreating'; 
			NextLabel = 'TakeHit';
			GotoState('TakeHit'); 
		}
		else if ( !bCanFire && (skill > 3 * FRand()) )
			GotoState('Retreating', 'Moving');
	}

	function Timer()
	{
		bReadyToAttack = True;
		Enable('Bump');
	}

	function SetFall()
	{
		NextState = 'Retreating'; 
		NextLabel = 'Landed';
		NextAnim = AnimSequence;
		GotoState('FallingState'); 
	}

	function HitWall(vector HitNormal, actor Wall)
	{
		if (Physics == PHYS_Falling)
			GoTo JL5502;
		if ( Wall != None && Wall.IsA('Mover') && Mover(Wall).HandleDoor(self) )
		{
			if ( SpecialPause > 0 )
				Acceleration = vect(0,0,0);
			GotoState('Retreating', 'SpecialNavig');
			GoTo JL5502;
		}
		bTacticalDir = !bTacticalDir;
		Focus = Destination;
		if ( PickWallAdjust() && (FRand() < 0.7) )
		{
			bAdvancedTactics = false;
			if ( Physics == PHYS_Falling )
				SetFall();
			else
				GotoState('Retreating', 'AdjustFromWall');
		}
		else
			MoveTimer = -1.0;
JL5502:
	}

	function PickDestination()
	{
		local inventory Inv, BestInv, SecondInv;
		local float Bestweight, NewWeight, invDist, MaxDist, SecondWeight;
		local actor BestPath;
		local bool bTriedFar;

		if ( !bReadyToAttack && (TimerRate == 0.0) )
			SetTimer(0.7, false);

		// do I still fear my enemy?
		if ( (Level.TimeSeconds - LastSeenTime > 12)
			|| (Level.Game.bTeamGame && (Level.TimeSeconds - LastSeenTime > 8)) )
			Enemy = None;
		if ( (Enemy == None) || (AttitudeTo(Enemy) > ATTITUDE_Fear) )
		{
			GotoState('Attacking');
			GoTo JL4605;
		}

		bestweight = 0;

		//first look at nearby inventory < 500 dist
		MaxDist = 500 + 70 * skill;
		foreach visiblecollidingactors(class'Inventory', Inv, MaxDist,,true)
			if ( (Inv.IsInState('PickUp')) && (Inv.MaxDesireability/200 > BestWeight)
				&& (Inv.Location.Z < Location.Z + MaxStepHeight + CollisionHeight)
				&& (Inv.Location.Z > FMin(Location.Z, Enemy.Location.Z) - CollisionHeight) )
			{
				NewWeight = inv.BotDesireability(self)/VSize(Inv.Location - Location);
				if ( NewWeight > BestWeight )
				{
					SecondWeight = BestWeight;
					BestWeight = NewWeight;
					SecondInv = BestInv;
					BestInv = Inv;
				}
			}

		 // see if better long distance inventory 
		if ( BestWeight < 0.001 )
		{ 
			bTriedFar = true;
			BestPath = FindBestInventoryPath(BestWeight, false);
			if ( Level.Game.bTeamGame && (BestWeight < 0.0002) )
			{
				if ( !Enemy.IsA('TeamCannon') && (Enemy.Location.Z < Location.Z + 500) )
				{
					bKamikaze = true;
					if ( LineOfSightTo(Enemy) )
					{
						LastInvFind = Level.TimeSeconds;
						GotoState('TacticalMove', 'NoCharge');
						GoTo JL4605;
					}
				}
				else if ( TeamGamePlus(Level.Game) != None && TeamGamePlus(Level.Game).SendBotToGoal(self) )
					GoTo JL4605;
			}
			if ( BestPath != None )
			{
				//GoalString = string(1000 * BestWeight);
				MoveTarget = BestPath;
				GoTo JL4605;
			}
		}

		if ( (BestInv != None) && ActorReachable(BestInv) )
		{
			MoveTarget = BestInv;
			GoTo JL4605;
		}

		if ( (SecondInv != None) && ActorReachable(SecondInv) )
		{
			MoveTarget = SecondInv;
			GoTo JL4605;
		}
		if ( !bTriedFar )
		{ 
			BestWeight = 0;
			BestPath = FindBestInventoryPath(BestWeight, false);
			if ( BestPath != None )
			{
				MoveTarget = BestPath;
				GoTo JL4605;
			}
		}
		if ( bVerbose )
			log(self$" give up retreat");

		// if nothing, then tactical move
		if ( LineOfSightTo(Enemy) )
		{
			LastInvFind = Level.TimeSeconds;
			bKamikaze = true;
			GotoState('TacticalMove', 'NoCharge');
			GoTo JL4605;
		}
		WhatToDoNext('','');
JL4605:
	}

	function ChangeDestination()
	{
		local actor oldTarget;
		local Actor path;

		oldTarget = Home;
		PickDestination();
		if (Home == oldTarget)
		{
			bKamikaze = true;
			//log("same old target");
			GotoState('TacticalMove', 'TacticalTick');
		}
		else
		{
			path = FindPathToward(Home);
			if (path == None)
			{
				//log("no new target");
				bKamikaze = true;
				GotoState('TacticalMove', 'TacticalTick');
			}
			else 
			{
				MoveTarget = path;
				Destination = path.Location;
			}
		}
	}

	function bool CheckBumpAttack(Pawn Other)
	{
		if ( (Other == Enemy) && (((Other.Location - Location) Dot Velocity) > 0) )
			bKamikaze = true;

		if ( SetEnemy(Other) && (Enemy == Other) && (Weapon != None) && !Weapon.bMeleeWeapon )
		{
			bReadyToAttack = true;
			GotoState('RangedAttack');
			return true;
		}
		return false;
	}

	function ReachedHome()
	{
		if (LineOfSightTo(Enemy))
		{
			if (Homebase(home) != None)
			{
				//log(class$" reached home base - turn and fight");
				bKamikaze = true;
				MakeNoise(1.0);
				GotoState('Attacking');
			}
			else
				ChangeDestination();
		}
		else
		{
			if (Homebase(home) != None)
				MakeNoise(1.0);
			bKamikaze = true;
			GotoState('Attacking');
		}
	}

	function PickNextSpot()
	{
		local Actor path;
		local vector dist2d;
		local float zdiff;

		if ( Home == None )
		{
			PickDestination();
			if ( Home == None )
				GoTo JL4718;
		}
		//log("find retreat spot");
		dist2d = Home.Location - Location;
		zdiff = dist2d.Z;
		dist2d.Z = 0.0;
		if ((VSize(dist2d) < 2 * CollisionRadius) && (Abs(zdiff) < CollisionHeight))
			ReachedHome();
		else
		{
			if (ActorReachable(Home))
			{
				//log("almost there");
				path = Home;
				if (HomeBase(Home) == None)
					Home = None;
			}
			else
			{
				if (SpecialGoal != None)
					path = FindPathToward(SpecialGoal);
				else
					path = FindPathToward(Home);
			}

			if (path == None)
				ChangeDestination();
			else
			{
				MoveTarget = path;
				Destination = path.Location;
			}
		}
JL4718:
	}

	function AnimEnd() 
	{
		if ( bCanFire && LineOfSightTo(Enemy) )
			PlayCombatMove();
		else if ( (Physics == PHYS_Falling) && (Velocity.Z < -300) )
			FastInAir();
		else
			PlayRunning();
	}

	function BeginState()
	{
		if ( Level.Game.bTeamGame && !Enemy.IsA('StationaryPawn') )
			CallForHelp();
		bSpecialPausing = false;
		bCanFire = false;
		SpecialGoal = None;
		SpecialPause = 0.0;
	}

	function EndState()
	{
		bAdvancedTactics = false;
	}

Begin:
	if ( bReadyToAttack && (FRand() < 0.4 - 0.1 * Skill) )
		bReadyToAttack = false;
	if ( (TimerRate == 0.0) || !bReadyToAttack )
		SetTimer(TimeBetweenAttacks, false);
	TweenToRunning(0.1);
	WaitForLanding();

RunAway:
	PickDestination();
	bAdvancedTactics = ( !bNovice && (Level.TimeSeconds - LastSeenTime < 1.0) 
						&& (Skill > 2.5 * FRand() - 1)
						&& (!MoveTarget.IsA('NavigationPoint') || !NavigationPoint(MoveTarget).bNeverUseStrafing) );
SpecialNavig:
	if (SpecialPause > 0.0)
	{
		if ( Enemy != None )
		{
			if ( LineOfSightTo(Enemy) )
			{
				if ( ((Base == None) || (Base == Level))
					&& (FRand() < 0.6) )
					GotoState('TacticalMove', 'NoCharge');
				Target = Enemy;
				bFiringPaused = true;
				NextState = 'Retreating';
				NextLabel = 'RunAway';
				GotoState('RangedAttack');
			}
			else //Added
			{
				if (Weapon != None)
				{
					if ( bFire==1 || bAltFire==1 )
					HaltFiring();
				}
			}
		}
		Disable('AnimEnd');
		Acceleration = vect(0,0,0);
		TweenToPatrolStop(0.3);
		Sleep(SpecialPause);
		SpecialPause = 0.0;
		Enable('AnimEnd');
		TweenToRunning(0.1);
		Goto('RunAway');
	}
Moving:
	if ( !IsAnimating() )
		AnimEnd();
	if ( MoveTarget == None )
	{
		Sleep(0.0);
		Goto('RunAway');
	}
	if ( MoveTarget.IsA('InventorySpot') && (InventorySpot(MoveTarget).markedItem != None) 
		&& (InventorySpot(MoveTarget).markedItem.GetStateName() == 'Pickup')
		&& (InventorySpot(MoveTarget).markedItem.BotDesireability(self) > 0) )
			MoveTarget = InventorySpot(MoveTarget).markedItem;
	if ( FaceDestination(2) )
	{
		HaltFiring();
		MoveToward(MoveTarget);
	}
	else
	{
		bCanFire = true;
		if (Enemy != None)
			StrafeFacing(MoveTarget.Location, Enemy);
	}
	Goto('RunAway');

Landed:
	if ( MoveTarget == None )
		Goto('RunAway');
	Goto('Moving');

TakeHit:
	TweenToRunning(0.12);
	Goto('Moving');

AdjustFromWall:
	if ( !IsAnimating() )
		AnimEnd();
	StrafeTo(Destination, Focus); 
	Destination = Focus; 
	MoveTo(Destination);
	Goto('Moving');
}

state Fallback
{
ignores EnemyNotVisible;

	function MayFall()
	{
		bAdvancedTactics = false;
		bCanJump = ( (MoveTarget != None) 
				&& ((MoveTarget.Physics != PHYS_Falling) || !MoveTarget.IsA('Inventory')) );
	}

	function EnemyNotVisible()
	{
		local Pawn P;

		if ( (OldEnemy != None) && LineOfSightTo(OldEnemy) )
		{
			P = OldEnemy;
			OldEnemy = Enemy;
			Enemy = P;
		}
		if ( Enemy != None && TeamCannon(Enemy) != None )
		{
			Enemy = OldEnemy;
			OldEnemy = None;
			if ( Enemy == None )
				GotoState('Roaming');
		}
	}

	function SeePlayer(Actor SeenPlayer)
	{
		if(ValidSight(SeenPlayer))
		{
			if ( SeenPlayer == Enemy )
			{
				LastSeenTime = Level.TimeSeconds;
				GoTo JL4878;
			}
			if ( SetEnemy(Pawn(SeenPlayer)) )
				MakeNoise(1.0);
		}
JL4878:
	}

	singular function HearNoise(float Loudness, Actor NoiseMaker)
	{
		if ( (NoiseMaker.instigator == Enemy) || LineOfSightTo(Enemy) )
			GoTo JL4791;

		if ( SetEnemy(NoiseMaker.instigator) )
		{
			LastSeenPos = 0.5 * (NoiseMaker.Location + VSize(NoiseMaker.Location - Location) * vector(Rotation));
			MakeNoise(1.0);
		}
JL4791:
	}

	function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
							Vector momentum, name damageType)
	{
		Global.TakeDamage(Damage, instigatedBy, hitlocation, momentum, damageType);
		if ( health <= 0 )
			GoTo JL4908;
		if (NextState == 'TakeHit')
		{
			NextState = 'Fallback'; 
			NextLabel = 'TakeHit';
			GotoState('TakeHit'); 
		}
		else if ( !bCanFire && (skill > 3 * FRand()) )
			GotoState('Fallback', 'Moving');
JL4908:
	}

	function Timer()
	{
		bReadyToAttack = True;
		Enable('Bump');
	}

	function SetFall()
	{
		NextState = 'Fallback'; 
		NextLabel = 'Landed';
		NextAnim = AnimSequence;
		GotoState('FallingState'); 
	}

	function HitWall(vector HitNormal, actor Wall)
	{
		if (Physics == PHYS_Falling)
			GoTo JL4947;
		if ( Wall.IsA('Mover') && Mover(Wall).HandleDoor(self) )
		{
			if ( SpecialPause > 0 )
				Acceleration = vect(0,0,0);
			GotoState('Fallback', 'SpecialNavig');
			GoTo JL4947;
		}
		Focus = Destination;
		if (PickWallAdjust())
		{
			bAdvancedTactics = false;
			if ( Physics == PHYS_Falling )
				SetFall();
			else
				GotoState('Fallback', 'AdjustFromWall');
		}
		else
			MoveTimer = -1.0;
JL4947:
	}

	function PickDestination()
	{
		local byte TeamPriority;

		if ( Level.TimeSeconds - LastSeenTime > 9 )
			Enemy = None;
		if ( Enemy == None )
		{
			WhatToDoNext('','');
			GoTo JL5026;
		}
		bCanTranslocate = ( Level.Game.IsA('DeathMatchPlus') && DeathMatchPlus(Level.Game).CanTranslocate(self) );
		LastAttractCheck = Level.TimeSeconds - 0.1;

		if ( TeamGamePlus(Level.Game) != None
			&& TeamGamePlus(Level.Game).FindSpecialAttractionFor(self) )
		{
			if ( IsInState('Fallback') )
			{
				TeamPriority = TeamGamePlus(Level.Game).PriorityObjective(self);
				if ( TeamPriority > 16 )
				{
					PickLocalInventory(160, 1.8);
					GoTo JL5026;
				}
				else if ( TeamPriority > 1 )
				{
					PickLocalInventory(200, 1);
					GoTo JL5026;
				}
				else if ( TeamPriority > 0 )
				{
					PickLocalInventory(250, 0.55);
					GoTo JL5026;
				}
				PickLocalInventory(400, 0.5);
				if ( MoveTarget == None )
				{
					if ( bVerbose )
						log(self.GetHumanName()$" no destination in fallback!");
					Orders = 'Freelance';
					GotoState('Attacking');
				}
			}
			GoTo JL5026;
		}
		else if ( (Orders == 'Attack') || (OrderObject == None) )
		{
			if ( bVerbose )
				log(self.GetHumanName()$" attack fallback turned to freelance");
			Orders = 'Freelance';
			GotoState('Attacking');
		}
		else if ( (VSize(Location - OrderObject.Location) < 20)
			|| ((VSize(Location - OrderObject.Location) < 600) && LineOfSightTo(OrderObject)) )
		{
			if ( Enemy.IsA('TeamCannon') || ((Level.TimeSeconds - LastSeenTime > 5) && (Orders == 'Hold')) )
			{
				Enemy = OldEnemy;
				OldEnemy = None;
			}
			GotoState('Attacking');
		}
		else if ( ActorReachable(OrderObject) )
			MoveTarget = OrderObject;
		else
		{
			MoveTarget = FindPathToward(OrderObject);
			if ( MoveTarget == None )
			{
				if ( bVerbose )
					log(self.GetHumanName()@"fallback turned to freelance (no path to"@OrderObject@")");
				Orders = 'Freelance';
				GotoState('Attacking');
			}
		}
JL5026:
	}

	function bool CheckBumpAttack(Pawn Other)
	{
		SetEnemy(Other);
		if (Enemy != None && Enemy == Other )
		{
			bReadyToAttack = true;
			bCanFire = true;
		}
		return false;
	}

	function AnimEnd() 
	{
		if ( bCanFire && LineOfSightTo(Enemy) )
			PlayCombatMove();
		else
		{
			bFire = 0;
			bAltFire = 0;
			if ( (Physics == PHYS_Falling) && (Velocity.Z < -300) )
				FastInAir();
			else
				PlayRunning();
		}
	}

	function BeginState()
	{
		if (bVerbose)
			log(self.GetHumanName()$" fallback");
		bCanFire = false;
		if ( bNoClearSpecial )
			bNoClearSpecial = false;
		else
		{
			bSpecialPausing = false;
			SpecialGoal = None;
			SpecialPause = 0.0;
		}
	}

	function EndState()
	{
		bAdvancedTactics = false;
		bCanTranslocate = false;
	}

Begin:
	TweenToRunning(0.12);
	WaitForLanding();

RunAway:
	PickDestination();
	bAdvancedTactics = ( !bNovice && (Level.TimeSeconds - LastSeenTime < 1.0) 
					&& (Skill > 2.5 * FRand() - 1)
					&& (!MoveTarget.IsA('NavigationPoint') || !NavigationPoint(MoveTarget).bNeverUseStrafing) );
SpecialNavig:
	if (SpecialPause > 0.0)
	{
		if ( LineOfSightTo(Enemy) )
		{
			Target = Enemy;
			bFiringPaused = true;
			NextState = 'Fallback';
			NextLabel = 'RunAway';
			GotoState('RangedAttack');
		}
		Disable('AnimEnd');
		Acceleration = vect(0,0,0);
		TweenToPatrolStop(0.3);
		Sleep(SpecialPause);
		SpecialPause = 0.0;
		Enable('AnimEnd');
		TweenToRunning(0.1);
		Goto('RunAway');
	}
Moving:
	if ( !IsAnimating() )
		AnimEnd();

	if ( MoveTarget == None )
	{
		Sleep(0.0);
		Goto('RunAway');
	}
	if ( FaceDestination(1) )
	{
		HaltFiring();
		MoveToward(MoveTarget);
	}
	else
	{
		bReadyToAttack = True;
		bCanFire = true;
		StrafeFacing(MoveTarget.Location, Enemy);
	}
	Goto('RunAway');

Landed:
	if ( MoveTarget == None )
		Goto('RunAway');
	Goto('Moving');

TakeHit:
	TweenToRunning(0.12);
	Goto('Moving');

AdjustFromWall:
	if ( !IsAnimating() )
		AnimEnd();
	StrafeTo(Destination, Focus); 
	Destination = Focus; 
	MoveTo(Destination);
	Goto('Moving');
}

state RangedAttack
{
ignores SeePlayer, HearNoise, Bump;

	function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
	{
		Global.TakeDamage(Damage, instigatedBy, hitlocation, momentum, damageType);
		if ( health <= 0 )
			GoTo JL5162;
		if (NextState == 'TakeHit')
		{
			bComboPaused = False;
			bFiringPaused = False;
			NextState = 'RangedAttack';
			NextLabel = 'Begin';
		}
JL5162:
	}

	function StopFiring()
	{
		goalstring = "Hold Fire";
		Super.StopFiring();
		GotoState('Attacking');
	}

	function StopWaiting()
	{
		Timer();
	}

	function EnemyNotVisible()
	{
		// log("enemy not visible");
		// let attack animation complete
		if ( Enemy == None )
		{
			bComboPaused = False;
			bFiringPaused = False;
		}
		if ( bComboPaused || bFiringPaused )
			GoTo JL5195;
		if ( (Weapon == None) || (Weapon != None && Weapon.bMeleeWeapon )
			|| (FRand() < 0.13) )
		{
			bReadyToAttack = true;
			GotoState('Attacking');
			GoTo JL5195;
		}
JL5195:
	}

	function KeepAttacking()
	{
		local TranslocatorTarget T;
		local int BaseSkill;

		if ( bComboPaused || bFiringPaused )
		{
			if ( TimerRate <= 0.0 )
			{
				TweenToRunning(0.12);
				GotoState(NextState, NextLabel);
			}
			if ( bComboPaused )
				GoTo JL5254;

			T = TranslocatorTarget(Target);
			if ( (T != None) && !T.Disrupted() && LineOfSightTo(T) )
				GoTo JL5254;
			if ( (Enemy == None) || ( Enemy != None && ( Enemy.Health <= 0 || !LineOfSightTo(Enemy) ) ) )
			{
				bFire = 0;
				bAltFire = 0; 
				TweenToRunning(0.12);
				GotoState(NextState, NextLabel);
			}
		}
		if ( (Enemy == None) || ( Enemy != None && ( Enemy.Health <= 0 || !LineOfSightTo(Enemy) ) ) )
		{
			bFire = 0;
			bAltFire = 0; 
			GotoState('Attacking');
			GoTo JL5254;
		}
		if ( Weapon != None && Weapon.bMeleeWeapon )
		{
			bReadyToAttack = true;
			GotoState('TacticalMove');
			GoTo JL5254;
		}
		BaseSkill = Skill;
/*
		if ( !bNovice )
			BaseSkill += 3;
		if ( (Enemy.Weapon != None) && Enemy.Weapon.bMeleeWeapon 
			&& (VSize(Enemy.Location - Location) < 500) )
			BaseSkill += 3;
Let's say that I don't like this problem
If situation is often, I guess they are about to go over-skilled like hell
BYE BYE!
*/
		if ( (BaseSkill > 3 * FRand() + 2)
			|| ((bFire == 0) && (bAltFire == 0) && (BaseSkill > 6 * FRand() - 1)) )
		{
			bReadyToAttack = true;
			GotoState('TacticalMove');
		}
JL5254:
	}

	function Timer()
	{
		if (Enemy == None)
		{
			bComboPaused = False;
			bFiringPaused = False;
			SpecialPause = 0;
			WhatToDoNext('','');
			GoTo JL5272;
		}
		if ( bComboPaused || bFiringPaused )
		{
			TweenToRunning(0.12);
			GotoState(NextState, NextLabel);
		}
JL5272:
	}

	function AnimEnd()
	{
		local float decision;

		if ( ( Weapon == None ) || (Weapon != None && Weapon.bMeleeWeapon)
			|| ((bFire == 0) && (bAltFire == 0)) )
		{
			GotoState('Attacking');
			GoTo JL5295;
		}
		decision = FRand() - 0.2 * skill;
		if ( !bNovice )
			decision -= 0.5;
		if ( decision < 0 )
			GotoState('RangedAttack', 'DoneFiring');
		else
		{
			PlayWaiting();
			FireWeapon();
		}
JL5295:
	}

	// ASMD combo move
	function SpecialFire()
	{
		if ( Enemy == None || Weapon == None )
			GoTo JL5309;

		bComboPaused = true;
		goalstring = "Attempt Nice Combo";
		SetTimer(0.75 + VSize(Enemy.Location - Location)/Weapon.AltProjectileSpeed, false);
		SpecialPause = 0.0;
		NextState = 'Attacking';
		NextLabel = 'Begin';
JL5309:
	}

	function BeginState()
	{
		Disable('AnimEnd');
		if ( bComboPaused || bFiringPaused )
		{
			SetTimer(SpecialPause, false);
			SpecialPause = 0;
		}
		else
			{
				if ( Enemy != None )
					Target = Enemy;
			}
	}

	function EndState()
	{
		bFiringPaused = false;
		bComboPaused = false;
	}

Challenge:
	Disable('AnimEnd');
	Acceleration = vect(0,0,0); //stop
	if ( Enemy != None )
		DesiredRotation = Rotator(Enemy.Location - Location);
	PlayChallenge();
	FinishAnim();
	TweenToFighter(0.1);
	Goto('FaceTarget');

Begin:
	if ( Enemy != None )
	{
		Target = Enemy;
		if ( Target == None )
			GotoState('Attacking');
	}
	Acceleration = vect(0,0,0); //stop
	if ( Target != None )
		DesiredRotation = Rotator(Target.Location - Location);
	TweenToFighter(0.16 - 0.2 * Skill);

FaceTarget:
	Disable('AnimEnd');
	if ( Target != None )
	if ( NeedToTurn(Target.Location) )
	{
		PlayTurning();
		TurnToward(Target);
		TweenToFighter(0.1);
	}
	FinishAnim();

ReadyToAttack:
	if (Target != None)
		DesiredRotation = Rotator(Target.Location - Location);
	PlayRangedAttack();
	if ( Weapon != None && Weapon.bMeleeWeapon )
		GotoState('Attacking');
	Enable('AnimEnd');
Firing:
	if ( Target == None )
		GotoState('Attacking');
	goalstring = "Want fire";
	TurnToward(Target);
	Goto('Firing');
DoneFiring:
	goalstring = "Done Firing";
	Disable('AnimEnd');
	KeepAttacking();  
	Goto('FaceTarget');
}

state Hunting
{
ignores EnemyNotVisible; 

	/* MayFall() called by engine physics if walking and bCanJump, and
		is about to go off a ledge.  Pawn has opportunity (by setting 
		bCanJump to false) to avoid fall
	*/
	function MayFall()
	{
		bCanJump = ( ((MoveTarget != None) 
					&& ((MoveTarget.Physics != PHYS_Falling) || !MoveTarget.IsA('Inventory')))
					|| PointReachable(Destination) );
	}

	function bool CheckBumpAttack(Pawn Other)
	{
		SetEnemy(Other);
		if ( Enemy != None && Enemy == Other )
		{
			bReadyToAttack = true;
			LastSeenTime = Level.TimeSeconds;
			LastSeenPos = Enemy.Location;
			GotoState('Attacking');
			return true;
		}
		return false;
	}

	function FearThisSpot(Actor aSpot)
	{
		Destination = Location + 120 * Normal(Normal(Destination - Location) + Normal(Location - aSpot.Location)); 
		MoveTarget = None;
		GotoState('Hunting', 'SpecialNavig');
	}

	function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
							Vector momentum, name damageType)
	{
		Global.TakeDamage(Damage, instigatedBy, hitlocation, momentum, damageType);
		if ( health <= 0 )
			GoTo JL5443;
		bFrustrated = true;
		if (NextState == 'TakeHit')
		{
			if (AttitudeTo(Enemy) == ATTITUDE_Fear)
			{
				NextState = 'Retreating';
				NextLabel = 'Begin';
			}
			else
			{
				NextState = 'Hunting';
				NextLabel = 'AfterFall';
			}
			GotoState('TakeHit'); 
		}
JL5443:
	}

	singular function HearNoise(float Loudness, Actor NoiseMaker)
	{
		SetEnemy(NoiseMaker.instigator);
	}

	function SetFall()
	{
		NextState = 'Hunting'; 
		NextLabel = 'AfterFall';
		NextAnim = AnimSequence;
		GotoState('FallingState'); 
	}

	function bool SetEnemy(Pawn NewEnemy)
	{
		local float rnd;

		if (Global.SetEnemy(NewEnemy))
		{
			bDevious = false;
			BlockedPath = None;
			rnd = FRand();
			bReadyToAttack = true;
			DesiredRotation = Rotator(Enemy.Location - Location);
			if ( CombatStyle > FRand() )
				GotoState('Charging'); 
			else
				GotoState('Attacking');
			return true;
		}
		return false;
	} 

	function AnimEnd()
	{
		bFire = 0;
		bAltFire = 0;
		bReadyToAttack = true;
		if ( (Physics == PHYS_Falling) && (Velocity.Z < -300) )
			FastInAir();
		else
		{
			PlayRunning();
			Disable('AnimEnd');
		}
	}
	
	function Timer()
	{
		if (Enemy == None)
		{
			WhatToDoNext('','');
			GoTo JL5503;
		}
		bReadyToAttack = true;
		Enable('Bump');
		SetTimer(1.0, false);
JL5503:
	}

	function HitWall(vector HitNormal, actor Wall)
	{
		if ( Physics == PHYS_Falling )
			GoTo JL5527;
		if ( Wall.IsA('Mover') && Mover(Wall).HandleDoor(self) )
		{
			if ( SpecialPause > 0 )
				Acceleration = vect(0,0,0);
			GotoState('Hunting', 'SpecialNavig');
			GoTo JL5527;
		}
		Focus = Destination;
		if (PickWallAdjust())
		{
			if ( Physics == PHYS_Falling )
				SetFall();
			else
				GotoState('Hunting', 'AdjustFromWall');
		}
		else
			MoveTimer = -1.0;
JL5527:
	}

	function bool TryToward(inventory Inv, float Weight)
	{
		local bool success; 
		local vector pickdir, collSpec, minDest, HitLocation, HitNormal;
		local Actor HitActor;

		pickdir = Inv.Location - Location;
		if ( Physics == PHYS_Walking )
			pickDir.Z = 0;
		pickDir = Normal(PickDir);

		collSpec.X = CollisionRadius;
		collSpec.Y = CollisionRadius;
		collSpec.Z = FMax(6, CollisionHeight - 18);

		minDest = Location + FMin(160.0, 3*CollisionRadius) * pickDir;
		HitActor = Trace(HitLocation, HitNormal, minDest, Location, false, collSpec);
		if (HitActor == None)
		{
			success = (Physics != PHYS_Walking);
			if ( !success )
			{
				collSpec.X = FMin(14, 0.5 * CollisionRadius);
				collSpec.Y = collSpec.X;
				HitActor = Trace(HitLocation, HitNormal, minDest - (18 + MaxStepHeight) * vect(0,0,1), minDest, false, collSpec);
				success = (HitActor != None);
			}
			if ( success )
			{
				MoveTarget = Inv;
				return true;
			}
		}

		return false;
	}

	function PickDestination()
	{
		local inventory Inv, BestInv, SecondInv;
		local float Bestweight, NewWeight, MaxDist, SecondWeight;
		local NavigationPoint path;
		local actor HitActor;
		local vector HitNormal, HitLocation, nextSpot, ViewSpot;
		local float posZ;
		local bool bCanSeeLastSeen;
		local int i;

		//If no enemy, or I should see him but don't, then give up
		if ( Enemy != None )
		{
			if ( DeathMatchPlus(Level.Game) != None 
			&& Level.TimeSeconds - LastSeenTime > 26 - Level.Game.NumPlayers - DeathMatchPlus(Level.Game).NumBots ) //LastSeenTime called for Who ????
			{
				Enemy = None;
			}
		}

		if ( Enemy == None || ( Enemy != None && Enemy.Health <= 0 ) || Enemy.bDeleteMe )
		{
			Enemy = None;
			WhatToDoNext('','');
			GoTo JL5772;
		}
//------------- Should not be a problem then if we call an enemy later.
		bAvoidLedges = false;
		if ( JumpZ > 0 )
			bCanJump = true;
		if ( ActorReachable(Enemy) )
		{
			BlockedPath = None;
			if ( (numHuntPaths < 8 + Skill) || (Level.TimeSeconds - LastSeenTime < 15)
				|| ((Normal(Enemy.Location - Location) Dot vector(Rotation)) > -0.5) )
			{
				Destination = Enemy.Location;
				MoveTarget = None;
				numHuntPaths++;
				goalstring = "Hunt an Reachable Enemy";
			}
			else
				WhatToDoNext('','');
			GoTo JL5772;
		}

		if ( Level.TimeSeconds - LastInvFind > 2.5 - 0.4 * skill && Enemy != None )
		{
			LastInvFind = Level.TimeSeconds;
			MaxDist = 600 + 70 * skill;
			BestWeight = 0.6/MaxDist;
			foreach visiblecollidingactors(class'Inventory', Inv, MaxDist,, true)
				if ( Inv != None && (Inv.IsInState('PickUp')) && (Inv.MaxDesireability/200 > BestWeight)
					&& (Inv.Location.Z < Location.Z + MaxStepHeight + CollisionHeight)
					&& (Inv.Location.Z > FMin(Location.Z, Enemy.Location.Z) - CollisionHeight) )
				{
					NewWeight = inv.BotDesireability(self)/VSize(Inv.Location - Location);
					if ( NewWeight > BestWeight )
					{
						SecondWeight = BestWeight;
						BestWeight = NewWeight;
						SecondInv = BestInv;
						BestInv = Inv;
						goalstring = "Hunting and gain Inventory";
					}
				}
			if ( BestInv != None )
			{
				if ( TryToward(BestInv, BestWeight) )
					GoTo JL5772;
				if ( (SecondInv != None) && TryToward(SecondInv, SecondWeight) )
					GoTo JL5772;
			}
		}
		numHuntPaths++;
		ViewSpot = Location + BaseEyeHeight * vect(0,0,1);
		bCanSeeLastSeen = false;
		bCanSeeLastSeen = FastTrace(LastSeenPos, ViewSpot);
		if ( bCanSeeLastSeen )
			bHunting = !FastTrace(LastSeenPos, Enemy.Location);
		else
			bHunting = true;
		bCanTranslocate = ( Level.Game.IsA('DeathMatchPlus') && DeathMatchPlus(Level.Game).CanTranslocate(self) );
		if ( bDevious )
		{
			if ( BlockedPath == None )
			{
				// block the first path visible to the enemy
				if ( FindPathToward(Enemy) != None )
				{
					for ( i=0; i<16; i++ )
					{
						if ( RouteCache[i] == None )
							break;
						else if ( Enemy.LineOfSightTo(RouteCache[i]) )
						{
							BlockedPath = RouteCache[i];
							break;
						}
					}
				}
				else if ( CanStakeOut() )
				{
					GotoState('StakeOut');
					GoTo JL5772;
				}
				else
				{
					WhatToDoNext('', '');
					GoTo JL5772;
				}
			}
			// control path weights
//			ClearPaths(); //I'll check what the heck does this. I hope it is not bugged but I have doubts
			if ( BlockedPath != None )
				BlockedPath.Cost = 1500;
//Added these
//My problem: If there is a fucking path to enemy just stop bullshiting at walls and track enemy, ASHOLE...
			MoveTarget = FindPathTo(Enemy.Location);
			if ( MoveTarget != None ) GoTo JL5772;
//End of add
			if ( FindBestPathToward(Enemy, false) )
				GoTo JL5772;
		}
		else
		{
			MoveTarget = FindPathTo(Enemy.Location+vect(0,0,-5));
			if ( MoveTarget != None )
			{
//				log( Self.GetHumanName()$" > I found a path to enemy "$Enemy.GetHumanName() );
				GoTo JL5772;
			}
			if ( FindBestPathToward(Enemy, false) ) //Changed to False before to look retarded
				GoTo JL5772;
		}

		MoveTarget = None;
		if ( bFromWall )
		{
			bFromWall = false;
			if ( !PickWallAdjust() )
			{
				if ( CanStakeOut() )
					GotoState('StakeOut');
				else
					WhatToDoNext('', '');
			}
			GoTo JL5772;
		}

		if ( (NumHuntPaths > 60) && (bNovice || !Level.Game.IsA('DeathMatchPlus') || !DeathMatchPlus(Level.Game).OneOnOne()) )
		{
			WhatToDoNext('', '');
			GoTo JL5772;
		}

		if ( LastSeeingPos != vect(1000000,0,0) )
		{
			Destination = LastSeeingPos;
			LastSeeingPos = vect(1000000,0,0);
			if ( FastTrace(Enemy.Location, ViewSpot) )
			{
				If (VSize(Location - Destination) < 20)
				{
					SetEnemy(Enemy);
					GoTo JL5772;
				}
				GoTo JL5772;
			}
		}
		bAvoidLedges = (CollisionRadius > 42);
		posZ = LastSeenPos.Z + CollisionHeight - Enemy.CollisionHeight;
		nextSpot = LastSeenPos - Normal(Enemy.Location - Enemy.OldLocation) * CollisionRadius;
		nextSpot.Z = posZ;
		if ( FastTrace(nextSpot, ViewSpot) )
			Destination = nextSpot;
		else if ( bCanSeeLastSeen )
			Destination = LastSeenPos;
		else
		{
			Destination = LastSeenPos;
			if ( !FastTrace(LastSeenPos, ViewSpot) )
			{
				// check if could adjust and see it
				if ( PickWallAdjust() || FindViewSpot() )
				{
					if ( Physics == PHYS_Falling )
					SetFall();
					else
						GotoState('Hunting', 'AdjustFromWall');
				}
				else if ( VSize(Enemy.Location - Location) < 1200 )
				{
					GotoState('StakeOut');
					GoTo JL5772;
				}
				else
				{
					WhatToDoNext('Waiting', 'TurnFromWall');
					GoTo JL5772;
				}
			}
		}
		LastSeenPos = Enemy.Location;
JL5772:
	}

	function bool FindViewSpot()
	{
		local vector X,Y,Z;
		local bool bAlwaysTry;

		GetAxes(Rotation,X,Y,Z);

		// try left and right
		// if frustrated, always move if possible
		bAlwaysTry = bFrustrated;
		bFrustrated = false;

		if ( FastTrace(Enemy.Location, Location + 2 * Y * CollisionRadius) )
		{
			Destination = Location + 2.5 * Y * CollisionRadius;
			return true;
		}

		if ( FastTrace(Enemy.Location, Location - 2 * Y * CollisionRadius) )
		{
			Destination = Location - 2.5 * Y * CollisionRadius;
			return true;
		}
		if ( bAlwaysTry )
		{
			if ( FRand() < 0.5 )
				Destination = Location - 2.5 * Y * CollisionRadius;
			else
				Destination = Location + 2.5 * Y * CollisionRadius; //was - there twice ?
			return true;
		}
		return false;
	}

	function BeginState()
	{
		if (bVerbose)
			log(self.GetHumanName()$" hunting");
		SpecialGoal = None;
		SpecialPause = 0.0;
		bFromWall = false;
		SetAlertness(0.5);
	}

	function EndState()
	{
		bCanTranslocate = false;
		bAvoidLedges = false;
		bHunting = false;
		if ( JumpZ > 0 )
			bCanJump = true;
	}

AdjustFromWall:
	Enable('AnimEnd');
	StrafeTo(Destination, Focus); 
	Destination = Focus; 
	if ( MoveTarget != None
	&& ( ( ValidSight( MoveTarget ) && SpecialPause == 0 )
	|| ( !ValidSight( MoveTarget ) && SpecialPause > 0 ) ) )
		Goto('SpecialNavig');
	else
		Goto('Follow');

Begin:
	numHuntPaths = 0;
AfterFall:
	TweenToRunning(0.1);
	bFromWall = false;

Follow:
	if ( TeamGamePlus(Level.Game) != None )
		TeamGamePlus(Level.Game).FindSpecialAttractionFor(self);
	if ( bSniping )
		GotoState('StakeOut');
	if ( (Orders == 'Hold') || (Orders == 'Follow') ) 
	{
		if ( OrderObject != None )
			if ( !LineOfSightTo(OrderObject) )
				GotoState('Fallback');
	}
	else if ( Orders == 'Defend' )
	{
		if ( AmbushSpot != None )
		{
			if ( !LineOfSightTo(AmbushSpot) )
				GotoState('Fallback');
		}
		else if ( !LineOfSightTo(OrderObject) && OrderObject != None )
			GotoState('Fallback');
	}
	WaitForLanding();
	if ( Enemy != None && CanSee(Enemy) )
		SetEnemy(Enemy);
	if ( !Level.Game.bGameEnded )
		PickDestination();
	else
		GotoState('GameEnded');
SpecialNavig:
	if ( SpecialPause > 0.0 )
	{
		Disable('AnimEnd');
		Acceleration = vect(0,0,0);
		bFire = 0;
		bAltFire = 0;
		PlayChallenge();
		Sleep(SpecialPause);
		SpecialPause = 0.0;
		Enable('AnimEnd');
		Goto('AfterFall');
	}
	if ( MoveTarget == None )
		MoveTo(Destination);
	else
		MoveToward(MoveTarget); 
	Goto('Follow');
}

state StakeOut
{
ignores EnemyNotVisible; 

	function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
							Vector momentum, name damageType)
	{
		Global.TakeDamage(Damage, instigatedBy, hitlocation, momentum, damageType);
		if ( health <= 0 )
			GoTo JL5922;
		bFrustrated = true;
		if ( Enemy != None )
			LastSeenPos = Enemy.Location;
		if (NextState == 'TakeHit')
		{
			if (AttitudeTo(Enemy) == ATTITUDE_Fear)
			{
				NextState = 'Retreating';
				NextLabel = 'Begin';
			}
			else
			{
				NextState = 'Attacking';
				NextLabel = 'Begin';
			}
			GotoState('TakeHit'); 
		}
		else
			GotoState('Attacking');
JL5922:
	}

	singular function HearNoise(float Loudness, Actor NoiseMaker)
	{
		if ( NoiseMaker.instigator != None )
			if ( SetEnemy(NoiseMaker.instigator) )
				LastSeenPos = Enemy.Location; 
	}

	function SetFall()
	{
		NextState = 'StakeOut'; 
		NextLabel = 'Begin';
		NextAnim = AnimSequence;
		GotoState('FallingState'); 
	}

	function bool SetEnemy(Pawn NewEnemy)
	{
		if (Global.SetEnemy(NewEnemy))
		{
			bReadyToAttack = true;
			DesiredRotation = Rotator(Enemy.Location - Location);
			GotoState('Attacking');
			return true;
		}
		return false;
	} 

	function Timer()
	{
		if (Enemy == None)
		{
			WhatToDoNext('','');
			GoTo JL5962;
		}
		bReadyToAttack = true;
		Enable('Bump');
		SetTimer(1.0, false);
JL5962:
	}

	function rotator AdjustAim(float projSpeed, vector projStart, int aimerror, bool leadTarget, bool warnTarget)
	{
		local vector FireSpot, X,Y,Z;
		local actor HitActor;
		local vector HitLocation, HitNormal;

		FireSpot = LastSeenPos;

		HitActor = Trace(HitLocation, HitNormal, FireSpot, ProjStart, false);
		if( HitActor != None ) 
		{
			FireSpot += 2 * Enemy.CollisionHeight * HitNormal;
			bClearShot = FastTrace(FireSpot, ProjStart);
			if ( !bClearShot )
			{
				FireSpot = LastSeenPos;
				bFire = 0;
				bAltFire = 0;
			}
		}

		ViewRotation = Rotator(FireSpot - ProjStart);
		return ViewRotation;
	}

	function bool ClearShot()
	{
		if ( Weapon == None ) return False;
		else
		{
			if ( Weapon.bSplashDamage && (VSize(Location - LastSeenPos) < 300) )
				return false;

			if ( !FastTrace(LastSeenPos + vect(0,0,0.9) * Enemy.CollisionHeight, Location) )
			{
				bFire = 0;
				bAltFire = 0;
				return false;
			}
		}
		return true;
	}

	function FindNewStakeOutDir()
	{
		local NavigationPoint N, Best;
		local vector Dir, EnemyDir;
		local float Dist, BestVal, Val;

		EnemyDir = Normal(Enemy.Location - Location);
		for ( N=Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
		{
			Dir = N.Location - Location;
			Dist = VSize(Dir);
			if ( (Dist < 800) && (Dist > 100) )
			{
				Val = (EnemyDir Dot Dir/Dist);
				if ( Level.Game.bTeamgame )
					Val += FRand();
				if ( (Val > BestVal) && LineOfSightTo(N) )
				{
					BestVal = Val;
					Best = N;
				}
			}
		}

		if ( Best != None )
			LastSeenPos = Best.Location + 0.5 * CollisionHeight * vect(0,0,1);
	}

	function bool ContinueStakeOut()
	{
		local float relstr;

		relstr = RelativeStrength(Enemy);
		if ( (VSize(Enemy.Location - Location) > 300 + (FRand() * relstr - CombatStyle) * 350)
			 || (Level.TimeSeconds - LastSeenTime > 2.5 + FMax(-1, 3 * (FRand() + 2 * (relstr - CombatStyle))) ) || !ClearShot() )
			return false;
		else if ( CanStakeOut() )
			return true;
		else
			return false;
	}

	function BeginState()
	{

		Acceleration = vect(0,0,0);
		bClearShot = ClearShot();
		bCanJump = false;
		bReadyToAttack = true;
		SetAlertness(0.5);
		RealLastSeenPos = LastSeenPos;
		if ( !bClearShot || ((Level.TimeSeconds - LastSeenTime > 6) && (FRand() < 0.5)) )
			FindNewStakeOutDir();
	}

	function EndState()
	{
		LastSeenPos = RealLastSeenPos;
		if ( JumpZ > 0 )
			bCanJump = true;
	}

Begin:
	if ( AmbushSpot == None )
		bSniping = false;
	if ( (bSniping && (VSize(Location - AmbushSpot.Location) > 3 * CollisionRadius)) 
		|| (Level.Game.IsA('DeathMatchPlus') && DeathMatchPlus(Level.Game).NeverStakeOut(self)) )
	{
		Enemy = None;
		OldEnemy = None;
		WhatToDoNext('','');
	}
	Acceleration = vect(0,0,0);
	PlayChallenge();
	TurnTo(LastSeenPos);
	if ( Enemy == None )
		WhatToDoNext('','');
	if ( (Weapon != None) && !Weapon.bMeleeWeapon && (FRand() < 0.5) && (VSize(Enemy.Location - LastSeenPos) < 150) 
		&& ClearShot() && CanStakeOut() )
		PlayRangedAttack();
	else
	{
		bFire = 0;
		bAltFire = 0;
	}
	FinishAnim();
	if ( !bNovice || (FRand() < 0.65) )
		TweenToWaiting(0.17);
	else
		PlayChallenge();
	Sleep(1 + FRand());
	if ( Level.Game.IsA('TeamGamePlus') )
		TeamGamePlus(Level.Game).FindSpecialAttractionFor(self);
	if ( ContinueStakeOut() )
	{
		if ( bSniping && (AmbushSpot != None) )
			LastSeenPos = Location + Ambushspot.lookdir;
		else if ( (FRand() < 0.3) || !FastTrace(LastSeenPos + vect(0,0,0.9) * Enemy.CollisionHeight, Location + vect(0,0,0.8) * CollisionHeight) )
			FindNewStakeOutDir();
		Goto('Begin');
	}
	else
	{
		if ( bSniping )
			WhatToDoNext('','');
		BlockedPath = None;
		bDevious = ( !bNovice && !Level.Game.bTeamGame && Level.Game.IsA('DeathMatchPlus') 
				&& (FRand() < 0.75 - 0.15 * DeathMatchPlus(Level.Game).NumBots) );
		GotoState('Hunting', 'AfterFall');
	}
}

Simulated Event Destroyed()
{
	if (mk != None)
	{
		mk.SetOwner(None);
		mk.Destroy();
	}
	Super(Pawn).Destroyed();
}

defaultproperties
{
   Footstep1=Sound'MBot_E.stone02'
   Footstep2=Sound'MBot_E.stone04'
   Footstep3=Sound'MBot_E.stone05'
   GroundSpeed=420.000000
   WaterSpeed=220.000000
   AirSpeed=410.000000
   JumpZ=330.000000
   MaxStepHeight=28.000000
   Land=Sound'MBot_E.Land1'
   WaterStep=Sound'MBot_E.LSplash'
}
