class XBotsMutator expands Mutator config(XBotsRandom);

var XBotsBotRandomInfo	BotConfig;
var bool bAdjustoBots, bStdAdjust, bAdjustSkillX;
var byte DifficultyX, MinPlayersX;

function PostBeginPlay()
{

	Super.PostBeginPlay();
	Level.Game.RegisterDamageMutator( Self );
	BotConfig=Spawn(class'XBotsBotRandomInfo');
	bAdjustoBots = class'AdjustoBotsConfig'.Default.bAdjustoBots;
	bStdAdjust = class'AdjustoBotsConfig'.Default.bStdAdjust;
	BotConfig.bAdjustSkill = class'AdjustoBotsConfig'.Default.bAdjustSkillX;
	BotConfig.Difficulty = class'AdjustoBotsConfig'.Default.DifficultyX;
	BotConfig.SeedList();
	DeathMatchPlus(Level.Game).MinPlayers = class'AdjustoBotsConfig'.Default.MinPlayersX;
	DeathMatchPlus(Level.Game).BotConfigType = class'XBots9b.XBotsBotRandomInfo';

	log("XAdjustoBots PostBeginPlay.......");

}

function ScoreKill(pawn Killer, pawn Other)
{
	local int RV;

	if ((bAdjustoBots) && (Killer != None) && (Other != None) && (Killer != Other))
	{
          if ((Killer.IsA('Bot')) && (Other.IsA('Bot')))
		{
		   RV=rand(5);
		   if (bStdAdjust) RV = 4;
		   Switch(RV)
			{
				case 4: // Adjust both bots...
					BotConfig.AdjustSkill(Bot(Other), False);
					BotConfig.AdjustSkill(Bot(Killer), True);
					break;

				case 3: // Skip adjusting this time....
					break;

				case 2: // Adjust winner only
					BotConfig.AdjustSkill(Bot(Killer), True);
					break;

				case 1: // Adjust loser only.   Case 0, we skip Adjustments.....
					BotConfig.AdjustSkill(Bot(Other), False);
					break;
			}
		}
	}
	Super.ScoreKill(Killer, Other);
}

defaultproperties
{
	bAdjustoBots=True
	bStdAdjust=False
}

