//=============================================================================
// AdjustoBotsConfig
//=============================================================================
class AdjustoBotsConfig expands UWindowDialogClientWindow config(XBotsRandom);

var UWindowHSliderControl slider;
var UWindowHSliderControl slider2;
var UWindowHSliderControl slider3;
var UWindowCheckBox checkbox1;
var UWindowCheckBox checkbox2;
var UWindowCheckBox checkbox3;
var UWindowCheckBox checkbox4;
var UWindowCheckBox checkbox5;
var UWindowSmallButton CloseButton;
var UWindowSmallCloseButton CancelButton;
var UWindowEditControl adjbotEditBox;
var UWindowEditControl adjbotEditBox2;
var UWindowEditControl adjbotEditBox3;
var string L;
var bool bInit;

//AdjustoBots setup variables
var() config float MaxBotSkill;
var() config byte DifficultyX, MinPlayersX;
var() config bool bAdjustoBots;
var() config bool bAdjustSkillX;
var() config bool bStdAdjust;
var() config bool bSilentMode;

function Created()
{	
	Super.Created();
	
	slider = UWindowHSliderControl(CreateControl(class'UWindowHSliderControl', 20, 15, 350, 1));
	slider.SetText("Maximum Bot Skill Level: ");
	slider.SetRange(0,7,0);
	if (MaxBotSkill > 7)
		slider.SetValue(7);
	else
		slider.SetValue(MaxBotSkill);
	adjbotEditBox = UWindowEditControl(CreateWindow(class'UWindowEditControl', 20, 30, 150, WinHeight-30));
	adjbotEditBox.Align = TA_Left;
	adjbotEditBox.SetText("                "@class'ChallengeBotInfo'.default.Skills[MaxBotSkill]);
	adjbotEditBox.SetValue(Left(string(MaxBotSkill), 3));
	adjbotEditBox.SetNumericOnly(False);
	adjbotEditBox.EditBoxWidth = 18;

	slider2 = UWindowHSliderControl(CreateControl(class'UWindowHSliderControl', 20, 55, 350, 1));
	slider2.SetText("Initial Bot Skill Level (UT Difficulty): ");
	slider2.SetRange(0,7,1);
	if (DifficultyX > 7)
		slider2.SetValue(7);
	else
		slider2.SetValue(DifficultyX);
	
	adjbotEditBox2 = UWindowEditControl(CreateWindow(class'UWindowEditControl', 20, 70, 150, WinHeight-30));
	adjbotEditBox2.Align = TA_Left;
	adjbotEditBox2.SetText("                "@class'ChallengeBotInfo'.default.Skills[DifficultyX]);
	adjbotEditBox2.SetValue(Left(string(DifficultyX), 1));
	adjbotEditBox2.SetNumericOnly(True);
	adjbotEditBox2.EditBoxWidth = 10;

	slider3 = UWindowHSliderControl(CreateControl(class'UWindowHSliderControl', 20, 95, 350, 1));
	slider3.SetText("Minimum Players (Bots + Players): ");
	slider3.SetRange(1,32,1);
	if (MinPlayersX > 32)
		slider3.SetValue(32);
	else
		slider3.SetValue(MinPlayersX);
	
	adjbotEditBox3 = UWindowEditControl(CreateWindow(class'UWindowEditControl', 20, 110, 150, WinHeight-30));
	adjbotEditBox3.Align = TA_Left;
	adjbotEditBox3.SetNumericOnly(True);
	adjbotEditBox3.EditBoxWidth = 16;
	if (MinPlayersX <= 9)
	{
		L = string(MinPlayersX);  L = Mid(L, 0, 1); 
		L = "0"$L;
		adjbotEditBox3.SetValue(Left(L, 2));
	}
	else
		adjbotEditBox3.SetValue(Left(string(MinPlayersX), 2));

	checkbox1 = UWindowCheckBox(CreateControl(class'UWindowCheckBox', 20, 135, 178, 1));
	checkbox1.SetText("AdjustoBots Bot vs Bot Adjusting: ");
	checkbox1.bChecked = bAdjustoBots;

	checkbox2 = UWindowCheckBox(CreateControl(class'UWindowCheckBox', 20, 155, 240, 1));
	checkbox2.SetText("UT Auto Adjust Skill (Human vs Bot Adjusting): ");
	checkbox2.bChecked = bAdjustSkillX;

	checkbox3 = UWindowCheckBox(CreateControl(class'UWindowCheckBox', 20, 175, 137, 1));
	checkbox3.SetText("Standard (Faster) Adjust: ");
	checkbox3.bChecked = bStdAdjust;

	checkbox4 = UWindowCheckBox(CreateControl(class'UWindowCheckBox', 20, 195, 78, 1));
	checkbox4.SetText("Silent Mode: ");
	checkbox4.bChecked = bSilentMode;

	// Update button 
	CloseButton = UWindowSmallButton(CreateWindow(class'UWindowSmallButton', 180 , 215, 48, 16));
	CloseButton.SetText( "Update" );
	CloseButton.NotifyWindow = Self; // doesn't seem to work otherwise.

	// Cancel button
	CancelButton = UWindowSmallCloseButton(CreateWindow(class'UWindowSmallCloseButton', 230, 215, 48, 16));
	CancelButton.SetText( "Cancel" );	
}

//when a control changes, Notify is called with the changed control
function Notify(UWindowDialogControl C, byte E)
{
	local float sval;

	Super.Notify( C, E );

	if (checkbox1 != None)
	switch(E)
	{
	case DE_Change: // the message sent by sliders and checkboxes 
	switch(C)
	{	
		case slider:
			sval =  slider.GetValue();
			adjbotEditBox.SetValue(Left(string(sval), 4));
			MaxBotSkill = sval;
			adjbotEditBox.SetText("                "@class'ChallengeBotInfo'.default.Skills[MaxBotSkill]);
			break;		
		case slider2:
			sval =  slider2.GetValue();
			adjbotEditBox2.SetValue(Left(string(sval), 4));
			DifficultyX = sval;
			adjbotEditBox2.SetText("                "@class'ChallengeBotInfo'.default.Skills[DifficultyX]);
			break;		
		case slider3:
			sval =  slider3.GetValue();
			MinPlayersX = sval;
			if (MinPlayersX <= 9)
			{
				L = string(MinPlayersX);  L = Mid(L, 0, 1); 
				L = "0"$L;
				adjbotEditBox3.SetValue(Left(L, 2));
			}
			else
				adjbotEditBox3.SetValue(Left(string(MinPlayersX), 2));
			break;		
		case checkbox1:
			if (checkbox1.bChecked) 
				bAdjustoBots=True;
			else
				bAdjustoBots=False;
			break;						
		case checkbox2:
			if (checkbox2.bChecked) 
				bAdjustSkillX=True;
			else
				bAdjustSkillX=False;
			break;						
		case checkbox3:
			if (checkbox3.bChecked) 
				bStdAdjust=True;
			else
				bStdAdjust=False;
			break;						
		case checkbox4:
			if (checkbox4.bChecked) 
				bSilentMode=True;
			else
				bSilentMode=False;
			break;						
	}
	case DE_Click:
	switch(C)
		{		
			case CloseButton:
				sval = float(adjbotEditBox.GetValue());
				MaxBotSkill = sval;
				sval = float(adjbotEditBox2.GetValue());
				DifficultyX = sval;
				sval = float(adjbotEditBox3.GetValue());
				MinPlayersX = sval;
				class'XBotsBotRandomInfo'.static.StaticSaveConfig();				
				SaveConfig();
				ParentWindow.Close();
			break;
		}
	break;
	}
}

defaultproperties
{
	MaxBotSkill=4.0
	DifficultyX=2
	MinPlayersX=10
	bAdjustoBots=True
	bAdjustSkillX=True
	bStdAdjust=False
	bSilentMode=False
}
