//=============================================================================
// BSInfoScoreBoard (c) 2010 Mr.Loathsome AKA Scott Armitage
//=============================================================================
class BSInfoScoreBoard extends TournamentScoreBoard config(BSInfo);

var config bool bDebugMode;
var byte Difficulty, CurMaxSkill;

function DrawNameAndPing(Canvas Canvas, PlayerReplicationInfo PRI, float XOffset, float YOffset, bool bCompressed)
{
	local float XL, YL, XL2, YL2, XL3, YL3, XB, YB;
	local Font CanvasFont;
	local bool bLocalPlayer;
	local PlayerPawn PlayerOwner;
	local int Time;
	local Bot B;
	local Pawn P;
	local string L;
	local byte Bsk, Bsk2;

	PlayerOwner = PlayerPawn(Owner);

	bLocalPlayer = (PRI.PlayerName == PlayerOwner.PlayerReplicationInfo.PlayerName);
	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);

	// Draw Name
	if ( PRI.bAdmin )
		Canvas.DrawColor = WhiteColor;
	else if ( bLocalPlayer ) 
		Canvas.DrawColor = GoldColor;
	else 
		Canvas.DrawColor = CyanColor;

	Canvas.SetPos(Canvas.ClipX * 0.1875, YOffset);

	Canvas.StrLen( "0000", XL, YL );
	Canvas.StrLen( PRI.PlayerName, XB, YB );

	Canvas.DrawText(PRI.PlayerName, False);
	
	// Draw Score
	if ( !bLocalPlayer )
		Canvas.DrawColor = LightCyanColor;

	Canvas.StrLen( int(PRI.Score), XL2, YL );
	Canvas.SetPos( Canvas.ClipX * 0.625 + XL * 0.5 - XL2, YOffset );
	Canvas.DrawText( int(PRI.Score), false );

	// Draw Deaths
	Canvas.StrLen( int(PRI.Deaths), XL2, YL );
	Canvas.SetPos( Canvas.ClipX * 0.75 + XL * 0.5 - XL2, YOffset );
	Canvas.DrawText( int(PRI.Deaths), false );

	if ( (Canvas.ClipX > 512) && (Level.NetMode != NM_Standalone) )
	{
		Canvas.DrawColor = WhiteColor;
		Canvas.Font = MyFonts.GetSmallestFont(Canvas.ClipX);

		// Draw Time
		Time = Max(1, (Level.TimeSeconds + PlayerOwner.PlayerReplicationInfo.StartTime - PRI.StartTime)/60);
		Canvas.TextSize( TimeString$": 999", XL3, YL3 );
		Canvas.SetPos( Canvas.ClipX * 0.75 + XL, YOffset );
		Canvas.DrawText( TimeString$":"@Time, false );

		// Draw FPH
		Canvas.TextSize( FPHString$": 999", XL2, YL2 );
		Canvas.SetPos( Canvas.ClipX * 0.75 + XL, YOffset + 0.5 * YL );
		Canvas.DrawText( FPHString$": "@int(60 * PRI.Score/Time), false );

		XL3 = FMax(XL3, XL2);
		// Draw Ping
		Canvas.SetPos( Canvas.ClipX * 0.75 + XL + XL3 + 16, YOffset );
		Canvas.DrawText( PingString$":"@PRI.Ping, false );
	}

	// Draw Current Bot Skill
	if ( !bCompressed )
	{
		CanvasFont = Canvas.Font;
		Canvas.Font = Font'SmallFont';
		L = "";
		if ( PRI.bIsABot )
		{
		L = "Current Skill:";
			for ( P=Level.PawnList; P!=None; P=P.nextPawn )
				if ( P.PlayerReplicationInfo.PlayerID == PRI.PlayerID )
				{
					B=Bot(P);
					Bsk=B.Skill;
					if (( !B.bThreePlus ) && ( !B.bNovice ) && ( Bsk <=3 ))
						Bsk +=4;
					Bsk = Min(Bsk, 7);
					Bsk2 = Min(Bsk, 7);
					CurMaxSkill = Max(CurMaxSkill, Bsk2);
					L=(class'ChallengeBotInfo'.default.Skills[Bsk] );
					if ( bDebugMode )
					{
						L=L$" - "@B.Skill;
						if ( B.bNovice ) L=L$" Novice";
						if ( B.bThreePlus ) L=L$" ThreePlus";
					}
					break;
				}

			if ( L != "" )
			{
				Canvas.SetPos(XL * 6 + XB + 16, YOffset + 0.3 * YB);
				Canvas.DrawText(L, False);
			}
		}
	
	CanvasFont = Canvas.Font;
	}

}

function DrawTrailer( canvas Canvas )
{
	local int Hours, Minutes, Seconds;
	local float XL, YL;
	local PlayerPawn PlayerOwner;
	local byte Bsk, Bsk2;

	PlayerOwner = PlayerPawn(Owner);

	Bsk = Level.Game.Difficulty;
	Bsk2 = Min(Bsk, 7);

	Canvas.bCenter = true;
	Canvas.StrLen("Test", XL, YL);

	Canvas.SetPos(0, Canvas.ClipY - 3 * YL);
	Canvas.DrawColor = GreenColor;
	Canvas.DrawText("Current Difficulty Value: "@class'ChallengeBotInfo'.default.Skills[Bsk2]$" = "@Bsk$"  -  Current Max Skill Level Achieved: "@class'ChallengeBotInfo'.default.Skills[CurMaxSkill], True);

	Canvas.SetPos(0, Canvas.ClipY - 2 * YL);
	Canvas.DrawColor = WhiteColor;
	Canvas.DrawText(PlayerOwner.GameReplicationInfo.GameName@MapTitle@Level.Title, true);

	Canvas.SetPos(0, Canvas.ClipY - YL);
	if ( bTimeDown || (PlayerOwner.GameReplicationInfo.RemainingTime > 0) )
	{
		bTimeDown = true;
		if ( PlayerOwner.GameReplicationInfo.RemainingTime <= 0 )
			Canvas.DrawText(RemainingTime@"00:00", true);
		else
		{
			Minutes = PlayerOwner.GameReplicationInfo.RemainingTime/60;
			Seconds = PlayerOwner.GameReplicationInfo.RemainingTime % 60;
			Canvas.DrawText(RemainingTime@TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
		}
	}
	else
	{
		Seconds = PlayerOwner.GameReplicationInfo.ElapsedTime;
		Minutes = Seconds / 60;
		Hours   = Minutes / 60;
		Seconds = Seconds - (Minutes * 60);
		Minutes = Minutes - (Hours * 60);
		Canvas.DrawText(ElapsedTime@TwoDigitString(Hours)$":"$TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
	}

	if ( PlayerOwner.GameReplicationInfo.GameEndedComments != "" )
	{
		Canvas.bCenter = true;
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.ClipY - Min(YL*6, Canvas.ClipY * 0.1));
		Canvas.DrawColor = GreenColor;
		if ( Level.NetMode == NM_Standalone )
			Canvas.DrawText(Ended@Continue, true);
		else
			Canvas.DrawText(Ended, true);
	}
	else if ( (PlayerOwner != None) && (PlayerOwner.Health <= 0) )
	{
		Canvas.bCenter = true;
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.ClipY - Min(YL*6, Canvas.ClipY * 0.1));
		Canvas.DrawColor = GreenColor;
		Canvas.DrawText(Restart, true);
	}
	Canvas.bCenter = false;
}


defaultproperties
{
	bDebugMode=False
	CurMaxSkill=0
}
