// ============================================================
// BSInfo.BSInfoMutator  (c) 2010 Mr.Loathsome
//
// Adds current realtime bot skill info to scoreboard.
// Currently only for Practice matches
//
// You may NOT modify this code without written permission from
// the author. You are free to use and distribute this code,
// as long as there is no money charged for it.
// ============================================================

class BSInfoMutator extends Mutator;

var PlayerPawn MyPlayer;
var ChallengeHUD MyHUD;
var bool	Initialized;

simulated function PreBeginPlay()
{
	if (Initialized)
		return;
	Initialized = True;
	log("BSInfoMutator PreBeginPlay.......");
	Super.PreBeginPlay();

	if ( Level.Game.GameName == "Assault" )
		Level.Game.ScoreBoardType=class'BSInfo.BSInfoASScoreBoard';
	else 
	if ( Level.Game.bTeamGame )
			Level.Game.ScoreBoardType=class'BSInfo.BSInfoTeamScoreBoard';
		else
			Level.Game.ScoreBoardType=class'BSInfo.BSInfoScoreBoard';

}

simulated function Tick(float DeltaTime)
{
   if ( !bHUDMutator && Level.NetMode != NM_DedicatedServer )
        RegisterHUDMutator();
}

simulated function PostRender(canvas Canvas)
{
   MyPlayer = Canvas.Viewport.Actor;
    if ( MyPlayer != None )
	MyHUD = ChallengeHUD(MyPlayer.myHUD);
	 
    // This is important! It allows the next HUD mutator to draw on the canvas.
    if ( NextHUDMutator != None )
        NextHUDMutator.PostRender(Canvas);
}
 

defaultproperties
{
}
