// ============================================================
// AdjustoBots.SkillCapBotInfo 
//  (c) 2010 Mr.Loathsome aka Scott Armitage
//
// Fixes the broken UT Auto Adjust Bot Skill option.
//
// You may NOT modify this code without written permission from
// the author. You are free to use and distribute this code,
// as long as there is no money charged for it.
// ============================================================

class SkillCapBotInfo extends ChallengeBotInfo;

var bool bInitialized, bSilentMode;
var float MaxBotSkill;

function AdjustSkill(Bot B, bool bWinner)
{
	local float BotSkill, RV, RV2;
	local byte Bsk, Bsk2;

	if (!bInitialized)
	{
		bInitialized = True;
		MaxBotSkill = class'AdjustoBotsConfig'.Default.MaxBotSkill;
		bSilentMode = class'AdjustoBotsConfig'.Default.bSilentMode;
	}
	RV = FRand();
	BotSkill = B.Skill;
	if (( !B.bThreePlus ) && ( !B.bNovice ))
		BotSkill += 4;
	BotSkill=FMin(BotSkill, MaxBotSkill);
	Bsk2 = BotSkill;
	if ( bWinner )
	{
		PlayerKills += 1;
		AdjustedDifficulty = FMax(0, AdjustedDifficulty - 2/Min(PlayerKills, 10));
		if ( BotSkill > AdjustedDifficulty )
			B.Skill = AdjustedDifficulty;
	}
	else
	{
		PlayerDeaths += 1;
		AdjustedDifficulty += FMin(MaxBotSkill, 2/Min(PlayerDeaths, 10));
		if ( BotSkill < AdjustedDifficulty )
			B.Skill = AdjustedDifficulty;
	}
	if (AdjustedDifficulty != BotSkill)
	{
//		BroadcastMessage("AdustedDifficulty = "@AdjustedDifficulty);
		if ( AdjustedDifficulty > MaxBotSkill )
		{
			if ( !bSilentMode )
				BroadcastMessage("Bot Skills Capped at: "@class'ChallengeBotInfo'.default.Skills[MaxBotSkill]);
		}
		if ((AdjustedDifficulty >= MaxBotSkill) && ((PlayerDeaths + PlayerKills) > 3))
		{
			RV = RV + 0.5;
			if (!bWinner)
			{
				RV2 = FMin(RV, 0.85);
				AdjustedDifficulty = abs((AdjustedDifficulty - (AdjustedDifficulty * RV)) - RV2);
				B.Skill = abs(B.Skill - RV2);
				PlayerDeaths -= 1;
			}
			else
			{
				AdjustedDifficulty = abs(AdjustedDifficulty - (AdjustedDifficulty * RV));
				B.Skill = abs(B.Skill - (RV));
				PlayerKills -= 1;
			}
		}
		if ( B.Skill > MaxBotSkill ) B.Skill = MaxBotSkill;
		B.bThreePlus = false;
		if ( B.Skill < 4 )
		{
			B.bNovice = true;
			if ( B.Skill > 3 )
			{
				B.Skill = 3;
				B.bThreePlus = true;
			}
		}
		else
		{
			B.Skill -= 4;
			B.bNovice = false;
		}
		Bsk=B.Skill;
		SetBSkills(B);
		if (( !B.bThreePlus ) && ( !B.bNovice ) && ( Bsk <= 3 ))
			Bsk += 4;
		Difficulty = Bsk;
		DeathMatchPlus(Level.Game).Difficulty = Difficulty;
		if (( !bSilentMode ) && ( Bsk != Bsk2 ))
			BroadcastMessage("Bot Skill Adjustment Detected.  "$B.GetHumanName()$" - "$class'ChallengeBotInfo'.default.Skills[Bsk2]$", Now "$class'ChallengeBotInfo'.default.Skills[Bsk]);
	}
}

function SetBSkills(Bot B)
{
		B.Accuracy = 0.3 * B.Skill;
		B.BaseAlertness = 0.3 * B.Skill;
		B.StrafingAbility = 0.3 * B.Skill;
		B.BaseAggressiveness = 0.3 * B.Skill;
		B.Aggressiveness = 0.3 * B.Skill;
		if (( B.bNovice ) && ( B.Skill <= 3 ))
		{
			if (B.Skill >= 2.50)
			{
				B.CombatStyle = 1.000;
				B.bJumpy = true;
			}
			else if (B.Skill >= 1.50)
			{
				B.CombatStyle = 0.500;
				B.bJumpy = true;
			}
			else
			{
				B.CombatStyle = 0.000;
				B.bJumpy = false;
			}
		}
		B.bLeadTarget = ( !B.bNovice || B.bThreePlus );
		B.PreSetMovement();
		if ( B.bNovice )
			B.ReFireRate = B.Default.ReFireRate;
		else
			B.ReFireRate = B.Default.ReFireRate * (1 - 0.25 * B.Skill);
}

defaultproperties
{
}
