// ============================================================
// AdjustoBots.AdjustoBots  (c) 2010 Mr.Loathsome
//
// Fixes the broken UT Auto Adjust Bot Skill option.
//
// You may NOT modify this code without written permission from
// the author. You are free to use and distribute this code,
// as long as there is no money charged for it.
// ============================================================

class AdjustoBots extends Mutator;

var SkillCapBotInfo		BotConfig;

var bool bAdjustoBots, bStdAdjust, bAdjustSkillX;
var byte DifficultyX, MinPlayersX;

function PostBeginPlay()
{
	Super.PostBeginPlay();
	Level.Game.RegisterDamageMutator(Self);
	bAdjustoBots = class'AdjustoBotsConfig'.Default.bAdjustoBots;
	bStdAdjust = class'AdjustoBotsConfig'.Default.bStdAdjust;

	BotConfig = Spawn(class'AdjustoBots.SkillCapBotInfo');
	DeathMatchPlus(Level.Game).BotConfigType=class'AdjustoBots.SkillCapBotInfo';
	DeathMatchPlus(Level.Game).MinPlayers = class'AdjustoBotsConfig'.Default.MinPlayersX;
	BotConfig.bAdjustSkill = class'AdjustoBotsConfig'.Default.bAdjustSkillX;
	BotConfig.Difficulty = class'AdjustoBotsConfig'.Default.DifficultyX;
	log("AdjustoBots Initialized.......");
}

function ScoreKill(pawn Killer, pawn Other)
{
	local int RV;

	if ((bAdjustoBots) && (Killer != None) && (Other != None) && (Killer != Other))
	{
          if ((Killer.IsA('Bot')) && (Other.IsA('Bot')))
		{
		   RV=rand(5);
		   if (bStdAdjust) RV = 4;
		   Switch(RV)
			{
				case 4: // Adjust both bots...
					BotConfig.AdjustSkill(Bot(Other), False);
					BotConfig.AdjustSkill(Bot(Killer), True);
					break;

				case 3: // Skip adjusting this time....
					break;

				case 2: // Adjust winner only
					BotConfig.AdjustSkill(Bot(Killer), True);
					break;

				case 1: // Adjust loser only.   Case 0, we skip Adjustments.....
					BotConfig.AdjustSkill(Bot(Other), False);
					break;
			}
		}
	}
	Super.ScoreKill(Killer, Other);
}

defaultproperties
{
}
