//=============================================================================
// TeamScoreBoard
//=============================================================================
class CTF_SB extends DM_SB config(DanesHUDnSB);

// custom vars
var config bool bTitleFlash;
var config byte FlashSpeed;
var config color TitleColor, FragColor, TimeColor;
var config color AdminNameColor, LocalPlayerColor, OtherPlayerColor, TimePingColor;
var config string FragLine, TimeLine;
var int GameTypeColorR, ColorUpDownR, GameTypeColorG, ColorUpDownG, GameTypeColorB, ColorUpDownB;
var int EFFcolor, EFFupdown;
var config int GreenEFFThreshold, RedEFFThreshold;
var config string TeamNames[4];
//




var localized string TeamName[4];
var localized string OrdersString, InString;
var localized string PlayersNotShown;
var() color TeamColor[4];
var() color AltTeamColor[4];
var PlayerReplicationInfo OwnerInfo;
var TournamentGameReplicationInfo OwnerGame;

function ShowScores( canvas Canvas )
{
	local PlayerReplicationInfo PRI;
	local int PlayerCount, i;
	local float LoopCountTeam[4];
	local float XL, YL, XOffset, YOffset, XStart;
	local int PlayerCounts[4];
	local int LongLists[4];
	local int BottomSlot[4];
	local font CanvasFont;
	local bool bCompressed;
	local float r;
	// Team EFF vars
	local float TScore;
	local int TEFF;
	local float TotalScore;

	OwnerInfo = Pawn(Owner).PlayerReplicationInfo;
	OwnerGame = TournamentGameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo);	
	Canvas.Style = ERenderStyle.STY_Normal;
	CanvasFont = Canvas.Font;

	// Header
	DrawHeader(Canvas);

	for ( i=0; i<32; i++ )
		Ordered[i] = None;

	for ( i=0; i<32; i++ )
	{
		if (PlayerPawn(Owner).GameReplicationInfo.PRIArray[i] != None)
		{
			PRI = PlayerPawn(Owner).GameReplicationInfo.PRIArray[i];
			if ( !PRI.bIsSpectator || PRI.bWaitingPlayer )
			{
				Ordered[PlayerCount] = PRI;
				PlayerCount++;
				PlayerCounts[PRI.Team]++;
			}
		}
	}

	SortScores(PlayerCount);
	Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );
	Canvas.StrLen("TEXT", XL, YL);
	ScoreStart = Canvas.CurY + YL*2;
	if ( ScoreStart + PlayerCount * YL + 2 > Canvas.ClipY )
	{
		bCompressed = true;
		CanvasFont = Canvas.Font;
		Canvas.Font = font'SmallFont';
		r = YL;
		Canvas.StrLen("TEXT", XL, YL);
		r = YL/r;
		Canvas.Font = CanvasFont;
	}
	for ( I=0; I<PlayerCount; I++ )
	{
		if ( Ordered[I].Team < 4 )
		{
			if ( Ordered[I].Team % 2 == 0 )
				XOffset = (Canvas.ClipX / 4) - (Canvas.ClipX / 8);
			else
				XOffset = ((Canvas.ClipX / 4) * 3) - (Canvas.ClipX / 8);

			Canvas.StrLen("TEXT", XL, YL);
			Canvas.DrawColor = AltTeamColor[Ordered[I].Team];
			YOffset = ScoreStart + (LoopCountTeam[Ordered[I].Team] * YL) + 2;
			if (( Ordered[I].Team > 1 ) && ( PlayerCounts[Ordered[I].Team-2] > 0 ))
			{
				BottomSlot[Ordered[I].Team] = 1;
				YOffset = ScoreStart + YL*11 + LoopCountTeam[Ordered[I].Team]*YL;
			}

			// Draw Name and Ping
			if ( (Ordered[I].Team < 2) && (BottomSlot[Ordered[I].Team] == 0) && (PlayerCounts[Ordered[I].Team+2] == 0))
			{
				LongLists[Ordered[I].Team] = 1;
				DrawNameAndPing( Canvas, Ordered[I], XOffset, YOffset, bCompressed);
			} 
			else if (LoopCountTeam[Ordered[I].Team] < 8)
				DrawNameAndPing( Canvas, Ordered[I], XOffset, YOffset, bCompressed);
			if ( bCompressed )
				LoopCountTeam[Ordered[I].Team] += 1;
			else
				LoopCountTeam[Ordered[I].Team] += 2;
		}
	}

	for ( i=0; i<4; i++ )
	{
		Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );
		if ( PlayerCounts[i] > 0 )
		{
			if ( i % 2 == 0 )
				XOffset = (Canvas.ClipX / 4) - (Canvas.ClipX / 8);
			else
				XOffset = ((Canvas.ClipX / 4) * 3) - (Canvas.ClipX / 8);
			YOffset = ScoreStart - YL + 2;

			if ( i > 1 )
				if (PlayerCounts[i-2] > 0)
					YOffset = ScoreStart + YL*10;
			// calculate Team EFF TScore[4] TotalScore;
			
			TotalScore = OwnerGame.Teams[0].Score;
			TotalScore += OwnerGame.Teams[1].Score;
			TotalScore += OwnerGame.Teams[2].Score;
			TotalScore += OwnerGame.Teams[3].Score;
			TScore = OwnerGame.Teams[i].Score;
			TScore /= TotalScore;
			TScore *= 100;
			TEFF = TScore;





			Canvas.DrawColor = TeamColor[i];
			Canvas.SetPos(XOffset, YOffset);
			Canvas.StrLen(TeamNames[i], XL, YL);
			Canvas.DrawText(TeamNames[i], false);
			Canvas.StrLen(int(OwnerGame.Teams[i].Score), XL, YL);
			Canvas.SetPos(XOffset + (Canvas.ClipX/4) - XL, YOffset);
			Canvas.DrawText(int(OwnerGame.Teams[i].Score)$" Eff:"@TEFF$"%", false);
				
			if ( PlayerCounts[i] > 4 )
			{
				if ( i < 2 )
					YOffset = ScoreStart + YL*8;
				else
					YOffset = ScoreStart + YL*19;
				Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
				Canvas.SetPos(XOffset, YOffset);
				if (LongLists[i] == 0)
					Canvas.DrawText(PlayerCounts[i] - 4 @ PlayersNotShown, false);
			}
		}
	}

	// Trailer
	if ( !Level.bLowRes )
	{
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		DrawTrailer(Canvas);
	}
	Canvas.Font = CanvasFont;
	Canvas.DrawColor = WhiteColor;
}

function DrawScore(Canvas Canvas, float Score, float XOffset, float YOffset)
{
	local float XL, YL;

	Canvas.StrLen(string(int(Score)), XL, YL);
	Canvas.SetPos(XOffset + (Canvas.ClipX/4) - XL, YOffset);
	Canvas.DrawText(int(Score), False);
}

function DrawNameAndPing(Canvas Canvas, PlayerReplicationInfo PRI, float XOffset, float YOffset, bool bCompressed)
{
	local float XL, YL, XL2, YL2, YB;
	local BotReplicationInfo BRI;
	local String S, O, L;
	local Font CanvasFont;
	local bool bAdminPlayer;
	local PlayerPawn PlayerOwner;
	local int Time;
	local float ResA;
	local float ResB;
	local float EFF;
	local int ResultEFF;

	PlayerOwner = PlayerPawn(Owner);

	bAdminPlayer = PRI.bAdmin;

	// Draw Name
	if (PRI.PlayerName == PlayerOwner.PlayerReplicationInfo.PlayerName)
		Canvas.DrawColor = GoldColor;

	if ( bAdminPlayer )
		Canvas.DrawColor = WhiteColor;

	Canvas.SetPos(XOffset, YOffset);
	Canvas.DrawText(PRI.PlayerName, False);
	Canvas.StrLen(PRI.PlayerName, XL, YB);

	if ( Canvas.ClipX > 512 )
	{
		CanvasFont = Canvas.Font;
		Canvas.Font = Font'SmallFont';
		Canvas.DrawColor = TimePingColor;

		if (Level.NetMode != NM_Standalone)
		{
			if ( !bCompressed || (Canvas.ClipX > 640) )
			{
				// Draw Time
				Time = Max(1, (Level.TimeSeconds + PlayerOwner.PlayerReplicationInfo.StartTime - PRI.StartTime)/60);
				Canvas.StrLen(TimeString$":     ", XL, YL);
				Canvas.SetPos(XOffset - XL - 6, YOffset);
				Canvas.DrawText(TimeString$":"@Time, false);
			}

			// Draw Ping
			Canvas.StrLen(PingString$":     ", XL2, YL2);
			Canvas.SetPos(XOffset - XL2 - 6, YOffset + (YL+1));
			Canvas.DrawText(PingString$":"@PRI.Ping, false);


// udregn eff

	ResA = PRI.Score;
	if (ResA < 0)
		{
		ResA = 0;
		}
	ResB = ResA;
	ResA += PRI.Deaths;
//	ResB = PRI.Score;
	ResB /=ResA;
	ResB *=100;
	ResultEFF = ResB;



//-------------------------------------------------------------
// start - vis eff i forskellige farver
	if (ResultEFF >= 100)
		{
		// EFF farve flash
			if (EFFupdown == 0)
				{
				EFFcolor += 12;
				if (EFFColor >= 255)
					{
					EFFcolor = 255;
					EFFupdown = 1;
					}

				}
			if (EFFupdown == 1)
				{
				EFFcolor -= 12;
				if (EFFcolor <= 0)
					{
					EFFcolor = 0;
					EFFupdown = 0;
					}

				}
		Canvas.DrawColor.R = EFFcolor;
		Canvas.DrawColor.G = EFFcolor;
		Canvas.DrawColor.B = EFFcolor;
		}
	else if (ResultEFF >= GreenEFFThreshold)
		{
		Canvas.DrawColor.R = 0;
		Canvas.DrawColor.G = 255;
		Canvas.DrawColor.B = 0;
		}
	else if (ResultEFF >= RedEFFThreshold)
		{
		Canvas.DrawColor.R = 255;
		Canvas.DrawColor.G = 255;
		Canvas.DrawColor.B = 0;
		}
	else
		{
		Canvas.DrawColor.R = 255;
		Canvas.DrawColor.G = 0;
		Canvas.DrawColor.B = 0;
		}
	
// slut - vis eff i forskellige farver
//-------------------------------------------------------------








			// Draw eff
			Canvas.StrLen(PingString$":     ", XL2, YL2);
			Canvas.SetPos(XOffset - XL2 - 6, YOffset + 25);
			Canvas.DrawText("EFF :"@ResultEFF$"%", false);

















		}
		Canvas.Font = CanvasFont;
	}

	// Draw Score
	if (PRI.PlayerName == PlayerOwner.PlayerReplicationInfo.PlayerName)
		Canvas.DrawColor = GoldColor;
	else
		Canvas.DrawColor = TeamColor[PRI.Team];
	DrawScore(Canvas, PRI.Score, XOffset, YOffset);

	if (Canvas.ClipX < 512)
		return;

	// Draw location, Order
	if ( !bCompressed && (PRI.Team == OwnerInfo.Team) )
	{
		CanvasFont = Canvas.Font;
		Canvas.Font = Font'SmallFont';

		if ( PRI.PlayerLocation != None )
			L = PRI.PlayerLocation.LocationName;
		else if ( PRI.PlayerZone != None )
			L = PRI.PlayerZone.ZoneName;
		else 
			L = "";
		if ( L != "" )
		{
			L = InString@L;
			Canvas.SetPos(XOffset, YOffset + YB);
			Canvas.DrawText(L, False);
		}
		O = OwnerGame.GetOrderString(PRI);
		if (O != "")
		{
			O = OrdersString@O;
			Canvas.StrLen(O, XL2, YL2);
			Canvas.SetPos(XOffset, YOffset + YB + YL2);
			Canvas.DrawText(O, False);
		}
		Canvas.Font = CanvasFont;
	}
}

function DrawVictoryConditions(Canvas Canvas)
{
	local TournamentGameReplicationInfo TGRI;
	local float XL, YL;

	TGRI = TournamentGameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo);
	if ( TGRI == None )
		return;

// Put custom color on title
	Canvas.DrawColor = TitleColor;
// if bTitleFlash

	if (bTitleFlash)
		// rd farve palette
			{
			if (ColorUpDownR == 0)
				{
				GameTypeColorR += FlashSpeed;
				if (GameTypeColorR >= 255)
					{
					GameTypeColorR = 255;
					ColorUpDownR = 1;
					}

				}
			if (ColorUpDownR == 1)
				{
				GameTypeColorR -= FlashSpeed;
				if (GameTypeColorR <= 0)
					{
					GameTypeColorR = 0;
					ColorUpDownR = 0;
					}

				}
			// grn farve palette
			if (ColorUpDownG == 0)
				{
				GameTypeColorG += FlashSpeed;
				if (GameTypeColorG >= 255)
					{
					GameTypeColorG = 255;
					ColorUpDownG = 1;
					}

				}
			if (ColorUpDownG == 1)
				{
				GameTypeColorG -= FlashSpeed;
				if (GameTypeColorG <= 0)
					{
					GameTypeColorG = 0;
					ColorUpDownG = 0;
					}

				}
			// bl farve palette
			if (ColorUpDownB == 0)
				{
				GameTypeColorB += FlashSpeed;
				if (GameTypeColorB >= 255)
					{
					GameTypeColorB = 255;
					ColorUpDownB = 1;
					}

				}
			if (ColorUpDownB == 1)
				{
				GameTypeColorB -= FlashSpeed;
				if (GameTypeColorB <= 0)
					{
					GameTypeColorB = 0;
					ColorUpDownB = 0;
					}

				}
			Canvas.DrawColor.R = GameTypeColorR;
			Canvas.DrawColor.G = GameTypeColorG;
			Canvas.DrawColor.B = GameTypeColorB;
			}







	Canvas.DrawText(TGRI.GameName);
	Canvas.StrLen("Test", XL, YL);
	Canvas.SetPos(0, Canvas.CurY - YL);

	if ( TGRI.GoalTeamScore > 0 )
	{
		Canvas.DrawColor = FragColor; // custom color
		Canvas.DrawText(FragLine@TGRI.GoalTeamScore);
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.CurY - YL);
	}

	if ( TGRI.TimeLimit > 0 )
		Canvas.DrawColor = TimeColor; // custom color
		Canvas.DrawText(TimeLine@TGRI.TimeLimit$":00");
}

defaultproperties
{
     TeamName(0)="Red Team"
     TeamName(1)="Blue Team"
     TeamName(2)="Green Team"
     TeamName(3)="Gold Team"
     OrdersString="Orders:"
     InString="Location:"
     PlayersNotShown="Player[s] not shown."
     TeamColor(0)=(R=255)
     TeamColor(1)=(G=128,B=255)
     TeamColor(2)=(G=255)
     TeamColor(3)=(R=255,G=255)
     AltTeamColor(0)=(R=200)
     AltTeamColor(1)=(G=94,B=187)
     AltTeamColor(2)=(G=128)
     AltTeamColor(3)=(R=255,G=255,B=128)
}
