//==============================================================================
// {oToD}Damage_Bubble: Created By {oToD}Dentures.
// Special Thanks to -=CoN=-Strych9.
//==============================================================================
class TBMutator expands Mutator;
//====
var float	   mMinScale;
var float	   mMaxScale;
var            PlayerPawn PlayerOwner;
var bool       Initialized;
var int        ownerId;
var            Pawn PawnOwner, SetOwner;
var int        player_id;
var            TBDamageBar HH;
var float 	   dist;
var Vector	   dir;
var Vector	   loc;
var int		   num_used;
var int		   player_count;
var int		   symbol_count;
var float	   draw_scale;
var float	   interp, ttime;
var            PlayerReplicationInfo PRI;
//====
simulated function PostBeginPlay()
{
    spawn(class'TBDamageBar');
}
//====
simulated function SetSymbol( TBDamageBar HH, Pawn PawnOwner)
{
    if(PawnOwner.Health >= 90 && PawnOwner.Health < 99)
    {
        HH.Texture = HH.HealthSprite[0];
    }
    else if(PawnOwner.Health >= 80 && PawnOwner.Health < 90)
    {
        HH.Texture = HH.HealthSprite[1];
    }
    else if(PawnOwner.Health >= 70 && PawnOwner.Health < 80)
    {
        HH.Texture = HH.HealthSprite[2];
    }
    else if(PawnOwner.Health >= 60 && PawnOwner.Health < 70)
    {
        HH.Texture = HH.HealthSprite[3];
    }
    else if(PawnOwner.Health >= 50 && PawnOwner.Health < 60)
    {
        HH.Texture = HH.HealthSprite[4];
    }
    else if(PawnOwner.Health >= 40 && PawnOwner.Health < 50)
    {
        HH.Texture = HH.HealthSprite[5];
    }
    else if(PawnOwner.Health >= 30 && PawnOwner.Health < 40)
    {
        HH.Texture = HH.HealthSprite[6];
    }
    else if(PawnOwner.Health >= 20 && PawnOwner.Health < 30)
    {
        HH.Texture = HH.HealthSprite[7];
    }
    else if(PawnOwner.Health >= 10 && PawnOwner.Health < 20)
    {
        HH.Texture = HH.HealthSprite[8];
    }
    else if(PawnOwner.Health >= 1 && PawnOwner.Health < 10)
    {
        HH.Texture = HH.HealthSprite[9];
    }
    else if(PawnOwner.Health <= 0)
    {
        HH.Texture = HH.HealthSprite[10];
    }
}
//====
simulated function PostRender(Canvas canvas)
{
	PlayerOwner = Canvas.Viewport.Actor;
    if(NextMutator != none)
    NextMutator.PostRender(Canvas);
}
//====
simulated event Tick( float DeltaTime)
{
    Super.Tick(DeltaTime);
	if (PlayerOwner == None)
	{
		return;
	}
	num_used     = 0;
	player_count = 0;
	symbol_count = 0;
	player_id    = PlayerOwner.PlayerReplicationInfo.PlayerID;
	foreach AllActors (class 'TBDamageBar', HH)
	{
		symbol_count++;
		HH.bHidden = True;
	}
	foreach AllActors (class'Pawn', PawnOwner)
	{
		PRI = PawnOwner.PlayerReplicationInfo;
		if(PRI == none)
		continue;
		if(PawnOwner.Health < 99)
		{
			player_id++;
			if (player_id > symbol_count)
			{
			    HH = Spawn(class 'TBDamageBar', HH);
				HH.bHidden = PawnOwner.bHidden;
				HH.SetOwner(PawnOwner);
				symbol_count++;
			}
			else
			{
				foreach AllActors (class 'TBDamageBar', HH)
				{
					if (HH.bHidden == True)
					{
						HH.bHidden = PawnOwner.bHidden;
						HH.SetOwner(PawnOwner);
						break;
					}
				}
			}
			loc = PawnOwner.Location;
			loc.z += PawnOwner.CollisionHeight * 1.75;
			dir = PawnOwner.Location - PlayerOwner.Location;
			dist = VSize(Dir);
			interp = Dist/32768.0;
			interp -= 0.0 * (1.0-(PlayerOwner.FOVAngle / PlayerOwner.DesiredFOV));
			if (interp < 0.0)
			interp = 0.0;
			if (interp > 0.0)
			interp = 0.0;
			draw_scale = Lerp( interp, mMinScale, mMaxScale);
			HH.SetLocation(loc);
			HH.DrawScale = draw_scale;
			SetSymbol(HH, PawnOwner);
		}
	}
}
//====
defaultproperties
{
    mMinScale=0.300000
    mMaxScale=14.000000
}
