#!/usr/bin/perl

package MasterServer;

use strict;
use warnings;

use Cwd 'abs_path';
our $ROOT;
BEGIN { ($ROOT = abs_path $0) =~ s{/util/MasterServer-perlsqlite\.pl$}{}; }

use lib $ROOT.'/lib';
use MasterServer;

our %C;
require "$ROOT/data/config.pl";

#add %C from config.pl to OBJ
$MasterServer::OBJ->{$_}   = $C{$_} for (keys %C);

# load Development Master libs
MasterServer::load('MasterServer::Core', 
                   'MasterServer::Util',
                   'MasterServer::Database',
                   'MasterServer::Maintenance',
                   'MasterServer::BeaconCatcher',
                   'MasterServer::UBrowserServer',
                   'MasterServer::MasterQuery');

# and let's roll!
MasterServer::run();
