
package MasterServer::Database;

use strict;
use warnings;
use Exporter 'import';

our @EXPORT = qw| addServer |;

################################################################################
##
##   Subroutine addServer
##
##   Add a server to the database (address + port only)
##   Args: hash {ip, port, gamename}
################################################################################
sub addServer {
  my ($self, $ip, $port, $gamename) = @_;
  
  # if address is in list, update the timestamp
  my $u = $self->{dbh}->do("UPDATE serverlist 
                            SET updated = CURRENT_TIMESTAMP,
                               gamename = ?
                            WHERE ip = ? 
                            AND port = ?",
                            undef, $gamename, $ip, $port);
  
  # if found, updated; done
  return if ($u > 0);
  
  # if not found, add it.
  $self->{dbh}->do("INSERT INTO serverlist (ip, port, gamename) 
                    SELECT ?, ?, ?",
                    undef, $ip, $port, lc $gamename);
   
   # DEBUG
   #$self->log("[DB] > $ip:$port -- $gamename game added.");
}

1;
