
package MasterServer::BeaconCatcher;

use strict;
use warnings;
use AnyEvent::Handle::UDP;
use Data::Dumper 'Dumper';
use Socket qw(sockaddr_in inet_ntoa);
use Exporter 'import';

our @EXPORT = qw| BeaconCatcher |;


################################################################################
##
##   Master Server UTBeacon UDP Listener
##
##   Waits for incoming UDP connections from UT servers via Uplink.
##   Stores the received IP and heartbeat port in the ip_list table of the
##   database, so they may be processed further.
##   Adds new addresses, <s>updates the time on excisting ones.</s>
##   Args: $beacon_port must be set above. Default 27900.
################################################################################
sub BeaconCatcher {
my $self = shift;

  my $udp_server = AnyEvent::Handle::UDP->new(
    # Bind to this host and port
    bind => ['0.0.0.0', $self->{beacon_port}],
    on_recv => sub {
      my ($b, $c, $pa) = @_; # beacon address, handle, packed client address
        
      # unpack ip from packed client address
      my ($port, $iaddr) = sockaddr_in($pa);
      my $peer_addr      = inet_ntoa($iaddr);
      
      # deusex support testing-- replace with any $gamename to match tests
      # print Dumper $b if $b =~ m/deusex/i;
      
      # check if valid format was received
      if ($b =~ m/heartbeat/ && $b =~ m/gamename/) {
        
        # received heartbeat in $b:    \heartbeat\7778\gamename\ut\ 
        my %r;
        $b =~ s/\\([^\\]+)\\([^\\]+)/$r{$1}=$2/eg;
        
        # check whether it is an UT server (only gamename = ut)
        if (defined $r{gamename} && $r{gamename} ne "") {
          
          # log beacons. WARNING: spams log with IPs. Useful for debugging.
          # $self->log("[UDP] beacon $peer_addr:$r{heartbeat}");
          
          # add in db
          $self->addServer($peer_addr, $r{heartbeat}, $r{gamename});
        }
        
      } # end if heartbeat + gamename
    }
  );
  
  # display that the server is up and listening for beacons
  $self->log("[OK] > Listening for UT Beacons on port $self->{beacon_port}.");
  
  # allow object to exist out of scope
  return $udp_server;
}

1;
