package MasterServer;
our (%C, $ROOT);
our %C = (
        # executable settings
        dblogin       => ["dbi:SQLite:dbname=$ROOT/data/serverlist.db",'',''],
        logfile       => "$ROOT/log/MasterServer-perlsqlite.log",
        
        # secure validate settings (public edition)
        gsmsalg_path  => "$ROOT/util/gsmsalg2",
        cipher        => { gamespy2  => "",
                           ut        => ""},
                           
        # port settings
        listen_port   => 28905, # 28900
        beacon_port   => 28906, # 27900
        
        # Timer settings: after [s], interval [s]
        MasterQueryTime   => [5,  4800, 60],  # 5 seconds grace time, query masters every X minutes, Y seconds grace time per type
        MaintenanceTime   => [36000, 3600],  # after 10 hours, ever hour
        
        # master server addresses
        master_server => [
          { label => "GameSpy",     ip => "69.10.30.248",  port => 28900},
#         { label => "333networks", ip => "84.83.176.234", port => 28900},
#         { label => "333nw Dev",   ip => "84.83.176.234", port => 28905},
        ],
        master_games => [qw | ras heretic2 legendsmm duke4 globalops il2sturmovik 
                              serioussam serioussamse deusex unreal avp2 descent3 daikatana 
                              civ3con gmtest cneagle bfield1942 sofretail nolf blood2 kohan 
                              thps3pc mohaa shogo bcommander cossacks kingpin insane wot 
                              turok2 bz2 ccrenegade aquanox postal2 ut giants |],
        #master_games => [qw | ut |], # debug / testing
        # not supported or not working: qw| group |
        ignore_key   => [qw| deusex |],
);



# import the ciphers from a file not in this git repository
require "/server/development/ciphers.pl";
1;
