
package MasterServer::Maintenance;

use strict;
use warnings;
use Exporter 'import';

our @EXPORT = qw| ScheduleMaintenance |;

################################################################################
##
##   Cleanup
##
##   Cleaning up old addresses every 5 hours or so
################################################################################
sub ScheduleMaintenance {
  my $self = shift;
  
  my $cleanup = AnyEvent->timer (
    after     => $self->{MaintenanceTime}[0],
    interval  => $self->{MaintenanceTime}[1],
    cb        => sub {
    
    # Delete the ip entries from all servers of which there is no update received
    # in the past 10 hours.
    my $r = $self->{dbh}->do("DELETE FROM serverlist 
                              WHERE updated < datetime(CURRENT_TIMESTAMP, '-36000 seconds');");
    
    # print stats
    $self->log("[DB] > Deleted $r old server entries.");
    
    }
  );
  return $cleanup;
}


1;
