
#include "msx.h"

void udpInit() {

    struct sockaddr_in serverAddress;

    // socket()
    if ((udpSocketDesc = socket(AF_INET, SOCK_DGRAM, 0)) == INVALID_SOCKET){
        printf("Could not create UDP socket: %d", WSAGetLastError());
        exit(EXIT_FAILURE);
    }

    // bind()
    memset(&serverAddress, 0, sizeof(serverAddress));
    serverAddress.sin_family = AF_INET;
    serverAddress.sin_addr.s_addr = htonl(INADDR_ANY);
    serverAddress.sin_port = htons(UDPPORT);

    if ((bind(udpSocketDesc, (struct sockaddr *)&serverAddress, sizeof(serverAddress))) == SOCKET_ERROR){
        printf("Cannot bind UDP socket: %d", WSAGetLastError());
        exit(EXIT_FAILURE);
    }
}

void *udpMasterThread() {

    udpThreadArgStruct *udpThreadArgs = malloc(sizeof(udpThreadArgStruct));
    (*udpThreadArgs).clientAddressLen = sizeof((*udpThreadArgs).clientAddress);

    //printf("malloc() udpMasterThread->udpThreadArgs :%p\n", udpThreadArgs);

    while(1) {
        // accept new connections
        if ((recvfrom(udpSocketDesc, (*udpThreadArgs).buffer, sizeof((*udpThreadArgs).buffer), 0, (struct sockaddr *)&(*udpThreadArgs).clientAddress, &(*udpThreadArgs).clientAddressLen)) != SOCKET_ERROR) {
            if (pthread_create(&thread, &threadAttr, udpThread, (void *)udpThreadArgs)) {
                printf("UDP pthread_create() error\n");
            }
        }
        else {
            printf("UDP recvfrom() failed. Error Code: %d", WSAGetLastError());
        }
        udpThreadArgs = malloc(sizeof(udpThreadArgStruct));
        memset((*udpThreadArgs).buffer, 0, BUFFERSIZE);
        (*udpThreadArgs).clientAddressLen = sizeof((*udpThreadArgs).clientAddress);
        //printf("malloc() udpMasterThread->udpThreadArgs :%p\n", udpThreadArgs);
    }
}


void *udpThread(void *args) {

    unsigned int i = 0, tmp = 0, len = 0, gameNum = 0;
    char *pch = NULL;
    char buffer[BUFFERSIZE], gamename[32], clientAddressStr[22], serverQueryPort[6];

    memset(buffer, 0, BUFFERSIZE);
    udpThreadArgStruct *udpThreadArgs = (udpThreadArgStruct *)args;
    strcpy(buffer, udpThreadArgs->buffer);

    struct sockaddr_in clientAddress = udpThreadArgs->clientAddress;
    free(udpThreadArgs);
    //printf("free() udpThread->udpThreadArgs :%p\n", udpThreadArgs);

    printf("UDP Recv:%s\n", buffer);

    memset(serverQueryPort, 0, 6);
    memset(gamename, 0, 32);

    pch = strtok(buffer, "\\");

    while (pch != NULL) {
        if (!strcmp(pch, "heartbeat")) {
            pch = strtok(NULL, "\\");
            if (pch != NULL) {
                tmp = atoi(pch);
                if ((strlen(pch) < 6) && (tmp > 0) && (tmp < 65536)) {
                    strncpy(serverQueryPort, pch, strlen(pch));
                }
                else {
                    printf("Invalid Server Query Port\n");
                    pthread_exit(NULL);
                    return NULL;
                }
            }
            else {
                printf("Invalid Server Query Port\n");
                pthread_exit(NULL);
                return NULL;
            }
        }
        else if (!strcmp(pch, "gamename")) {
            pch = strtok(NULL, "\\");
            if (pch != NULL) {
                if (strlen(pch) < 33) {
                    strcpy(gamename, pch);
                    printf("gamename:%s\n", gamename);
                }
                else {
                    printf("Invalid gamename\n");
                    pthread_exit(NULL);
                    return NULL;
                }
            }
            else {
                printf("No gamename found\n");
                pthread_exit(NULL);
                return NULL;
            }
        }

        pch = (pch != NULL) ? strtok(NULL, "\\") : NULL;
    }

    // Store client address
    memset(clientAddressStr, 0, 22);
    snprintf(clientAddressStr, 22, "%s:%s", inet_ntoa(clientAddress.sin_addr), serverQueryPort);

    printf("UDP Client:%s|\n", clientAddressStr);
    printf("gamename:%s\n", gamename);

    // Find gamename in game list
    while(gameNum < GAMECOUNT) {
        if (strcmp(gamename, gsGamename[gameNum]) == 0) {
            break;
        }
        gameNum++;
    }

    if (gameNum == GAMECOUNT) {
        printf("Game not found\n");
        pthread_exit(NULL);
        return NULL;
    }

    printf("gameNum:%d\n", gameNum);

    // Star Trek: Bridge Commander default port replacement
    if (!strcmp(gamename, "bcommander")) {
        memset(clientAddressStr, 0, 22);
        snprintf(clientAddressStr, 22, "%s:22101", inet_ntoa(clientAddress.sin_addr));
        printf("Star Trek: Bridge Commander - Replacing serverQueryPort 0 with 22101\n");
    }

    // Check if client address is already listed
    i = 0;
    while (i < dbAddressCount[gameNum]) {
        if (!strcmp(clientAddressStr, dbAddress[gameNum][i])) {
            break;
        }
        i++;
    }

    // if client address not found, add address
    if (i == dbAddressCount[gameNum]){
        printf("Adding server:%s\n", clientAddressStr);
        len = strlen(clientAddressStr);
        dbAddress[gameNum][dbAddressCount[gameNum]] = malloc(len + 1);
        memset(dbAddress[gameNum][dbAddressCount[gameNum]], 0, len + 1);
        memcpy(dbAddress[gameNum][dbAddressCount[gameNum]], clientAddressStr, len);
        dbAddressCount[gameNum]++;
    }

    printf("dbAddressCount[gameNum]:%d\n", dbAddressCount[gameNum]);

    pthread_exit(NULL);
    return NULL;
}
