
#include "msx.h"

void tcpInit() {

    int on = 1, timeout = TCPTHREADTIMEOUT;
    struct sockaddr_in address;

    // socket()
    if ((tcpSocketDesc = socket(AF_INET, SOCK_STREAM, 0)) == INVALID_SOCKET){
        printf("Could not create TCP socket: %d", WSAGetLastError());
        exit(EXIT_FAILURE);
    }

    // setsockopt()
    setsockopt(tcpSocketDesc, SOL_SOCKET, SO_REUSEADDR, (char *)&on, sizeof(on));
    setsockopt(tcpSocketDesc, SOL_SOCKET, SO_SNDTIMEO, (char *)&timeout, sizeof(int));
    setsockopt(tcpSocketDesc, SOL_SOCKET, SO_RCVTIMEO, (char *)&timeout, sizeof(int));

    // bind()
    memset(&address, 0, sizeof(address));
    address.sin_family = AF_INET;
    address.sin_port = htons(TCPPORT);
    address.sin_addr.s_addr = htonl(INADDR_ANY);

    if (bind(tcpSocketDesc, (struct sockaddr *)&address, sizeof(address)) == SOCKET_ERROR){
        printf("Bind failed with error code: %d", WSAGetLastError());
        exit(EXIT_FAILURE);
    }

    // listen()
    listen(tcpSocketDesc, MAXLISTENCONNECTIONS);

}


void *tcpMasterThread() {

    tcpThreadArgStruct *tcpThreadArgs = malloc(sizeof(tcpThreadArgStruct));
    (*tcpThreadArgs).clientAddressLen = sizeof(struct sockaddr);

    //printf("malloc() tcpMasterThread->tcpThreadArgs :%p\n", tcpThreadArgs);

    while(1) {
        // accept new connections
        if (((*tcpThreadArgs).c = accept(tcpSocketDesc, (struct sockaddr *)&(*tcpThreadArgs).clientAddress, &(*tcpThreadArgs).clientAddressLen)) != INVALID_SOCKET) {
            if (pthread_create(&thread, &threadAttr, tcpThread, (void *)tcpThreadArgs)) {
                printf("tcpThread pthread_create() error\n");
            }
        }
        else {
            printf("TCP accept() failed. Error Code: %d", WSAGetLastError());
        }
        tcpThreadArgs = malloc(sizeof(tcpThreadArgStruct));
        (*tcpThreadArgs).clientAddressLen = sizeof(struct sockaddr);
        //printf("malloc() tcpMasterThread->tcpThreadArgs :%p\n", tcpThreadArgs);
    }
}


void *tcpThread(void *args) {

    srand((unsigned)clock());

    unsigned int i = 0, ii = 0;
    int gameNum = 0;

    char buffer[BUFFERSIZE], secureKey[7], secureMsg[22], gamename[32], clientValidateKey[9], ipData[IPDATASIZE];
    char *gsKey = NULL, *pch = NULL, *clientIP = NULL;
    unsigned char *gsValidateKey;

    pthread_setcancelstate(PTHREAD_CANCEL_ENABLE, NULL);
    pthread_setcanceltype(PTHREAD_CANCEL_ASYNCHRONOUS, NULL);

    tcpThreadArgStruct *tcpThreadArgs = (tcpThreadArgStruct *)args;

    int c = tcpThreadArgs->c;
    struct sockaddr_in clientAddress = tcpThreadArgs->clientAddress;
    int clientAddressLen = tcpThreadArgs->clientAddressLen;
    free(tcpThreadArgs);
    //printf("free() tcpThread->tcpThreadArgs :%p\n", tcpThreadArgs);

    // Get client IP
    getpeername(c, (struct sockaddr *)&clientAddress, &clientAddressLen);
    clientIP = inet_ntoa(clientAddress.sin_addr);

    printf("New Connection:%d\n", c);
    printf("Client IP:%s\n", clientIP);

    // Generate secure key
    memset(secureKey, 0, 7);
    memset(secureMsg, 0, 22);
    sprintf(secureKey, "%c%c%c%c%c%c", UCASEALPHA[rand() % 26], UCASEALPHA[rand() % 26], UCASEALPHA[rand() % 26], UCASEALPHA[rand() % 26], UCASEALPHA[rand() % 26], UCASEALPHA[rand() % 26]);
    sprintf(secureMsg, "\\basic\\\\secure\\%s", secureKey);

    // send secure key
    send(c, secureMsg, strlen(secureMsg), 0);
    printf("secureKey:%s|\n", secureKey);
    printf("Send:%s|\n", secureMsg);

    // receive validation string from client
    memset(buffer, 0, BUFFERSIZE);
    if ((recv(c, buffer, sizeof(buffer), 0)) == SOCKET_ERROR) {
        printf("TCP recv failed. Error Code: %d", WSAGetLastError());
        closesocket(c);
        pthread_exit(NULL);
        return(NULL);
    }

    printf("TCP Recv:%s\n", buffer);

    memset(clientValidateKey, 0, 8);
    memset(gamename, 0, 32);

    pch = strtok(buffer, "\\");

    while (pch != NULL) {
        if (!strcmp(pch, "validate")) {
            pch = strtok(NULL, "\\");
            if (pch != NULL) {
                if (strlen(pch) != 8) {
                    printf("Invalid validation key\n");
                    closesocket(c);
                    pthread_exit(NULL);
                    return NULL;
                }
                strncpy(clientValidateKey, pch, 9);
                printf("clientValidateKey:%s\n", clientValidateKey);
            }
            else {
                printf("No validation key found\n");
                closesocket(c);
                pthread_exit(NULL);
                return NULL;
            }
        }
        else if (!strcmp(pch, "gamename")) {
            pch = strtok(NULL, "\\");
            if (pch != NULL) {
                if (strlen(pch) < 33) {
                    strncpy(gamename, pch, strlen(pch));
                    printf("gamename:%s|\n", gamename);
                }
                else {
                    printf("Invalid gamename\n");
                    closesocket(c);
                    pthread_exit(NULL);
                    return NULL;
                }
            }
            else {
                printf("No gamename found\n");
                closesocket(c);
                pthread_exit(NULL);
                return NULL;
            }
        }
        else if (!strcmp(pch, "version")) {
            send(c, "MSx_pre_alpha by Polyverse", 26, 0);
            printf("Version info request - Sent: MSx_pre_alpha by Polyverse\n");
            closesocket(c);
            pthread_exit(NULL);
            return NULL;
        }

        pch = (pch != NULL) ? strtok(NULL, "\\") : NULL;
    }

    if (!strlen(clientValidateKey)) {
        printf("No Validation Key Found\n");
        closesocket(c);
        pthread_exit(NULL);
        return NULL;
    }

    if (!strlen(gamename)) {
        printf("No Gamename Found\n");
        closesocket(c);
        pthread_exit(NULL);
        return NULL;
    }

    // Find gamename, get gameNum and gsKey
    while((gsKey == NULL) && (i < GAMECOUNT)) {
        if (!strcmp(gamename, gsGamename[i])){
            gsKey = gsGamekey[i];
            gameNum = i;
            break;
        }
        i++;
    }

    if (i == GAMECOUNT) {
        printf("Game not found\n");
        closesocket(c);
        pthread_exit(NULL);
        return NULL;
    }

    // Verify \list\ was received, otherwise attempt to receive
    if ((strstr(buffer, "\\list\\")) == NULL) {
        memset(buffer, 0, BUFFERSIZE);
        if ((recv(c, buffer, sizeof(buffer), 0)) == SOCKET_ERROR){
            printf("TCP recv \\list\\ failed. Error Code: %d", WSAGetLastError());
            closesocket(c);
            pthread_exit(NULL);
            return(NULL);
        }
        printf("Recv:%s\n", buffer);

        if ((strstr(buffer, "\\list\\")) == NULL) {
            printf("No \\list\\ request found.\n");
            closesocket(c);
            pthread_exit(NULL);
            return NULL;
        }
    }

    // use gsseckey() to generate validation key using secure key
    gsValidateKey = gsseckey(NULL, (unsigned char *)secureKey, (unsigned char *)gsKey, 0);

    printf("gsValidateKey:%s\n", gsValidateKey);

    // ignore validation for Deus Ex
    if (!strcmp(gamename, "deusex")) {
        strcpy(clientValidateKey, (char *)gsValidateKey);
        printf("Skipping key validation for Deus Ex\n");
    }

    // compare client validate key with gsseckey() key
    if (!strcmp((char *)gsValidateKey, clientValidateKey)) {
        printf("Keys match\n");
        free(gsValidateKey);

        memset(ipData, 0, IPDATASIZE);

        // server list formatting
        if (!strcmp(gamename, "bcommander")) {
            pch = NULL;
            for (i = 0; i < dbAddressCount[gameNum]; i++) {
                char *tempIPData = malloc(strlen(dbAddress[gameNum][i]));
                strcpy(tempIPData, dbAddress[gameNum][i]);
                pch = strtok(tempIPData, ".:");
                for (ii = 0; ii < 4; ii++) {
                    sprintf(ipData,"%s%c", ipData, (unsigned char)atoi(pch));
                    pch = strtok(NULL, ".:");
                }
                sprintf(ipData,"%s%c%c", ipData, (unsigned char)(atoi(pch) >> 8), (unsigned char)atoi(pch));
                free(tempIPData);
            }
            sprintf(ipData, "%s\\final\\", ipData);
        }
        else {
            for (i = 0; i < dbAddressCount[gameNum]; i++) {
                sprintf(ipData,"%s\\ip\\%s", ipData, dbAddress[gameNum][i]);
            }

            sprintf(ipData, "%s\\final\\", ipData);

            printf("ipData:%s\n", ipData);
        }

        send(c, ipData, strlen(ipData), 0);
        printf("ipData sent\n");
    }
    else {
        printf("Key mismatch\n");
        free(gsValidateKey);
        closesocket(c);
        pthread_exit(NULL);
        return NULL;
    }

    closesocket(c);
    pthread_exit(NULL);
    return NULL;
}
