
#include "msx.h"

pthread_t thread;
pthread_attr_t threadAttr;

void udpInit(), tcpInit(), initGSKeys();
void *udpMasterThread(), *tcpMasterThread();
void *udpThread(), *tcpThread();

SOCKET udpSocketDesc;
SOCKET tcpSocketDesc;

char *gsGamename[GAMECOUNT], *gsGamekey[GAMECOUNT], *dbAddress[GAMECOUNT][DBSIZE];

unsigned int dbAddressCount[GAMECOUNT];
unsigned char *gsseckey(unsigned char *dst, unsigned char *src, unsigned char *key, int enctype);

int main() {

    WSADATA wsa;

    // read gsGamename/gsGamekey values
    initGSKeys();

    // set thread attributes to detached
    if (pthread_attr_init(&threadAttr)) {
        printf("pthread_attr_init() error\n");
    }

    if (pthread_attr_setdetachstate(&threadAttr, PTHREAD_CREATE_DETACHED)) {
        printf("pthread_attr_setdetachstate() error\n");
    }

    // Winsock
    if (WSAStartup(MAKEWORD(2, 2), &wsa) != 0) {
        printf("Failed. Error Code: %d", WSAGetLastError());
    }

    // set up UDP/TCP sockets
    udpInit();
    tcpInit();

    // create master UDP/TCP threads
    if (pthread_create(&thread, &threadAttr, udpMasterThread, NULL)) {
        printf("udpMasterThread pthread_create() error\n");
    }

    if (pthread_create(&thread, &threadAttr, tcpMasterThread, NULL)) {
        printf("tcpMasterThread pthread_create() error\n");
    }

    printf("MSx online.\n");

    while(1) {
        Sleep(-1);
    }

    return 0;
}

