class MPLLadderNewGame extends DeathmatchPlus;//UTIntro;

event playerpawn login //from MPLLadderLoadGame
(
	string Portal,
	string Options,
	out string Error,
	class<playerpawn> SpawnClass
)
{
	local PlayerPawn NewPlayer;
	local SpectatorCam Cam;

	NewPlayer.ReducedDamageType = 'All';
	NewPlayer = Super(TournamentGameInfo).login(Portal, Options, Error, SpawnClass);
	//NewPlayer.bHidden = True;

	foreach AllActors(class'SpectatorCam', Cam) 
		NewPlayer.ViewTarget = Cam;

	return NewPlayer;
}

function AcceptInventory(pawn PlayerPawn)
{
	local inventory Inv, Next;
	local MPLLadderInventory LadderObj;

	for( Inv=PlayerPawn.Inventory; Inv!=None; Inv=Next )
	{
		if (Inv.IsA('MPLLadderInventory'))
		{
			LadderObj = MPLLadderInventory(Inv);
		} 
		else
			Inv.Destroy();
	}

	//TournamentConsole(PlayerPawn(PlayerPawn).Player.Console).StartNewGame();
	PlayerPawn.Weapon = None;
	PlayerPawn.SelectedItem = None;
	PlayerPawn.ReducedDamageType = 'All';
}

function PlayTeleportEffect( actor Incoming, bool bOut, bool bSound)
{
}


function bool NeedPlayers()
{
	return false;
}



defaultproperties
{
     bGameEnded=False
     HUDType=Class'UT99MPLadder.MPLCHNullHUD'
     GameName="Tournament Lobby (New Game)"
     FragLimit=0
     TimeLimit=0
}
