//=============================================================================
// DeathMatchPlus.
//=============================================================================
class MPLLadderLoadGame extends DeathmatchPlus//GameInfo//UTIntro
	config(UT99MPLadderConfig);


/*function AddDefaultInventory( pawn PlayerPawn )
{
	local Weapon NewWeapon;
	local Bot B;

	if ( PlayerPawn.IsA('Spectator') || (bRequireReady && (CountDown > 0)) )
		return;

	// Spawn Automag
	GiveWeapon(PlayerPawn, "Botpack.Enforcer");

	Super.AddDefaultInventory(PlayerPawn);

	if ( bUseTranslocator && (!bRatedGame || bRatedTranslocator) )
	{
		// Spawn Translocator.
		if( PlayerPawn.FindInventoryType(class'Translocator')==None )
		{
			newWeapon = Spawn(class'Translocator');
			if( newWeapon != None )
			{
				newWeapon.Instigator = PlayerPawn;
				newWeapon.BecomeItem();
				PlayerPawn.AddInventory(newWeapon);
				newWeapon.GiveAmmo(PlayerPawn);
				newWeapon.SetSwitchPriority(PlayerPawn);
				newWeapon.WeaponSet(PlayerPawn);
			}
		}
	}

	B = Bot(PlayerPawn);
	if ( B != None )
		B.bHasImpactHammer = (B.FindInventoryType(class'ImpactHammer') != None);
}*/	

function GiveWeapon(Pawn PlayerPawn, string aClassName )
{
	local class<Weapon> WeaponClass;
	local Weapon NewWeapon;

	WeaponClass = class<Weapon>(DynamicLoadObject(aClassName, class'Class'));

	if( PlayerPawn.FindInventoryType(WeaponClass) != None )
		return;
	newWeapon = Spawn(WeaponClass);
	if( newWeapon != None )
	{
		newWeapon.RespawnTime = 0.0;
		newWeapon.GiveTo(PlayerPawn);
		newWeapon.bHeldItem = true;
		newWeapon.GiveAmmo(PlayerPawn);
		newWeapon.SetSwitchPriority(PlayerPawn);
		newWeapon.WeaponSet(PlayerPawn);
		newWeapon.AmbientGlow = 0;
		if ( PlayerPawn.IsA('PlayerPawn') )
			newWeapon.SetHand(PlayerPawn(PlayerPawn).Handedness);
		else
			newWeapon.GotoState('Idle');
		PlayerPawn.Weapon.GotoState('DownWeapon');
		PlayerPawn.PendingWeapon = None;
		PlayerPawn.Weapon = newWeapon;
	}
}
	

event playerpawn login //from MPLLadderLoadGame
(
	string Portal,
	string Options,
	out string Error,
	class<playerpawn> SpawnClass
)
{
	local PlayerPawn NewPlayer;
	local SpectatorCam Cam;

	NewPlayer.ReducedDamageType = 'All';
	NewPlayer = Super(TournamentGameInfo).login(Portal, Options, Error, SpawnClass);
	//NewPlayer.bHidden = True;

	foreach AllActors(class'SpectatorCam', Cam) 
		NewPlayer.ViewTarget = Cam;

	return NewPlayer;
}

function AcceptInventory(pawn PlayerPawn) //from MPLLadderLoadGame
{
	local inventory Inv, Next;
	local MPLLadderInventory LadderObj;

	/*for( Inv=PlayerPawn.Inventory; Inv!=None; Inv=Next )
	{
		Inv.Destroy();
	}*/

	for( Inv=PlayerPawn.Inventory; Inv!=None; Inv=Inv.Inventory )
	{
		if (Inv.IsA('MPLLadderInventory'))
		{
			LadderObj = MPLLadderInventory(Inv);
		} 
		else 	
			Inv.Destroy();
	}

	//TournamentConsole(PlayerPawn(PlayerPawn).Player.Console).LoadGame();
	PlayerPawn.Weapon = None;
	PlayerPawn.SelectedItem = None;
	PlayerPawn.ReducedDamageType = 'All';
}


function bool NeedPlayers()
{
	return false;
}

defaultproperties
{
     FragLimit=0
     TimeLimit=0
     GameName="Tournament Lobby (Load Game)"
     HUDType=Class'UT99MPLadder.MPLCHNullHUD'
}
