//=============================================================================
// Ladder
// A ladder game ladder.
//=============================================================================
class MPLLadder extends Info
	abstract
	config(UT99MPLadderConfig);

var() config int			Matches;						// # of matches in ladder.
var() config bool			bTeamGame;						// TeamGame ladder?
var() config localized string	    Titles[9];						// Ranking titles.
var() config string		MapPrefix;						// Match map prefix.

// 32 Matches
var() config string	    Maps[32];						// Match map.
var() config string	    MapAuthors[32];					// Map authors.
var() config localized string	    MapTitle[32];					// Map title.
var() config localized string	    MapDescription[32];				// Map description.
var() config int			RankedGame[32];					// Rank to award upon completion.
var() config int			GoalTeamScore[32];				// Match goalteamscore.
var() config int			FragLimits[32];					// Match fraglimit.
var() config int			TimeLimits[32];					// Match timelimit.
var() config string		MatchInfo[32];					// BotConfig to use for each game
													// The botconfig has all the info about
													// individual bots in this match
var() config int			DemoDisplay[32];				// This match is for demo display only.

var() config class<MPLRatedTeamInfo> LadderTeams[32];			// Teams that can be fought in this ladder
var() config int			NumTeams;						// Number of LadderTeams

var   globalconfig bool	HasBeatenGame;

static function Class<MPLRatedMatchInfo> GetMatchConfigType(int Index)
{
	return Class<MPLRatedMatchInfo>(DynamicLoadObject(Default.MatchInfo[Index], class'Class'));
}

static function string GetMap( int Index )
{
	return Default.Maps[Index];
}

static function string GetAuthor( int Index )
{
	return Default.MapAuthors[Index];
}

static function string GetMapTitle( int Index )
{
	return Default.MapTitle[Index];
}

static function string GetDesc( int Index )
{
	return Default.MapDescription[Index];
}

static function string GetRank( int Index )
{
	return Default.Titles[Index];
}

static function int GetFragLimit( int Index )
{
	return Default.FragLimits[Index];
}

static function int GetGoalTeamScore( int Index )
{
	return Default.GoalTeamScore[Index];
}

defaultproperties
{
     Titles(0)="Untrained"
     Titles(1)="Contender"
     Titles(2)="Light Weight"
     Titles(3)="Heavy Weight"
     Titles(4)="Warlord"
     Titles(5)="Battle Master"
     Titles(6)="Champion"
     LadderTeams(0)=Class'UT99MPLadder.MPLRatedTeamInfo1'
     LadderTeams(1)=Class'UT99MPLadder.MPLRatedTeamInfo2'
     LadderTeams(2)=Class'UT99MPLadder.MPLRatedTeamInfo3'
     LadderTeams(3)=Class'UT99MPLadder.MPLRatedTeamInfo4'
     LadderTeams(4)=Class'UT99MPLadder.MPLRatedTeamInfo5'
     LadderTeams(5)=Class'UT99MPLadder.MPLRatedTeamInfo6'
     LadderTeams(6)=Class'UT99MPLadder.MPLRatedTeamInfoS'
     LadderTeams(7)=Class'UT99MPLadder.MPLRatedTeamInfoDemo1'
     LadderTeams(8)=Class'UT99MPLadder.MPLRatedTeamInfoDemo2'
     NumTeams=7
}
