//=============================================================================
// Domination.
//=============================================================================
class MPLDomination extends Domination//MPLTeamGamePlus
	config(UT99MPLadderConfig);

/*var bool bNeutralPoints;
var config bool bDumbDown;			// reduce efficiency of bot team AI
var ControlPoint ControlPoints[16]; // control point list used for AI
									// (so game could have more than 16, but bots will only understand first 16
var MPLControlPoint MPLControlPoints[16];
var int DomScoreEvent;				// used to track when to dump out periodic stat information
*/
var MPLRatedMatchInfo MPLRatedMatchConfig;
var MPLLadderInventory MPLRatedGameLadderObj;
var() globalconfig int NumExtraPlayers;

function PostBeginPlay()
{
	
	local NavigationPoint N;
	local int TempTotal;
	local int i;
	//from TeamGamePlus
	for (i=0;i<4;i++)
	{
		//moved to startmatch to fix team assignment
		/*Teams[i] = Spawn(class'TeamInfo');
		Teams[i].Size = 0;
		Teams[i].Score = 0;
		Teams[i].TeamName = TeamColor[i];
		Teams[i].TeamIndex = i;*/
		TournamentGameReplicationInfo(GameReplicationInfo).Teams[i] = Teams[i];

	}
	//end TeamGamePlus stuff
	Super(DeathmatchPlus).PostBeginPlay();

	//from Domination
	for ( N=Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
		if ( N.IsA('ControlPoint') )
		{
			ControlPoints[TempTotal] = ControlPoint(N);
			TempTotal++;
		}
	//end Domination stuff

	//from TeamGamePlus
	if ( bRatedGame )
	{
		FriendlyFireScale = 0;
		MaxTeams = 2;
	}
	//end TeamGamePlus stuff
}

function StartMatch()
{	
	local Pawn P;
	local TimedTrigger T;
	local int i;

	if (Locallog != None)
		Locallog.logGameStart();
	if (Worldlog != None)
		Worldlog.logGameStart();

	ForEach AllActors(class'TimedTrigger', T)
		T.SetTimer(T.DelaySeconds, T.bRepeating);
	//if ( Level.NetMode != NM_Standalone )
	//	RemainingBots = 0;
	GameReplicationInfo.RemainingMinute = RemainingTime;
	bStartMatch = true;

	// start players first (in their current startspots)
	for ( P = Level.PawnList; P!=None; P=P.nextPawn )
		if ( P.bIsPlayer && P.IsA('PlayerPawn') )
		{
			if ( bGameEnded ) return; // telefrag ended the game with ridiculous frag limit
			else if ( !P.IsA('Spectator')  )
			{
				P.PlayerRestartState = P.Default.PlayerRestartState;
				P.GotoState(P.Default.PlayerRestartState);
				if ( !P.IsA('Commander') )
				{
					if ( !RestartPlayer(P) )
						P.GotoState('Dying'); //failed to restart player, so let him try to respawn again
				}
			}
			SendStartMessage(PlayerPawn(P));
		}


	for ( P = Level.PawnList; P!=None; P=P.nextPawn )
		if ( P.bIsPlayer && !P.IsA('PlayerPawn') )
		{
			P.RestartPlayer();
			if ( P.IsA('Bot') )
				Bot(P).StartMatch();
		}
	bStartMatch = false;


	//new - from TeamGamePlus PostBeginPlay
	for (i=0;i<4;i++)
	{
		Teams[i] = Spawn(class'TeamInfo');
		Teams[i].Size = 0;
		Teams[i].Score = 0;
		Teams[i].TeamName = TeamColor[i];
		Teams[i].TeamIndex = i;
		TournamentGameReplicationInfo(GameReplicationInfo).Teams[i] = Teams[i];

	}
}


event Postlogin( playerpawn NewPlayer )
{
	Super(TournamentGameInfo).Postlogin(NewPlayer);
	//if ( Level.NetMode == NM_Standalone )
	//{
		while ( (RemainingBots > 0) && AddBot() )
			RemainingBots--;
	
	//}
	//else
	//	RemainingBots = 0;

	if ( !bRatedGame )
	{
		PlayStartUpMessage(NewPlayer);
		NewPlayer.SetProgressTime(6);
	}
}


// Set game settings based on ladder information.
// Called when RatedPlayer //logs in.
function MPLInitRatedGame(MPLLadderInventory LadderObj, PlayerPawn LadderPlayer)
{
	local class<MPLRatedMatchInfo> RMI;
	local Weapon W;
	local bool bDoneThis;//new 


	bDumbDown = True;
	GoalTeamScore = LadderObj.CurrentLadder.Default.GoalTeamScore[IDnum];
	
	//Super.MPLInitRatedGame(LadderObj, LadderPlayer);	
	//From MPLDeathMatchPlus
	if (bDoneThis) return;

	bDoneThis = true;
	FragLimit = LadderObj.CurrentLadder.Default.FragLimits[IDnum];
	if (MPLRatedGameLadderObj == None)//new
		MPLRatedGameLadderObj = LadderObj;
	//log("MPLRatedGameLadderObj is: "$MPLRatedGameLadderObj);

	if (LadderObj.CurrentLadder.Default.TimeLimits[IDnum] > 0)
		TimeLimit = LadderObj.CurrentLadder.Default.TimeLimits[IDnum];
	bJumpMatch = false;
	bHardCoreMode = true;
	bRequireReady = true; //was true; false is new
	bMegaSpeed = false;
	CountDown = 1;
	bRatedGame = true;
	bCoopWeaponMode = false;
	bUseTranslocator = bRatedTranslocator;
	ForEach AllActors(class'Weapon', W)
		W.bWeaponStay = false;

	if (RatedPlayer == None)
		RatedPlayer = LadderPlayer; 

	//log("RatedPlayer is: "$RatedPlayer);

	// Set up RatedBotConfig for this game
	BotConfig.bAdjustSkill = false;
	RMI = LadderObj.CurrentLadder.Static.GetMatchConfigType(IDnum);
	MPLRatedMatchConfig = spawn(RMI);
	//log("RMI is: "$RMI);
	RemainingBots = MPLRatedMatchConfig.NumBots; 
	//log("MPLRatedMatchConfig.NumBots: "$MPLRatedMatchConfig.NumBots);
	//log("RemainingBots: "$RemainingBots);

	Difficulty = LadderObj.TournamentDifficulty + MPLRatedMatchConfig.ModifiedDifficulty;
	if ( Difficulty >= 4 )
	{
		bNoviceMode = false;
		Difficulty = Difficulty - 4;
	}
	else
	{
		if ( Difficulty > 3 )
		{
			Difficulty = 3;
			bThreePlus = true;
		}
		bNoviceMode = true;
	}

	// Update GRI
	InitGameReplicationInfo();

	// Update //logged Info
	if (bLocallog && bloggingGame)
	{
		logGameParameters(Locallog);
	}
	if (bWorldlog && bloggingGame)
	{
		logGameParameters(Worldlog);
	}

	PlayStartupMessage(LadderPlayer);
	LadderPlayer.SetProgressTime(6);
	//MPLDeathmatchPlus end
	

	bCoopWeaponMode = true;
	FriendlyFireScale = 0.0;
	MaxTeams = 2;
	ForEach AllActors(class'Weapon', W)
		W.SetWeaponStay();
}

function InitRatedGame(LadderInventory LadderObj, PlayerPawn LadderPlayer)
{
}

function bool TooManyBots()
{
	return (NumBots + NumPlayers > MinPlayers + NumExtraPlayers);
}


function bool ForceAddBot()
{
	// add bot during gameplay
	if ( Level.NetMode != NM_Standalone )
		MinPlayers = Max(MinPlayers+1, NumPlayers + NumBots + NumExtraPlayers);
	AddBot();
}


function bool NeedPlayers()
{
	return (!bGameEnded && (NumPlayers + NumBots < MinPlayers + NumExtraPlayers));
}


/* AcceptInventory()
Examine the passed player's inventory, and accept or discard each item
* AcceptInventory needs to gracefully handle the case of some inventory
being accepted but other inventory not being accepted (such as the default
weapon).  There are several things that can go wrong: A weapon's
AmmoType not being accepted but the weapon being accepted -- the weapon
should be killed off. Or the player's selected inventory item, active
weapon, etc. not being accepted, leaving the player weaponless or leaving
the HUD inventory rendering messed up (AcceptInventory should pick another
applicable weapon/item as current).
*/
function AcceptInventory(pawn PlayerPawn)
{
	local inventory Inv;
	local MPLLadderInventory LadderObj;

	// DeathMatchPlus accepts MPLLadderInventory
	for( Inv=PlayerPawn.Inventory; Inv!=None; Inv=Inv.Inventory )
	{
		if (Inv.IsA('MPLLadderInventory'))
		{ 
			LadderObj = MPLLadderInventory(Inv);
		} 
		else 	
			Inv.Destroy();
	}
	PlayerPawn.Weapon = None;
	PlayerPawn.SelectedItem = None;
	AddDefaultInventory( PlayerPawn );
}


function Bot SpawnRatedBot(out NavigationPoint StartSpot)
{
	local bot NewBot;
	local int BotN;
	local bool bEnemy;

	//log("1");
	//log("RemainingBots: "$RemainingBots);
	//log("NumAllies: "$MPLRatedMatchConfig.NumAllies);
	//log("NumExtraPlayers: "$NumExtraPlayers);
	if (RemainingBots > MPLRatedMatchConfig.NumAllies/* + NumExtraPlayers*/)
		bEnemy = True;
	//log("2");
	BotN = MPLRatedMatchConfig.ChooseBotInfo(bTeamGame, bEnemy);
	//log("bEnemy: "$bEnemy);
	//log("BotN: "$BotN);
	//log("3");
	// Find a start spot.
	StartSpot = FindPlayerStart(None, 255);
	//log("4");
	if( StartSpot == None )
	{
		//log("5");
		//log("Could not find starting spot for Bot");
		return None;
	}
	//log("6");

	// Try to spawn the bot.
	NewBot = Spawn(MPLRatedMatchConfig.GetBotClass(BotN, bTeamGame, bEnemy, RatedPlayer),,,StartSpot.Location,StartSpot.Rotation);
	if ( NewBot == None )
	{
		//log("7");
		if ( (MPLRatedMatchConfig.EnemyTeam == class'MPLRatedTeamInfo7')
			|| (MPLRatedMatchConfig.EnemyTeam == class'MPLRatedTeamInfo8') )
			MPLRatedMatchConfig.EnemyTeam = class'MPLRatedTeamInfo3';
		//log("Couldn't spawn player at "$StartSpot);
	}

	if ( NewBot != None )
	{
		// Set the player's ID.
		NewBot.PlayerReplicationInfo.PlayerID = CurrentID++;
	
		MPLRatedMatchConfig.Individualize(NewBot, BotN, NumBots, bTeamGame, bEnemy);
		NewBot.ViewRotation = StartSpot.Rotation;
		// broadcast a welcome message.
		BroadcastMessage( NewBot.PlayerReplicationInfo.PlayerName$EnteredMessage, false );

		ModifyBehaviour(NewBot);
		AddDefaultInventory( NewBot );
		NumBots++;
		if ( bRequireReady && (CountDown > 0) )
			NewBot.GotoState('Dying', 'WaitingForStart');
		NewBot.AirControl = 0.35;
	}

	return NewBot;
}


//
// Discard a player's inventory after he dies.
//
function DiscardInventory( Pawn Other )
{
	local actor dropped;
	local inventory Inv, NextInv;
	local weapon weap;
	local float speed;
	local MPLLadderInventory MainLadderInventory;

	if( Other.DropWhenKilled != None )
	{
		dropped = Spawn(Other.DropWhenKilled,,,Other.Location);
		Inv = Inventory(dropped);
		if ( Inv != None )
		{ 
			Inv.RespawnTime = 0.0; //don't respawn
			Inv.BecomePickup();		
		}
		if ( dropped != None )
		{
			dropped.RemoteRole = ROLE_DumbProxy;
			dropped.SetPhysics(PHYS_Falling);
			dropped.bCollideWorld = true;
			dropped.Velocity = Other.Velocity + VRand() * 280;
		}
		if ( Inv != None )
			Inv.GotoState('PickUp', 'Dropped');
	}					
	if( (Other.Weapon!=None) && (Other.Weapon.Class!=BaseMutator.MutatedDefaultWeapon()) 
		&& ((Other.Weapon.Ammotype == None) || (Other.Weapon.Ammotype.AmmoAmount > 0))
		&& Other.Weapon.bCanThrow )
	{
		speed = VSize(Other.Velocity);
		weap = Other.Weapon;
		if (speed != 0)
			weap.Velocity = Normal(Other.Velocity/speed + 0.5 * VRand()) * (speed + 280);
		else {
			weap.Velocity.X = 0;
			weap.Velocity.Y = 0;
			weap.Velocity.Z = 0;
		}
		Other.TossWeapon();
	}
	Other.Weapon = None;
	Other.SelectedItem = None;

	// Destroy the inventory list.
	Inv = Other.Inventory;
	while (Inv != None)
	{
		NextInv = Inv.Inventory;
		if (!Inv.IsA('MPLLadderInventory'))
		{
			Inv.DropInventory();
			Inv.Destroy();
		} else
			MainLadderInventory = MPLLadderInventory(Inv);
		Inv = NextInv;
	}
	if (MainLadderInventory != None)
	{
		Other.Inventory = MainLadderInventory;
		MainLadderInventory = None;
	}
}


function RestartGame()
{
	local string NextMap;
	local MapList myList;

	// multipurpose don't restart variable
	if ( bDontRestart )
		return;

	if ( EndTime > Level.TimeSeconds ) // still showing end screen
		return;

	// Evaluate a rated game.
	if ( bRatedGame )
	{
		// Clear out the advancement fields.
		MPLRatedGameLadderObj.PendingPosition = 0;
		MPLRatedGameLadderObj.PendingRank = 0;
		MPLRatedGameLadderObj.PendingChange = 0;

		// Setup advancement.
		//log("MPLRatedGameLadderObj.LastMatchType before: "$MPLRatedGameLadderObj.LastMatchType);
		MPLRatedGameLadderObj.LastMatchType = LadderTypeIndex;
		//log("MPLRatedGameLadderObj.LastMatchType after: "$MPLRatedGameLadderObj.LastMatchType);
		if ( SuccessfulGame() )
		{
			//log("Won game");
			//log("LadderTypeIndex: "$LadderTypeIndex);
			//log("MPLRatedGameLadderObj.CurrentLadder: "$MPLRatedGameLadderObj.CurrentLadder);
			//log("IDnum: "$IDnum);		
			MPLRatedGameLadderObj.PendingChange = LadderTypeIndex;
			if (IDnum < MPLRatedGameLadderObj.CurrentLadder.Default.Matches-1)
				MPLRatedGameLadderObj.PendingPosition = IDnum+1;	// We are advancing to the next match.
			//log("MPLRatedGameLadderObj.PendingPosition: "$MPLRatedGameLadderObj.PendingPosition);
			MPLRatedGameLadderObj.PendingRank = MPLRatedGameLadderObj.CurrentLadder.Default.RankedGame[IDnum];
		}
		//log("After SuccessfulGame if");

		RatedPlayer.Health = RatedPlayer.Default.Health;
		//RatedPlayer.Level.ServerTravel("DM-MPLobby"$"?Game=UT99MPLadder.MPLLadderTransition", True);
		RatedPlayer.Level.ServerTravel("DM-MPLobby"$"?Game=UT99MPLadder.MPLLadderTransition?MinPlayers=0", True);
		return;
	}

	// these server travels should all be relative to the current URL
	if ( bChangeLevels && !bAlreadyChanged && (MapListType != None) )
	{
		// open a the nextmap actor for this game type and get the next map
		bAlreadyChanged = true;
		myList = spawn(MapListType);
		NextMap = myList.GetNextMap();
		myList.Destroy();
		if ( NextMap == "" )
			NextMap = GetMapName(MapPrefix, NextMap,1);

		if ( NextMap != "" )
		{
			//log("In nextmap if");
			//Level.ServerTravel(NextMap, false);
			RatedPlayer.Level.ServerTravel("DM-MPLobby"$"?Game=UT99MPLadder.MPLLadderTransition?MinPlayers=0", false);
			//Level.ServerTravel("DM-MPLobby"$"?Game=UT99MPLadder.MPLLadderTransition", False);
			return;
		}
	}

	Level.ServerTravel("?Restart" , false);
}


function Timer()
{
	local Pawn P;
	local bool bReady;
	local int M;
	local NavigationPoint N;
	local ControlPoint CP;
	local int i;
	local float c;
	local PlayerReplicationInfo PRI;

	Super(DeathMatchPlus).Timer();

	//new start
	if ( !bGameEnded )
	{
		c = 0.2;
		if ( TimeLimit > 0 )
		{
			if ( RemainingTime < 0.25 * TimeLimit )
			{
				if ( RemainingTime < 0.1 * TimeLimit )
					c = 0.8;
				else
					c = 0.4;
			}
		}

		if ( !bRequireReady || (CountDown <= 0) )
			for ( N=Level.NavigationPointList; N!=None; N=N.nextNavigationPoint )
			{
				CP = ControlPoint(N);
				if ( (CP != None) && (CP.ControllingTeam != None) && CP.bScoreReady )
				{
					CP.ControllingTeam.Score += c;
					CP.Controller.PlayerReplicationInfo.Score += c;
				}
			}
		DomScoreEvent++;
		if (DomScoreEvent >= 5)
		{
			DomScoreEvent = 0;
			for (i=0; i<4; i++)
			{
				if (Teams[i].Score > 0)
				{
					if (Level.Game.Worldlog != None)
						Level.Game.Worldlog.logSpecialEvent("dom_score_update", i, Teams[i].Score);
					if (Level.Game.Locallog != None)
						Level.Game.Locallog.logSpecialEvent("dom_score_update", i, Teams[i].Score);
				}
			}
			for (i=0; i<32; i++)
			{
				PRI = GameReplicationInfo.PRIArray[i];
				if (PRI != None)
				{
					if (Level.Game.Worldlog != None)
						Level.Game.Worldlog.logSpecialEvent("dom_playerscore_update", PRI.PlayerID, int(PRI.Score));
					if (Level.Game.Locallog != None)
						Level.Game.Locallog.logSpecialEvent("dom_playerscore_update", PRI.PlayerID, int(PRI.Score));				
				}
			}
		}
		if ( GoalTeamScore > 0 )
			for ( i=0; i<4; i++ )
				if ( Teams[i].Score >= GoalTeamScore )
					EndGame("teamscorelimit");
	}
	//new end
	if ( bNetReady )
	{
		if ( NumPlayers > 0 )
			ElapsedTime++;
		else
			ElapsedTime = 0;
		if ( ElapsedTime > NetWait )
		{
			if ( (NumPlayers + NumBots < 4) && NeedPlayers() )
			{
				//log("Timer if: needplayers");
				AddBot();
			}
			else if ( (NumPlayers + NumBots > 1) || ((NumPlayers > 0) && (ElapsedTime > 2 * NetWait)) )
				bNetReady = false;
		}

		if ( bNetReady )
		{
			for (P=Level.PawnList; P!=None; P=P.NextPawn )
				if ( P.IsA('PlayerPawn') )
					PlayerPawn(P).SetProgressTime(2);
			return;
		}
		else
		{
			while ( NeedPlayers() )
			{
				//log("Timer while: needplayers");
				AddBot();
			}
			bRequireReady = false;//was uncommented
			StartMatch(); //was uncommented
		}
	}

	if ( bRequireReady && (CountDown > 0) )
	{
		while ( (RemainingBots > 0) && AddBot() )
			RemainingBots--;
		for (P=Level.PawnList; P!=None; P=P.NextPawn )
			if ( P.IsA('PlayerPawn') )
				PlayerPawn(P).SetProgressTime(2);
		if ( ((NumPlayers == MaxPlayers) || (Level.NetMode == NM_Standalone)) 
				&& (RemainingBots <= 0) )
		{	
			bReady = true;
			for (P=Level.PawnList; P!=None; P=P.NextPawn )
				if ( P.IsA('PlayerPawn') && !P.IsA('Spectator')
					&& !PlayerPawn(P).bReadyToPlay )
					bReady = false;
			
			if ( bReady )
			{	
				StartCount = 30;
				CountDown--;
				if ( CountDown <= 0 )
					StartMatch();
				else
				{
					for ( P = Level.PawnList; P!=None; P=P.nextPawn )
						if ( P.IsA('PlayerPawn') )
						{
							PlayerPawn(P).ClearProgressMessages();
							if ( (CountDown < 11) && P.IsA('TournamentPlayer') )
								TournamentPlayer(P).TimeMessage(CountDown);
							else
								PlayerPawn(P).SetProgressMessage(CountDown$CountDownMessage, 0);
						}
				}
			}
			else if ( StartCount > 8 ) 
			{
				for ( P = Level.PawnList; P!=None; P=P.nextPawn )
					if ( P.IsA('PlayerPawn') )
					{
						PlayerPawn(P).ClearProgressMessages();
						PlayerPawn(P).SetProgressTime(2);
						PlayerPawn(P).SetProgressMessage(WaitingMessage1, 0);
						PlayerPawn(P).SetProgressMessage(WaitingMessage2, 1);
						if ( PlayerPawn(P).bReadyToPlay )
							PlayerPawn(P).SetProgressMessage(ReadyMessage, 2);
						else
							PlayerPawn(P).SetProgressMessage(NotReadyMessage, 2);
					}
			}
			else
			{
				StartCount++;
				if ( Level.NetMode != NM_Standalone )
					StartCount = 30;
			}
		}
		else
		{
			for ( P = Level.PawnList; P!=None; P=P.nextPawn )
				if ( P.IsA('PlayerPawn') )
					PlayStartupMessage(PlayerPawn(P));
		}
	}	
	else
	{
		if ( bAlwaysForceRespawn || (bForceRespawn && (Level.NetMode != NM_Standalone)) )
			For ( P=Level.PawnList; P!=None; P=P.NextPawn )
			{
				if ( P.IsInState('Dying') && P.IsA('PlayerPawn') && P.bHidden )
					PlayerPawn(P).ServerReStartPlayer();
			}
		if ( Level.NetMode != NM_Standalone )
		{
			if ( NeedPlayers() )
			{
				//log("Timer if 2: needplayers");
				AddBot();
			}
		}
		else
			while ( (RemainingBots > 0) && AddBot() )
				RemainingBots--;
		if ( bGameEnded )
		{
			if ( Level.TimeSeconds > EndTime + RestartWait )
				RestartGame();
		}
		else if ( !bOverTime && (TimeLimit > 0) )
		{
			GameReplicationInfo.bStopCountDown = false;
			RemainingTime--;
			GameReplicationInfo.RemainingTime = RemainingTime;
			if ( RemainingTime % 60 == 0 )
				GameReplicationInfo.RemainingMinute = RemainingTime;
			if ( RemainingTime <= 0 )
				EndGame("timelimit");
		}
		else
		{
			ElapsedTime++;
			GameReplicationInfo.ElapsedTime = ElapsedTime;
		}
	}
}

// Parse options for this game...
event InitGame( string Options, out string Error )
{
	local string InOpt;

	//log("Game is: "$Self);
	Super(TournamentGameInfo).InitGame(Options, Error);

	RemainingTime = 60 * TimeLimit;
	SetGameSpeed(GameSpeed);
	FragLimit = GetIntOption( Options, "FragLimit", FragLimit );
	TimeLimit = GetIntOption( Options, "TimeLimit", TimeLimit );
	MaxCommanders = GetIntOption( Options, "MaxCommanders", MaxCommanders );
	MinPlayers = GetIntOption( Options, "MinPlayers", MinPlayers );//new

	InOpt = ParseOption( Options, "CoopWeaponMode");
	if ( InOpt != "" )
	{
		//log("CoopWeaponMode: "$bool(InOpt));
		bCoopWeaponMode = bool(InOpt);
	}

	IDnum = -1;
	IDnum = GetIntOption( Options, "Tournament", IDnum );
	if ( IDnum > 0 )
	{
		bRatedGame = true;
		TimeLimit = 0;
		RemainingTime = 0;
	}
	if ( bTournament ) 
	{
		bRequireReady = true;
		CheckReady();
	}
	if ( Level.NetMode == NM_StandAlone )
	{
		bRequireReady = true;
		CountDown = 1;
	}
	if ( !bRequireReady && (Level.NetMode != NM_Standalone) )
	{
		bRequireReady = true;
		bNetReady = true;
	}
}

// Commented out for release version.
function Skip()
{
	if (bRatedGame)
	{
		MPLRatedGameLadderObj.LastMatchType = LadderTypeIndex;
		MPLRatedGameLadderObj.PendingChange = LadderTypeIndex;
		if (IDnum < MPLRatedGameLadderObj.CurrentLadder.Default.Matches-1)
			MPLRatedGameLadderObj.PendingPosition = IDnum+1;
		MPLRatedGameLadderObj.PendingRank = MPLRatedGameLadderObj.CurrentLadder.Default.RankedGame[IDnum];

		//RatedPlayer.ClientTravel("UT-//logo-Map.unr"$"?Game=Botpack.LadderTransition", TRAVEL_Absolute, True);
		RatedPlayer.Level.ServerTravel("DM-MPLobby.unr"$"?Game=UT99MPLadder.MPLLadderTransition", True);
		return;
	}
}

function SkipAll()
{
	if (bRatedGame)
	{
		MPLRatedGameLadderObj.DMPosition = class'MPLLadderDMGOTY'.Default.Matches - 1;
		MPLRatedGameLadderObj.DMRank = 6;
		MPLRatedGameLadderObj.DOMPosition = class'MPLLadderDOM'.Default.Matches - 1;
		MPLRatedGameLadderObj.DOMRank = 6;
		MPLRatedGameLadderObj.CTFPosition = class'MPLLadderCTFGOTY'.Default.Matches - 1;
		MPLRatedGameLadderObj.CTFRank = 6;
		MPLRatedGameLadderObj.ASPosition = class'MPLLadderAS'.Default.Matches - 1;
		MPLRatedGameLadderObj.ASRank = 6;
		MPLRatedGameLadderObj.ChalPosition = class'MPLLadderChal'.Default.Matches - 1;
		MPLRatedGameLadderObj.ChalRank = 6;

		MPLRatedGameLadderObj.LastMatchType = LadderTypeIndex;
		MPLRatedGameLadderObj.PendingChange = LadderTypeIndex;
		MPLRatedGameLadderObj.PendingPosition = 0;
		MPLRatedGameLadderObj.PendingRank = 0;

		//RatedPlayer.ClientTravel("UT-//logo-Map.unr"$"?Game=Botpack.LadderTransition", TRAVEL_Absolute, True);
		RatedPlayer.Level.ServerTravel("DM-MPLobby"$"?Game=UT99MPLadder.MPLLadderTransition", True);

		return;
	}
}

defaultproperties
{
     bDumbDown=True
     bScoreTeamKills=False
     GoalTeamScore=100.000000
     bUseTranslocator=True
     bRatedTranslocator=True
     StartUpMessage="Capture and hold control points to win."
     gamegoal="points wins the match!"
     LadderTypeIndex=3
     bCoopWeaponMode=True
     ScoreBoardType=Class'Botpack.DominationScoreboard'
     HUDType=Class'Botpack.ChallengeDominationHUD'
     MapListType=Class'Botpack.DOMMapList'
     MapPrefix="DOM"
     BeaconName="DOM"
     GameName="Domination"
}
