//=============================================================================
// DeathMatchPlus.
//=============================================================================
class MPLDeathMatchPlus extends DeathMatchPlus
	config(UT99MPLadderConfig);

var MPLRatedMatchInfo MPLRatedMatchConfig;
var MPLLadderInventory MPLRatedGameLadderObj;
var() globalconfig int NumExtraPlayers;

function PostBeginPlay()
{
	local string NextPlayerClass;
	local int i;

	if ( bAlternateMode )
	{
		bVeryLowGore = true;
		bLowGore = true;
	}
	BotConfig = spawn(BotConfigType);
	if ( Level.NetMode == NM_Standalone )
		RemainingBots = InitialBots;
	else
		RemainingBots = 0;
	Super(TournamentGameInfo).PostBeginPlay();
	GameReplicationInfo.RemainingTime = RemainingTime;
}

function PreCacheReferences()
{
	//never called - here to force precaching of meshes
	spawn(class'TMale1');
	spawn(class'TMale2');
	spawn(class'TFemale1');
	spawn(class'TFemale2');
	spawn(class'ImpactHammer');
	spawn(class'Translocator');
	spawn(class'Enforcer');
	spawn(class'UT_Biorifle');
	spawn(class'ShockRifle');
	spawn(class'PulseGun');
	spawn(class'Ripper');
	spawn(class'Minigun2');
	spawn(class'UT_FlakCannon');
	spawn(class'UT_Eightball');
	spawn(class'SniperRifle');
}

function CheckReady()
{
	if ( (FragLimit == 0) && (TimeLimit == 0) )
	{
		TimeLimit = 20;
		RemainingTime = 60 * TimeLimit;
	}
}

//
// Set gameplay speed.
//
function SetGameSpeed( Float T )
{
	GameSpeed = FMax(T, 0.1);
	if ( bHardCoreMode )
	{
		if ( bChallengeMode )
			Level.TimeDilation = 1.25 * GameSpeed;
		else
			Level.TimeDilation = 1.1 * GameSpeed;
	}
	else
		Level.TimeDilation = GameSpeed;
	SaveConfig();
	SetTimer(Level.TimeDilation, true);
}

function PlayTeleportEffect( actor Incoming, bool bOut, bool bSound)
{
 	local UTTeleportEffect PTE;

	if ( bRequireReady && (Countdown > 0) )
		return;

	if ( Incoming.bIsPawn && (Incoming.Mesh != None) )
	{
		if ( bSound )
		{
 			PTE = Spawn(class'UTTeleportEffect',Incoming,, Incoming.Location, Incoming.Rotation);
 			PTE.Initialize(Pawn(Incoming), bOut);
			PTE.PlaySound(sound'Resp2A',, 10.0);
		}
	}
}

// Parse options for this game...
event InitGame( string Options, out string Error )
{
	local string InOpt;

	//log("Game is: "$Self);
	Super(TournamentGameInfo).InitGame(Options, Error);

	RemainingTime = 60 * TimeLimit;
	SetGameSpeed(GameSpeed);
	FragLimit = GetIntOption( Options, "FragLimit", FragLimit );
	TimeLimit = GetIntOption( Options, "TimeLimit", TimeLimit );
	MaxCommanders = GetIntOption( Options, "MaxCommanders", MaxCommanders );
	MinPlayers = GetIntOption( Options, "MinPlayers", MinPlayers );//new

	InOpt = ParseOption( Options, "CoopWeaponMode");
	if ( InOpt != "" )
	{
		//log("CoopWeaponMode: "$bool(InOpt));
		bCoopWeaponMode = bool(InOpt);
	}

	IDnum = -1;
	IDnum = GetIntOption( Options, "Tournament", IDnum );
	if ( IDnum > 0 )
	{
		bRatedGame = true;
		TimeLimit = 0;
		RemainingTime = 0;
	}
	if ( bTournament ) 
	{
		bRequireReady = true;
		CheckReady();
	}
	if ( Level.NetMode == NM_StandAlone )
	{
		bRequireReady = true;
		CountDown = 1;
	}
	if ( !bRequireReady && (Level.NetMode != NM_Standalone) )
	{
		bRequireReady = true;
		bNetReady = true;
	}
}

// Set game settings based on ladder information.
// Called when RatedPlayer //logs in.
function MPLInitRatedGame(MPLLadderInventory LadderObj, PlayerPawn LadderPlayer)
{
	local class<MPLRatedMatchInfo> RMI;
	local Weapon W;
	local bool bDoneThis;//new 

	////log("MPLInitRatedGame");
	if (bDoneThis) return;

	bDoneThis = true;
	FragLimit = LadderObj.CurrentLadder.Default.FragLimits[IDnum];
	if (MPLRatedGameLadderObj == None)//new
		MPLRatedGameLadderObj = LadderObj;
	//log("MPLRatedGameLadderObj is: "$MPLRatedGameLadderObj);

	if (LadderObj.CurrentLadder.Default.TimeLimits[IDnum] > 0)
		TimeLimit = LadderObj.CurrentLadder.Default.TimeLimits[IDnum];
	bJumpMatch = false;
	bHardCoreMode = true;
	bRequireReady = true; //was true; false is new
	bMegaSpeed = false;
	CountDown = 1;
	bRatedGame = true;
	bCoopWeaponMode = false;
	bUseTranslocator = bRatedTranslocator;
	ForEach AllActors(class'Weapon', W)
		W.bWeaponStay = false;

	if (RatedPlayer == None)
		RatedPlayer = LadderPlayer; 

	//log("RatedPlayer is: "$RatedPlayer);

	// Set up RatedBotConfig for this game
	BotConfig.bAdjustSkill = false;
	RMI = LadderObj.CurrentLadder.Static.GetMatchConfigType(IDnum);
	MPLRatedMatchConfig = spawn(RMI);
	//log("RMI is: "$RMI);
	RemainingBots = MPLRatedMatchConfig.NumBots; 
	Difficulty = LadderObj.TournamentDifficulty + MPLRatedMatchConfig.ModifiedDifficulty;
	if ( Difficulty >= 4 )
	{
		bNoviceMode = false;
		Difficulty = Difficulty - 4;
	}
	else
	{
		if ( Difficulty > 3 )
		{
			Difficulty = 3;
			bThreePlus = true;
		}
		bNoviceMode = true;
	}

	// Update GRI
	InitGameReplicationInfo();

	// Update //logged Info
	if (bLocallog && bloggingGame)
	{
		logGameParameters(Locallog);
	}
	if (bWorldlog && bloggingGame)
	{
		logGameParameters(Worldlog);
	}

	PlayStartupMessage(LadderPlayer);
	LadderPlayer.SetProgressTime(6);
}

/* AcceptInventory()
Examine the passed player's inventory, and accept or discard each item
* AcceptInventory needs to gracefully handle the case of some inventory
being accepted but other inventory not being accepted (such as the default
weapon).  There are several things that can go wrong: A weapon's
AmmoType not being accepted but the weapon being accepted -- the weapon
should be killed off. Or the player's selected inventory item, active
weapon, etc. not being accepted, leaving the player weaponless or leaving
the HUD inventory rendering messed up (AcceptInventory should pick another
applicable weapon/item as current).
*/
function AcceptInventory(pawn PlayerPawn)
{
	local inventory Inv;
	local MPLLadderInventory LadderObj;

	// DeathMatchPlus accepts MPLLadderInventory
	for( Inv=PlayerPawn.Inventory; Inv!=None; Inv=Inv.Inventory )
	{
		if (Inv.IsA('MPLLadderInventory'))
		{ 
			LadderObj = MPLLadderInventory(Inv);
		} 
		else 	
			Inv.Destroy();
	}
	PlayerPawn.Weapon = None;
	PlayerPawn.SelectedItem = None;
	AddDefaultInventory( PlayerPawn );
}

function bool SetEndCams(string Reason)
{
	local pawn P, Best;
	local PlayerPawn Player;

	// find individual winner
	for ( P=Level.PawnList; P!=None; P=P.nextPawn )
		if ( P.bIsPlayer && !P.IsA('Spectator') && ((Best == None) || (P.PlayerReplicationInfo.Score > Best.PlayerReplicationInfo.Score)) )
			Best = P;

	// check for tie
	for ( P=Level.PawnList; P!=None; P=P.nextPawn )
		if ( P.bIsPlayer && (Best != P) && (P.PlayerReplicationInfo.Score == Best.PlayerReplicationInfo.Score) )
		{
			BroadcastLocalizedMessage( DMMessageClass, 0 );
			return false;
		}		

	EndTime = Level.TimeSeconds + 3.0;
	GameReplicationInfo.GameEndedComments = Best.PlayerReplicationInfo.PlayerName@GameEndedMessage;
	//log( "Game ended at "$EndTime);
	for ( P=Level.PawnList; P!=None; P=P.nextPawn )
	{
		Player = PlayerPawn(P);
		if ( Player != None )
		{
			if (!bTutorialGame)
				PlayWinMessage(Player, (Player == Best));
			Player.bBehindView = true;
			if ( Player == Best )
				Player.ViewTarget = None;
			else
				Player.ViewTarget = Best;
			Player.ClientGameEnded();
		}
		P.GotoState('GameEnded');
	}
	CalcEndStats();
	return true;
}

function PlayWinMessage(PlayerPawn Player, bool bWinner)
{
	if ( Player.IsA('TournamentPlayer') )
		TournamentPlayer(Player).PlayWinMessage(bWinner);
}

function NotifySpree(Pawn Other, int num)
{
	local Pawn P;

	if ( num == 5 )
		num = 0;
	else if ( num == 10 )
		num = 1;
	else if ( num == 15 )
		num = 2;
	else if ( num == 20 )
		num = 3;
	else if ( num == 25 )
		num = 4;
	else
		return;

	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
		if ( P.IsA('TournamentPlayer') )
			P.ReceiveLocalizedMessage( class'KillingSpreeMessage', Num, Other.PlayerReplicationInfo );
}

function EndSpree(Pawn Killer, Pawn Other)
{
	local Pawn P;

	if ( !Other.bIsPlayer )
		return;
	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
		if ( P.IsA('TournamentPlayer') )
		{
			if ( (Killer == None) || !Killer.bIsPlayer )
				TournamentPlayer(P).EndSpree(None, Other.PlayerReplicationInfo);
			else
				TournamentPlayer(P).EndSpree(Killer.PlayerReplicationInfo, Other.PlayerReplicationInfo);
		}
}

function ScoreKill(pawn Killer, pawn Other)
{
	Super.ScoreKill(Killer, Other);

	if ( bAltScoring && (Killer != Other) && (killer != None) )
		Other.PlayerReplicationInfo.Score -= 1;
}

// Monitor killed messages for fraglimit
function Killed(pawn killer, pawn Other, name damageType)
{
	local int NextTaunt, i;
	local bool bAutoTaunt, bEndOverTime;
	local Pawn P, Best;

	if ( (damageType == 'Decapitated') && (Killer != Other) && (Killer != None) )
	{
		if (Level.Game.Locallog != None)
			Level.Game.Locallog.logSpecialEvent("headshot", Killer.PlayerReplicationInfo.PlayerID, Other.PlayerReplicationInfo.PlayerID);
		if (Level.Game.Worldlog != None)
			Level.Game.Worldlog.logSpecialEvent("headshot", Killer.PlayerReplicationInfo.PlayerID, Other.PlayerReplicationInfo.PlayerID);
		Killer.ReceiveLocalizedMessage( class'DecapitationMessage' );
	}

	Super.Killed(killer, Other, damageType);

	if ( Other.Spree > 4 )
		EndSpree(Killer, Other); 
	Other.Spree = 0;

	if ( !bTeamGame )
	{
		if ( bOverTime )
		{
			bEndOverTime = true;
			//check for clear winner now
			// find individual winner
			for ( P=Level.PawnList; P!=None; P=P.nextPawn )
				if ( P.bIsPlayer && ((Best == None) || (P.PlayerReplicationInfo.Score > Best.PlayerReplicationInfo.Score)) )
					Best = P;

			// check for tie
			for ( P=Level.PawnList; P!=None; P=P.nextPawn )
				if ( P.bIsPlayer && (Best != P) && (P.PlayerReplicationInfo.Score == Best.PlayerReplicationInfo.Score) )
					bEndOverTime = false;

			if ( bEndOverTime )
			{
				if ( (FragLimit > 0) && (Best.PlayerReplicationInfo.Score >= FragLimit) )
					EndGame("fraglimit");
				else
					EndGame("timelimit");
			}
		}
		else if ( (FragLimit > 0) && (killer != None) && (killer.PlayerReplicationInfo != None)
				&& (killer.PlayerReplicationInfo.Score >= FragLimit) )
			EndGame("fraglimit");
	}
	
	if ( (killer == None) || (Other == None) )
		return;
	if ( !bFirstBlood )
		if ( Killer.bIsPlayer && (Killer != Other) )
			if (!Self.IsA('MPLTrainingDM'))
			{
				bFirstBlood = True;
				BroadcastLocalizedMessage( class'FirstBloodMessage', 0, Killer.PlayerReplicationInfo );
			}

	if ( BotConfig.bAdjustSkill && (killer.IsA('PlayerPawn') || Other.IsA('PlayerPawn')) )
	{
		if ( killer.IsA('Bot') )
			BotConfig.AdjustSkill(Bot(killer),true);
		if ( Other.IsA('Bot') )
			BotConfig.AdjustSkill(Bot(Other),false);
	}
		
	if ( Other.bIsPlayer && (Killer != None) && Killer.bIsPlayer && (Killer != Other) 
		&& (!bTeamGame || (Other.PlayerReplicationInfo.Team != Killer.PlayerReplicationInfo.Team)) )
	{
		Killer.Spree++;
		if ( Killer.Spree > 4 )
			NotifySpree(Killer, Killer.Spree);
	} 

	bAutoTaunt = ((TournamentPlayer(Killer) != None) && TournamentPlayer(Killer).bAutoTaunt);
	if ( ((Bot(Killer) != None) || bAutoTaunt)
		&& (Killer != Other) && (DamageType != 'gibbed') && (Killer.Health > 0)
		&& (Level.TimeSeconds - LastTauntTime > 3) )
	{
		LastTauntTime = Level.TimeSeconds;
		NextTaunt = Rand(class<ChallengeVoicePack>(Killer.PlayerReplicationInfo.VoiceType).Default.NumTaunts);
		for ( i=0; i<4; i++ )
		{
			if ( NextTaunt == LastTaunt[i] )
				NextTaunt = Rand(class<ChallengeVoicePack>(Killer.PlayerReplicationInfo.VoiceType).Default.NumTaunts);
			if ( i > 0 )
				LastTaunt[i-1] = LastTaunt[i];
		}	
		LastTaunt[3] = NextTaunt;
 		killer.SendGlobalMessage(None, 'AUTOTAUNT', NextTaunt, 5);
	}
	if ( bRatedGame )
		RateVs(Other, Killer);
}

event playerpawn login
(
	string Portal,
	string Options,
	out string Error,
	class<playerpawn> SpawnClass
)
{
	local playerpawn NewPlayer;

	if ( (Level.NetMode != NM_Standalone) && (NumCommanders >= MaxCommanders) && ClassIsChildOf(SpawnClass, class'Commander') )
	{
		Error="Max commanders "$MaxCommanders$" exceeded";
		return None;
	}

	NewPlayer = Super.login(Portal, Options, Error, SpawnClass);

	if ( NewPlayer != None )
	{
		if ( bRatedGame )
			NewPlayer.AirControl = 0.35;
		else
			NewPlayer.AirControl = AirControl;
		if ( Left(NewPlayer.PlayerReplicationInfo.PlayerName, 6) == DefaultPlayerName )
		{
			if (Level.Game.Worldlog != None)
				Level.Game.Worldlog.logSpecialEvent("forced_name_change", NewPlayer.PlayerReplicationInfo.PlayerName, NewPlayer.PlayerReplicationInfo.PlayerID, DefaultPlayerName$NumPlayers);
			ChangeName( NewPlayer, (DefaultPlayerName$NumPlayers), false );
		}
		NewPlayer.bAutoActivate = true;
		if ( (bGameEnded || (bRequireReady && (CountDown > 0))) && !NewPlayer.IsA('Spectator') )
			NewPlayer.PlayerRestartState = 'PlayerWaiting';
		else
			NewPlayer.PlayerRestartState = NewPlayer.Default.PlayerRestartState;

		if ( NewPlayer.IsA('TournamentPlayer') )
		{
			TournamentPlayer(NewPlayer).StartSpot = LastStartSpot;
			if ( NewPlayer.IsA('Commander') )
				NumCommanders++;
		}
	}
	return NewPlayer;
}

event Postlogin( playerpawn NewPlayer )
{
	Super(TournamentGameInfo).Postlogin(NewPlayer);
	if ( Level.NetMode == NM_Standalone )
	{
		while ( (RemainingBots > 0) && AddBot() )
			RemainingBots--;
	}
	else
		RemainingBots = 0;

	if ( !bRatedGame )
	{
		PlayStartUpMessage(NewPlayer);
		NewPlayer.SetProgressTime(6);
	}
}

function int ReduceDamage(int Damage, name DamageType, pawn injured, pawn instigatedBy)
{
	if (injured.Region.Zone.bNeutralZone)
		return 0;

	if ( instigatedBy == None)
		return Damage;

	if ( bHardCoreMode )
		Damage *= 1.5;
	if ( bNoviceMode && !bThreePlus )
	{
		if ( instigatedBy.bIsPlayer && (injured == instigatedby) && (Level.NetMode == NM_Standalone) )
			Damage *= 0.5;

		//skill level modification
		if ( instigatedBy.IsA('Bot') && injured.IsA('PlayerPawn') )
		{
			if ( ((instigatedBy.Weapon != None) && instigatedBy.Weapon.bMeleeWeapon) 
				|| ((injured.Weapon != None) && injured.Weapon.bMeleeWeapon && (VSize(injured.location - instigatedBy.Location) < 600)) )
				Damage = Damage * (0.76 + 0.08 * instigatedBy.skill);
			else
				Damage = Damage * (0.25 + 0.15 * instigatedBy.skill);
		}
	}
	return (Damage * instigatedBy.DamageScaling);
}

function StartMatch()
{	
	local Pawn P;
	local TimedTrigger T;

	if (Locallog != None)
		Locallog.logGameStart();
	if (Worldlog != None)
		Worldlog.logGameStart();

	ForEach AllActors(class'TimedTrigger', T)
		T.SetTimer(T.DelaySeconds, T.bRepeating);
	//if ( Level.NetMode != NM_Standalone )
	//	RemainingBots = 0;
	GameReplicationInfo.RemainingMinute = RemainingTime;
	bStartMatch = true;

	// start players first (in their current startspots)
	for ( P = Level.PawnList; P!=None; P=P.nextPawn )
		if ( P.bIsPlayer && P.IsA('PlayerPawn') )
		{
			if ( bGameEnded ) return; // telefrag ended the game with ridiculous frag limit
			else if ( !P.IsA('Spectator')  )
			{
				P.PlayerRestartState = P.Default.PlayerRestartState;
				P.GotoState(P.Default.PlayerRestartState);
				if ( !P.IsA('Commander') )
				{
					if ( !RestartPlayer(P) )
						P.GotoState('Dying'); //failed to restart player, so let him try to respawn again
				}
			}
			SendStartMessage(PlayerPawn(P));
		}


	for ( P = Level.PawnList; P!=None; P=P.nextPawn )
		if ( P.bIsPlayer && !P.IsA('PlayerPawn') )
		{
			P.RestartPlayer();
			if ( P.IsA('Bot') )
				Bot(P).StartMatch();
		}
	bStartMatch = false;

}


function Timer()
{
	local Pawn P;
	local bool bReady;
	local int M;

	Super(TournamentGameInfo).Timer();

	if ( bNetReady )
	{
		if ( NumPlayers > 0 )
			ElapsedTime++;
		else
			ElapsedTime = 0;
		if ( ElapsedTime > NetWait )
		{
			if ( (NumPlayers + NumBots < 4) && NeedPlayers() )
			{
				//log("Timer if: needplayers");
				AddBot();
			}
			else if ( (NumPlayers + NumBots > 1) || ((NumPlayers > 0) && (ElapsedTime > 2 * NetWait)) )
				bNetReady = false;
		}

		if ( bNetReady )
		{
			for (P=Level.PawnList; P!=None; P=P.NextPawn )
				if ( P.IsA('PlayerPawn') )
					PlayerPawn(P).SetProgressTime(2);
			return;
		}
		else
		{
			while ( NeedPlayers() )
			{
				//log("Timer while: needplayers");
				AddBot();
			}
			bRequireReady = false;
			StartMatch();
		}
	}

	if ( bRequireReady && (CountDown > 0) )
	{
		while ( (RemainingBots > 0) && AddBot() )
			RemainingBots--;
		for (P=Level.PawnList; P!=None; P=P.NextPawn )
			if ( P.IsA('PlayerPawn') )
				PlayerPawn(P).SetProgressTime(2);
		if ( ((NumPlayers == MaxPlayers) || (Level.NetMode == NM_Standalone)) 
				&& (RemainingBots <= 0) )
		{	
			bReady = true;
			for (P=Level.PawnList; P!=None; P=P.NextPawn )
				if ( P.IsA('PlayerPawn') && !P.IsA('Spectator')
					&& !PlayerPawn(P).bReadyToPlay )
					bReady = false;
			
			if ( bReady )
			{	
				StartCount = 30;
				CountDown--;
				if ( CountDown <= 0 )
					StartMatch();
				else
				{
					for ( P = Level.PawnList; P!=None; P=P.nextPawn )
						if ( P.IsA('PlayerPawn') )
						{
							PlayerPawn(P).ClearProgressMessages();
							if ( (CountDown < 11) && P.IsA('TournamentPlayer') )
								TournamentPlayer(P).TimeMessage(CountDown);
							else
								PlayerPawn(P).SetProgressMessage(CountDown$CountDownMessage, 0);
						}
				}
			}
			else if ( StartCount > 8 ) 
			{
				for ( P = Level.PawnList; P!=None; P=P.nextPawn )
					if ( P.IsA('PlayerPawn') )
					{
						PlayerPawn(P).ClearProgressMessages();
						PlayerPawn(P).SetProgressTime(2);
						PlayerPawn(P).SetProgressMessage(WaitingMessage1, 0);
						PlayerPawn(P).SetProgressMessage(WaitingMessage2, 1);
						if ( PlayerPawn(P).bReadyToPlay )
							PlayerPawn(P).SetProgressMessage(ReadyMessage, 2);
						else
							PlayerPawn(P).SetProgressMessage(NotReadyMessage, 2);
					}
			}
			else
			{
				StartCount++;
				if ( Level.NetMode != NM_Standalone )
					StartCount = 30;
			}
		}
		else
		{
			for ( P = Level.PawnList; P!=None; P=P.nextPawn )
				if ( P.IsA('PlayerPawn') )
					PlayStartupMessage(PlayerPawn(P));
		}
	}	
	else
	{
		if ( bAlwaysForceRespawn || (bForceRespawn && (Level.NetMode != NM_Standalone)) )
			For ( P=Level.PawnList; P!=None; P=P.NextPawn )
			{
				if ( P.IsInState('Dying') && P.IsA('PlayerPawn') && P.bHidden )
					PlayerPawn(P).ServerReStartPlayer();
			}
		if ( Level.NetMode != NM_Standalone )
		{
			if ( NeedPlayers() )
			{
				//log("Timer if 2: needplayers");
				AddBot();
			}
		}
		else
			while ( (RemainingBots > 0) && AddBot() )
				RemainingBots--;
		if ( bGameEnded )
		{
			if ( Level.TimeSeconds > EndTime + RestartWait )
				RestartGame();
		}
		else if ( !bOverTime && (TimeLimit > 0) )
		{
			GameReplicationInfo.bStopCountDown = false;
			RemainingTime--;
			GameReplicationInfo.RemainingTime = RemainingTime;
			if ( RemainingTime % 60 == 0 )
				GameReplicationInfo.RemainingMinute = RemainingTime;
			if ( RemainingTime <= 0 )
				EndGame("timelimit");
		}
		else
		{
			ElapsedTime++;
			GameReplicationInfo.ElapsedTime = ElapsedTime;
		}
	}
}

function bool TooManyBots()
{
	return (NumBots + NumPlayers > MinPlayers + NumExtraPlayers);
}

function bool RestartPlayer( pawn aPlayer )	
{
	local Bot B;
	local bool bResult;

	aPlayer.DamageScaling = aPlayer.Default.DamageScaling;
	B = Bot(aPlayer);
	if ( (B != None) 
		&& (Level.NetMode != NM_Standalone) 
		&& TooManyBots() )
	{
		aPlayer.Destroy();
		return false;
	}
	bResult = Super.RestartPlayer(aPlayer);
	if ( aPlayer.IsA('TournamentPlayer') )
		TournamentPlayer(aPlayer).StartSpot = LastStartSpot;
	return bResult;
}

function SendStartMessage(PlayerPawn P)
{
	P.ClearProgressMessages();
	P.SetProgressMessage(StartMessage, 0);
}

function Bot SpawnBot(out NavigationPoint StartSpot)
{
	local bot NewBot;
	local int BotN;
	local Pawn P;

	if ( bRatedGame )
		return SpawnRatedBot(StartSpot);

	Difficulty = BotConfig.Difficulty;

	if ( Difficulty >= 4 )
	{
		bNoviceMode = false;
		Difficulty = Difficulty - 4;
	}
	else
	{
		if ( Difficulty > 3 )
		{
			Difficulty = 3;
			bThreePlus = true;
		}
		bNoviceMode = true;
	}
	BotN = BotConfig.ChooseBotInfo();
	
	// Find a start spot.
	StartSpot = FindPlayerStart(None, 255);
	if( StartSpot == None )
	{
		//log("Could not find starting spot for Bot");
		return None;
	}

	// Try to spawn the bot.
	NewBot = Spawn(BotConfig.CHGetBotClass(BotN),,,StartSpot.Location,StartSpot.Rotation);

	if ( NewBot == None )
		//log("Couldn't spawn player at "$StartSpot);

	if ( (bHumansOnly || Level.bHumansOnly) && !NewBot.bIsHuman )
	{
		//log("can't add non-human bot to this game");
		NewBot.Destroy();
		NewBot = None;
	}

	if ( NewBot == None )
		NewBot = Spawn(BotConfig.CHGetBotClass(0),,,StartSpot.Location,StartSpot.Rotation);

	if ( NewBot != None )
	{
		// Set the player's ID.
		NewBot.PlayerReplicationInfo.PlayerID = CurrentID++;

		NewBot.PlayerReplicationInfo.Team = BotConfig.GetBotTeam(BotN);
		BotConfig.CHIndividualize(NewBot, BotN, NumBots);
		NewBot.ViewRotation = StartSpot.Rotation;
		// broadcast a welcome message.
		BroadcastMessage( NewBot.PlayerReplicationInfo.PlayerName$EnteredMessage, false );

		ModifyBehaviour(NewBot);
		AddDefaultInventory( NewBot );
		NumBots++;
		if ( bRequireReady && (CountDown > 0) )
			NewBot.GotoState('Dying', 'WaitingForStart');
		NewBot.AirControl = AirControl;

		if ( (Level.NetMode != NM_Standalone) && (bNetReady || bRequireReady) )
		{
			// replicate skins
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
				if ( P.bIsPlayer && (P.PlayerReplicationInfo != None) && P.PlayerReplicationInfo.bWaitingPlayer && P.IsA('PlayerPawn') )
				{
					if ( NewBot.bIsMultiSkinned )
						PlayerPawn(P).ClientReplicateSkins(NewBot.MultiSkins[0], NewBot.MultiSkins[1], NewBot.MultiSkins[2], NewBot.MultiSkins[3]);
					else
						PlayerPawn(P).ClientReplicateSkins(NewBot.Skin);	
				}						
		}
	}

	return NewBot;
}

function Bot SpawnRatedBot(out NavigationPoint StartSpot)
{
	local bot NewBot;
	local int BotN;
	local bool bEnemy;

	if (RemainingBots > MPLRatedMatchConfig.NumAllies)
		bEnemy = True;

	BotN = MPLRatedMatchConfig.ChooseBotInfo(bTeamGame, bEnemy);
	
	// Find a start spot.
	StartSpot = FindPlayerStart(None, 255);
	if( StartSpot == None )
	{
		//log("Could not find starting spot for Bot");
		return None;
	}

	// Try to spawn the bot.
	NewBot = Spawn(MPLRatedMatchConfig.GetBotClass(BotN, bTeamGame, bEnemy, RatedPlayer),,,StartSpot.Location,StartSpot.Rotation);
	if ( NewBot == None )
	{
		if ( (MPLRatedMatchConfig.EnemyTeam == class'MPLRatedTeamInfo7')
			|| (MPLRatedMatchConfig.EnemyTeam == class'MPLRatedTeamInfo8') )
			MPLRatedMatchConfig.EnemyTeam = class'MPLRatedTeamInfo3';
		//log("Couldn't spawn player at "$StartSpot);
	}

	if ( NewBot != None )
	{
		// Set the player's ID.
		NewBot.PlayerReplicationInfo.PlayerID = CurrentID++;
	
		MPLRatedMatchConfig.Individualize(NewBot, BotN, NumBots, bTeamGame, bEnemy);
		NewBot.ViewRotation = StartSpot.Rotation;
		// broadcast a welcome message.
		BroadcastMessage( NewBot.PlayerReplicationInfo.PlayerName$EnteredMessage, false );

		ModifyBehaviour(NewBot);
		AddDefaultInventory( NewBot );
		NumBots++;
		if ( bRequireReady && (CountDown > 0) )
			NewBot.GotoState('Dying', 'WaitingForStart');
		NewBot.AirControl = 0.35;
	}

	return NewBot;
}

function bool ForceAddBot()
{
	// add bot during gameplay
	if ( Level.NetMode != NM_Standalone )
		MinPlayers = Max(MinPlayers+1, NumPlayers + NumBots + NumExtraPlayers);
	AddBot();
}
		
function bool AddBot()
{
	local bot NewBot;
	local NavigationPoint StartSpot;

	NewBot = SpawnBot(StartSpot);
	if ( NewBot == None )
	{
		//log("Failed to spawn bot.");
		return false;
	}

	StartSpot.PlayTeleportEffect(NewBot, true);

	NewBot.PlayerReplicationInfo.bIsABot = True;

	// //log it.
	if (Locallog != None)
	{
		Locallog.logPlayerConnect(NewBot);
		Locallog.Flushlog();
	}
	if (Worldlog != None)
	{
		Worldlog.logPlayerConnect(NewBot);
		Worldlog.Flushlog();
	}

	return true;
}

function ModifyBehaviour(Bot NewBot);

function PlayStartUpMessage(PlayerPawn NewPlayer)
{
	local int i;

	NewPlayer.ClearProgressMessages();

	// Game Name
	NewPlayer.SetProgressMessage(GameName, i++);

	// Optional FragLimit
	if ( fraglimit > 0 )
		NewPlayer.SetProgressMessage(FragLimit@GameGoal, i++);

	if ( Level.NetMode == NM_Standalone )
		NewPlayer.SetProgressMessage(SingleWaitingMessage, i++);
	else if ( bRequireReady )
		NewPlayer.SetProgressMessage(TourneyMessage, i++);
}

function float PlayerJumpZScaling()
{
	if ( bJumpMatch )
		return 3;
	else if ( bMegaSpeed )
		return 1.2;
	else if ( bHardCoreMode )
		return 1.1;
	else
		return 1.0;
}

function AddDefaultInventory( pawn PlayerPawn )
{
	local Weapon NewWeapon;
	local Bot B;

	if ( PlayerPawn.IsA('Spectator') || (bRequireReady && (CountDown > 0)) )
		return;

	// Spawn Automag
	GiveWeapon(PlayerPawn, "Botpack.Enforcer");

	Super.AddDefaultInventory(PlayerPawn);

	if ( bUseTranslocator && (!bRatedGame || bRatedTranslocator) )
	{
		// Spawn Translocator.
		if( PlayerPawn.FindInventoryType(class'Translocator')==None )
		{
			newWeapon = Spawn(class'Translocator');
			if( newWeapon != None )
			{
				newWeapon.Instigator = PlayerPawn;
				newWeapon.BecomeItem();
				PlayerPawn.AddInventory(newWeapon);
				newWeapon.GiveAmmo(PlayerPawn);
				newWeapon.SetSwitchPriority(PlayerPawn);
				newWeapon.WeaponSet(PlayerPawn);
			}
		}
	}

	B = Bot(PlayerPawn);
	if ( B != None )
		B.bHasImpactHammer = (B.FindInventoryType(class'ImpactHammer') != None);
}	

function GiveWeapon(Pawn PlayerPawn, string aClassName )
{
	local class<Weapon> WeaponClass;
	local Weapon NewWeapon;

	WeaponClass = class<Weapon>(DynamicLoadObject(aClassName, class'Class'));

	if( PlayerPawn.FindInventoryType(WeaponClass) != None )
		return;
	newWeapon = Spawn(WeaponClass);
	if( newWeapon != None )
	{
		newWeapon.RespawnTime = 0.0;
		newWeapon.GiveTo(PlayerPawn);
		newWeapon.bHeldItem = true;
		newWeapon.GiveAmmo(PlayerPawn);
		newWeapon.SetSwitchPriority(PlayerPawn);
		newWeapon.WeaponSet(PlayerPawn);
		newWeapon.AmbientGlow = 0;
		if ( PlayerPawn.IsA('PlayerPawn') )
			newWeapon.SetHand(PlayerPawn(PlayerPawn).Handedness);
		else
			newWeapon.GotoState('Idle');
		PlayerPawn.Weapon.GotoState('DownWeapon');
		PlayerPawn.PendingWeapon = None;
		PlayerPawn.Weapon = newWeapon;
	}
}
	
function byte AssessBotAttitude(Bot aBot, Pawn Other)
{
	local float skillmod;

	if ( bNoviceMode )
		skillmod = 0.3;
	else
		skillmod = 0.2 - aBot.skill * 0.06;
	if ( aBot.bKamikaze )
		return 1;
	else if ( Other.IsA('TeamCannon') 
		|| (aBot.RelativeStrength(Other) > aBot.Aggressiveness + skillmod) )
		return 0;
	else
		return 1;
}

function float GameThreatAdd(Bot aBot, Pawn Other)
{
	return 0;
}

// AllowTranslocation - return true if Other can teleport to Dest
function bool AllowTranslocation(Pawn Other, vector Dest )
{
	return true;
}

function bool CanTranslocate(Bot aBot)
{
	if ( !bUseTranslocator || (bRatedGame && !bRatedTranslocator) )
		return false;
	return ( (aBot.MyTranslocator != None) && (aBot.MyTranslocator.TTarget == None) );
} 

function PickAmbushSpotFor(Bot aBot)
{
	local NavigationPoint N;

	for ( N=Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
		if ( N.IsA('Ambushpoint') && !N.taken 
			&& ((aBot.AmbushSpot == None)
				|| (VSize(aBot.Location - aBot.Ambushspot.Location)
					 > VSize(aBot.Location - N.Location))) )
				aBot.Ambushspot = Ambushpoint(N);
}

function RateVs(Pawn Other, Pawn Killer)
{
	local int numopp, Win;
	local float oppRating, K, We;
	Local PlayerPawn P;
	Local Bot B;

	if ( Killer.IsA('PlayerPawn') )
	{
		P = PlayerPawn(Killer);
		B = Bot(Other);
		Win = 1;
		WinCount++;
	}
	else if ( Other.IsA('PlayerPawn') )
	{
		LoseCount++;
		P = PlayerPawn(Other);
		B = Bot(Killer);
	}
	else
		return;

	if ( B == None )
		oppRating = PlayerRating - 400;
	else
		oppRating = FMin(B.GetRating(), PlayerRating + 400);

	numopp++;
	AvgOpponentRating = (AvgOpponentRating * (numopp - 1) + oppRating)/numopp;  	
	if ( numopp < 20 )
	{
		PlayerRating = AvgOpponentRating + 400 * (WinCount - LoseCount)/numopp;			
	}
	else
	{
		if ( oppRating < PlayerRating - 400 )
			return;
		
		if ( PlayerRating < 2100 )
			K = 32;
		else if ( PlayerRating < 2400 )
			K = 24;
		else 
			K = 16; 

		We = 1/(10^((PlayerRating - opprating)/400) + 1);
		PlayerRating = PlayerRating + K * (Win - We);

		/* FOLLOWING NOT DONE - do at end of level FIXME
		Pre-tournament Rating Post-tournament Rating   
		0-2099  2100-2399 Ra = 2100 + (Rn-2100) x 0.75  
		2100-2399 0-2099  Ra = 2100 + (Rn-2100) x 1.33  
		2100-2399 2400-3000 Ra = 2400 + (Rn-2400) x 0.66  
		2400-3000  2100-2399  Ra = 2400 + (Rn-2400) x 1.50 
		*/
	}
}

function bool SuccessfulGame()
{
	local Pawn P;
	local PlayerPawn Pl;

	//if (RatedPlayer.IsA('PlayerPawn')) //log("Player is a playerpawn - don't need child");
	//if (RatedPlayer.ClassIsChildOf(class'TournamentPlayer',class'PlayerPawn')) //log("Player is child of tournamentplayer");
	//if (RatedPlayer.ClassIsChildOf(class'PlayerPawn',class'TournamentPlayer')) //log("Player is child of playerpawn?");


	////log("Rated player score: "$RatedPlayer.PlayerReplicationInfo.Score);

	//P = None;

	//Checks for RatedPlayer win, then checks for the other human players, and then checks the bots

	if ( RatedPlayer.PlayerReplicationInfo.Score >= FragLimit )
		return true;

	ForEach AllActors(class'PlayerPawn', Pl)
	{
		if ( Pl != RatedPlayer && Pl.PlayerReplicationInfo.Score >= FragLimit )
			return true;
	}

	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
	{
		if ( P != RatedPlayer )
		{
			if ( P.IsA('Bot') && Bot(P).PlayerReplicationInfo.Score >= RatedPlayer.PlayerReplicationInfo.Score )
				return false;
			else if ( P.IsA('TournamentPlayer') && TournamentPlayer(P).PlayerReplicationInfo.Score >= RatedPlayer.PlayerReplicationInfo.Score )
				return true;
		}
	}

	return false;


}


// Commented out for release version.
function Skip()
{
	if (bRatedGame)
	{
		MPLRatedGameLadderObj.LastMatchType = LadderTypeIndex;
		MPLRatedGameLadderObj.PendingChange = LadderTypeIndex;
		if (IDnum < MPLRatedGameLadderObj.CurrentLadder.Default.Matches-1)
			MPLRatedGameLadderObj.PendingPosition = IDnum+1;
		MPLRatedGameLadderObj.PendingRank = MPLRatedGameLadderObj.CurrentLadder.Default.RankedGame[IDnum];

		//RatedPlayer.ClientTravel("UT-//logo-Map.unr"$"?Game=Botpack.LadderTransition", TRAVEL_Absolute, True);
		RatedPlayer.Level.ServerTravel("DM-MPLobby.unr"$"?Game=UT99MPLadder.MPLLadderTransition", True);
		return;
	}
}

function SkipAll()
{
	if (bRatedGame)
	{
		MPLRatedGameLadderObj.DMPosition = class'MPLLadderDMGOTY'.Default.Matches - 1;
		MPLRatedGameLadderObj.DMRank = 6;
		MPLRatedGameLadderObj.DOMPosition = class'MPLLadderDOM'.Default.Matches - 1;
		MPLRatedGameLadderObj.DOMRank = 6;
		MPLRatedGameLadderObj.CTFPosition = class'MPLLadderCTFGOTY'.Default.Matches - 1;
		MPLRatedGameLadderObj.CTFRank = 6;
		MPLRatedGameLadderObj.ASPosition = class'MPLLadderAS'.Default.Matches - 1;
		MPLRatedGameLadderObj.ASRank = 6;
		MPLRatedGameLadderObj.ChalPosition = class'MPLLadderChal'.Default.Matches - 1;
		MPLRatedGameLadderObj.ChalRank = 6;

		MPLRatedGameLadderObj.LastMatchType = LadderTypeIndex;
		MPLRatedGameLadderObj.PendingChange = LadderTypeIndex;
		MPLRatedGameLadderObj.PendingPosition = 0;
		MPLRatedGameLadderObj.PendingRank = 0;

		//RatedPlayer.ClientTravel("UT-//logo-Map.unr"$"?Game=Botpack.LadderTransition", TRAVEL_Absolute, True);
		RatedPlayer.Level.ServerTravel("DM-MPLobby"$"?Game=UT99MPLadder.MPLLadderTransition", True);

		return;
	}
}


function bool CanSpectate( pawn Viewer, actor ViewTarget )
{
	if ( ViewTarget.bIsPawn && (Pawn(ViewTarget).PlayerReplicationInfo != None)
		&& Pawn(ViewTarget).PlayerReplicationInfo.bIsSpectator )
		return false;
	return ( (!bRatedGame && (Level.NetMode == NM_Standalone)) || Viewer.PlayerReplicationInfo.bIsSpectator );
}

function bool ShouldRespawn(Actor Other)
{
	return ( (Inventory(Other) != None) && (Inventory(Other).ReSpawnTime!=0.0) );
}

function ChangeName(Pawn Other, string S, bool bNameChange)
{
	local pawn APlayer;

	if ( S == "" )
		return;

	S = left(S,24);
	if (Other.PlayerReplicationInfo.PlayerName~=S)
		return;
	
	APlayer = Level.PawnList;
	
	While ( APlayer != None )
	{	
		if ( APlayer.bIsPlayer && (APlayer.PlayerReplicationInfo.PlayerName~=S) )
		{
			Other.ClientMessage(S$NoNameChange);
			return;
		}
		APlayer = APlayer.NextPawn;
	}

	Other.PlayerReplicationInfo.OldName = Other.PlayerReplicationInfo.PlayerName;
	Other.PlayerReplicationInfo.PlayerName = S;
	if ( bNameChange && !Other.IsA('Spectator') )
		BroadcastLocalizedMessage( DMMessageClass, 2, Other.PlayerReplicationInfo );			

	if (Locallog != None)
		Locallog.logNameChange(Other);
	if (Worldlog != None)
		Worldlog.logNameChange(Other);
}

/* FindPlayerStart()
returns the 'best' player start for this player to start from.
Re-implement for each game type
*/
function NavigationPoint FindPlayerStart(Pawn Player, optional byte InTeam, optional string incomingName)
{
	local PlayerStart Dest, Candidate[16], Best;
	local float Score[16], BestScore, NextDist;
	local pawn OtherPlayer;
	local int i, num;
	local Teleporter Tel;
	local NavigationPoint N, LastPlayerStartSpot;

	if ( bStartMatch && (Player != None) && Player.IsA('TournamentPlayer') 
		&& (Level.NetMode == NM_Standalone)
		&& (TournamentPlayer(Player).StartSpot != None) )
		return TournamentPlayer(Player).StartSpot;

	if( incomingName!="" )
		foreach AllActors( class 'Teleporter', Tel )
			if( string(Tel.Tag)~=incomingName )
				return Tel;

	//choose candidates	
	for ( N=Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
	{
		Dest = PlayerStart(N);
		if ( (Dest != None) && Dest.bEnabled && !Dest.Region.Zone.bWaterZone )
		{
			if (num<16)
				Candidate[num] = Dest;
			else if (Rand(num) < 16)
				Candidate[Rand(16)] = Dest;
			num++;
		}
	}

	if (num == 0 )
		foreach AllActors( class 'PlayerStart', Dest )
		{
			if (num<16)
				Candidate[num] = Dest;
			else if (Rand(num) < 16)
				Candidate[Rand(16)] = Dest;
			num++;
		}

	if (num>16) num = 16;
	else if (num == 0)
		return None;

	if ( (Player != None) && Player.IsA('TournamentPlayer') 
		&& (TournamentPlayer(Player).StartSpot != None) )
		LastPlayerStartSpot = TournamentPlayer(Player).StartSpot;

	//assess candidates
	for (i=0;i<num;i++)
	{
		if ( (Candidate[i] == LastStartSpot) || (Candidate[i] == LastPlayerStartSpot) )
			Score[i] = -10000.0;
		else
			Score[i] = 3000 * FRand(); //randomize
	}		
	for ( OtherPlayer=Level.PawnList; OtherPlayer!=None; OtherPlayer=OtherPlayer.NextPawn)	
		if ( OtherPlayer.bIsPlayer && (OtherPlayer.Health > 0) && !OtherPlayer.IsA('Spectator') )
			for ( i=0; i<num; i++ )
			{
				if ( OtherPlayer.Region.Zone == Candidate[i].Region.Zone )
				{
					Score[i] -= 1500;
					NextDist = VSize(OtherPlayer.Location - Candidate[i].Location);
					if ( NextDist < OtherPlayer.CollisionRadius + OtherPlayer.CollisionHeight )
						Score[i] -= 1000000.0;
					else if ( (NextDist < 2000) && FastTrace(Candidate[i].Location, OtherPlayer.Location) )
						Score[i] -= (10000.0 - NextDist);
				}
				else if ( NumPlayers + NumBots == 2 )
				{
					Score[i] += 2 * VSize(OtherPlayer.Location - Candidate[i].Location);
					if ( FastTrace(Candidate[i].Location, OtherPlayer.Location) )
						Score[i] -= 10000;
				}
			}
	
	BestScore = Score[0];
	Best = Candidate[0];
	for (i=1;i<num;i++)
		if (Score[i] > BestScore)
		{
			BestScore = Score[i];
			Best = Candidate[i];
		}

	LastStartSpot = Best;
	return Best;
}

function logout(pawn Exiting)
{
	Super.logout(Exiting);
	if ( Exiting.IsA('Bot') )
		NumBots--;
	if ( Exiting.IsA('Commander') )
		NumCommanders--;
	if ( (Level.NetMode != NM_Standalone) && NeedPlayers() && !AddBot() )
	{
		//log("logout: needplayers");
		RemainingBots++;
	}
}

function bool NeedPlayers()
{
	return (!bGameEnded && (NumPlayers + NumBots < MinPlayers + NumExtraPlayers));
}

function RestartGame()
{
	local string NextMap;
	local MapList myList;

	// multipurpose don't restart variable
	if ( bDontRestart )
		return;

	if ( EndTime > Level.TimeSeconds ) // still showing end screen
		return;

	// Evaluate a rated game.
	if ( bRatedGame )
	{
		// Clear out the advancement fields.
		MPLRatedGameLadderObj.PendingPosition = 0;
		MPLRatedGameLadderObj.PendingRank = 0;
		MPLRatedGameLadderObj.PendingChange = 0;

		// Setup advancement.
		MPLRatedGameLadderObj.LastMatchType = LadderTypeIndex;
		if ( SuccessfulGame() )
		{
			//log("Won game");
			MPLRatedGameLadderObj.PendingChange = LadderTypeIndex;
			if (IDnum < MPLRatedGameLadderObj.CurrentLadder.Default.Matches-1)
				MPLRatedGameLadderObj.PendingPosition = IDnum+1;	// We are advancing to the next match.
			MPLRatedGameLadderObj.PendingRank = MPLRatedGameLadderObj.CurrentLadder.Default.RankedGame[IDnum];
		}
		//log("After SuccessfulGame if");

		RatedPlayer.Health = RatedPlayer.Default.Health;
		//RatedPlayer.Level.ServerTravel("DM-MPLobby"$"?Game=UT99MPLadder.MPLLadderTransition", True);
		RatedPlayer.Level.ServerTravel("DM-MPLobby"$"?Game=UT99MPLadder.MPLLadderTransition?MinPlayers=0", True);
		return;
	}

	// these server travels should all be relative to the current URL
	if ( bChangeLevels && !bAlreadyChanged && (MapListType != None) )
	{
		// open a the nextmap actor for this game type and get the next map
		bAlreadyChanged = true;
		myList = spawn(MapListType);
		NextMap = myList.GetNextMap();
		myList.Destroy();
		if ( NextMap == "" )
			NextMap = GetMapName(MapPrefix, NextMap,1);

		if ( NextMap != "" )
		{
			//log("In nextmap if");
			//Level.ServerTravel(NextMap, false);
			RatedPlayer.Level.ServerTravel("DM-MPLobby"$"?Game=UT99MPLadder.MPLLadderTransition?MinPlayers=0", false);
			//Level.ServerTravel("DM-MPLobby"$"?Game=UT99MPLadder.MPLLadderTransition", False);
			return;
		}
	}

	Level.ServerTravel("?Restart" , false);
}

function logGameParameters(Statlog Statlog)
{
	local bool bTemp;

	if (Statlog == None)
		return;

	// hack to make sure weapon stay //logging is correct for multiplayer games
	bTemp = bCoopWeaponMode;
	if ( Level.Netmode != NM_Standalone )
		bCoopWeaponMode = bMultiWeaponStay;	
	Super.logGameParameters(Statlog);
	bCoopWeaponMode = bTemp;

	Statlog.logEventString(Statlog.GetTimeStamp()$Chr(9)$"game"$Chr(9)$"FragLimit"$Chr(9)$FragLimit);
	Statlog.logEventString(Statlog.GetTimeStamp()$Chr(9)$"game"$Chr(9)$"TimeLimit"$Chr(9)$TimeLimit);
	Statlog.logEventString(Statlog.GetTimeStamp()$Chr(9)$"game"$Chr(9)$"MultiPlayerBots"$Chr(9)$(MinPlayers > 0));
	Statlog.logEventString(Statlog.GetTimeStamp()$Chr(9)$"game"$Chr(9)$"HardCore"$Chr(9)$bHardCoreMode);
	Statlog.logEventString(Statlog.GetTimeStamp()$Chr(9)$"game"$Chr(9)$"MegaSpeed"$Chr(9)$bMegaSpeed);
	Statlog.logEventString(Statlog.GetTimeStamp()$Chr(9)$"game"$Chr(9)$"AirControl"$Chr(9)$AirControl);
	Statlog.logEventString(Statlog.GetTimeStamp()$Chr(9)$"game"$Chr(9)$"JumpMatch"$Chr(9)$bJumpMatch);
	Statlog.logEventString(Statlog.GetTimeStamp()$Chr(9)$"game"$Chr(9)$"UseTranslocator"$Chr(9)$bUseTranslocator);
	Statlog.logEventString(Statlog.GetTimeStamp()$Chr(9)$"game"$Chr(9)$"TournamentMode"$Chr(9)$bTournament);
	if (Level.NetMode == NM_DedicatedServer)
		Statlog.logEventString(Statlog.GetTimeStamp()$Chr(9)$"game"$Chr(9)$"NetMode"$Chr(9)$"DedicatedServer");
	else if (Level.NetMode == NM_ListenServer)
		Statlog.logEventString(Statlog.GetTimeStamp()$Chr(9)$"game"$Chr(9)$"NetMode"$Chr(9)$"ListenServer");
	else if (Level.NetMode == NM_Standalone)
	{
		if (bRatedGame)
			Statlog.logEventString(Statlog.GetTimeStamp()$Chr(9)$"game"$Chr(9)$"NetMode"$Chr(9)$"SinglePlayer");
		else
			Statlog.logEventString(Statlog.GetTimeStamp()$Chr(9)$"game"$Chr(9)$"NetMode"$Chr(9)$"PracticeMatch");
	}
}

//------------------------------------------------------------------------------
// Game Querying.

function string GetRules()//new stuff
{
	local string ResultSet;
	local Mutator M;
	local string NextMutator, NextDesc;
	local int Num, i;

	//ResultSet = Super.GetRules();

	ResultSet = "";

	if( EnabledMutators == "" )
	{
		for (M = BaseMutator.NextMutator; M != None; M = M.NextMutator)
		{
			Num = 0;
			NextMutator = "";
			GetNextIntDesc("Engine.Mutator", 0, NextMutator, NextDesc);
			while( (NextMutator != "") && (Num < 50) )
			{
				if(NextMutator ~= string(M.Class))
				{
					i = InStr(NextDesc, ",");
					if(i != -1)
						NextDesc = Left(NextDesc, i);

					if(EnabledMutators != "")
						EnabledMutators = EnabledMutators $ ", ";
					 EnabledMutators = EnabledMutators $ NextDesc;
					 break;
				}
				
				Num++;
				GetNextIntDesc("Engine.Mutator", Num, NextMutator, NextDesc);
			}
		}
		if(EnabledMutators != "")
			ResultSet = ResultSet $ "\\mutators\\"$EnabledMutators;
	}

	ResultSet = ResultSet$"\\timelimit\\"$TimeLimit;
	ResultSet = ResultSet$"\\fraglimit\\"$FragLimit;
	Resultset = ResultSet$"\\minplayers\\"$MinPlayers;
	Resultset = ResultSet$"\\changelevels\\"$bChangeLevels;
	Resultset = ResultSet$"\\tournament\\"$bTournament;
	if(bMegaSpeed)
		Resultset = ResultSet$"\\gamestyle\\Turbo";
	else
	if(bHardcoreMode)
		Resultset = ResultSet$"\\gamestyle\\Hardcore";
	else
		Resultset = ResultSet$"\\gamestyle\\Classic";

	if(MinPlayers > 0)
		Resultset = ResultSet$"\\botskill\\"$class'ChallengeBotInfo'.default.Skills[Difficulty];

	return ResultSet;
}

function InitGameReplicationInfo()
{
	Super.InitGameReplicationInfo();

	MPLTournamentGameReplicationInfo(GameReplicationInfo).FragLimit = FragLimit;
	MPLTournamentGameReplicationInfo(GameReplicationInfo).TimeLimit = TimeLimit;
}

function bool CheckThisTranslocator(Bot aBot, TranslocatorTarget T)
{
	return false;
}

function bool OneOnOne()
{
	return ( NumPlayers + NumBots == 2 );
}

function float SpawnWait(bot B)
{
	/*//log("SpawnWait vars: ");
	//log("bRatedGame: "$bRatedGame);
	//log("bNoviceMode: "$bNoviceMode);
	//log("bTeamGame: "$bTeamGame);
	//log("Difficulty: "$Difficulty);*/
	if ( bRatedGame && bNoviceMode && !bTeamGame && (Difficulty <= 2) 
		&& (NumBots > 1)
		&& (B.PlayerReplicationInfo.Score > RatedPlayer.PlayerReplicationInfo.Score) )
		return ( 7 + NumBots * FRand() );
	return ( NumBots * FRand() );
}
	
function bool NeverStakeOut(bot Other)
{
	return false;
}


//
// Discard a player's inventory after he dies.
//
function DiscardInventory( Pawn Other )
{
	local actor dropped;
	local inventory Inv, NextInv;
	local weapon weap;
	local float speed;
	local MPLLadderInventory MainLadderInventory;

	if( Other.DropWhenKilled != None )
	{
		dropped = Spawn(Other.DropWhenKilled,,,Other.Location);
		Inv = Inventory(dropped);
		if ( Inv != None )
		{ 
			Inv.RespawnTime = 0.0; //don't respawn
			Inv.BecomePickup();		
		}
		if ( dropped != None )
		{
			dropped.RemoteRole = ROLE_DumbProxy;
			dropped.SetPhysics(PHYS_Falling);
			dropped.bCollideWorld = true;
			dropped.Velocity = Other.Velocity + VRand() * 280;
		}
		if ( Inv != None )
			Inv.GotoState('PickUp', 'Dropped');
	}					
	if( (Other.Weapon!=None) && (Other.Weapon.Class!=BaseMutator.MutatedDefaultWeapon()) 
		&& ((Other.Weapon.Ammotype == None) || (Other.Weapon.Ammotype.AmmoAmount > 0))
		&& Other.Weapon.bCanThrow )
	{
		speed = VSize(Other.Velocity);
		weap = Other.Weapon;
		if (speed != 0)
			weap.Velocity = Normal(Other.Velocity/speed + 0.5 * VRand()) * (speed + 280);
		else {
			weap.Velocity.X = 0;
			weap.Velocity.Y = 0;
			weap.Velocity.Z = 0;
		}
		Other.TossWeapon();
	}
	Other.Weapon = None;
	Other.SelectedItem = None;

	// Destroy the inventory list.
	Inv = Other.Inventory;
	while (Inv != None)
	{
		NextInv = Inv.Inventory;
		if (!Inv.IsA('MPLLadderInventory'))
		{
			Inv.DropInventory();
			Inv.Destroy();
		} else
			MainLadderInventory = MPLLadderInventory(Inv);
		Inv = NextInv;
	}
	if (MainLadderInventory != None)
	{
		Other.Inventory = MainLadderInventory;
		MainLadderInventory = None;
	}
}

defaultproperties
{
     AirControl=0.350000
     FragLimit=10
     bChangeLevels=True
     bHardCoreMode=True
     bMultiWeaponStay=True
     NetWait=10
     RestartWait=15
     CountDown=10
     TourneyMessage="Waiting for other players."
     WaitingMessage1="Waiting for ready signals."
     WaitingMessage2="(Use your fire button to toggle ready!)"
     ReadyMessage="You are READY!"
     NotReadyMessage="You are NOT READY!"
     CountDownMessage=" seconds until play starts!"
     StartMessage="The match has begun!"
     GameEndedMessage="wins the match!"
     SingleWaitingMessage="Press Fire to start."
     gamegoal="frags wins the match."
     InitialBots=4
     NoNameChange=" is already in use."
     OvertimeMessage="Score tied at the end of regulation. Sudden Death Overtime!!!"
     BotConfigType=Class'Botpack.ChallengeBotInfo'
     LadderTypeIndex=1
     bNoMonsters=True
     bRestartLevel=False
     bPauseable=False
     bDeathMatch=True
     ScoreBoardType=Class'Botpack.TournamentScoreBoard'
     BotMenuType="UTMenu.UTBotConfigSClient"
     RulesMenuType="UTMenu.UTRulesSClient"
     SettingsMenuType="UTMenu.UTSettingsSClient"
     GameUMenuType="UTMenu.UTGameMenu"
     MultiplayerUMenuType="UTMenu.UTMultiplayerMenu"
     GameOptionsMenuType="UTMenu.UTOptionsMenu"
     HUDType=Class'Botpack.ChallengeHUD'
     MapListType=Class'Botpack.TDMmaplist'
     MapPrefix="DM"
     BeaconName="DM"
     GameName="Tournament DeathMatch"
     DeathMessageClass=Class'Botpack.DeathMessagePlus'
     DMMessageClass=Class'Botpack.DeathMatchMessage'
     MutatorClass=Class'Botpack.DMMutator'
     GameReplicationInfoClass=Class'UT99MPLadder.MPLTournamentGameReplicationInfo'
     bloggingGame=True
}
